/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.bibench.platform.ui.content.filter;

import com.kingdee.bos.ctrl.bibench.platform.model.nodes.RDBaseNode;
import com.kingdee.bos.ctrl.bibench.platform.model.nodes.report.IReportNode;
import com.kingdee.bos.ctrl.bibench.platform.ui.PaltformWorkBenchContext;
import com.kingdee.bos.ctrl.bibench.platform.ui.content.filter.FilterDesignListener;
import com.kingdee.bos.ctrl.bibench.platform.ui.content.filter.FilterDialog;
import com.kingdee.bos.ctrl.bibench.platform.ui.content.filter.FilterItemCollection;
import com.kingdee.bos.ctrl.bibench.platform.ui.content.filter.InputTypeComboBox;
import com.kingdee.bos.ctrl.bibench.platform.ui.content.filter.LogicComponent;
import com.kingdee.bos.ctrl.bibench.platform.ui.content.filter.dsfields.DSFieldsSelector;
import com.kingdee.bos.ctrl.bibench.platform.ui.content.filter.type.AbstractFilterType;
import com.kingdee.bos.ctrl.bibench.platform.ui.content.filter.type.FilterString;
import com.kingdee.bos.ctrl.bibench.platform.ui.content.filter.visitor.EditorVisitor;
import com.kingdee.bos.ctrl.bibench.platform.ui.util.FaceUtil;
import com.kingdee.bos.ctrl.bibench.platform.ui.util.MsgBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.EditorFactory;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDContainer;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;

public class FilterDesignPanel
extends KDPanel {
    private int col_name = 0;
    private int col_label = 1;
    private int col_field = 2;
    private int col_logic = 3;
    private int col_inputtype = 4;
    private int col_init = 5;
    private int col_required = 6;
    private KDTable tbl = new KDTable(7, 1, 0);
    private KDWorkButton btnAdd = new KDWorkButton(" + ");
    private KDWorkButton btnDel = new KDWorkButton(" - ");
    private KDWorkButton btnPreview = new KDWorkButton("\u9884\u89c8");
    private List filterListenerList = new ArrayList();
    private IReportNode item;
    private KDPromptBox pbField = new KDPromptBox();
    private DSFieldsSelector fs;
    private PaltformWorkBenchContext ctx;

    public FilterDesignPanel(IReportNode item) {
        this.item = item;
    }

    public void setWorkBenchContext(PaltformWorkBenchContext ctx) {
        this.ctx = ctx;
        if (this.fs == null) {
            this.fs = new DSFieldsSelector((Frame)((Object)ctx.getFrame()), this.item);
            this.pbField.setSelector((KDPromptSelector)this.fs);
            this.pbField.setEditable(false);
            this.pbField.addDataChangeListener(new DataChangeListener(){

                public void dataChanged(DataChangeEvent eventObj) {
                    FilterDesignPanel.this.fireFilterChanged();
                }
            });
            this.pbField.addSelectorListener(new SelectorListener(){

                public void willShow(SelectorEvent e) {
                    try {
                        FilterDesignPanel.this.fs.setInitValue((String)FilterDesignPanel.this.pbField.getValue());
                    }
                    catch (Exception ex) {
                        MsgBox.error("\u8bbe\u7f6e\u7b5b\u9009\u5b57\u6bb5", ex, (Component)((Object)FilterDesignPanel.this));
                    }
                }
            });
        }
        this.fs.setWorkBenchContext(ctx);
    }

    public void addFilterDesignListener(FilterDesignListener fdl) {
        this.filterListenerList.add(fdl);
    }

    private void fireFilterChanged() {
        for (int i = 0; i < this.filterListenerList.size(); ++i) {
            ((FilterDesignListener)this.filterListenerList.get(i)).filterChanged();
        }
    }

    public void onLoad() {
        this.setLayout(new BorderLayout());
        KDContainer c = FaceUtil.createContainer("\u7b5b\u9009", (Component)this.tbl);
        this.add((Component)c, "Center");
        c.addButton((JButton)this.btnAdd);
        c.addButton((JButton)this.btnDel);
        c.addButton((JButton)this.btnPreview);
        this.btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FilterDesignPanel.this.addRow();
            }
        });
        this.btnDel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FilterDesignPanel.this.removeRow();
            }
        });
        this.btnPreview.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FilterDesignPanel.this.preview();
            }
        });
        IRow r = this.tbl.getHeadRow(0);
        r.getCell(this.col_name).setValue((Object)"\u540d\u79f0");
        r.getCell(this.col_label).setValue((Object)"\u6807\u7b7e");
        r.getCell(this.col_field).setValue((Object)"\u7ed1\u5b9a\u5b57\u6bb5");
        r.getCell(this.col_logic).setValue((Object)"\u6bd4\u8f83\u7b26");
        r.getCell(this.col_inputtype).setValue((Object)"\u7c7b\u578b");
        r.getCell(this.col_init).setValue((Object)"\u521d\u59cb\u503c/\u53d6\u503c\u8303\u56f4");
        r.getCell(this.col_required).setValue((Object)"\u5fc5\u5f55");
        InputTypeComboBox it = new InputTypeComboBox();
        it.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    FilterDesignPanel.this.fireFilterChanged();
                    FilterDesignPanel.this.onInputTypeChanged((AbstractFilterType)e.getItem(), FilterDesignPanel.this.tbl.getSelectManager().get().getTop(), true);
                }
            }
        });
        this.tbl.getColumn(this.col_field).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)this.pbField));
        LogicComponent lc = new LogicComponent();
        lc.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    FilterDesignPanel.this.fireFilterChanged();
                }
            }
        });
        this.tbl.getColumn(this.col_logic).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)((Object)lc)));
        this.tbl.getColumn(this.col_inputtype).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)((Object)it)));
        this.tbl.getColumn(this.col_required).setEditor((ICellEditor)new EditorFactory.BooleanEditor());
        this.tbl.getEditManager().addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editValueChanged(KDTEditEvent e) {
                FilterDesignPanel.this.fireFilterChanged();
            }
        });
    }

    private void onInputTypeChanged(AbstractFilterType filter, int r, boolean withWarning) {
        ICell cell = this.tbl.getCell(r, this.col_init);
        RDBaseNode cubeModelNode = this.ctx.getTree().searchItemById(this.item.getReportConfig().getDsId());
        if (cubeModelNode == null) {
            this.pbField.requestFocus();
            if (withWarning) {
                MsgBox.info("\u7b5b\u9009-\u7c7b\u578b", "\u8bf7\u9009\u62e9\u6570\u636e\u6a21\u578b\u3002", (Component)((Object)this));
            }
            return;
        }
        ICellEditor ce = (ICellEditor)filter.accept(new EditorVisitor(cell, this.ctx), cubeModelNode);
        cell.setEditor(ce);
        boolean enableRequired = filter.enableRequireOption();
        if (!enableRequired) {
            this.tbl.getCell(r, this.col_required).setValue((Object)Boolean.FALSE);
        }
        this.tbl.getCell(r, this.col_required).getStyleAttributes().setLocked(!enableRequired);
        this.tbl.updateUI();
    }

    private void addRow() {
        IRow r = this.tbl.addRow();
        r.getCell(this.col_logic).setValue((Object)"=");
        r.getCell(this.col_inputtype).setValue((Object)new FilterString());
        r.getCell(this.col_required).setValue((Object)Boolean.TRUE);
        this.tbl.scrollToVisible(this.tbl.getRowCount() - 1, 0);
        this.fireFilterChanged();
    }

    private void removeRow() {
        KDTSelectBlock b = this.tbl.getSelectManager().get();
        if (b != null) {
            int i = b.getTop();
            this.tbl.removeRow(i);
            this.fireFilterChanged();
        }
    }

    private void preview() {
        FilterItemCollection c = this.getFilters();
        try {
            FilterDialog.preview(c, "\u9884\u89c8", this.ctx);
        }
        catch (Exception e) {
            e.printStackTrace();
            MsgBox.error("\u9884\u89c8", e, (Component)((Object)this));
        }
    }

    public FilterItemCollection getFilters() {
        FilterItemCollection c = new FilterItemCollection();
        for (int i = 0; i < this.tbl.getRowCount(); ++i) {
            IRow r = this.tbl.getRow(i);
            AbstractFilterType item = (AbstractFilterType)r.getCell(this.col_inputtype).getValue();
            if (item == null) continue;
            item = item.newTypeCopy();
            item.setName((String)r.getCell(this.col_name).getValue());
            item.setLabel((String)r.getCell(this.col_label).getValue());
            item.setBindField((String)r.getCell(this.col_field).getValue());
            item.setLogic((String)r.getCell(this.col_logic).getValue());
            item.setInitValue(r.getCell(this.col_init).getValue());
            item.setRequired((Boolean)r.getCell(this.col_required).getValue());
            c.addFilterItem(item);
        }
        return c;
    }

    public void setFilters(FilterItemCollection filters) {
        this.tbl.removeRows();
        for (int i = 0; i < filters.size(); ++i) {
            AbstractFilterType item = filters.get(i);
            IRow r = this.tbl.addRow();
            r.getCell(this.col_name).setValue((Object)item.getName());
            r.getCell(this.col_label).setValue((Object)item.getLabel());
            r.getCell(this.col_field).setValue((Object)item.getBindField());
            r.getCell(this.col_logic).setValue((Object)item.getLogic());
            r.getCell(this.col_inputtype).setValue((Object)item);
            this.onInputTypeChanged((AbstractFilterType)r.getCell(this.col_inputtype).getValue(), i, false);
            r.getCell(this.col_init).setValue(item.getInitValue());
            r.getCell(this.col_required).setValue((Object)item.isRequired());
        }
    }
}

