/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.bibench.platform.ui.desktop;

import com.kingdee.bos.ctrl.analysis.mdxw.panelet.SplitUtil;
import com.kingdee.bos.ctrl.bibench.platform.model.listener.ICatalogNodePropertyListener;
import com.kingdee.bos.ctrl.bibench.platform.model.nodes.RDBaseNode;
import com.kingdee.bos.ctrl.bibench.platform.model.nodes.RDBaseNodeFactory;
import com.kingdee.bos.ctrl.bibench.platform.model.nodes.RDNodeEnum;
import com.kingdee.bos.ctrl.bibench.platform.services.IPlatformFacade;
import com.kingdee.bos.ctrl.bibench.platform.ui.PaltformWorkBenchContext;
import com.kingdee.bos.ctrl.bibench.platform.ui.desktop.DesktopCombineItem;
import com.kingdee.bos.ctrl.bibench.platform.ui.desktop.ICatalogItemPopMenuActionListener;
import com.kingdee.bos.ctrl.bibench.platform.ui.desktop.ICatalogTreeAction;
import com.kingdee.bos.ctrl.bibench.platform.ui.desktop.RDItemPropertiesPanel;
import com.kingdee.bos.ctrl.bibench.platform.ui.desktop.RDNodeItemMenu;
import com.kingdee.bos.ctrl.bibench.platform.ui.util.IconUtil;
import com.kingdee.bos.ctrl.bibench.platform.ui.util.MsgBox;
import com.kingdee.bos.ctrl.swing.KDContainer;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDPopupMenu;
import com.kingdee.bos.ctrl.swing.KDSplitPane;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.swing.JScrollPane;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class RDTreePanel
extends KDPanel
implements ICatalogNodePropertyListener,
ICatalogItemPopMenuActionListener {
    private PaltformWorkBenchContext ctx;
    private KDTree tree = new KDTree();
    private RDItemPropertiesPanel pros = new RDItemPropertiesPanel();
    private ICatalogTreeAction actor = null;
    private TreeModel tm;
    private DefaultKingdeeTreeNode root;
    private RDNodeItemMenu pm = new RDNodeItemMenu(this, false);
    private RDNodeItemMenu mainMenu = new RDNodeItemMenu(this, true);

    public RDTreePanel() {
        this.initUI();
    }

    private void initUI() {
        this.setLayout(new BorderLayout());
        KDContainer c = new KDContainer();
        c.setTitleStyle(1);
        c.setEnableActive(false);
        c.setTitle("\u76ee\u5f55");
        c.getContentPane().setLayout(new BorderLayout(0, 0));
        KDSplitPane sp = new KDSplitPane(0);
        sp.add((Component)new JScrollPane((Component)this.tree), (Object)"top");
        sp.add((Component)new JScrollPane((Component)((Object)this.pros)), (Object)"bottom");
        new SplitUtil().layout(sp, 0.7f);
        c.getContentPane().add((Component)sp, "Center");
        this.add((Component)c, "Center");
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                TreePath tp = e.getNewLeadSelectionPath();
                if (tp != null) {
                    DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)tp.getLastPathComponent();
                    if (node != null && !node.isRoot()) {
                        RDBaseNode item = (RDBaseNode)node.getUserObject();
                        RDTreePanel.this.onSelectRDCatalogItem(item);
                    } else {
                        RDTreePanel.this.onSelectRDCatalogItem(null);
                    }
                }
            }
        });
        this.tree.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                DefaultKingdeeTreeNode node = RDTreePanel.this.getSelectedNode();
                if (e.getButton() == 1 && e.getClickCount() == 2) {
                    RDTreePanel.this.onOpenCatalogItem();
                } else if (e.getButton() == 3) {
                    RDBaseNode item = null;
                    if (node != null && !node.isRoot()) {
                        item = (RDBaseNode)node.getUserObject();
                    }
                    KDPopupMenu pp = RDTreePanel.this.pm.getPopupMenu(item);
                    pp.show((Component)RDTreePanel.this.tree, e.getX(), e.getY());
                }
                RDTreePanel.this.changeMainEditMenu();
            }
        });
    }

    public void onSelectRDCatalogItem(RDBaseNode item) {
        this.pros.bindItemProperty(item);
        if (item != null && !RDNodeEnum.isDir(item.getType()) && this.actor != null) {
            this.actor.active(item);
        }
    }

    public void onLoad() throws Exception {
        this.root = new DefaultKingdeeTreeNode((Object)"BI\u62a5\u8868\u5e73\u53f0");
        this.tm = new DefaultTreeModel((TreeNode)this.root);
        this.tree.setModel(this.tm);
        IPlatformFacade bc = this.ctx.getPlatformFacade();
        List list = bc.getCatalogNodeList(this.ctx.getOrgID());
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            this.addNode(this.root, (RDBaseNode)list.get(i));
        }
        this.tree.setRootVisible(true);
        this.tree.updateUI();
        this.changeMainEditMenu();
    }

    public void changeMainEditMenu() {
        DefaultKingdeeTreeNode node = this.getSelectedNode();
        if (node != null && !node.isRoot()) {
            RDBaseNode item = (RDBaseNode)node.getUserObject();
            this.ctx.getFrame().setEditMenu(this.mainMenu.getPopupMenu(item));
        } else {
            this.ctx.getFrame().setEditMenu(this.mainMenu.getPopupMenu(null));
        }
    }

    public PaltformWorkBenchContext getWorkBenchContext() {
        return this.ctx;
    }

    public void setWorkBenchContext(PaltformWorkBenchContext workBenchContext) {
        this.ctx = workBenchContext;
    }

    private DefaultKingdeeTreeNode addNode(DefaultKingdeeTreeNode parent, RDBaseNode item) {
        item.addPropertyListener(this);
        DefaultKingdeeTreeNode node = new DefaultKingdeeTreeNode((Object)item);
        item.setProperty("node", node);
        IconUtil.setTreeNodeIcon(node, item);
        if (parent == null) {
            parent = this.root;
        }
        parent.add((MutableTreeNode)node);
        Iterator iter = item.childIterator();
        while (iter.hasNext()) {
            this.addNode(node, (RDBaseNode)iter.next());
        }
        return node;
    }

    private RDBaseNode newRootNode(int type) {
        return this.doNewNode(this.root, type);
    }

    private RDBaseNode newNode(int type) {
        DefaultKingdeeTreeNode node = this.getSelectedNode();
        if (node == null) {
            node = this.root;
        }
        return this.doNewNode(node, type);
    }

    private RDBaseNode doNewNode(DefaultKingdeeTreeNode node, int type) {
        try {
            RDBaseNode item = RDBaseNodeFactory.createCatalogNode(type, null);
            item.setDesignStatus(1);
            item.setOrgID(this.ctx.getOrgID());
            Object p = node.getUserObject();
            if (p instanceof RDBaseNode) {
                RDBaseNode r = (RDBaseNode)p;
                item.setParentID(r.getId());
                RDBaseNode last = r.getLastChild();
                if (last == null) {
                    last = r;
                }
                String k = last.getOrderKey();
                item.setOrderKey(k + k.length());
                r.addChild(item);
            } else {
                item.setParentID(null);
                item.setOrderKey("0");
            }
            if (type != -1) {
                DefaultKingdeeTreeNode newNode = this.addNode(node, item);
                item.setName(RDNodeEnum.getRDCatalogItemEnum(type).getName());
                this.tree.setSelectionPath(new TreePath(newNode.getPath()));
                this.tree.updateUI();
            } else {
                MsgBox.warn("\u65b0\u5efa", "\u65b0\u5efa\u7c7b\u578b\u672a\u77e5\uff01", (Component)((Object)this));
            }
            return item;
        }
        catch (Exception e) {
            MsgBox.error("\u65b0\u5efa", e, (Component)((Object)this));
            return null;
        }
    }

    public void saveNode() {
        DefaultKingdeeTreeNode node = this.getSelectedNode();
        if (node == null) {
            return;
        }
        RDBaseNode item = (RDBaseNode)node.getUserObject();
        this.saveNode(item);
    }

    public RDBaseNode searchItemById(String id) {
        if (id != null && id.length() > 0) {
            Enumeration em = this.root.depthFirstEnumeration();
            DefaultKingdeeTreeNode node = null;
            while (em.hasMoreElements()) {
                RDBaseNode item;
                node = (DefaultKingdeeTreeNode)em.nextElement();
                Object obj = node.getUserObject();
                if (!(obj instanceof RDBaseNode) || !id.equals((item = (RDBaseNode)obj).getId())) continue;
                return item;
            }
        }
        return null;
    }

    private void collectChildItemIdsExcludeNew(RDBaseNode item, List ids) {
        Iterator iter = item.childIterator();
        while (iter.hasNext()) {
            RDBaseNode n = (RDBaseNode)iter.next();
            if (n.getDesignStatus() == 1) continue;
            ids.add(n.getId());
            this.collectChildItemIdsExcludeNew(n, ids);
        }
    }

    public void saveNode(RDBaseNode item) {
        int status;
        RDBaseNode pItem;
        DefaultKingdeeTreeNode parent;
        Object pObj;
        Enumeration em = this.root.depthFirstEnumeration();
        DefaultKingdeeTreeNode node = null;
        while (em.hasMoreElements()) {
            node = (DefaultKingdeeTreeNode)em.nextElement();
            if (node.getUserObject() != item) continue;
            this.tree.setSelectionNode(node);
            break;
        }
        if (node != null && (pObj = (parent = (DefaultKingdeeTreeNode)node.getParent()).getUserObject()) instanceof RDBaseNode && (pItem = (RDBaseNode)pObj).isModified()) {
            this.saveNode(pItem);
            item.setParentID(pItem.getId());
        }
        if ((status = item.getDesignStatus()) == 0) {
            return;
        }
        IPlatformFacade bc = this.ctx.getPlatformFacade();
        try {
            RDBaseNode saveItem = item.copyWithoutChildren();
            if (status == 3) {
                ArrayList<String> ids = new ArrayList<String>();
                ids.add(saveItem.getId());
                this.collectChildItemIdsExcludeNew(item, ids);
                saveItem.setProperty("ids", ids);
            }
            String id = bc.saveCatalogNode(saveItem);
            if (status == 1) {
                item.setId(id);
                item.setDesignStatus(0, false);
                item.firePropertyChanged("name", false);
            } else if (status == 2) {
                item.setDesignStatus(0, false);
                item.firePropertyChanged("name", false);
            } else if (status == 3 && null != node) {
                Object obj;
                DefaultKingdeeTreeNode p = (DefaultKingdeeTreeNode)node.getParent();
                if (p != null && (obj = p.getUserObject()) instanceof RDBaseNode) {
                    ((RDBaseNode)obj).removeChild(item);
                }
                node.removeFromParent();
            }
            this.tree.updateUI();
        }
        catch (Exception e) {
            e.printStackTrace();
            MsgBox.error("\u4fdd\u5b58", e, (Component)((Object)this.ctx.getFrame()));
        }
    }

    private void delNode() {
        DefaultKingdeeTreeNode node = this.getSelectedNode();
        if (node == null) {
            return;
        }
        RDBaseNode item = (RDBaseNode)node.getUserObject();
        if (RDNodeEnum.isDir(item.getType()) && this.actor != null) {
            List list = item.getAllDeepChildren();
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                this.actor.close((RDBaseNode)list.get(i));
            }
        }
        if (item.getDesignStatus() == 1) {
            Object obj;
            DefaultKingdeeTreeNode p = (DefaultKingdeeTreeNode)node.getParent();
            if (p != null && (obj = p.getUserObject()) instanceof RDBaseNode) {
                ((RDBaseNode)obj).removeChild(item);
            }
            node.removeFromParent();
            this.tree.updateUI();
        } else {
            item.setDesignStatus(3, false);
            this.saveNode();
        }
        if (this.actor != null) {
            this.actor.close(item);
        }
        this.pros.bindItemProperty(null);
    }

    private DefaultKingdeeTreeNode getSelectedNode() {
        TreePath tp = this.tree.getSelectionPath();
        if (tp != null && this.tree.getSelectionRows() != null) {
            return (DefaultKingdeeTreeNode)tp.getLastPathComponent();
        }
        return null;
    }

    private void sortMyPosition(RDBaseNode item) {
        int i;
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)item.getProperty("node");
        DefaultKingdeeTreeNode p = (DefaultKingdeeTreeNode)node.getParent();
        ArrayList<TreeNode> childList = new ArrayList<TreeNode>();
        int n = p.getChildCount();
        for (i = 0; i < n; ++i) {
            childList.add(p.getChildAt(i));
        }
        Collections.sort(childList, new Comparator(){

            public int compare(Object o1, Object o2) {
                RDBaseNode item1 = (RDBaseNode)((DefaultKingdeeTreeNode)o1).getUserObject();
                RDBaseNode item2 = (RDBaseNode)((DefaultKingdeeTreeNode)o2).getUserObject();
                return item1.compareTo(item2);
            }
        });
        p.removeAllChildren();
        n = childList.size();
        for (i = 0; i < n; ++i) {
            p.add((MutableTreeNode)((DefaultKingdeeTreeNode)childList.get(i)));
        }
    }

    @Override
    public void valueChanged(String name, RDBaseNode item) {
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)item.getProperty("node");
        if ("type".equals(name)) {
            IconUtil.setTreeNodeIcon(node, item);
        } else if ("orderKey".equals(name)) {
            this.sortMyPosition(item);
        } else if ("name".equals(name) && RDNodeEnum.isDir(item.getType())) {
            this.saveNode(item);
        }
        node.setText(item.toString());
        this.onSelectRDCatalogItem(item);
        this.tree.updateUI();
    }

    public ICatalogTreeAction getCatalogTreeAction() {
        return this.actor;
    }

    public void setCatalogTreeAction(ICatalogTreeAction catalogTreeActionAdapter) {
        this.actor = catalogTreeActionAdapter;
    }

    public void setSelectItem(RDBaseNode item) {
        if (item != null) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)item.getProperty("node");
            this.tree.setSelectionNode(node);
        }
    }

    @Override
    public void onCreateCatalogItem(RDBaseNode selectedItem, int type) {
        RDBaseNode newItem = null;
        newItem = selectedItem == null ? this.newRootNode(type) : this.newNode(type);
        if (newItem != null && !RDNodeEnum.isDir(newItem.getType()) && this.actor != null) {
            this.actor.open(newItem);
        }
    }

    @Override
    public void onDeleteCatalogItem() {
        if (MsgBox.confirm("\u5220\u9664", "\u786e\u5b9a\u5220\u9664\u5417\uff1f", (Component)((Object)this.ctx.getFrame()))) {
            this.delNode();
        }
    }

    @Override
    public void onReloadCatalogItem() {
        DefaultKingdeeTreeNode node = this.getSelectedNode();
        if (node == null) {
            return;
        }
        RDBaseNode item = (RDBaseNode)node.getUserObject();
        DesktopCombineItem dskitem = this.ctx.getFrame().getDesktopList().getBy(item);
        if (dskitem != null) {
            dskitem.f.close(true);
        }
        try {
            item = this.ctx.getPlatformFacade().getCatalogNodeById(item.getId());
            item.setProperty("node", node);
            item.addPropertyListener(this);
            node.setUserObject((Object)item);
            item.setDesignStatus(2, false);
            item.setDesignStatus(0, true);
            int n = node.getChildCount();
            for (int i = 0; i < n; ++i) {
                item.addChild((RDBaseNode)((DefaultKingdeeTreeNode)node.getChildAt(i)).getUserObject());
            }
            this.tree.updateUI();
        }
        catch (Exception e) {
            e.printStackTrace();
            MsgBox.error("\u91cd\u65b0\u52a0\u8f7d", e, (Component)((Object)this.ctx.getFrame()));
        }
    }

    @Override
    public void onSaveCatalogItem() {
        DefaultKingdeeTreeNode node = this.getSelectedNode();
        if (node == null) {
            return;
        }
        RDBaseNode item = (RDBaseNode)node.getUserObject();
        DesktopCombineItem dci = this.ctx.getFrame().getDesktopList().getBy(item);
        if (dci == null) {
            this.saveNode();
        } else {
            dci.f.save();
        }
    }

    @Override
    public void onOpenCatalogItem() {
        RDBaseNode item;
        DefaultKingdeeTreeNode node = this.getSelectedNode();
        if (node != null && !node.isRoot() && !RDNodeEnum.isDir((item = (RDBaseNode)node.getUserObject()).getType()) && this.actor != null) {
            this.actor.open(item);
        }
    }
}

