/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.bibench.platform.ui.widget;

import com.kingdee.bos.ctrl.bibench.platform.ui.widget.CloseableTabbedPane;
import com.kingdee.bos.ctrl.swing.plaf.KingdeeTabbedPaneUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Icon;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicGraphicsUtils;

public class CloseableTabbedPaneUI
extends KingdeeTabbedPaneUI {
    private MouseHandler myMouseHandler = null;

    protected void installListeners() {
        super.installListeners();
        if (this.getTabView() != null && this.tabPane.getTabLayoutPolicy() == 1 && (this.myMouseHandler = new MouseHandler()) != null) {
            this.getTabView().addMouseListener((MouseListener)this.myMouseHandler);
        }
    }

    protected void uninstallListeners() {
        if (this.myMouseHandler != null) {
            this.getTabView().removeMouseListener((MouseListener)this.myMouseHandler);
            this.myMouseHandler = null;
        }
        super.uninstallListeners();
    }

    protected void paintFocusIndicator(Graphics g, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
        Rectangle tabRect = textRect;
        if (this.tabPane.hasFocus() && isSelected) {
            g.setColor(this.focus);
            int x = tabRect.x - 4 - 2 - 16;
            int y = tabRect.y + 2;
            int w = tabRect.width + 8 + 3 + 16;
            int h = tabRect.height - 2;
            BasicGraphicsUtils.drawDashedRect(g, x, y, 1, h);
            BasicGraphicsUtils.drawDashedRect(g, x + w, y, 1, h);
        }
    }

    public static CloseIcon createCloseIcon() {
        return new CloseIcon();
    }

    static class CloseIcon
    implements Icon {
        Rectangle rec = new Rectangle(0, 0, 15, 16);
        private boolean pressed = false;
        private boolean drawCenter = true;

        CloseIcon() {
        }

        @Override
        public synchronized void paintIcon(Component c, Graphics g, int x1, int y1) {
            int x = x1 - 3;
            int y = y1;
            if (this.pressed) {
                ++x;
                ++y;
            }
            this.rec.x = x;
            this.rec.y = y;
            Color oldColor = g.getColor();
            g.setColor(UIManager.getColor("TabbedPane.highlight"));
            g.drawLine(x, y, x, y + this.rec.height);
            g.drawLine(x, y, x + this.rec.width, y);
            g.setColor(UIManager.getColor("TabbedPane.shadow"));
            g.drawLine(x, y + this.rec.height, x + this.rec.width, y + this.rec.height);
            g.drawLine(x + this.rec.width, y, x + this.rec.width, y + this.rec.height);
            g.setColor(UIManager.getColor("TabbedPane.foreground"));
            g.drawRect(x + 4, y + 4, 1, 1);
            g.drawRect(x + 5, y + 5, 1, 1);
            g.drawRect(x + 5, y + 9, 1, 1);
            g.drawRect(x + 4, y + 10, 1, 1);
            if (this.drawCenter) {
                g.drawRect(x + 6, y + 6, 1, 1);
                g.drawRect(x + 8, y + 6, 1, 1);
                g.drawRect(x + 6, y + 8, 1, 1);
                g.drawRect(x + 8, y + 8, 1, 1);
            }
            g.drawRect(x + 10, y + 4, 1, 1);
            g.drawRect(x + 9, y + 5, 1, 1);
            g.drawRect(x + 9, y + 9, 1, 1);
            g.drawRect(x + 10, y + 10, 1, 1);
            g.setColor(oldColor);
        }

        public Rectangle getBounds() {
            return this.rec;
        }

        public void setBounds(Rectangle rec) {
            this.rec = rec;
        }

        @Override
        public int getIconWidth() {
            return this.rec.width;
        }

        @Override
        public int getIconHeight() {
            return this.rec.height;
        }

        public void setPressed(boolean pressed) {
            this.pressed = pressed;
        }

        public void setDrawCenter(boolean drawCenter) {
            this.drawCenter = drawCenter;
        }

        public boolean isPressed() {
            return this.pressed;
        }

        public boolean isDrawCenter() {
            return this.drawCenter;
        }
    }

    public class MouseHandler
    extends MouseAdapter {
        @Override
        public void mousePressed(MouseEvent e) {
            JTabbedPane jtb = CloseableTabbedPaneUI.this.tabPane;
            if (jtb == null || !jtb.isEnabled()) {
                return;
            }
            int tabIndex = jtb.indexAtLocation(e.getX(), e.getY());
            if (tabIndex >= 0 && jtb.isEnabledAt(tabIndex)) {
                CloseIcon icon;
                if (tabIndex == jtb.getSelectedIndex()) {
                    if (jtb.isRequestFocusEnabled()) {
                        jtb.requestFocus();
                        jtb.repaint(CloseableTabbedPaneUI.this.getTabBounds(jtb, tabIndex));
                    }
                } else {
                    jtb.setSelectedIndex(tabIndex);
                }
                if ((icon = (CloseIcon)jtb.getIconAt(tabIndex)).getBounds().contains(e.getPoint())) {
                    icon.setPressed(true);
                    Component c = jtb.getComponentAt(tabIndex);
                    if (((CloseableTabbedPane)((Object)jtb)).getCloseHandler().close(c, tabIndex)) {
                        ((CloseableTabbedPane)((Object)jtb)).fireClosed(new ActionEvent(c, 1001, "close"));
                    }
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (CloseableTabbedPaneUI.this.tabPane == null || !CloseableTabbedPaneUI.this.tabPane.isEnabled()) {
                return;
            }
            int tabIndex = CloseableTabbedPaneUI.this.tabPane.indexAtLocation(e.getX(), e.getY());
            if (tabIndex >= 0 && CloseableTabbedPaneUI.this.tabPane.isEnabledAt(tabIndex)) {
                CloseIcon icon = (CloseIcon)CloseableTabbedPaneUI.this.tabPane.getIconAt(tabIndex);
                icon.setPressed(false);
                CloseableTabbedPaneUI.this.tabPane.repaint();
            }
        }
    }
}

