/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.swing.chart;

import com.kingdee.bos.ctrl.common.LanguageManager;
import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.ctrl.swing.chart.BawDrawingSupplier;
import com.kingdee.bos.ctrl.swing.chart.ChartArea;
import com.kingdee.bos.ctrl.swing.chart.ChartCategory;
import com.kingdee.bos.ctrl.swing.chart.ChartEvent;
import com.kingdee.bos.ctrl.swing.chart.ChartEventListener;
import com.kingdee.bos.ctrl.swing.chart.ChartGroup;
import com.kingdee.bos.ctrl.swing.chart.ChartGroups;
import com.kingdee.bos.ctrl.swing.chart.ChartType;
import com.kingdee.bos.ctrl.swing.chart.IChart;
import com.kingdee.bos.ctrl.swing.chart.Legend;
import com.kingdee.bos.ctrl.swing.chart.PlotArea;
import com.kingdee.bos.ctrl.swing.chart.Series;
import com.kingdee.bos.ctrl.swing.chart.SeriesCollection;
import com.kingdee.bos.ctrl.swing.chart.axis.Axes;
import com.kingdee.bos.ctrl.swing.chart.collection.AxesCollection;
import com.kingdee.bos.ctrl.swing.chart.collection.ChartDataCollection;
import com.kingdee.bos.ctrl.swing.chart.data.CommonChartData;
import com.kingdee.bos.ctrl.swing.chart.data.IChartData;
import com.kingdee.bos.ctrl.swing.chart.data.PieChartData;
import com.kingdee.bos.ctrl.swing.chart.panel.ChartPanel;
import com.kingdee.bos.ctrl.swing.chart.plot.RadarPlot;
import com.kingdee.bos.ctrl.swing.chart.title.ChartTitle;
import com.kingdee.bos.ctrl.swing.chart.title.ITitle;
import com.kingdee.bos.ctrl.swing.chart.util.ChartDataUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Paint;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.event.EventListenerList;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.JFreeChartConstants;
import org.jfree.chart.Marker;
import org.jfree.chart.StandardLegend;
import org.jfree.chart.axis.Axis;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.axis.TickUnit;
import org.jfree.chart.axis.TickUnitSource;
import org.jfree.chart.axis.TickUnits;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.labels.StandardCategoryItemLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.CombinedDomainCategoryPlot;
import org.jfree.chart.plot.DrawingSupplier;
import org.jfree.chart.plot.Pie3DPlot;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.BarRenderer;
import org.jfree.chart.renderer.CategoryItemRenderer;
import org.jfree.chart.renderer.ItemLabelAnchor;
import org.jfree.chart.renderer.ItemLabelPosition;
import org.jfree.chart.renderer.LineAndShapeRenderer;
import org.jfree.chart.renderer.StandardXYItemRenderer;
import org.jfree.chart.renderer.WaterfallBarRenderer;
import org.jfree.chart.urls.CategoryURLGenerator;
import org.jfree.chart.urls.StandardCategoryURLGenerator;
import org.jfree.data.CategoryDataset;
import org.jfree.data.PieDataset;
import org.jfree.data.XYDataset;
import org.jfree.ui.Layer;
import org.jfree.ui.TextAnchor;

public class Chart
extends JPanel
implements IChart {
    public static final long serialVersionUID = 1001001001L;
    public static final int NO_LABELS = 0;
    public static final int NAME_LABELS = 1;
    public static final int VALUE_LABELS = 2;
    public static final int PERCENT_LABELS = 3;
    public static final int NAME_AND_VALUE_LABELS = 4;
    public static final int NAME_AND_PERCENT_LABELS = 5;
    public static final int VALUE_AND_PERCENT_LABELS = 6;
    public static final int NORMAL_POPUPMENU = 1;
    public static final int REPORT_POPUPMENU = 2;
    private ChartType chartType;
    protected ChartTitle chartTitle;
    protected Legend legend;
    private ChartPanel panel;
    private AxesCollection axesCollection;
    private ChartDataCollection chartDataCollection;
    protected ChartArea chartArea;
    protected PlotArea plotArea;
    private boolean displayLegend = true;
    private boolean displayBlackAndWhite = false;
    private JFreeChart chart;
    private int popupMenuType = 1;
    private int explodeSection = 0;
    private List chartMouseListeners = new ArrayList(2);
    private int pieChartSectionLabelType = -1;
    protected SeriesCollection seriesCollection;
    protected ChartGroups chartGroups;
    private boolean initDefaults = false;
    private boolean dataLimit = false;
    private int pieDataLimitNum = 100;
    private int commonDataFirstDimLimitNum = 100;
    private int commonDataSecondDimLimitNum = 100;

    public Chart() {
        this(ChartType.CT_COLUMNCLUSTERED);
    }

    public Chart(ChartType type) {
        this.setChartType(type);
    }

    public JFreeChart getDelegate() {
        return this.chart;
    }

    public void setCategoryLabelPositions(int angle) {
        double targetAngle = (double)angle * Math.PI / 180.0;
        Plot plot = this.chart.getPlot();
        if (plot instanceof CategoryPlot) {
            CategoryAxis domainAxis = ((CategoryPlot)plot).getDomainAxis();
            domainAxis.setCategoryLabelPositions(CategoryLabelPositions.createUpRotationLabelPositions((double)targetAngle));
        }
    }

    @Override
    public ChartType getChartType() {
        return this.chartType;
    }

    @Override
    public void setChartType(ChartType type) {
        if (this.chartType == type) {
            return;
        }
        this.chartType = type;
        this.updatePlot();
    }

    public int getPopupMenuType() {
        return this.popupMenuType;
    }

    public void setPopupMenuType(int popupMenuType) {
        this.popupMenuType = popupMenuType;
        this.updatePlot();
    }

    public int getExplodeSection() {
        return this.explodeSection;
    }

    public void setExplodeSection(int section) {
        this.explodeSection = section;
    }

    public void setPieChartSectionLabelType(int type) {
        this.pieChartSectionLabelType = type;
        if (this.isPieChart()) {
            ((PiePlot)this.getDelegate().getPlot()).setSectionLabelType(type);
        }
    }

    public void setPieChartValueFormatString(String format) {
        if (this.isPieChart()) {
            ((PiePlot)this.getDelegate().getPlot()).setValueFormatString(format);
        }
    }

    public void setPieChartValueFormat(NumberFormat format) {
        if (this.isPieChart()) {
            ((PiePlot)this.getDelegate().getPlot()).setValueFormat(format);
        }
    }

    public void setPieChartPercentFormatString(String format) {
        if (this.isPieChart()) {
            ((PiePlot)this.getDelegate().getPlot()).setPercentFormatString(format);
        }
    }

    public void setPieChartPercentFormat(NumberFormat format) {
        if (this.isPieChart()) {
            ((PiePlot)this.getDelegate().getPlot()).setPercentFormat(format);
        }
    }

    public EventListenerList getListenerList() {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        return this.listenerList;
    }

    public void addChartEventListener(ChartEventListener l) {
        this.getListenerList().add(ChartEventListener.class, l);
    }

    public void addChartMouseListener(ChartMouseListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Null 'listener' argument.");
        }
        this.chartMouseListeners.add(listener);
        if (this.panel != null) {
            this.panel.addChartMouseListener(listener);
        }
    }

    public void fireDataChange(ChartType oldChartType, ChartType newChartType) {
        Object[] listeners = this.getListenerList().getListenerList();
        ChartEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChartEventListener.class) continue;
            if (e == null) {
                e = new ChartEvent(this, oldChartType, newChartType);
            }
            ((ChartEventListener)listeners[i + 1]).dataChange(e);
        }
    }

    public AxesCollection getAxesCollection() {
        return this.axesCollection;
    }

    public void addAxes(Axes axes) {
        this.axesCollection.add(axes);
    }

    public void addAxes(int index, Axes axes) {
        this.axesCollection.add(index, axes);
    }

    public Axes getAxes(int index) {
        return (Axes)this.axesCollection.get(index);
    }

    public void removeAxes(int index) {
        this.axesCollection.remove(index);
    }

    public void clearAxesCollection() {
        this.axesCollection.clear();
    }

    public int sizeOfAxesCollection() {
        return this.axesCollection.size();
    }

    public ChartDataCollection getChartDataCollection() {
        return this.chartDataCollection;
    }

    public void addChartData(IChartData chartData) {
        this.chartDataCollection.add(chartData);
        this.updateData();
    }

    public void addChartData(int index, IChartData chartData) {
        this.chartDataCollection.add(index, chartData);
        this.updateData();
    }

    public IChartData getChartData(int index) {
        return (IChartData)this.chartDataCollection.get(index);
    }

    public void removeChartData(int index) {
        this.chartDataCollection.remove(index);
    }

    public void clearChartDataCollection() {
        this.chartDataCollection.clear();
        Plot plot = this.chart.getPlot();
        if (plot instanceof PiePlot) {
            ((PiePlot)plot).setDataset(null);
        } else if (plot instanceof CategoryPlot) {
            ((CategoryPlot)plot).setDataset(null);
        }
    }

    public int sizeOfChartDataCollection() {
        return this.chartDataCollection.size();
    }

    public boolean isDisplayLegend() {
        return this.displayLegend;
    }

    public void setDisplayLegend(boolean b) {
        this.displayLegend = b;
        org.jfree.chart.Legend curLegend = this.chart.getLegend();
        if (this.displayLegend) {
            if (curLegend == null) {
                this.chart.setLegend(this.createLegend());
            }
        } else if (curLegend != null) {
            this.chart.setLegend(null);
        }
    }

    public void setDisplayBlackAndWhite(boolean baw) {
        if (this.displayBlackAndWhite == baw) {
            return;
        }
        this.displayBlackAndWhite = baw;
        this.updatePlot();
    }

    public boolean isDisplayBlackAndWhite() {
        return this.displayBlackAndWhite;
    }

    public ChartArea getChartArea() {
        return this.chartArea;
    }

    public PlotArea getPlotArea() {
        return this.plotArea;
    }

    @Override
    public ITitle getChartTitle() {
        return this.chartTitle;
    }

    public Legend getLegend() {
        return this.legend;
    }

    public void setLegendAnchor(int anchor) {
        this.getLegend().setLegendAnchor(anchor);
    }

    public Series getSeries(int index) {
        return this.seriesCollection.get(index);
    }

    public Series getSeries(Object key) {
        return this.seriesCollection.get(key);
    }

    public ChartGroup getChartGroup(int index) {
        return this.chartGroups.get(index);
    }

    public ChartGroup getChartGroup(Object key) {
        return this.chartGroups.get(key);
    }

    @Override
    public BufferedImage createBufferedImage(int width, int height) {
        return this.chart.createBufferedImage(width, height);
    }

    @Override
    public void saveAsPng(File file, int width, int height) {
        try {
            ChartUtilities.saveChartAsPNG((File)file, (JFreeChart)this.chart, (int)width, (int)height);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeChartAsJPEG(OutputStream out, float quality, JFreeChart chart, int width, int height, ChartRenderingInfo info) throws IOException {
        try {
            ChartUtilities.writeChartAsJPEG((OutputStream)out, (float)quality, (JFreeChart)chart, (int)width, (int)height, (ChartRenderingInfo)info);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setLowerMargin(double margin) {
        if (this.chart != null) {
            if (this.chartType.getChartCategory() == ChartCategory.AREACHART || this.chartType.getChartCategory() == ChartCategory.BARCHART || this.chartType.getChartCategory() == ChartCategory.LINECHART) {
                this.chart.getCategoryPlot().getDomainAxis().setLowerMargin(margin);
            }
            if (this.chartType.getChartCategory() == ChartCategory.SCATTERPLOT) {
                this.chart.getXYPlot().getDomainAxis().setLowerMargin(margin);
            }
        }
    }

    public void setUpperMargin(double margin) {
        if (this.chart != null) {
            if (this.chartType.getChartCategory() == ChartCategory.AREACHART || this.chartType.getChartCategory() == ChartCategory.BARCHART || this.chartType.getChartCategory() == ChartCategory.LINECHART) {
                this.chart.getCategoryPlot().getDomainAxis().setUpperMargin(margin);
            }
            if (this.chartType.getChartCategory() == ChartCategory.SCATTERPLOT) {
                this.chart.getXYPlot().getDomainAxis().setUpperMargin(margin);
            }
        }
    }

    public void setPercentRangeLabel(double min, double max) {
        if (this.chart != null) {
            if (this.chartType.getChartCategory() == ChartCategory.AREACHART || this.chartType.getChartCategory() == ChartCategory.BARCHART || this.chartType.getChartCategory() == ChartCategory.LINECHART) {
                this.chart.getCategoryPlot().getRangeAxis().setRange(min, max);
            }
            if (this.chartType.getChartCategory() == ChartCategory.SCATTERPLOT) {
                this.chart.getXYPlot().getRangeAxis().setRange(min, max);
            }
        }
    }

    public void showNoDataMessage(String text) {
        this.setNoDataMessage(text);
        this.clearChartDataCollection();
    }

    public void showNoDataMessage(String text, Paint paint) {
        this.setNoDataMessage(text);
        this.setNoDataMessagePant(paint);
        this.clearChartDataCollection();
    }

    public void setNoDataMessage(String text) {
        this.chart.getPlot().setNoDataMessage(text);
    }

    public void setNoDataMessage(String text, Paint paint) {
        this.setNoDataMessage(text);
        this.setNoDataMessagePant(paint);
    }

    public void setNoDataMessagePant(Paint paint) {
        this.chart.getPlot().setNoDataMessagePaint(paint);
    }

    private void initDefaults() {
        if (this.initDefaults) {
            return;
        }
        this.axesCollection = new AxesCollection();
        this.chartDataCollection = new ChartDataCollection();
        this.chartArea = new ChartArea();
        this.plotArea = new PlotArea();
        this.chartTitle = new ChartTitle();
        this.axesCollection.add(0, new Axes());
        this.legend = new Legend();
        this.setLayout(ChartLayout.createLayout());
        this.setPreferredSize(new Dimension(450, 300));
        this.setBorder(BorderFactory.createLineBorder(Color.BLUE));
        this.initDefaults = true;
    }

    private void initChartView() {
        this.chart = this.createChart();
        if (this.panel != null) {
            this.remove((Component)((Object)this.panel));
        }
        this.panel = new ChartPanel(this, this.popupMenuType);
        for (int i = 0; i < this.chartMouseListeners.size(); ++i) {
            this.panel.addChartMouseListener((ChartMouseListener)this.chartMouseListeners.get(0));
        }
        this.add((Component)((Object)this.panel));
        this.validate();
        this.configDelegates(this.chart);
    }

    private void configDelegates(JFreeChart chart) {
        this.chartTitle.setDelegate(chart.getTitle());
        ValueAxis xAxis = null;
        ValueAxis yAxis = null;
        Plot plot = chart.getPlot();
        if (plot instanceof XYPlot) {
            XYPlot p = (XYPlot)plot;
            xAxis = p.getDomainAxis();
            yAxis = p.getRangeAxis();
            this.getAxes(0).getCategotyAxis().setDelegate((Axis)xAxis);
            this.getAxes(0).getValueAxis().setDelegate((Axis)yAxis);
        } else if (plot instanceof CategoryPlot && !(plot instanceof CombinedDomainCategoryPlot)) {
            CategoryPlot p = (CategoryPlot)plot;
            xAxis = p.getDomainAxis();
            yAxis = p.getRangeAxis();
            this.getAxes(0).getCategotyAxis().setDelegate((Axis)xAxis);
            this.getAxes(0).getValueAxis().setDelegate((Axis)yAxis);
        }
        this.legend.setDelegate(chart.getLegend());
    }

    private void updatePlot() {
        this.initDefaults();
        this.initChartView();
        this.updateData();
    }

    ChartPanel getChartPanel() {
        return this.panel;
    }

    public void setDataLimit(boolean b) {
        this.dataLimit = b;
    }

    public boolean isDataLimit() {
        return this.dataLimit;
    }

    public void setPieDataLimitNum(int dataLimitNum) {
        this.pieDataLimitNum = dataLimitNum;
    }

    public int getPieDataLimitNum() {
        return this.pieDataLimitNum;
    }

    public void setCommonDataFirstDimLimitNum(int firstLimit) {
        this.commonDataFirstDimLimitNum = firstLimit;
    }

    public int getCommonDataFirstDimLimitNum() {
        return this.commonDataFirstDimLimitNum;
    }

    public void setCommonDataSecondDimLimitNum(int secondLimit) {
        this.commonDataSecondDimLimitNum = secondLimit;
    }

    public int getCommonDataSecondDimLimitNum() {
        return this.commonDataSecondDimLimitNum;
    }

    private JFreeChart createChart() {
        String title = this.getChartTitle().getText();
        String categoryLabel = this.getAxes(0).getCategotyAxis().getTitle().getText();
        String valueLabel = this.getAxes(0).getValueAxis().getTitle().getText();
        PlotOrientation orient = PlotOrientation.VERTICAL;
        boolean legend = this.isDisplayLegend();
        boolean tooltips = true;
        boolean urls = true;
        if (categoryLabel != null && categoryLabel.length() <= 0) {
            categoryLabel = null;
        }
        if (valueLabel != null && valueLabel.length() <= 0) {
            valueLabel = null;
        }
        JFreeChart chart = null;
        for (int i = 0; i < 4; ++i) {
            CommonLogger.getLogger(ChartFactory.class).info((Object)ChartFactory.class.getResource(""));
        }
        if (this.chartType.getChartCategory() == ChartCategory.PIECHART) {
            if (this.chartType == ChartType.CT_PIE || this.chartType == ChartType.CT_PIEEXPLODED) {
                chart = ChartFactory.createPieChart((String)title, null, (boolean)legend, (boolean)tooltips, (boolean)urls);
                if (this.isDisplayBlackAndWhite()) {
                    chart.getPlot().setDrawingSupplier((DrawingSupplier)BawDrawingSupplier.getDefault());
                }
                if (this.pieChartSectionLabelType != -1) {
                    ((PiePlot)chart.getPlot()).setSectionLabelType(this.pieChartSectionLabelType);
                }
            } else if (this.chartType == ChartType.CT_PIE3D) {
                chart = ChartFactory.createPieChart3D((String)title, null, (boolean)legend, (boolean)tooltips, (boolean)urls);
                Pie3DPlot plot = (Pie3DPlot)chart.getPlot();
                plot.setStartAngle(270.0);
                plot.setForegroundAlpha(0.75f);
                plot.setRadius(0.7);
                if (this.isDisplayBlackAndWhite()) {
                    plot.setDrawingSupplier((DrawingSupplier)BawDrawingSupplier.getDefault());
                }
                if (this.pieChartSectionLabelType != -1) {
                    ((PiePlot)chart.getPlot()).setSectionLabelType(this.pieChartSectionLabelType);
                }
            }
        } else if (this.chartType.getChartCategory() == ChartCategory.MULTIPIECHART) {
            chart = ChartFactory.createPieChart((String)title, null, (int)1, (boolean)legend, (boolean)tooltips, (boolean)urls);
            if (this.isDisplayBlackAndWhite()) {
                chart.getPlot().setDrawingSupplier((DrawingSupplier)BawDrawingSupplier.getDefault());
            }
            if (this.pieChartSectionLabelType != -1) {
                ((PiePlot)chart.getPlot()).setSectionLabelType(this.pieChartSectionLabelType);
            }
        } else if (this.chartType.getChartCategory() == ChartCategory.BARCHART) {
            CategoryPlot cPlot;
            BarRenderer barRenderer;
            if (this.chartType == ChartType.CT_COLUMNCLUSTERED) {
                chart = ChartFactory.createBarChart((String)title, (String)categoryLabel, (String)valueLabel, null, (PlotOrientation)orient, (boolean)legend, (boolean)tooltips, (boolean)urls);
            } else if (this.chartType == ChartType.CT_COLUMNSTACKED) {
                chart = ChartFactory.createStackedBarChart((String)title, (String)categoryLabel, (String)valueLabel, null, (PlotOrientation)orient, (boolean)legend, (boolean)tooltips, (boolean)urls);
            } else if (this.chartType == ChartType.CT_COLUMNCLUSTERED3D) {
                chart = ChartFactory.createBarChart3D((String)title, (String)categoryLabel, (String)valueLabel, null, (PlotOrientation)orient, (boolean)legend, (boolean)tooltips, (boolean)urls);
            } else if (this.chartType == ChartType.CT_COLUMNSTACKED3D) {
                chart = ChartFactory.createStackedBarChart3D((String)title, (String)categoryLabel, (String)valueLabel, null, (PlotOrientation)orient, (boolean)legend, (boolean)tooltips, (boolean)urls);
            } else if (this.chartType == ChartType.CT_BARCLUSTERED) {
                orient = PlotOrientation.HORIZONTAL;
                chart = ChartFactory.createBarChart((String)title, (String)categoryLabel, (String)valueLabel, null, (PlotOrientation)orient, (boolean)legend, (boolean)tooltips, (boolean)urls);
            } else if (this.chartType == ChartType.CT_BARSTACKED) {
                orient = PlotOrientation.HORIZONTAL;
                chart = ChartFactory.createStackedBarChart((String)title, (String)categoryLabel, (String)valueLabel, null, (PlotOrientation)orient, (boolean)legend, (boolean)tooltips, (boolean)urls);
            } else if (this.chartType == ChartType.CT_BARCLUSTERED3D) {
                orient = PlotOrientation.HORIZONTAL;
                chart = ChartFactory.createBarChart3D((String)title, (String)categoryLabel, (String)valueLabel, null, (PlotOrientation)orient, (boolean)legend, (boolean)tooltips, (boolean)urls);
            } else if (this.chartType == ChartType.CT_BARSTACKED3D) {
                orient = PlotOrientation.HORIZONTAL;
                chart = ChartFactory.createStackedBarChart3D((String)title, (String)categoryLabel, (String)valueLabel, null, (PlotOrientation)orient, (boolean)legend, (boolean)tooltips, (boolean)urls);
            } else if (this.chartType == ChartType.CT_WATERFALL) {
                orient = PlotOrientation.HORIZONTAL;
                chart = this.createSelftWaterfallChart(title, categoryLabel, valueLabel, null, orient, legend, tooltips, urls);
            }
            if (this.isDisplayBlackAndWhite() && chart != null) {
                chart.getPlot().setDrawingSupplier((DrawingSupplier)BawDrawingSupplier.getDefault());
            }
            if (chart != null && (barRenderer = (BarRenderer)(cPlot = chart.getCategoryPlot()).getRenderer()) != null) {
                this.setGradientPaint(barRenderer);
            }
        } else if (this.chartType.getChartCategory() == ChartCategory.LINECHART) {
            chart = ChartFactory.createLineChart((String)title, (String)categoryLabel, (String)valueLabel, null, (PlotOrientation)orient, (boolean)legend, (boolean)tooltips, (boolean)urls);
            CategoryPlot plot = chart.getCategoryPlot();
            StandardLegend stdlegend = null;
            if (legend) {
                stdlegend = (StandardLegend)chart.getLegend();
            }
            if (this.chartType == ChartType.CT_LINEMARKERS || this.chartType == ChartType.CT_LINEMARKERSSTACKED) {
                LineAndShapeRenderer renderer = (LineAndShapeRenderer)plot.getRenderer();
                renderer.setDrawShapes(true);
                if (stdlegend != null) {
                    stdlegend.setDisplaySeriesShapes(true);
                }
            }
            if (this.isDisplayBlackAndWhite()) {
                plot.setDrawingSupplier((DrawingSupplier)BawDrawingSupplier.getSolid());
                if (stdlegend != null) {
                    stdlegend.setDisplaySeriesLines(true);
                }
            }
        } else if (this.chartType.getChartCategory() == ChartCategory.SCATTERPLOT) {
            chart = ChartFactory.createScatterPlot((String)title, (String)categoryLabel, (String)valueLabel, null, (PlotOrientation)orient, (boolean)legend, (boolean)tooltips, (boolean)urls);
            XYPlot plot = chart.getXYPlot();
            StandardXYItemRenderer renderer = (StandardXYItemRenderer)plot.getRenderer();
            StandardLegend stdlegend = null;
            if (legend) {
                stdlegend = (StandardLegend)chart.getLegend();
            }
            if (this.chartType == ChartType.CT_XYSCATTERLINES) {
                renderer.setPlotLines(true);
            } else if (this.chartType == ChartType.CT_XYSCATTERLINESNOMARKERS) {
                renderer.setPlotShapes(false);
                renderer.setPlotLines(true);
            }
            if (this.isDisplayBlackAndWhite()) {
                plot.setDrawingSupplier((DrawingSupplier)BawDrawingSupplier.getSolid());
            }
            if (stdlegend != null && this.isDisplayBlackAndWhite()) {
                if (this.chartType == ChartType.CT_XYSCATTERLINES) {
                    stdlegend.setDisplaySeriesShapes(true);
                    stdlegend.setDisplaySeriesLines(true);
                } else if (this.chartType == ChartType.CT_XYSCATTERLINESNOMARKERS) {
                    stdlegend.setDisplaySeriesShapes(false);
                    stdlegend.setDisplaySeriesLines(true);
                } else {
                    stdlegend.setDisplaySeriesShapes(true);
                    stdlegend.setDisplaySeriesLines(false);
                }
            }
        } else if (this.chartType.getChartCategory() == ChartCategory.AREACHART) {
            if (this.chartType == ChartType.CT_AREA) {
                chart = ChartFactory.createAreaChart((String)title, (String)categoryLabel, (String)valueLabel, null, (PlotOrientation)orient, (boolean)legend, (boolean)tooltips, (boolean)urls);
                CategoryPlot plot = chart.getCategoryPlot();
                plot.setForegroundAlpha(0.5f);
                if (this.isDisplayBlackAndWhite()) {
                    chart.getPlot().setDrawingSupplier((DrawingSupplier)BawDrawingSupplier.getDefault());
                }
            } else if (this.chartType == ChartType.CT_AREASTACKED) {
                chart = ChartFactory.createStackedAreaChart((String)title, (String)categoryLabel, (String)valueLabel, null, (PlotOrientation)orient, (boolean)legend, (boolean)tooltips, (boolean)urls);
                CategoryPlot plot = chart.getCategoryPlot();
                plot.setForegroundAlpha(0.5f);
                if (this.isDisplayBlackAndWhite()) {
                    chart.getPlot().setDrawingSupplier((DrawingSupplier)BawDrawingSupplier.getDefault());
                }
            }
        } else if (this.chartType.getChartCategory() == ChartCategory.GANTTCHART) {
            chart = ChartFactory.createGanttChart((String)title, (String)categoryLabel, (String)valueLabel, null, (boolean)legend, (boolean)tooltips, (boolean)urls);
            if (this.isDisplayBlackAndWhite()) {
                chart.getPlot().setDrawingSupplier((DrawingSupplier)BawDrawingSupplier.getDefault());
            }
        } else if (this.chartType.getChartCategory() == ChartCategory.COMBINEDCATEGORYPLOTCHART) {
            CategoryAxis domainAxis = new CategoryAxis("");
            CombinedDomainCategoryPlot plot = new CombinedDomainCategoryPlot(domainAxis);
            chart = new JFreeChart(title, JFreeChartConstants.DEFAULT_TITLE_FONT, (Plot)plot, true);
            chart.getLegend().setAnchor(3);
        } else if (this.chartType.getChartCategory() == ChartCategory.RADARCHART) {
            RadarPlot plot = new RadarPlot();
            chart = new JFreeChart(title, JFreeChartConstants.DEFAULT_TITLE_FONT, (Plot)plot, true);
            if (this.isDisplayBlackAndWhite()) {
                chart.getPlot().setDrawingSupplier((DrawingSupplier)BawDrawingSupplier.getSolid());
            }
        }
        return chart;
    }

    private void setGradientPaint(BarRenderer renderer) {
        GradientPaint gp0 = new GradientPaint(0.0f, 0.0f, new Color(255, 37, 37), 0.0f, 0.0f, new Color(145, 0, 0));
        GradientPaint gp1 = new GradientPaint(0.0f, 0.0f, new Color(56, 135, 255), 0.0f, 0.0f, new Color(5, 49, 114));
        GradientPaint gp2 = new GradientPaint(0.0f, 0.0f, new Color(94, 219, 73), 0.0f, 0.0f, new Color(33, 96, 0));
        GradientPaint gp3 = new GradientPaint(0.0f, 0.0f, new Color(253, 224, 21), 0.0f, 0.0f, new Color(231, 119, 4));
        GradientPaint gp4 = new GradientPaint(0.0f, 0.0f, new Color(120, 125, 228), 0.0f, 0.0f, new Color(55, 15, 131));
        GradientPaint gp5 = new GradientPaint(0.0f, 0.0f, new Color(250, 156, 15), 0.0f, 0.0f, new Color(217, 30, 15));
        GradientPaint gp6 = new GradientPaint(0.0f, 0.0f, new Color(178, 149, 126), 0.0f, 0.0f, new Color(91, 70, 55));
        GradientPaint gp7 = new GradientPaint(0.0f, 0.0f, new Color(239, 117, 237), 0.0f, 0.0f, new Color(149, 23, 149));
        GradientPaint gp8 = new GradientPaint(0.0f, 0.0f, new Color(152, 171, 203), 0.0f, 0.0f, new Color(57, 71, 97));
        GradientPaint gp9 = new GradientPaint(0.0f, 0.0f, new Color(191, 228, 252), 0.0f, 0.0f, new Color(65, 131, 185));
        GradientPaint gp10 = new GradientPaint(0.0f, 0.0f, new Color(255, 199, 202), 0.0f, 0.0f, new Color(234, 68, 76));
        GradientPaint gp11 = new GradientPaint(0.0f, 0.0f, new Color(106, 220, 242), 0.0f, 0.0f, new Color(26, 119, 138));
        GradientPaint gp12 = new GradientPaint(0.0f, 0.0f, new Color(173, 227, 43), 0.0f, 0.0f, new Color(68, 110, 10));
        GradientPaint gp13 = new GradientPaint(0.0f, 0.0f, new Color(107, 173, 189), 0.0f, 0.0f, new Color(83, 108, 141));
        GradientPaint gp14 = new GradientPaint(0.0f, 0.0f, new Color(227, 137, 137), 0.0f, 0.0f, new Color(136, 52, 52));
        GradientPaint gp15 = new GradientPaint(0.0f, 0.0f, new Color(255, 241, 216), 0.0f, 0.0f, new Color(247, 177, 77));
        renderer.setSeriesPaint(0, (Paint)gp0);
        renderer.setSeriesPaint(1, (Paint)gp1);
        renderer.setSeriesPaint(2, (Paint)gp2);
        renderer.setSeriesPaint(3, (Paint)gp3);
        renderer.setSeriesPaint(4, (Paint)gp4);
        renderer.setSeriesPaint(5, (Paint)gp5);
        renderer.setSeriesPaint(6, (Paint)gp6);
        renderer.setSeriesPaint(7, (Paint)gp7);
        renderer.setSeriesPaint(8, (Paint)gp8);
        renderer.setSeriesPaint(9, (Paint)gp9);
        renderer.setSeriesPaint(10, (Paint)gp10);
        renderer.setSeriesPaint(11, (Paint)gp11);
        renderer.setSeriesPaint(12, (Paint)gp12);
        renderer.setSeriesPaint(13, (Paint)gp13);
        renderer.setSeriesPaint(14, (Paint)gp14);
        renderer.setSeriesPaint(15, (Paint)gp15);
    }

    private void updateData() {
        boolean nullData = true;
        IChartData chartData = null;
        if (this.chartDataCollection != null && this.chartDataCollection.size() != 0) {
            chartData = this.getChartData(0);
            nullData = false;
        }
        if (this.chartType.getChartCategory() == ChartCategory.PIECHART) {
            if (this.chartType == ChartType.CT_PIE || this.chartType == ChartType.CT_PIEEXPLODED) {
                PiePlot plot = (PiePlot)this.chart.getPlot();
                PieDataset dataset = null;
                if (!nullData) {
                    if (this.isDataLimit()) {
                        if (((PieChartData)chartData).getValues().length > this.getPieDataLimitNum()) {
                            dataset = null;
                            this.setNoDataMessage(LanguageManager.getLangMessage((String)"Chart.data.tooBig", Chart.class, (String)"\u6570\u636e\u91cf\u592a\u5927\uff0c\u8bf7\u8c03\u6574\u6570\u636e\u91cf..."));
                        } else {
                            dataset = ChartDataUtil.createPieDataset(chartData);
                        }
                    } else {
                        dataset = ChartDataUtil.createPieDataset(chartData);
                    }
                }
                plot.setDataset(dataset);
                if (this.chartType == ChartType.CT_PIEEXPLODED && !nullData) {
                    if (this.isDataLimit()) {
                        if (((PieChartData)chartData).getValues().length <= this.getPieDataLimitNum()) {
                            plot.setRadius(0.8);
                            plot.setExplodePercent(this.getExplodeSection(), 1.0);
                        }
                    } else {
                        plot.setRadius(0.8);
                        plot.setExplodePercent(this.getExplodeSection(), 1.0);
                    }
                }
            } else if (this.chartType == ChartType.CT_PIE3D) {
                Pie3DPlot plot = (Pie3DPlot)this.chart.getPlot();
                PieDataset dataset = null;
                if (!nullData) {
                    if (this.isDataLimit()) {
                        if (((PieChartData)chartData).getValues().length > this.getPieDataLimitNum()) {
                            dataset = null;
                            this.setNoDataMessage(LanguageManager.getLangMessage((String)"Chart.data.tooBig", Chart.class, (String)"\u6570\u636e\u91cf\u592a\u5927\uff0c\u8bf7\u8c03\u6574\u6570\u636e\u91cf..."));
                        } else {
                            dataset = ChartDataUtil.createPieDataset(chartData);
                        }
                    } else {
                        dataset = ChartDataUtil.createPieDataset(chartData);
                    }
                }
                plot.setDataset(dataset);
            }
        } else if (this.chartType.getChartCategory() == ChartCategory.MULTIPIECHART) {
            PiePlot plot = (PiePlot)this.chart.getPlot();
            plot.setExtractType(1);
            CategoryDataset dataset = null;
            if (!nullData) {
                if (this.isDataLimit()) {
                    double[][] v = ((CommonChartData)chartData).getValues();
                    if (v.length > this.getCommonDataFirstDimLimitNum() || v.length > 0 && v[0].length > this.getCommonDataSecondDimLimitNum()) {
                        dataset = null;
                        this.setNoDataMessage(LanguageManager.getLangMessage((String)"Chart.data.tooBig", Chart.class, (String)"\u6570\u636e\u91cf\u592a\u5927\uff0c\u8bf7\u8c03\u6574\u6570\u636e\u91cf..."));
                    } else {
                        dataset = ChartDataUtil.createCategoryDataset(chartData);
                    }
                } else {
                    dataset = ChartDataUtil.createCategoryDataset(chartData);
                }
            }
            plot.setMultiDataset(dataset);
        } else if (this.chartType.getChartCategory() == ChartCategory.BARCHART) {
            CategoryPlot plot = this.chart.getCategoryPlot();
            CategoryDataset dataset = null;
            if (!nullData) {
                double[][] v = ((CommonChartData)chartData).getValues();
                if (this.isDataLimit()) {
                    if (v.length > this.getCommonDataFirstDimLimitNum() || v.length > 0 && v[0].length > this.getCommonDataSecondDimLimitNum()) {
                        dataset = null;
                        this.setNoDataMessage(LanguageManager.getLangMessage((String)"Chart.data.tooBig", Chart.class, (String)"\u6570\u636e\u91cf\u592a\u5927\uff0c\u8bf7\u8c03\u6574\u6570\u636e\u91cf..."));
                    } else {
                        dataset = ChartDataUtil.createCategoryDataset(chartData);
                    }
                } else {
                    dataset = ChartDataUtil.createCategoryDataset(chartData);
                }
                if (this.isAllDataZero(v)) {
                    plot.getRangeAxis().setAutoRange(false);
                }
            }
            plot.setDataset(dataset);
        } else if (this.chartType.getChartCategory() == ChartCategory.LINECHART) {
            CategoryPlot plot = this.chart.getCategoryPlot();
            CategoryDataset dataset = null;
            if (!nullData) {
                if (this.chartType == ChartType.CT_LINESTACKED || this.chartType == ChartType.CT_LINEMARKERSSTACKED) {
                    if (this.isDataLimit()) {
                        double[][] v = ((CommonChartData)chartData).getValues();
                        if (v.length > this.getCommonDataFirstDimLimitNum() || v.length > 0 && v[0].length > this.getCommonDataSecondDimLimitNum()) {
                            dataset = null;
                            this.setNoDataMessage(LanguageManager.getLangMessage((String)"Chart.data.tooBig", Chart.class, (String)"\u6570\u636e\u91cf\u592a\u5927\uff0c\u8bf7\u8c03\u6574\u6570\u636e\u91cf..."));
                        } else {
                            dataset = ChartDataUtil.createStackedCategoryDataset(chartData);
                        }
                    } else {
                        dataset = ChartDataUtil.createStackedCategoryDataset(chartData);
                    }
                } else if (this.isDataLimit()) {
                    double[][] v = ((CommonChartData)chartData).getValues();
                    if (v.length > this.getCommonDataFirstDimLimitNum() || v.length > 0 && v[0].length > this.getCommonDataSecondDimLimitNum()) {
                        dataset = null;
                        this.setNoDataMessage(LanguageManager.getLangMessage((String)"Chart.data.tooBig", Chart.class, (String)"\u6570\u636e\u91cf\u592a\u5927\uff0c\u8bf7\u8c03\u6574\u6570\u636e\u91cf..."));
                    } else {
                        dataset = ChartDataUtil.createCategoryDataset(chartData);
                    }
                } else {
                    dataset = ChartDataUtil.createCategoryDataset(chartData);
                }
            }
            plot.setDataset(dataset);
        } else if (this.chartType.getChartCategory() == ChartCategory.SCATTERPLOT) {
            XYPlot plot = this.chart.getXYPlot();
            XYDataset dataset = null;
            if (!nullData) {
                if (this.isDataLimit()) {
                    double[][] v = ((CommonChartData)chartData).getValues();
                    if (v.length > this.getCommonDataFirstDimLimitNum() || v.length > 0 && v[0].length > this.getCommonDataSecondDimLimitNum()) {
                        dataset = null;
                        this.setNoDataMessage(LanguageManager.getLangMessage((String)"Chart.data.tooBig", Chart.class, (String)"\u6570\u636e\u91cf\u592a\u5927\uff0c\u8bf7\u8c03\u6574\u6570\u636e\u91cf..."));
                    } else {
                        dataset = ChartDataUtil.createScatterDataset(chartData);
                    }
                } else {
                    dataset = ChartDataUtil.createScatterDataset(chartData);
                }
            }
            plot.setDataset(dataset);
        } else if (this.chartType.getChartCategory() == ChartCategory.AREACHART) {
            CategoryPlot plot = this.chart.getCategoryPlot();
            CategoryDataset dataset = null;
            if (!nullData) {
                if (this.isDataLimit()) {
                    double[][] v = ((CommonChartData)chartData).getValues();
                    if (v.length > this.getCommonDataFirstDimLimitNum() || v.length > 0 && v[0].length > this.getCommonDataSecondDimLimitNum()) {
                        dataset = null;
                        this.setNoDataMessage(LanguageManager.getLangMessage((String)"Chart.data.tooBig", Chart.class, (String)"\u6570\u636e\u91cf\u592a\u5927\uff0c\u8bf7\u8c03\u6574\u6570\u636e\u91cf..."));
                    } else {
                        dataset = ChartDataUtil.createCategoryDataset(chartData);
                    }
                } else {
                    dataset = ChartDataUtil.createCategoryDataset(chartData);
                }
            }
            plot.setDataset(dataset);
        } else if (this.chartType.getChartCategory() == ChartCategory.GANTTCHART) {
            CategoryPlot plot = (CategoryPlot)this.chart.getPlot();
            if (!nullData) {
                plot.setDataset((CategoryDataset)ChartDataUtil.createGanttDataset(chartData));
            }
        } else if (this.chartType.getChartCategory() == ChartCategory.COMBINEDCATEGORYPLOTCHART) {
            CombinedDomainCategoryPlot plot = (CombinedDomainCategoryPlot)this.chart.getPlot();
            List subplotList = plot.getSubplots();
            while (subplotList.size() > 0) {
                plot.remove((CategoryPlot)subplotList.get(0));
            }
            CategoryDataset dataset = null;
            for (int i = 0; i < this.chartDataCollection.size(); ++i) {
                chartData = (IChartData)this.chartDataCollection.get(i);
                if (this.isDataLimit()) {
                    double[][] v = ((CommonChartData)chartData).getValues();
                    if (v.length > this.getCommonDataFirstDimLimitNum() || v.length > 0 && v[0].length > this.getCommonDataSecondDimLimitNum()) {
                        dataset = null;
                        this.setNoDataMessage(LanguageManager.getLangMessage((String)"Chart.data.tooBig", Chart.class, (String)"\u6570\u636e\u91cf\u592a\u5927\uff0c\u8bf7\u8c03\u6574\u6570\u636e\u91cf..."));
                    } else {
                        dataset = ChartDataUtil.createCategoryDataset(chartData);
                    }
                } else {
                    dataset = ChartDataUtil.createCategoryDataset(chartData);
                }
                NumberAxis rangeAxis = new NumberAxis("");
                rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
                LineAndShapeRenderer renderer = new LineAndShapeRenderer();
                renderer.setBaseItemLabelGenerator((CategoryItemLabelGenerator)new StandardCategoryItemLabelGenerator());
                CategoryPlot subplot = new CategoryPlot(dataset, null, (ValueAxis)rangeAxis, (CategoryItemRenderer)renderer);
                subplot.setDomainGridlinesVisible(true);
                plot.add(subplot, 1);
            }
        } else if (this.chartType.getChartCategory() == ChartCategory.RADARCHART) {
            RadarPlot plot = (RadarPlot)this.chart.getPlot();
            if (!nullData) {
                plot.setDataset(ChartDataUtil.createCategoryDataset(chartData));
            }
        }
    }

    private boolean isPieChart() {
        if (this.getChartType().getChartCategory() == ChartCategory.PIECHART) {
            return true;
        }
        return this.getChartType().getChartCategory() == ChartCategory.MULTIPIECHART;
    }

    private boolean isAllDataZero(double[][] value) {
        if (value != null) {
            for (int i = 0; i < value.length; ++i) {
                for (int j = 0; j < value[i].length; ++j) {
                    if (value[i][j] == 0.0) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private org.jfree.chart.Legend createLegend() {
        StandardLegend stdlegend = (StandardLegend)org.jfree.chart.Legend.createInstance((JFreeChart)this.chart);
        if (this.chartType.getChartCategory() != ChartCategory.PIECHART && this.chartType.getChartCategory() != ChartCategory.BARCHART) {
            if (this.chartType.getChartCategory() == ChartCategory.LINECHART) {
                if (this.chartType == ChartType.CT_LINEMARKERS || this.chartType == ChartType.CT_LINEMARKERSSTACKED) {
                    stdlegend.setDisplaySeriesShapes(true);
                }
                if (this.isDisplayBlackAndWhite()) {
                    stdlegend.setDisplaySeriesLines(true);
                }
            } else if (this.chartType.getChartCategory() == ChartCategory.SCATTERPLOT) {
                if (this.isDisplayBlackAndWhite()) {
                    if (this.chartType == ChartType.CT_XYSCATTERLINES) {
                        stdlegend.setDisplaySeriesShapes(true);
                        stdlegend.setDisplaySeriesLines(true);
                    } else if (this.chartType == ChartType.CT_XYSCATTERLINESNOMARKERS) {
                        stdlegend.setDisplaySeriesShapes(false);
                        stdlegend.setDisplaySeriesLines(true);
                    } else {
                        stdlegend.setDisplaySeriesShapes(true);
                        stdlegend.setDisplaySeriesLines(false);
                    }
                }
            } else if (this.chartType.getChartCategory() == ChartCategory.AREACHART || this.chartType.getChartCategory() == ChartCategory.GANTTCHART) {
                // empty if block
            }
        }
        return stdlegend;
    }

    private JFreeChart createSelftWaterfallChart(String title, String categoryAxisLabel, String valueAxisLabel, CategoryDataset data, PlotOrientation orientation, boolean legend, boolean tooltips, boolean urls) {
        ItemLabelPosition position;
        CategoryAxis categoryAxis = new CategoryAxis(categoryAxisLabel);
        categoryAxis.setCategoryMargin(0.0);
        NumberAxis valueAxis = new NumberAxis(valueAxisLabel);
        WaterfallBarRenderer renderer = new WaterfallBarRenderer();
        if (orientation == PlotOrientation.HORIZONTAL) {
            position = new ItemLabelPosition(ItemLabelAnchor.CENTER, TextAnchor.CENTER, TextAnchor.CENTER, 0.0);
            renderer.setPositiveItemLabelPosition(position);
            renderer.setNegativeItemLabelPosition(position);
        } else if (orientation == PlotOrientation.VERTICAL) {
            position = new ItemLabelPosition(ItemLabelAnchor.CENTER, TextAnchor.CENTER, TextAnchor.CENTER, 0.0);
            renderer.setPositiveItemLabelPosition(position);
            renderer.setNegativeItemLabelPosition(position);
        }
        if (tooltips) {
            StandardCategoryItemLabelGenerator generator = new StandardCategoryItemLabelGenerator(NumberFormat.getInstance(), true);
            renderer.setItemLabelGenerator((CategoryItemLabelGenerator)generator);
        }
        if (urls) {
            renderer.setItemURLGenerator((CategoryURLGenerator)new StandardCategoryURLGenerator());
        }
        renderer.setOutlinePaint((Paint)Color.BLACK);
        renderer.setDrawBarOutline(true);
        CategoryPlot plot = new CategoryPlot(data, categoryAxis, (ValueAxis)valueAxis, (CategoryItemRenderer)renderer);
        plot.clearRangeMarkers();
        Marker baseline = new Marker(0.0, (Paint)Color.black);
        plot.addRangeMarker(baseline, Layer.FOREGROUND);
        plot.setRangeGridlinesVisible(false);
        plot.setOrientation(orientation);
        plot.setRangeAxisLocation(AxisLocation.BOTTOM_OR_LEFT);
        JFreeChart chart = new JFreeChart(title, JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, legend);
        ValueAxis rangeAxis = plot.getRangeAxis();
        DecimalFormat formatter = new DecimalFormat("#####");
        formatter.setNegativePrefix("(");
        formatter.setNegativeSuffix(")");
        TickUnits standardUnits = new TickUnits();
        standardUnits.add((TickUnit)new NumberTickUnit(5.0, (NumberFormat)formatter));
        standardUnits.add((TickUnit)new NumberTickUnit(10.0, (NumberFormat)formatter));
        standardUnits.add((TickUnit)new NumberTickUnit(20.0, (NumberFormat)formatter));
        standardUnits.add((TickUnit)new NumberTickUnit(50.0, (NumberFormat)formatter));
        standardUnits.add((TickUnit)new NumberTickUnit(100.0, (NumberFormat)formatter));
        standardUnits.add((TickUnit)new NumberTickUnit(200.0, (NumberFormat)formatter));
        standardUnits.add((TickUnit)new NumberTickUnit(500.0, (NumberFormat)formatter));
        standardUnits.add((TickUnit)new NumberTickUnit(1000.0, (NumberFormat)formatter));
        standardUnits.add((TickUnit)new NumberTickUnit(2000.0, (NumberFormat)formatter));
        standardUnits.add((TickUnit)new NumberTickUnit(5000.0, (NumberFormat)formatter));
        rangeAxis.setStandardTickUnits((TickUnitSource)standardUnits);
        DecimalFormat labelFormatter = new DecimalFormat("#####");
        labelFormatter.setNegativePrefix("(");
        labelFormatter.setNegativeSuffix(")");
        renderer.setItemLabelGenerator((CategoryItemLabelGenerator)new StandardCategoryItemLabelGenerator((NumberFormat)labelFormatter, false));
        renderer.setItemLabelsVisible(true);
        return chart;
    }

    static class ChartLayout
    implements LayoutManager {
        public static final ChartLayout layout = new ChartLayout();

        ChartLayout() {
        }

        public static ChartLayout createLayout() {
            return layout;
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void layoutContainer(Container parent) {
            Chart chart = (Chart)parent;
            ChartPanel pane = chart.getChartPanel();
            if (pane != null) {
                Insets insets = chart.getInsets();
                int w = chart.getWidth();
                int h = chart.getHeight();
                ((Component)((Object)pane)).setBounds(insets.left, insets.top, w - insets.left - insets.right, h - insets.top - insets.bottom);
            }
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return new Dimension(10, 10);
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(450, 300);
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }
    }
}

