/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.swing.chart;

import com.kingdee.bos.ctrl.swing.chart.Series;
import com.kingdee.bos.ctrl.swing.chart.SeriesCollection;

public class ChartGroup {
    private SeriesCollection coll;
    private String key;

    public ChartGroup() {
    }

    ChartGroup(String key, SeriesCollection coll) {
        if (coll == null || key == null) {
            throw new IllegalArgumentException("series collection couldn't be null!");
        }
        this.coll = coll;
        this.key = key;
    }

    public double getValue(int index) {
        return this.coll.get(index).getValue(this.key);
    }

    public double getValue(Object seriesKey) {
        Series series = this.coll.get(seriesKey);
        if (series != null) {
            return series.getValue(this.key);
        }
        return 0.0;
    }

    public Series getSeries(int index) {
        return this.coll.get(index);
    }

    public Series getSeries(Object seriesKey) {
        return this.coll.get(seriesKey);
    }

    public double[] getValues() {
        double[] ret = new double[this.coll.getCount()];
        for (int i = 0; i < this.coll.getCount(); ++i) {
            ret[i] = this.coll.get(i).getValue(this.key);
        }
        return ret;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.key);
        sb.append(':');
        sb.append(' ');
        double[] values = this.getValues();
        sb.append('{');
        if (values != null) {
            for (int i = 0; i < values.length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(values[i]);
            }
        } else {
            sb.append("no values");
        }
        sb.append('}');
        return sb.toString();
    }
}

