/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.swing.chart.data;

import com.kingdee.bos.ctrl.swing.chart.data.IChartData;
import java.util.Date;

public class GanttChartData
implements IChartData {
    public static final String name = "GanttChartData";
    private String[] seriesKeys;
    private String[] groupKeys;
    private Date[][][] dates;

    public GanttChartData(String[] seriesKeys, String[] groupKeys, Date[][][] dates) {
        int i;
        if (seriesKeys == null) {
            seriesKeys = new String[]{};
        }
        if (groupKeys == null) {
            groupKeys = new String[]{};
        }
        if (dates == null) {
            dates = new Date[0][0][0];
        }
        int seriesCount = 0;
        int groupsCount = 0;
        seriesCount = dates.length;
        if (seriesCount > 0) {
            for (i = 0; i < seriesCount; ++i) {
                if (dates[i] == null || dates[i].length <= groupsCount) continue;
                groupsCount = dates[i].length;
            }
        }
        if (seriesKeys.length > seriesCount) {
            seriesCount = seriesKeys.length;
        }
        if (groupKeys.length > groupsCount) {
            groupsCount = groupKeys.length;
        }
        this.seriesKeys = new String[seriesCount];
        this.groupKeys = new String[groupsCount];
        this.dates = new Date[seriesCount][groupsCount][2];
        for (i = 0; i < seriesCount; ++i) {
            this.seriesKeys[i] = i < seriesKeys.length && seriesKeys[i] != null ? seriesKeys[i] : "S" + i;
        }
        for (i = 0; i < groupsCount; ++i) {
            this.groupKeys[i] = i < groupKeys.length && groupKeys[i] != null ? groupKeys[i] : "G" + i;
        }
        for (i = 0; i < seriesCount; ++i) {
            if (i >= dates.length || dates[i] == null) continue;
            for (int j = 0; j < groupsCount; ++j) {
                if (j >= dates[i].length) continue;
                this.dates[i][j][0] = dates[i][j][0];
                this.dates[i][j][1] = dates[i][j][1];
            }
        }
    }

    @Override
    public String getName() {
        return name;
    }

    public String[] getSeriesKeys() {
        return this.seriesKeys;
    }

    public String[] getGroupKeys() {
        return this.groupKeys;
    }

    public Date[][][] getDates() {
        return this.dates;
    }

    public String toString() {
        return name;
    }
}

