/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.data.wizard.dataprocess;

import com.kingdee.bos.ctrl.common.ui.select.IObjectSelector;
import com.kingdee.bos.ctrl.data.meta.MetaClass;
import com.kingdee.bos.ctrl.data.meta.MetaField;
import com.kingdee.bos.ctrl.data.meta.MetaLibrary;
import com.kingdee.bos.ctrl.data.modal.IDataDef;
import com.kingdee.bos.ctrl.data.modal.Import;
import com.kingdee.bos.ctrl.data.modal.Imports;
import com.kingdee.bos.ctrl.data.wizard.common.ParamPanel;
import com.kingdee.bos.ctrl.data.wizard.dataprocess.DataSetBeanShellProcess;
import com.kingdee.bos.ctrl.data.wizard.dataprocess.ImportSelector;
import com.kingdee.bos.ctrl.data.wizard.dataprocess.WizardPane;
import com.kingdee.bos.ctrl.data.wizard.formula.FormulaWizardEditor;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import java.util.Iterator;
import java.util.List;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public abstract class BasicDataProcessWizard
extends WizardPane {
    protected ParamPanel paramUI;
    protected ImportSelector importSelector;
    protected DataSetBeanShellProcess dataSetProcess;
    protected IObjectSelector provider;
    protected IDataDef dataObj;

    @Override
    public Object getDataObject() {
        return this.dataObj;
    }

    @Override
    public void setDataObject(Object dataObj) {
        this.dataObj = (IDataDef)dataObj;
        this.showValue();
    }

    @Override
    public void setMeta(MetaLibrary ml) {
    }

    public void setProvider(IObjectSelector provider) {
        this.provider = provider;
        this.importSelector.setProvider(provider);
    }

    protected void updateFieldSupplyTree(KDTree tree) {
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)tree.getModel().getRoot();
        tree.removeAllChildrenFromParent((MutableTreeNode)root);
        Imports imports = this.importSelector.getImports();
        for (Import impt : imports) {
            Object obj = this.provider.getObject(impt.getExpr());
            if (obj == null || !(obj instanceof MetaClass)) continue;
            MetaClass mc = (MetaClass)obj;
            DefaultKingdeeTreeNode parent = new DefaultKingdeeTreeNode((Object)impt);
            tree.addNodeInto((MutableTreeNode)parent, (MutableTreeNode)root);
            for (MetaField mf : mc.getFields()) {
                tree.addNodeInto((MutableTreeNode)new DefaultKingdeeTreeNode((Object)mf), (MutableTreeNode)parent);
            }
        }
        tree.expandAllNodes(true, (TreeNode)root);
    }

    protected void updateImportOfFormula(FormulaWizardEditor f) {
        Imports imports = this.importSelector.getImports();
        MetaClass[] mcs = new MetaClass[imports.size()];
        String[] names = new String[imports.size()];
        Iterator it = imports.iterator();
        int i = 0;
        while (it.hasNext()) {
            Import impt = (Import)it.next();
            names[i] = impt.getName();
            Object obj = this.provider.getObject(impt.getExpr());
            if (obj == null) {
                mcs[i] = null;
                continue;
            }
            if (obj instanceof MetaClass) {
                mcs[i] = (MetaClass)obj;
            }
            ++i;
        }
        f.getFieldSupplyGroup().updateImportSupplyGroup(names, mcs);
    }

    protected void updateParamFormula() {
        List paramList = this.paramUI.getParameters();
        this.dataSetProcess.getFormulaEditor().getFieldSupplyGroup().updateParamGroup(paramList);
    }

    public ParamPanel getParamUI() {
        return this.paramUI;
    }
}

