/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.data.wizard.process;

import com.kingdee.bos.ctrl.common.FullPath;
import com.kingdee.bos.ctrl.common.ui.select.IObjectSelector;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.data.engine.script.beanshell.ScriptMaker;
import com.kingdee.bos.ctrl.data.modal.DataDef;
import com.kingdee.bos.ctrl.data.modal.Import;
import com.kingdee.bos.ctrl.data.modal.Imports;
import com.kingdee.bos.ctrl.data.modal.Outputs;
import com.kingdee.bos.ctrl.data.modal.ProcessScript;
import com.kingdee.bos.ctrl.data.modal.types.DataSetType;
import com.kingdee.bos.ctrl.data.modal.types.IDataSetTypeProvider;
import com.kingdee.bos.ctrl.data.modal.types.ScriptType;
import com.kingdee.bos.ctrl.data.process.IDataProcessModel;
import com.kingdee.bos.ctrl.data.wizard.common.ParamPanel;
import com.kingdee.bos.ctrl.data.wizard.process.ProcessResource;
import com.kingdee.bos.ctrl.data.wizard.process.ProcessWizard;
import com.kingdee.bos.ctrl.data.wizard.process.Wizard_SelectProcessor;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;
import org.apache.log4j.Logger;
import org.jdom2.Content;
import org.jdom2.Element;

public class WizardContext {
    private static Logger log = LogUtil.getPackageLogger(WizardContext.class);
    private ParamPanel paramEditor;
    private ScriptMaker bshScriptMaker = new ScriptMaker();
    private Stack outputsStack = new Stack();
    private HashMap properties = new HashMap();
    public static final String DATAPROVIDER = "DATAPROVIDER";
    public static final String PROCESSER_WIZARD_FILE = "PROCESSER_WIZARD_FILE";

    public DataSetType getLastDataSetType() {
        IDataSetTypeProvider output = this.getOutput();
        if (output == null) {
            return null;
        }
        return output.getType();
    }

    public void putProperty(String key, Object v) {
        this.properties.put(key, v);
    }

    public Object getProperty(String key) {
        return this.properties.get(key);
    }

    public void addProcessModel(IDataProcessModel model) {
        this.outputsStack.push(model);
    }

    public IDataSetTypeProvider getOutput() {
        if (this.outputsStack.isEmpty()) {
            return null;
        }
        return ((IDataProcessModel)this.outputsStack.peek()).getOutput();
    }

    public void discardOutput() {
        this.outputsStack.pop();
    }

    public final DataDef makeDataObject(List wizardList) {
        int i;
        StringBuffer scripts = new StringBuffer();
        Imports importsObj = new Imports();
        Element designInfoes = new Element("DesignInfoes");
        IDataProcessModel lastModel = null;
        int processStep = i = 0;
        while (i < wizardList.size()) {
            ProcessWizard wizard = (ProcessWizard)((Object)wizardList.get(i));
            IDataProcessModel model = wizard.getModel();
            if (model != null) {
                wizard.onGenerateScript(processStep++);
                designInfoes.addContent((Content)model.toXml());
                String[] imports = model.getImportExprs();
                if (imports != null) {
                    for (int j = 0; j < imports.length; ++j) {
                        FullPath fp = FullPath.parse((String)imports[j]);
                        Import importObj = new Import();
                        importObj.setName(fp.getPathx());
                        importObj.setExpr(imports[j]);
                        importsObj.add((Object)importObj);
                    }
                }
                lastModel = model;
            } else if (!(wizard instanceof Wizard_SelectProcessor)) {
                throw new UnsupportedOperationException(ProcessResource.getString("res_34") + (Object)((Object)wizard));
            }
            ++i;
        }
        String importScripts = this.bshScriptMaker.makeScript_imports();
        if (importScripts.length() > 0) {
            scripts.append(importScripts + "\n");
        }
        scripts.append(this.bshScriptMaker.getScript_process());
        if (log.isDebugEnabled()) {
            log.debug((Object)scripts);
        }
        DataDef object = new DataDef();
        object.setImports(importsObj);
        object.setProcessScript(new ProcessScript(ScriptType.BEANSHELL, scripts.toString()));
        if (null != lastModel) {
            object.setOutputs(new Outputs(lastModel.getOutput()));
        }
        object.setParameters(this.getParameterEditor().getParameters());
        object.setDesignInfoes(designInfoes);
        object.setVersion(1.0f);
        return object;
    }

    public final ScriptMaker getBshScriptGenerator() {
        return this.bshScriptMaker;
    }

    public final ParamPanel getParameterEditor() {
        if (this.paramEditor == null) {
            this.paramEditor = new ParamPanel();
        }
        return this.paramEditor;
    }

    public String getWizardConfigFile() {
        Object s = this.getProperty(PROCESSER_WIZARD_FILE);
        if (s == null) {
            return "/com/kingdee/bos/ctrl/data/wizard/process/ProcessWizard.xml";
        }
        return (String)s;
    }

    public IObjectSelector getObjSelector() {
        return (IObjectSelector)this.getProperty(DATAPROVIDER);
    }
}

