/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.data.framework.bos;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.FullPath;
import com.kingdee.bos.ctrl.common.util.DBUtil;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.data.DataDefType;
import com.kingdee.bos.ctrl.data.framework.bos.AUnitedResultSet;
import com.kingdee.bos.ctrl.data.framework.bos.BosUtil;
import com.kingdee.bos.ctrl.data.framework.bos.IdsDataAccess;
import com.kingdee.bos.ctrl.data.invoke.IDataExecutor;
import com.kingdee.bos.dao.query.EntityExecutorFactory;
import com.kingdee.bos.dao.query.IDataProvider;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import java.io.InputStream;
import java.io.Reader;
import java.security.InvalidParameterException;
import java.sql.Connection;
import java.sql.NClob;
import java.sql.ResultSet;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class BosExecutor
implements IDataExecutor {
    private static final Logger log = LogUtil.getPackageLogger(BosExecutor.class);
    public static final String EXECUTE_MODE = "executeMode";
    public static final String MODE_SQL = "SQL";
    public static final String MODE_RESULT_SET = "RESULT_SET";
    public static final String MODE_ROW_SET = "ROW_SET";
    public static final String MODE_IDS = "IDS";
    public static final String IDS_PAGE_SIZE = "intIdsPageSize";
    private Context ctx;
    private static BosExecutor remoteInstance = new BosExecutor(null);

    public static BosExecutor getRemoteInstance() {
        return remoteInstance;
    }

    public static BosExecutor newLocalInstance(Context ctx) {
        return new BosExecutor(ctx);
    }

    protected BosExecutor(Context ctx) {
        this.ctx = ctx;
    }

    @Override
    public Object execute(String category, Object obj, HashMap args, IDataExecutor env) throws Exception {
        if (obj instanceof QueryInfo) {
            return this.executeQuery(((QueryInfo)obj).getFullName(), args);
        }
        if (obj instanceof EntityViewInfo) {
            return this.executeEntity(((QueryInfo)obj).getFullName(), args);
        }
        if (obj instanceof FullPath) {
            FullPath fp = (FullPath)obj;
            DataDefType type = DataDefType.fromName((String)fp.getCategory());
            if (DataDefType.BOS_QUERY == type) {
                return this.executeQuery(fp.getDots(), args);
            }
            if (DataDefType.BOS_ENTITY == type) {
                return this.executeEntity(fp.getDots(), args);
            }
        }
        throw new UnsupportedOperationException();
    }

    private boolean isRemote() {
        return this.ctx == null;
    }

    protected IQueryExecutor getQueryExecutor(String fullName) {
        MetaDataPK pk = new MetaDataPK(fullName);
        if (this.isRemote()) {
            return QueryExecutorFactory.getRemoteInstance((IMetaDataPK)pk);
        }
        return QueryExecutorFactory.getLocalInstance((Context)this.ctx, (IMetaDataPK)pk);
    }

    protected IDataProvider getEntityExecutor(String fullName) {
        MetaDataPK pk = new MetaDataPK(fullName);
        if (this.isRemote()) {
            return EntityExecutorFactory.getRemoteInstance((IMetaDataPK)pk);
        }
        return EntityExecutorFactory.getLocalInstance((Context)this.ctx, (IMetaDataPK)pk);
    }

    public Object executeQuery(String fullName, HashMap args) throws BOSException, SQLException {
        IQueryExecutor exec = this.getQueryExecutor(fullName);
        try {
            QueryInfo qi = BosUtil.getMetaDataLoader().getQuery((IMetaDataPK)new MetaDataPK(fullName));
            EntityViewInfo evi = this.prepareDataView(args, qi);
            if (evi != null) {
                exec.setObjectView(evi);
            }
        }
        catch (Exception ex) {
            log.error((Object)"\u52a0\u6570\u636e\u89c6\u56fe\u5931\u8d25\uff0c\u5ffd\u7565\u9519\u8bef\u7ee7\u7eed\u8fd0\u884c", (Throwable)ex);
        }
        return this.executeWithMode((IDataProvider)exec, args);
    }

    public Object executeEntity(String fullName, HashMap args) throws BOSException, SQLException {
        IDataProvider exec = this.getEntityExecutor(fullName);
        try {
            EntityObjectInfo eoi = BosUtil.getMetaDataLoader().getEntity((IMetaDataPK)new MetaDataPK(fullName));
            EntityViewInfo evi = this.prepareDataView(args, eoi);
            if (evi != null) {
                exec.setObjectView(evi);
            }
        }
        catch (Exception ex) {
            log.error((Object)"\u52a0\u6570\u636e\u89c6\u56fe\u5931\u8d25\uff0c\u5ffd\u7565\u9519\u8bef\u7ee7\u7eed\u8fd0\u884c", (Throwable)ex);
        }
        return this.executeWithMode(exec, args);
    }

    protected EntityViewInfo prepareDataView(HashMap args, QueryInfo qi) throws Exception {
        return null;
    }

    protected EntityViewInfo prepareDataView(HashMap args, EntityObjectInfo eoi) throws Exception {
        return null;
    }

    private Object executeWithMode(IDataProvider exec, HashMap args) throws BOSException, SQLException {
        Object argExecMode = args.get(EXECUTE_MODE);
        if (argExecMode == null) {
            exec.option().isAutoTranslateEnum = true;
            if (log.isInfoEnabled()) {
                log.info((Object)("\r\n" + exec.getSQL()));
            }
            return exec.executeQuery();
        }
        if (MODE_SQL.equals(argExecMode)) {
            exec.option().isAutoTranslateEnum = false;
            String sql = exec.getSQL();
            if (log.isInfoEnabled()) {
                log.info((Object)("\r\n" + sql));
            }
            return sql;
        }
        if (MODE_RESULT_SET.equals(argExecMode)) {
            exec.option().isAutoTranslateEnum = false;
            String sql = exec.getSQL();
            if (log.isInfoEnabled()) {
                log.info((Object)("\r\n" + sql));
            }
            Connection conn = EJBFactory.getQueryConnection((Context)this.ctx);
            return DBUtil.executeSql((Connection)conn, (String)sql);
        }
        if (MODE_IDS.equals(argExecMode)) {
            Object pageSize = args.get(IDS_PAGE_SIZE);
            if (!(pageSize instanceof Integer)) {
                throw new InvalidParameterException("Nedd page size");
            }
            exec.option().isAutoTranslateEnum = true;
            return new BosIdsResultSet(exec, (int)((Integer)pageSize));
        }
        throw new InvalidParameterException("Unknown execute mode:" + argExecMode);
    }

    public static class BosIdsResultSet
    extends AUnitedResultSet {
        private static final Logger log = LogUtil.getPackageLogger(BosIdsResultSet.class);
        private IdsDataAccess dataAccess;
        private int pageSize;

        public BosIdsResultSet(IdsDataAccess dataAccess, int pageSize) {
            this.pageSize = pageSize;
            this.dataAccess = dataAccess;
        }

        public BosIdsResultSet(IDataProvider dataProvider, int pageSize) {
            this(new IdsDataAccess(dataProvider), pageSize);
        }

        @Override
        protected ResultSet nextResultSet(int startRowIndex) throws SQLException {
            try {
                return this.dataAccess.getRowSet(startRowIndex - 1, this.pageSize);
            }
            catch (BOSException ex) {
                log.error((Object)"\u83b7\u53d6BOS\u6570\u636e\u5931\u8d25", (Throwable)ex);
                throw new SQLException(ex.getMessage());
            }
        }

        @Override
        public RowId getRowId(int columnIndex) throws SQLException {
            return null;
        }

        @Override
        public RowId getRowId(String columnLabel) throws SQLException {
            return null;
        }

        @Override
        public void updateRowId(int columnIndex, RowId x) throws SQLException {
        }

        @Override
        public void updateRowId(String columnLabel, RowId x) throws SQLException {
        }

        @Override
        public int getHoldability() throws SQLException {
            return 0;
        }

        @Override
        public boolean isClosed() throws SQLException {
            return false;
        }

        @Override
        public void updateNString(int columnIndex, String nString) throws SQLException {
        }

        @Override
        public void updateNString(String columnLabel, String nString) throws SQLException {
        }

        @Override
        public void updateNClob(int columnIndex, NClob nClob) throws SQLException {
        }

        @Override
        public void updateNClob(String columnLabel, NClob nClob) throws SQLException {
        }

        @Override
        public NClob getNClob(int columnIndex) throws SQLException {
            return null;
        }

        @Override
        public NClob getNClob(String columnLabel) throws SQLException {
            return null;
        }

        @Override
        public SQLXML getSQLXML(int columnIndex) throws SQLException {
            return null;
        }

        @Override
        public SQLXML getSQLXML(String columnLabel) throws SQLException {
            return null;
        }

        @Override
        public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        }

        @Override
        public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        }

        @Override
        public String getNString(int columnIndex) throws SQLException {
            return null;
        }

        @Override
        public String getNString(String columnLabel) throws SQLException {
            return null;
        }

        @Override
        public Reader getNCharacterStream(int columnIndex) throws SQLException {
            return null;
        }

        @Override
        public Reader getNCharacterStream(String columnLabel) throws SQLException {
            return null;
        }

        @Override
        public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        }

        @Override
        public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        }

        @Override
        public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        }

        @Override
        public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        }

        @Override
        public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        }

        @Override
        public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        }

        @Override
        public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        }

        @Override
        public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        }

        @Override
        public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        }

        @Override
        public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        }

        @Override
        public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        }

        @Override
        public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        }

        @Override
        public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        }

        @Override
        public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        }

        @Override
        public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        }

        @Override
        public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        }

        @Override
        public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        }

        @Override
        public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        }

        @Override
        public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        }

        @Override
        public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        }

        @Override
        public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        }

        @Override
        public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        }

        @Override
        public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        }

        @Override
        public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        }

        @Override
        public void updateClob(int columnIndex, Reader reader) throws SQLException {
        }

        @Override
        public void updateClob(String columnLabel, Reader reader) throws SQLException {
        }

        @Override
        public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        }

        @Override
        public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        }

        @Override
        public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
            return null;
        }

        @Override
        public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
            return null;
        }

        @Override
        public <T> T unwrap(Class<T> iface) throws SQLException {
            return null;
        }

        @Override
        public boolean isWrapperFor(Class<?> iface) throws SQLException {
            return false;
        }
    }
}

