/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.data.invoke;

import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.data.invoke.DataContext;
import com.kingdee.bos.ctrl.data.invoke.IEnvProvider;
import com.kingdee.bos.ctrl.data.process.function.Functions;
import com.kingdee.bos.ctrl.kdf.expr.Parser;
import com.kingdee.bos.ctrl.kdf.expr.ParserHelperListener;
import com.kingdee.bos.ctrl.kdf.expr.RelationsListener;
import com.kingdee.bos.ctrl.kdf.expr.SyntaxErrorException;
import com.kingdee.bos.ctrl.kdf.expr.Variant;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class FormulaParserHelperListener
implements ParserHelperListener {
    public static final Logger logger = LogUtil.getLogger(FormulaParserHelperListener.class);
    private static final int ERROR_BADID = 4093;
    private static final String AT = "@";
    private static final int ID_RS_COLUMN = 1;
    private static final int ID_PARAMETER = 2;
    private static final int ID_PROPERTY = 3;
    private int idType;
    private boolean meetAT = false;
    private DataContext ctx;

    public FormulaParserHelperListener(DataContext ctx) {
        this.ctx = ctx;
    }

    public FormulaParserHelperListener(HashMap parameters, IEnvProvider envProvider, ResultSet rs) {
        this.ctx = new DataContext(null, parameters, envProvider, null);
        this.ctx.setDataResult(rs);
    }

    public long parseToken(Parser psr) throws SyntaxErrorException {
        String word = psr.getCurrentWord();
        if (AT.equals(word)) {
            if (!this.meetAT) {
                this.meetAT = true;
                psr.advance();
                if (psr.meet(0x4000000L)) {
                    psr.advance();
                    if (psr.meet(0x100000000000000L)) {
                        this.idType = 3;
                        return 0x100000000000000L;
                    }
                    return 0x400000000L;
                }
                if (psr.meet(0x100000000000000L)) {
                    this.idType = 2;
                    return 0x100000000000000L;
                }
                return 0x400000000L;
            }
            return 0x4000000L;
        }
        this.meetAT = false;
        if (FormulaParserHelperListener.isValidID(word)) {
            this.idType = 1;
            return 0x100000000000000L;
        }
        return 0x400000000L;
    }

    public void parseID(Parser psr, String id, Variant rvarResult) throws SyntaxErrorException {
        switch (this.idType) {
            case 3: {
                rvarResult.setObject(this.ctx.getEnvProvider().get(id));
                break;
            }
            case 2: {
                rvarResult.setObject(this.ctx.getParameters().get(id));
                break;
            }
            default: {
                Object rv = this.ctx.getDataResult();
                if (rv instanceof ResultSet) {
                    try {
                        rvarResult.setObject(((ResultSet)rv).getObject(id));
                        break;
                    }
                    catch (SQLException ex) {
                        logger.error((Object)"", (Throwable)ex);
                        throw new SyntaxErrorException(4093L, (Object)("The specified column '" + id + "' was not existed, details: '" + ex.toString() + "'"));
                    }
                }
                throw new SyntaxErrorException(4093L, (Object)("Colun't resolve id '" + id + "'"));
            }
        }
    }

    public boolean externalMethod(Parser psr, String funcName, ArrayList params, Variant rvarResult) throws SyntaxErrorException {
        try {
            Object[] paramVals = new Object[params.size()];
            for (int i = 0; i < paramVals.length; ++i) {
                paramVals[i] = ((Variant)params.get(i)).getValue();
            }
            rvarResult.setObject(Functions.callFunc(funcName, paramVals));
            return true;
        }
        catch (IllegalArgumentException ex) {
            throw new SyntaxErrorException(0L, (Object)ex.toString());
        }
    }

    public String getMethodName(String methodName) {
        return null;
    }

    public void processExt(Parser psr, Variant rvarResult) throws SyntaxErrorException {
    }

    public Variant getObjectInstance(Parser psr, String name) throws SyntaxErrorException {
        return null;
    }

    public boolean queryCell(Parser psr, RelationsListener listener, int row, int col, Variant rvarResult) throws SyntaxErrorException {
        return false;
    }

    private static boolean isValidID(String idStr) {
        for (int i = 0; i < idStr.length(); ++i) {
            char ch = idStr.charAt(i);
            if (Character.isDigit(ch) || Character.isLetter(ch)) continue;
            return false;
        }
        return true;
    }
}

