/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.data.modal.io;

import com.kingdee.bos.ctrl.data.DataDefType;
import com.kingdee.bos.ctrl.data.meta.MetaClass;
import com.kingdee.bos.ctrl.data.modal.CommonQuery;
import com.kingdee.bos.ctrl.data.modal.IDataDef;
import com.kingdee.bos.ctrl.data.modal.IDefObj;
import com.kingdee.bos.ctrl.data.modal.Outputs;
import com.kingdee.bos.ctrl.data.modal.query.io.Query2Meta;
import com.kingdee.bos.ctrl.data.modal.types.crosstab.CrosstabDef;
import com.kingdee.bos.ctrl.data.modal.types.grouping.Grouping;
import com.kingdee.bos.ctrl.data.modal.types.rows.OutputColumns;
import java.util.Iterator;

public class DataDef2Meta {
    public static final MetaClass parseDataObject(IDataDef dataObj) {
        Iterator flds = null;
        DataDefType type = null;
        Outputs outs = dataObj.getOutputs();
        if (dataObj instanceof CommonQuery) {
            type = DataDefType.KDRS_QUERY;
            flds = outs != null && outs.size() > 0 ? ((OutputColumns)outs.get(0)).iterator() : ((CommonQuery)dataObj).getQuery().getColumns().iterator();
        } else if (outs != null && outs.size() > 0) {
            Object out = outs.get(0);
            if (out instanceof OutputColumns) {
                type = DataDefType.KDRS_ROWSET;
                flds = ((OutputColumns)out).iterator();
            } else if (out instanceof Grouping) {
                type = DataDefType.KDRS_GROUPING;
                flds = ((Grouping)out).getFields().iterator();
            } else if (out instanceof CrosstabDef) {
                type = DataDefType.KDRS_CROSSTAB;
            }
        }
        MetaClass mc = new MetaClass();
        if (type != null) {
            mc.setType(type.getName());
        }
        mc.copy((IDefObj)dataObj);
        if (flds != null) {
            Query2Meta.makeMetaFields(mc, flds);
        }
        mc.setParameters(dataObj.getParameters());
        return mc;
    }

    public static final DataDefType parseType(Object dataObj) {
        if (dataObj == null) {
            return null;
        }
        if (dataObj instanceof CommonQuery) {
            return DataDefType.KDRS_QUERY;
        }
        if (dataObj instanceof IDataDef) {
            Outputs outs = ((IDataDef)dataObj).getOutputs();
            if (outs == null || outs.isEmpty()) {
                return null;
            }
            Object out = outs.get(0);
            if (out instanceof OutputColumns) {
                return DataDefType.KDRS_ROWSET;
            }
            if (out instanceof Grouping) {
                return DataDefType.KDRS_GROUPING;
            }
            if (out instanceof CrosstabDef) {
                return DataDefType.KDRS_CROSSTAB;
            }
            return null;
        }
        return null;
    }
}

