/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.data.process;

import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.data.DataDefType;
import com.kingdee.bos.ctrl.data.meta.MetaClass;
import com.kingdee.bos.ctrl.data.meta.MetaField;
import com.kingdee.bos.ctrl.data.meta.MetaUtil;
import com.kingdee.bos.ctrl.data.modal.IDataDef;
import com.kingdee.bos.ctrl.data.modal.IDefObj;
import com.kingdee.bos.ctrl.data.modal.query.Column;
import com.kingdee.bos.ctrl.data.modal.types.IDataSetTypeProvider;
import com.kingdee.bos.ctrl.data.modal.types.rows.OutputColumn;
import com.kingdee.bos.ctrl.data.modal.types.rows.OutputColumns;
import com.kingdee.bos.ctrl.data.process.AbstractDataProcessModel;
import com.kingdee.bos.ctrl.data.process.IDataProcessModel;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.jdom2.Element;

public class ProcessUtil {
    public static final Logger log = LogUtil.getPackageLogger(ProcessUtil.class);

    public static int findColumn(List cols, String name) {
        for (int i = 0; i < cols.size(); ++i) {
            Column c = (Column)((Object)cols.get(i));
            if (!c.getName().equalsIgnoreCase(name)) continue;
            return i;
        }
        return -1;
    }

    public static IDataSetTypeProvider mc2DataSetOutput(MetaClass mc) {
        if (MetaUtil.likeRows((MetaClass)mc)) {
            return ProcessUtil.mc2OutputColumns(mc);
        }
        List list = mc.getFields();
        IDataDef dataDef = (IDataDef)list.get(0);
        return (IDataSetTypeProvider)dataDef.getOutputs().get(0);
    }

    public static final OutputColumns mc2OutputColumns(MetaClass mc) {
        if (!MetaUtil.likeRows((MetaClass)mc)) {
            return null;
        }
        OutputColumns al = new OutputColumns();
        List mfields = mc.getFields();
        Iterator i = mfields.iterator();
        int colIndex = 1;
        while (i.hasNext()) {
            MetaField mField = (MetaField)i.next();
            OutputColumn col = new OutputColumn();
            col.copy((IDefObj)mField);
            col.setDataType(mField.getType());
            col.setName(mField.getName());
            col.setOriginSeq(colIndex++);
            al.add(col);
        }
        return al;
    }

    public static MetaClass cols2MetaClass(List outputCols) {
        MetaClass mc = new MetaClass();
        mc.setType(DataDefType.KDRS_ROWSET.getName());
        for (int i = 0; i < outputCols.size(); ++i) {
            Column c = (Column)((Object)outputCols.get(i));
            MetaField metaField = new MetaField();
            metaField.copy((IDefObj)c);
            metaField.setName(c.getName());
            metaField.setType(c.getDataType());
            mc.addField(metaField);
        }
        return mc;
    }

    public static OutputColumns filterOutputColumns(OutputColumns ocs, String[] names) {
        OutputColumns newOCs = new OutputColumns();
        for (int i = 0; i < names.length; ++i) {
            OutputColumn oc = ocs.findColumn(names[i]);
            if (oc == null) {
                log.error((Object)("Coludn't find column:" + names[i]));
                return null;
            }
            newOCs.add(oc);
        }
        return newOCs;
    }

    public static IDataProcessModel getModelFromInfoes(Element designInfoes, int index) throws Exception {
        List elements = designInfoes.getChildren(AbstractDataProcessModel.T_MODEL);
        return ProcessUtil.xml2Model((Element)elements.get(index));
    }

    public static IDataProcessModel xml2Model(Element e) throws Exception {
        String modelType = e.getAttributeValue(AbstractDataProcessModel.ATTR_MODEL_TYPE);
        Class<?> javaType = null;
        try {
            javaType = Class.forName(modelType);
        }
        catch (ClassNotFoundException ex) {
            String tmp = ".process2.";
            int index = modelType.indexOf(tmp);
            if (index != -1) {
                String target = ".process.";
                String tryClass = modelType.substring(0, index) + target + modelType.substring(index + tmp.length());
                javaType = Class.forName(tryClass);
            }
            throw ex;
        }
        Constructor<?> c = javaType.getConstructor(null);
        IDataProcessModel model = (IDataProcessModel)c.newInstance(null);
        model.fromXml(e);
        return model;
    }

    public static List xml2Models(Element designInfoes) throws Exception {
        List elements = designInfoes.getChildren(AbstractDataProcessModel.T_MODEL);
        ArrayList<IDataProcessModel> models = new ArrayList<IDataProcessModel>();
        if (elements != null) {
            for (Element e : elements) {
                models.add(ProcessUtil.xml2Model(e));
            }
        }
        return models;
    }
}

