/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.database;

import com.kingdee.bos.ctrl.etl.database.BaseDatabaseMeta;
import com.kingdee.bos.ctrl.etl.database.DatabaseInterface;
import com.kingdee.bos.ctrl.etl.util.Const;
import com.kingdee.bos.ctrl.etl.value.Value;

public class OracleDatabaseMeta
extends BaseDatabaseMeta
implements DatabaseInterface {
    public OracleDatabaseMeta(String name, String access, String host, String db, int port, String user, String pass) {
        super(name, access, host, db, port, user, pass);
    }

    public OracleDatabaseMeta() {
    }

    @Override
    public String getDatabaseTypeDesc() {
        return "ORACLE";
    }

    @Override
    public String getDatabaseTypeDescLong() {
        return "Oracle";
    }

    @Override
    public int getDatabaseType() {
        return 4;
    }

    @Override
    public int[] getAccessTypeList() {
        return new int[]{0, 1, 2};
    }

    @Override
    public int getDefaultDatabasePort() {
        if (this.getAccessType() == 0) {
            return 1521;
        }
        return -1;
    }

    @Override
    public boolean supportsAutoInc() {
        return false;
    }

    @Override
    public String getLimitClause(int nrRows) {
        return " WHERE ROWNUM <= " + nrRows;
    }

    @Override
    public String getSQLQueryFields(String tableName) {
        return "SELECT /*+FIRST_ROWS*/ * FROM " + tableName + " WHERE ROWNUM < 1";
    }

    @Override
    public String getDriverClass() {
        if (this.getAccessType() == 1) {
            return "sun.jdbc.odbc.JdbcOdbcDriver";
        }
        return "oracle.jdbc.driver.OracleDriver";
    }

    @Override
    public String getURL() {
        if (this.getAccessType() == 1) {
            return "jdbc:odbc:" + this.getDatabaseName();
        }
        if (this.getAccessType() == 0) {
            return "jdbc:oracle:thin:@" + this.getHostname() + ":" + this.getDatabasePortNumber() + ":" + this.getDatabaseName();
        }
        if (this.getDatabaseName() != null && this.getDatabaseName().length() > 0 && this.getDatabasePortNumber() != 0) {
            return "jdbc:oracle:oci:@(description=(address=(host=" + this.getHostname() + ")(protocol=tcp)(port=" + this.getDatabasePortNumber() + "))(connect_data=(sid=" + this.getDatabaseName() + ")))";
        }
        return "jdbc:oracle:oci:@" + this.getDatabaseName();
    }

    @Override
    public boolean supportsSequences() {
        return true;
    }

    @Override
    public String getSQLSequenceExists(String sequenceName) {
        return "SELECT * FROM USER_SEQUENCES WHERE SEQUENCE_NAME = '" + sequenceName.toUpperCase() + "'";
    }

    @Override
    public String getSQLCurrentSequenceValue(String sequenceName) {
        return "SELECT " + sequenceName + ".currval FROM DUAL";
    }

    @Override
    public String getSQLNextSequenceValue(String sequenceName) {
        return "SELECT " + sequenceName + ".nextval FROM dual";
    }

    @Override
    public boolean useSchemaNameForTableList() {
        return true;
    }

    @Override
    public boolean supportsSynonyms() {
        return true;
    }

    @Override
    public String getAddColumnStatement(String tablename, Value v, String tk, boolean use_autoinc, String pk, boolean semicolon) {
        return "ALTER TABLE " + tablename + " ADD ( " + this.getFieldDefinition(v, tk, pk, use_autoinc, true, false) + " ) ";
    }

    @Override
    public String getDropColumnStatement(String tablename, Value v, String tk, boolean use_autoinc, String pk, boolean semicolon) {
        return "ALTER TABLE " + tablename + " DROP ( " + v.getName() + " ) " + Const.CR;
    }

    @Override
    public String getModifyColumnStatement(String tablename, Value v, String tk, boolean use_autoinc, String pk, boolean semicolon) {
        return "ALTER TABLE " + tablename + " MODIFY (" + this.getFieldDefinition(v, tk, pk, use_autoinc, true, false) + " )";
    }

    @Override
    public String getFieldDefinition(Value v, String tk, String pk, boolean use_autoinc, boolean add_fieldname, boolean add_cr) {
        String retval = "";
        String fieldname = v.getName();
        int length = v.getLength();
        int precision = v.getPrecision();
        if (add_fieldname) {
            retval = retval + fieldname + " ";
        }
        int type = v.getType();
        switch (type) {
            case 3: {
                retval = retval + "DATE";
                break;
            }
            case 4: {
                retval = retval + "CHAR(1)";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                retval = retval + "NUMBER";
                if (length <= 0) break;
                retval = retval + "(" + length;
                if (precision > 0) {
                    retval = retval + ", " + precision;
                }
                retval = retval + ")";
                break;
            }
            case 2: {
                if (length >= 9999999) {
                    retval = retval + "CLOB";
                    break;
                }
                retval = retval + "VARCHAR2";
                retval = length > 0 && length <= 2000 ? retval + "(" + length : retval + "(2000";
                retval = retval + ")";
                break;
            }
            default: {
                retval = retval + " UNKNOWN";
            }
        }
        if (add_cr) {
            retval = retval + Const.CR;
        }
        return retval;
    }

    @Override
    public String[] getReservedWords() {
        return new String[]{"ACCESS", "ADD", "ALL", "ALTER", "AND", "ANY", "ARRAYLEN", "AS", "ASC", "AUDIT", "BETWEEN", "BY", "CHAR", "CHECK", "CLUSTER", "COLUMN", "COMMENT", "COMPRESS", "CONNECT", "CREATE", "CURRENT", "DATE", "DECIMAL", "DEFAULT", "DELETE", "DESC", "DISTINCT", "DROP", "ELSE", "EXCLUSIVE", "EXISTS", "FILE", "FLOAT", "FOR", "FROM", "GRANT", "GROUP", "HAVING", "IDENTIFIED", "IMMEDIATE", "IN", "INCREMENT", "INDEX", "INITIAL", "INSERT", "INTEGER", "INTERSECT", "INTO", "IS", "LEVEL", "LIKE", "LOCK", "LONG", "MAXEXTENTS", "MINUS", "MODE", "MODIFY", "NOAUDIT", "NOCOMPRESS", "NOT", "NOTFOUND", "NOWAIT", "NULL", "NUMBER", "OF", "OFFLINE", "ON", "ONLINE", "OPTION", "OR", "ORDER", "PCTFREE", "PRIOR", "PRIVILEGES", "PUBLIC", "RAW", "RENAME", "RESOURCE", "REVOKE", "ROW", "ROWID", "ROWLABEL", "ROWNUM", "ROWS", "SELECT", "SESSION", "SET", "SHARE", "SIZE", "SMALLINT", "SQLBUF", "START", "SUCCESSFUL", "SYNONYM", "SYSDATE", "TABLE", "THEN", "TO", "TRIGGER", "UID", "UNION", "UNIQUE", "UPDATE", "USER", "VALIDATE", "VALUES", "VARCHAR", "VARCHAR2", "VIEW", "WHENEVER", "WHERE", "WITH"};
    }

    @Override
    public String getSQLListOfProcedures() {
        return "SELECT DISTINCT DECODE(package_name, NULL, '', package_name||'.')||object_name FROM user_arguments";
    }

    @Override
    public String getSQLLockTables(String[] tableNames) {
        String sql = "";
        for (int i = 0; i < tableNames.length; ++i) {
            sql = sql + "LOCK TABLE " + tableNames[i] + " IN EXCLUSIVE MODE;" + Const.CR;
        }
        return sql;
    }

    @Override
    public String getSQLUnlockTables(String[] tableNames) {
        return null;
    }
}

