/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.transformation.step.calculator;

import com.kingdee.bos.ctrl.etl.base.CheckResult;
import com.kingdee.bos.ctrl.etl.base.Row;
import com.kingdee.bos.ctrl.etl.exception.ETLException;
import com.kingdee.bos.ctrl.etl.exception.ETLStepException;
import com.kingdee.bos.ctrl.etl.exception.ETLXMLException;
import com.kingdee.bos.ctrl.etl.repository.Repository;
import com.kingdee.bos.ctrl.etl.transformation.Trans;
import com.kingdee.bos.ctrl.etl.transformation.TransMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.BaseStepMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.StepDataInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMetaInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.calculator.Calculator;
import com.kingdee.bos.ctrl.etl.transformation.step.calculator.CalculatorData;
import com.kingdee.bos.ctrl.etl.transformation.step.calculator.CalculatorMetaFunction;
import com.kingdee.bos.ctrl.etl.util.Const;
import com.kingdee.bos.ctrl.etl.util.XMLHandler;
import com.kingdee.bos.ctrl.etl.value.Value;
import java.util.Hashtable;
import java.util.List;
import org.w3c.dom.Node;

public class CalculatorMeta
extends BaseStepMeta
implements StepMetaInterface {
    private CalculatorMetaFunction[] calculation;

    public CalculatorMetaFunction[] getCalculation() {
        return this.calculation;
    }

    public void setCalculation(CalculatorMetaFunction[] calcTypes) {
        this.calculation = calcTypes;
    }

    public void allocate(int nrCalcs) {
        this.calculation = new CalculatorMetaFunction[nrCalcs];
    }

    @Override
    public void loadXML(Node stepnode, List databases, Hashtable counters) throws ETLXMLException {
        int nrCalcs = XMLHandler.countNodes(stepnode, "calculation");
        this.allocate(nrCalcs);
        for (int i = 0; i < nrCalcs; ++i) {
            Node calcnode = XMLHandler.getSubNodeByNr(stepnode, "calculation", i);
            this.calculation[i] = new CalculatorMetaFunction(calcnode);
        }
    }

    @Override
    public String getXML() {
        String xml = "";
        if (this.calculation != null) {
            for (int i = 0; i < this.calculation.length; ++i) {
                xml = xml + "       " + this.calculation[i].getXML() + Const.CR;
            }
        }
        return xml;
    }

    @Override
    public Object clone() {
        CalculatorMeta retval = (CalculatorMeta)super.clone();
        if (this.calculation != null) {
            retval.allocate(this.calculation.length);
            for (int i = 0; i < this.calculation.length; ++i) {
                retval.getCalculation()[i] = (CalculatorMetaFunction)this.calculation[i].clone();
            }
        } else {
            retval.allocate(0);
        }
        return retval;
    }

    @Override
    public void setDefault() {
        this.calculation = new CalculatorMetaFunction[0];
    }

    @Override
    public void readRep(Repository rep, long id_step, List databases, Hashtable counters) throws ETLException {
        int nrCalcs = rep.countNrStepAttributes(id_step, "field_name");
        this.allocate(nrCalcs);
        for (int i = 0; i < nrCalcs; ++i) {
            this.calculation[i] = new CalculatorMetaFunction(rep, id_step, i);
        }
    }

    @Override
    public void saveRep(Repository rep, long id_transformation, long id_step) throws ETLException {
        for (int i = 0; i < this.calculation.length; ++i) {
            this.calculation[i].saveRep(rep, id_transformation, id_step, i);
        }
    }

    @Override
    public Row getFields(Row r, String name, Row info) throws ETLStepException {
        Row row = r == null ? new Row() : r;
        for (int i = 0; i < this.calculation.length; ++i) {
            CalculatorMetaFunction fn = this.calculation[i];
            if (fn.isRemovedFromResult() || fn.getFieldName() == null || fn.getFieldName().length() <= 0) continue;
            Value v = new Value(fn.getFieldName(), fn.getValueType());
            v.setLength(fn.getValueLength(), fn.getValuePrecision());
            v.setOrigin(name);
            row.addValue(v);
        }
        return row;
    }

    @Override
    public void check(List remarks, StepMeta stepinfo, Row prev, String[] input, String[] output, Row info) {
        CheckResult cr;
        if (prev == null || prev.size() == 0) {
            cr = new CheckResult(3, "Not receiving any fields from previous steps!", stepinfo);
            remarks.add(cr);
        } else {
            cr = new CheckResult(1, "Step is connected to previous one, receiving " + prev.size() + " fields", stepinfo);
            remarks.add(cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, "Step is receiving info from other steps.", stepinfo);
            remarks.add(cr);
        } else {
            cr = new CheckResult(4, "No input received from other steps!", stepinfo);
            remarks.add(cr);
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta tr, Trans trans) {
        return new Calculator(stepMeta, stepDataInterface, cnr, tr, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new CalculatorData();
    }
}

