/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.transformation.step.calculator;

import com.kingdee.bos.ctrl.etl.exception.ETLException;
import com.kingdee.bos.ctrl.etl.repository.Repository;
import com.kingdee.bos.ctrl.etl.util.Const;
import com.kingdee.bos.ctrl.etl.util.XMLHandler;
import com.kingdee.bos.ctrl.etl.value.Value;
import org.w3c.dom.Node;

public class CalculatorMetaFunction
implements Cloneable {
    public static final String XML_TAG = "calculation";
    public static final int CALC_NONE = 0;
    public static final int CALC_CONSTANT = 1;
    public static final int CALC_ADD = 2;
    public static final int CALC_SUBTRACT = 3;
    public static final int CALC_MULTIPLY = 4;
    public static final int CALC_DIVIDE = 5;
    public static final int CALC_SQUARE = 6;
    public static final int CALC_SQUARE_ROOT = 7;
    public static final int CALC_PERCENT_1 = 8;
    public static final int CALC_PERCENT_2 = 9;
    public static final int CALC_PERCENT_3 = 10;
    public static final int CALC_COMBINATION_1 = 11;
    public static final int CALC_COMBINATION_2 = 12;
    public static final int CALC_ROUND_1 = 13;
    public static final int CALC_ROUND_2 = 14;
    public static final int CALC_NVL = 15;
    public static final int CALC_ADD_DAYS = 16;
    public static final int CALC_YEAR_OF_DATE = 17;
    public static final int CALC_MONTH_OF_DATE = 18;
    public static final int CALC_DAY_OF_YEAR = 19;
    public static final int CALC_DAY_OF_MONTH = 20;
    public static final int CALC_DAY_OF_WEEK = 21;
    public static final int CALC_WEEK_OF_YEAR = 22;
    public static final String[] calc_desc = new String[]{"-", "CONSTANT", "ADD", "SUBTRACT", "MULTIPLY", "DIVIDE", "SQUARE", "SQUARE_ROOT", "PERCENT_1", "PERCENT_2", "PERCENT_3", "COMBINATION_1", "COMBINATION_2", "ROUND_1", "ROUND_2", "NVL", "ADD_DAYS", "YEAR_OF_DATE", "MONTH_OF_DATE", "DAY_OF_YEAR", "DAY_OF_MONTH", "DAY_OF_WEEK", "WEEK_OF_YEAR"};
    public static final String[] calcLongDesc = new String[]{"-", "Set field to constant value A", "A + B", "A - B", "A * B", "A / B", "A * A", "SQRT( A )", "100 * A / B", "A - ( A * B / 100 )", "A + ( A * B / 100 )", "A + B * C", "SQRT( A*A + B*B )", "ROUND( A )", "ROUND( A , B )", "NVL( A, B )", "Date A + B Days", "Year of date A", "Month of date A", "Day of year of date A", "Day of month of date A", "Day of week of date A", "Week of year of date A"};
    private String fieldName;
    private int calcType;
    private String fieldA;
    private String fieldB;
    private String fieldC;
    private int valueType;
    private int valueLength;
    private int valuePrecision;
    private boolean removedFromResult;

    public CalculatorMetaFunction(String fieldName, int calcType, String fieldA, String fieldB, String fieldC, int valueType, int valueLength, int valuePrecision, boolean removedFromResult) {
        this.fieldName = fieldName;
        this.calcType = calcType;
        this.fieldA = fieldA;
        this.fieldB = fieldB;
        this.fieldC = fieldC;
        this.valueType = valueType;
        this.valueLength = valueLength;
        this.valuePrecision = valuePrecision;
        this.removedFromResult = removedFromResult;
    }

    public Object clone() {
        try {
            CalculatorMetaFunction retval = (CalculatorMetaFunction)super.clone();
            return retval;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public String getXML() {
        String xml = "";
        xml = xml + "<calculation>";
        xml = xml + XMLHandler.addTagValue("field_name", this.fieldName);
        xml = xml + XMLHandler.addTagValue("calc_type", this.getCalcTypeDesc());
        xml = xml + XMLHandler.addTagValue("field_a", this.fieldA);
        xml = xml + XMLHandler.addTagValue("field_b", this.fieldB);
        xml = xml + XMLHandler.addTagValue("field_c", this.fieldC);
        xml = xml + XMLHandler.addTagValue("value_type", Value.getTypeDesc(this.valueType));
        xml = xml + XMLHandler.addTagValue("value_length", this.valueLength);
        xml = xml + XMLHandler.addTagValue("value_precision", this.valuePrecision);
        xml = xml + XMLHandler.addTagValue("remove", this.removedFromResult);
        xml = xml + "</calculation>";
        return xml;
    }

    public CalculatorMetaFunction(Node calcnode) {
        this.fieldName = XMLHandler.getTagValue(calcnode, "field_name");
        this.calcType = CalculatorMetaFunction.getCalcFunctionType(XMLHandler.getTagValue(calcnode, "calc_type"));
        this.fieldA = XMLHandler.getTagValue(calcnode, "field_a");
        this.fieldB = XMLHandler.getTagValue(calcnode, "field_b");
        this.fieldC = XMLHandler.getTagValue(calcnode, "field_c");
        this.valueType = Value.getType(XMLHandler.getTagValue(calcnode, "value_type"));
        this.valueLength = Const.toInt(XMLHandler.getTagValue(calcnode, "value_length"), -1);
        this.valuePrecision = Const.toInt(XMLHandler.getTagValue(calcnode, "value_precision"), -1);
        this.removedFromResult = "Y".equalsIgnoreCase(XMLHandler.getTagValue(calcnode, "remove"));
    }

    public void saveRep(Repository rep, long id_transformation, long id_step, int nr) throws ETLException {
        rep.saveStepAttribute(id_transformation, id_step, (long)nr, "field_name", this.fieldName);
        rep.saveStepAttribute(id_transformation, id_step, (long)nr, "calc_type", this.getCalcTypeDesc());
        rep.saveStepAttribute(id_transformation, id_step, (long)nr, "field_a", this.fieldA);
        rep.saveStepAttribute(id_transformation, id_step, (long)nr, "field_b", this.fieldB);
        rep.saveStepAttribute(id_transformation, id_step, (long)nr, "field_c", this.fieldC);
        rep.saveStepAttribute(id_transformation, id_step, (long)nr, "value_type", Value.getTypeDesc(this.valueType));
        rep.saveStepAttribute(id_transformation, id_step, (long)nr, "value_length", this.valueLength);
        rep.saveStepAttribute(id_transformation, id_step, (long)nr, "value_precision", this.valuePrecision);
        rep.saveStepAttribute(id_transformation, id_step, (long)nr, "remove", this.removedFromResult);
    }

    public CalculatorMetaFunction(Repository rep, long id_step, int nr) throws ETLException {
        this.fieldName = rep.getStepAttributeString(id_step, nr, "field_name");
        this.calcType = CalculatorMetaFunction.getCalcFunctionType(rep.getStepAttributeString(id_step, nr, "calc_type"));
        this.fieldA = rep.getStepAttributeString(id_step, nr, "field_a");
        this.fieldB = rep.getStepAttributeString(id_step, nr, "field_b");
        this.fieldC = rep.getStepAttributeString(id_step, nr, "field_c");
        this.valueType = Value.getType(rep.getStepAttributeString(id_step, nr, "value_type"));
        this.valueLength = (int)rep.getStepAttributeInteger(id_step, nr, "value_length");
        this.valuePrecision = (int)rep.getStepAttributeInteger(id_step, nr, "value_precision");
        this.removedFromResult = rep.getStepAttributeBoolean(id_step, nr, "remove");
    }

    public static final int getCalcFunctionType(String desc) {
        int i;
        for (i = 1; i < calc_desc.length; ++i) {
            if (!calc_desc[i].equalsIgnoreCase(desc)) continue;
            return i;
        }
        for (i = 1; i < calcLongDesc.length; ++i) {
            if (!calcLongDesc[i].equalsIgnoreCase(desc)) continue;
            return i;
        }
        return 0;
    }

    public static final String getCalcFunctionDesc(int type) {
        if (type < 0 || type >= calc_desc.length) {
            return null;
        }
        return calc_desc[type];
    }

    public static final String getCalcFunctionLongDesc(int type) {
        if (type < 0 || type >= calcLongDesc.length) {
            return null;
        }
        return calcLongDesc[type];
    }

    public int getCalcType() {
        return this.calcType;
    }

    public void setCalcType(int calcType) {
        this.calcType = calcType;
    }

    public String getCalcTypeDesc() {
        return CalculatorMetaFunction.getCalcFunctionDesc(this.calcType);
    }

    public String getCalcTypeLongDesc() {
        return CalculatorMetaFunction.getCalcFunctionLongDesc(this.calcType);
    }

    public String getFieldA() {
        return this.fieldA;
    }

    public void setFieldA(String fieldA) {
        this.fieldA = fieldA;
    }

    public String getFieldB() {
        return this.fieldB;
    }

    public void setFieldB(String fieldB) {
        this.fieldB = fieldB;
    }

    public String getFieldC() {
        return this.fieldC;
    }

    public void setFieldC(String fieldC) {
        this.fieldC = fieldC;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public int getValueLength() {
        return this.valueLength;
    }

    public void setValueLength(int valueLength) {
        this.valueLength = valueLength;
    }

    public int getValuePrecision() {
        return this.valuePrecision;
    }

    public void setValuePrecision(int valuePrecision) {
        this.valuePrecision = valuePrecision;
    }

    public int getValueType() {
        return this.valueType;
    }

    public void setValueType(int valueType) {
        this.valueType = valueType;
    }

    public boolean isRemovedFromResult() {
        return this.removedFromResult;
    }

    public void setRemovedFromResult(boolean removedFromResult) {
        this.removedFromResult = removedFromResult;
    }
}

