/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.transformation.step.combinationlookup;

import com.kingdee.bos.ctrl.etl.base.Row;
import com.kingdee.bos.ctrl.etl.database.Database;
import com.kingdee.bos.ctrl.etl.exception.ETLDatabaseException;
import com.kingdee.bos.ctrl.etl.exception.ETLException;
import com.kingdee.bos.ctrl.etl.exception.ETLStepException;
import com.kingdee.bos.ctrl.etl.transformation.Trans;
import com.kingdee.bos.ctrl.etl.transformation.TransMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.BaseStep;
import com.kingdee.bos.ctrl.etl.transformation.step.StepDataInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMetaInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.combinationlookup.CombinationLookupData;
import com.kingdee.bos.ctrl.etl.transformation.step.combinationlookup.CombinationLookupMeta;
import com.kingdee.bos.ctrl.etl.value.Value;
import java.util.Hashtable;

public class CombinationLookup
extends BaseStep
implements StepInterface {
    private CombinationLookupMeta meta = (CombinationLookupMeta)this.getStepMeta().getStepMetaInterface();
    private CombinationLookupData data;

    public CombinationLookup(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
        this.data = (CombinationLookupData)stepDataInterface;
    }

    private Value lookupInCache(Row row) {
        Value tk = (Value)this.data.cache.get(row);
        return tk;
    }

    private void storeInCache(Row row, Value tk) {
        this.data.cache.put(row, tk);
    }

    private void lookupValues(Row row) throws ETLException {
        int i;
        Value val_hash = null;
        Value val_key = null;
        if (this.first) {
            this.first = false;
            this.data.keynrs = new int[this.meta.getKeyField().length];
            for (int i2 = 0; i2 < this.meta.getKeyField().length; ++i2) {
                this.data.keynrs[i2] = row.searchValueIndex(this.meta.getKeyField()[i2]);
                if (this.data.keynrs[i2] >= 0) continue;
                throw new ETLStepException("Field [" + this.meta.getKeyField()[i2] + "] couldn't be found!");
            }
            if (this.meta.replaceFields()) {
                int size = this.meta.getKeyField().length;
                for (int x = 0; x < size; ++x) {
                    for (int y = 0; y < size - 1; ++y) {
                        int nr2 = this.data.keynrs[y + 1];
                        int nr1 = this.data.keynrs[y];
                        if (nr2 <= nr1) continue;
                        int nr_dummy = this.data.keynrs[y];
                        String key_dummy = this.meta.getKeyField()[y];
                        String keylookup_dummy = this.meta.getKeyLookup()[y];
                        this.data.keynrs[y] = this.data.keynrs[y + 1];
                        this.meta.getKeyField()[y] = this.meta.getKeyField()[y + 1];
                        this.meta.getKeyLookup()[y] = this.meta.getKeyLookup()[y + 1];
                        this.data.keynrs[y + 1] = nr_dummy;
                        this.meta.getKeyField()[y + 1] = key_dummy;
                        this.meta.getKeyLookup()[y + 1] = keylookup_dummy;
                    }
                }
            }
            this.data.db.setCombiLookup(this.meta.getTablename(), this.meta.getKeyLookup(), this.meta.getTechnicalKeyField(), this.meta.useHash(), this.meta.getHashField());
        }
        Row lu = new Row();
        for (i = 0; i < this.meta.getKeyField().length; ++i) {
            lu.addValue(row.getValue(this.data.keynrs[i]));
        }
        if (this.meta.useHash()) {
            val_hash = new Value(this.meta.getHashField(), (long)lu.hashCode());
            lu.clear();
            lu.addValue(val_hash);
        } else {
            lu.clear();
        }
        for (i = 0; i < this.meta.getKeyField().length; ++i) {
            Value parval = row.getValue(this.data.keynrs[i]);
            lu.addValue(parval);
            lu.addValue(parval);
        }
        val_key = this.lookupInCache(lu);
        if (val_key == null) {
            this.data.db.setValuesLookup(lu);
            Row add = this.data.db.getLookup();
            ++this.linesInput;
            if (add == null) {
                boolean autoinc = false;
                if (this.meta.getDatabase().supportsAutoinc() && this.meta.isUseAutoinc()) {
                    autoinc = true;
                    val_key = new Value(this.meta.getTechnicalKeyField(), 0.0);
                } else if (this.meta.getDatabase().supportsSequences() && this.meta.getSequenceFrom() != null && this.meta.getSequenceFrom().length() > 0) {
                    val_key = this.data.db.getNextSequenceValue(this.meta.getSequenceFrom(), this.meta.getTechnicalKeyField());
                    if (val_key != null) {
                        this.logRowlevel("Found next sequence value: " + val_key.toString());
                    }
                } else {
                    val_key = new Value(this.meta.getTechnicalKeyField(), 0.0);
                    this.data.db.getNextValue(this.getTransMeta(), this.meta.getTablename(), val_key);
                }
                this.data.db.combiInsert(row, this.meta.getTablename(), this.meta.getSequenceFrom() == null ? null : this.meta.getTechnicalKeyField(), autoinc, val_key, this.meta.getKeyLookup(), this.data.keynrs, this.meta.useHash(), this.meta.getHashField(), val_hash);
                ++this.linesOutput;
                this.log.logRowlevel(this.toString(), "added dimension entry with key=" + val_key);
                this.storeInCache(lu, val_key);
            } else {
                val_key = add.getValue(0);
                this.storeInCache(lu, val_key);
            }
        }
        if (this.meta.replaceFields()) {
            for (int i3 = 0; i3 < this.data.keynrs.length; ++i3) {
                row.removeValue(this.data.keynrs[i3]);
            }
        }
        row.addValue(val_key);
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws ETLException {
        Row r = this.getRow();
        if (r == null) {
            this.setOutputDone();
            return false;
        }
        try {
            this.lookupValues(r);
            this.putRow(r);
            if (this.linesRead > 0L && this.linesRead % 5000L == 0L) {
                this.logBasic("linenr " + this.linesRead);
            }
        }
        catch (ETLException e) {
            this.logError("Because of an error, this step can't continue: " + e.getMessage());
            this.setErrors(1L);
            this.stopAll();
            this.setOutputDone();
            return false;
        }
        return true;
    }

    @Override
    public boolean init(StepMetaInterface sii, StepDataInterface sdi) {
        if (super.init(sii, sdi)) {
            this.data.cache = new Hashtable();
            this.data.db = new Database(this.meta.getDatabase());
            try {
                this.data.db.connect();
                this.logBasic("Connected to database...");
                this.data.db.setCommit(this.meta.getCommitSize());
                return true;
            }
            catch (ETLDatabaseException dbe) {
                this.logError("Unable to connect to database: " + dbe.getMessage());
            }
        }
        return false;
    }

    @Override
    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (CombinationLookupMeta)smi;
        this.data = (CombinationLookupData)sdi;
        this.data.db.disconnect();
        super.dispose(smi, sdi);
    }

    @Override
    public void run() {
        this.logBasic("Starting to run...");
        try {
            while (this.processRow(this.meta, this.data) && !this.isStopped()) {
            }
        }
        catch (Exception e) {
            this.logError("Unexpected error in '" + this.debug + "' : " + e.toString());
            this.setErrors(1L);
            this.stopAll();
        }
        finally {
            this.dispose(this.meta, this.data);
            this.markStop();
            this.logSummary();
        }
    }

    @Override
    public String toString() {
        return this.getClass().getName();
    }
}

