/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.transformation.step.denormaliser;

import com.kingdee.bos.ctrl.etl.base.Row;
import com.kingdee.bos.ctrl.etl.exception.ETLException;
import com.kingdee.bos.ctrl.etl.exception.ETLValueException;
import com.kingdee.bos.ctrl.etl.transformation.Trans;
import com.kingdee.bos.ctrl.etl.transformation.TransMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.BaseStep;
import com.kingdee.bos.ctrl.etl.transformation.step.StepDataInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMetaInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.denormaliser.DenormaliserData;
import com.kingdee.bos.ctrl.etl.transformation.step.denormaliser.DenormaliserMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.denormaliser.DenormaliserTargetField;
import com.kingdee.bos.ctrl.etl.value.Value;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Set;

public class Denormaliser
extends BaseStep
implements StepInterface {
    private DenormaliserMeta meta = (DenormaliserMeta)this.getStepMeta().getStepMetaInterface();
    private DenormaliserData data;

    public Denormaliser(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
        this.data = (DenormaliserData)stepDataInterface;
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws ETLException {
        this.debug = "processRow";
        Row r = this.getRow();
        if (r == null) {
            if (this.data.previous != null) {
                this.deNormalise(this.data.previous);
                this.buildResult(this.data.previous);
                this.putRow(this.data.previous);
            }
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            int i;
            this.data.keyFieldNr = r.searchValueIndex(this.meta.getKeyField());
            if (this.data.keyFieldNr < 0) {
                this.logError("Key field name [" + this.meta.getKeyField() + "] couldn't be found!");
                this.setErrors(1L);
                this.stopAll();
                return false;
            }
            Hashtable<Integer, Integer> subjects = new Hashtable<Integer, Integer>();
            this.data.fieldNameIndex = new int[this.meta.getDenormaliserTargetField().length];
            for (int i2 = 0; i2 < this.meta.getDenormaliserTargetField().length; ++i2) {
                DenormaliserTargetField field = this.meta.getDenormaliserTargetField()[i2];
                int idx = r.searchValueIndex(field.getFieldName());
                if (idx < 0) {
                    this.logError("Unpivot field name [" + field.getFieldName() + "] couldn't be found!");
                    this.setErrors(1L);
                    this.stopAll();
                    return false;
                }
                this.data.fieldNameIndex[i2] = idx;
                subjects.put(new Integer(idx), new Integer(idx));
                this.data.keyValue.put(field.getKeyValue(), new Integer(i2));
            }
            Set subjectSet = subjects.keySet();
            this.data.fieldNrs = subjectSet.toArray(new Integer[subjectSet.size()]);
            this.data.groupnrs = new int[this.meta.getGroupField().length];
            for (int i3 = 0; i3 < this.meta.getGroupField().length; ++i3) {
                this.data.groupnrs[i3] = r.searchValueIndex(this.meta.getGroupField()[i3]);
                if (this.data.groupnrs[i3] >= 0) continue;
                this.logError("Grouping field [" + this.meta.getGroupField()[i3] + "] couldn't be found!");
                this.setErrors(1L);
                this.stopAll();
                return false;
            }
            ArrayList<Integer> removeList = new ArrayList<Integer>();
            removeList.add(new Integer(this.data.keyFieldNr));
            for (i = 0; i < this.data.fieldNrs.length; ++i) {
                removeList.add(this.data.fieldNrs[i]);
            }
            Collections.sort(removeList);
            this.data.removeNrs = new int[removeList.size()];
            for (i = 0; i < removeList.size(); ++i) {
                this.data.removeNrs[i] = (Integer)removeList.get(i);
            }
            this.data.previous = new Row(r);
            this.newGroup();
            this.first = false;
        }
        if (!this.sameGroup(this.data.previous, r)) {
            this.debug = "Different group";
            this.buildResult(this.data.previous);
            this.putRow(this.data.previous);
            this.newGroup();
            this.deNormalise(r);
        } else {
            this.debug = "unPivot()";
            this.deNormalise(r);
        }
        this.data.previous = new Row(r);
        if (this.linesRead > 0L && this.linesRead % 5000L == 0L) {
            this.logBasic("Linenr " + this.linesRead);
        }
        return true;
    }

    private void buildResult(Row inputRow) throws ETLValueException {
        int i;
        for (i = this.data.removeNrs.length - 1; i >= 0; --i) {
            inputRow.removeValue(this.data.removeNrs[i]);
        }
        for (i = 0; i < this.data.targetResult.size(); ++i) {
            Value resultValue = this.data.targetResult.getValue(i);
            DenormaliserTargetField field = this.meta.getDenormaliserTargetField()[i];
            switch (field.getTargetAggregationType()) {
                case 2: {
                    long count = this.data.counters[i];
                    Value sum = this.data.sum[i];
                    if (count <= 0L) break;
                    sum.divide(count);
                    resultValue.setValue(sum);
                    break;
                }
            }
            inputRow.addValue(resultValue);
        }
    }

    private boolean sameGroup(Row previous, Row r) {
        this.debug = "sameGroup";
        for (int i = 0; i < this.data.groupnrs.length; ++i) {
            Value curr;
            Value prev = previous.getValue(this.data.groupnrs[i]);
            if (prev.equals(curr = r.getValue(this.data.groupnrs[i]))) continue;
            return false;
        }
        return true;
    }

    private void newGroup() {
        this.debug = "newAggregate";
        this.data.targetResult = new Row();
        for (int i = 0; i < this.meta.getDenormaliserTargetField().length; ++i) {
            DenormaliserTargetField field = this.meta.getDenormaliserTargetField()[i];
            Value defaultTarget = new Value(field.getTargetName(), field.getTargetType());
            defaultTarget.setLength(field.getTargetLength(), field.getTargetPrecision());
            this.data.targetResult.addValue(defaultTarget);
            this.data.counters[i] = 0L;
            this.data.sum[i] = new Value(field.getTargetName(), field.getTargetType());
        }
    }

    private void deNormalise(Row r) throws ETLValueException {
        String key = r.getValue(this.data.keyFieldNr).getString();
        Integer keyNr = (Integer)this.data.keyValue.get(key);
        if (keyNr != null) {
            int idx = keyNr;
            DenormaliserTargetField field = this.meta.getDenormaliserTargetField()[idx];
            Value targetValue = r.getValue(this.data.fieldNameIndex[idx]);
            if (targetValue.getType() != field.getTargetType()) {
                block0 : switch (targetValue.getType()) {
                    case 2: {
                        switch (field.getTargetType()) {
                            case 3: {
                                targetValue.str2dat(field.getTargetFormat());
                                break block0;
                            }
                            case 5: {
                                targetValue.setType(targetValue.getType());
                                break block0;
                            }
                            case 1: {
                                targetValue.str2num(field.getTargetFormat(), field.getTargetDecimalSymbol(), field.getTargetGroupingSymbol(), field.getTargetCurrencySymbol());
                                break block0;
                            }
                            case 6: {
                                targetValue.setType(targetValue.getType());
                                break block0;
                            }
                            case 4: {
                                targetValue.setType(targetValue.getType());
                                break block0;
                            }
                        }
                    }
                }
                targetValue.setType(targetValue.getType());
            }
            Value prevTarget = this.data.targetResult.getValue(idx);
            switch (field.getTargetAggregationType()) {
                case 1: {
                    prevTarget.plus(targetValue);
                    break;
                }
                case 3: {
                    if (targetValue.compare(prevTarget) >= 0) break;
                    prevTarget.setValue(targetValue);
                    break;
                }
                case 4: {
                    if (targetValue.compare(prevTarget) <= 0) break;
                    prevTarget.setValue(targetValue);
                    break;
                }
                case 5: {
                    if (targetValue.isNull()) break;
                    prevTarget.setValue(prevTarget.getInteger() + 1L);
                    break;
                }
                case 2: {
                    if (targetValue.isNull()) break;
                    int n = idx;
                    this.data.counters[n] = this.data.counters[n] + 1L;
                    this.data.sum[idx].plus(targetValue);
                    break;
                }
                default: {
                    prevTarget.setValue(targetValue);
                }
            }
        }
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (DenormaliserMeta)smi;
        this.data = (DenormaliserData)sdi;
        if (super.init(smi, sdi)) {
            this.data.counters = new long[this.meta.getDenormaliserTargetField().length];
            this.data.sum = new Value[this.meta.getDenormaliserTargetField().length];
            return true;
        }
        return false;
    }

    @Override
    public void run() {
        try {
            this.logBasic("Starting to run...");
            while (this.processRow(this.meta, this.data) && !this.isStopped()) {
            }
        }
        catch (Exception e) {
            this.logError("Unexpected error in '" + this.debug + "' : " + e.toString());
            this.setErrors(1L);
            this.stopAll();
        }
        finally {
            this.dispose(this.meta, this.data);
            this.logSummary();
            this.markStop();
        }
    }
}

