/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.transformation.step.dimensionlookup;

import com.kingdee.bos.ctrl.etl.base.CheckResult;
import com.kingdee.bos.ctrl.etl.base.Row;
import com.kingdee.bos.ctrl.etl.base.SQLStatement;
import com.kingdee.bos.ctrl.etl.database.Database;
import com.kingdee.bos.ctrl.etl.database.DatabaseMeta;
import com.kingdee.bos.ctrl.etl.exception.ETLDatabaseException;
import com.kingdee.bos.ctrl.etl.exception.ETLException;
import com.kingdee.bos.ctrl.etl.exception.ETLStepException;
import com.kingdee.bos.ctrl.etl.exception.ETLXMLException;
import com.kingdee.bos.ctrl.etl.repository.Repository;
import com.kingdee.bos.ctrl.etl.transformation.DatabaseImpact;
import com.kingdee.bos.ctrl.etl.transformation.Trans;
import com.kingdee.bos.ctrl.etl.transformation.TransMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.BaseStepMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.StepDataInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMetaInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.dimensionlookup.DimensionLookup;
import com.kingdee.bos.ctrl.etl.transformation.step.dimensionlookup.DimensionLookupData;
import com.kingdee.bos.ctrl.etl.util.Const;
import com.kingdee.bos.ctrl.etl.util.LogWriter;
import com.kingdee.bos.ctrl.etl.util.XMLHandler;
import com.kingdee.bos.ctrl.etl.value.Value;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import org.w3c.dom.Node;

public class DimensionLookupMeta
extends BaseStepMeta
implements StepMetaInterface {
    public static final int TYPE_UPDATE_DIM_INSERT = 0;
    public static final int TYPE_UPDATE_DIM_UPDATE = 1;
    public static final int TYPE_UPDATE_DIM_PUNCHTHROUGH = 2;
    public static final String[] typeDesc = new String[]{"Insert", "Update", "Punch through"};
    public static final String[] typeDescLookup = Value.getTypes();
    private String tableName;
    private DatabaseMeta databaseMeta;
    private boolean update;
    private String[] keyStream;
    private String[] keyLookup;
    private String dateField;
    private String dateFrom;
    private String dateTo;
    private String[] fieldStream;
    private String[] fieldLookup;
    private int[] fieldUpdate;
    private String keyField;
    private String keyRename;
    private boolean autoIncrement;
    private String versionField;
    private String sequenceName;
    private Value notFound;
    private int commitSize;
    private int minYear;
    private int maxYear;

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tablename) {
        this.tableName = tablename;
    }

    public DatabaseMeta getDatabaseMeta() {
        return this.databaseMeta;
    }

    public void setDatabaseMeta(DatabaseMeta database) {
        this.databaseMeta = database;
    }

    public boolean isUpdate() {
        return this.update;
    }

    public void setUpdate(boolean update) {
        this.update = update;
    }

    public boolean isAutoIncrement() {
        return this.autoIncrement;
    }

    public void setAutoIncrement(boolean autoIncrement) {
        this.autoIncrement = autoIncrement;
    }

    public int getCommitSize() {
        return this.commitSize;
    }

    public void setCommitSize(int commitSize) {
        this.commitSize = commitSize;
    }

    public String getDateField() {
        return this.dateField;
    }

    public void setDateField(String dateField) {
        this.dateField = dateField;
    }

    public String getDateFrom() {
        return this.dateFrom;
    }

    public void setDateFrom(String dateFrom) {
        this.dateFrom = dateFrom;
    }

    public String getDateTo() {
        return this.dateTo;
    }

    public void setDateTo(String dateTo) {
        this.dateTo = dateTo;
    }

    public String[] getFieldLookup() {
        return this.fieldLookup;
    }

    public void setFieldLookup(String[] fieldLookup) {
        this.fieldLookup = fieldLookup;
    }

    public String[] getFieldStream() {
        return this.fieldStream;
    }

    public void setFieldStream(String[] fieldStream) {
        this.fieldStream = fieldStream;
    }

    public int[] getFieldUpdate() {
        return this.fieldUpdate;
    }

    public void setFieldUpdate(int[] fieldUpdate) {
        this.fieldUpdate = fieldUpdate;
    }

    public String getKeyField() {
        return this.keyField;
    }

    public void setKeyField(String keyField) {
        this.keyField = keyField;
    }

    public String[] getKeyLookup() {
        return this.keyLookup;
    }

    public void setKeyLookup(String[] keyLookup) {
        this.keyLookup = keyLookup;
    }

    public String getKeyRename() {
        return this.keyRename;
    }

    public void setKeyRename(String keyRename) {
        this.keyRename = keyRename;
    }

    public String[] getKeyStream() {
        return this.keyStream;
    }

    public void setKeyStream(String[] keyStream) {
        this.keyStream = keyStream;
    }

    public int getMaxYear() {
        return this.maxYear;
    }

    public void setMaxYear(int maxYear) {
        this.maxYear = maxYear;
    }

    public int getMinYear() {
        return this.minYear;
    }

    public void setMinYear(int minYear) {
        this.minYear = minYear;
    }

    public Value getNotFound() {
        return this.notFound;
    }

    public void setNotFound(Value notFound) {
        this.notFound = notFound;
    }

    public String getSequenceName() {
        return this.sequenceName;
    }

    public void setSequenceName(String sequenceName) {
        this.sequenceName = sequenceName;
    }

    public String getVersionField() {
        return this.versionField;
    }

    public void setVersionField(String versionField) {
        this.versionField = versionField;
    }

    @Override
    public void loadXML(Node stepnode, List databases, Hashtable counters) throws ETLXMLException {
        this.readData(stepnode, databases);
    }

    public void allocate(int nrkeys, int nrfields) {
        this.keyStream = new String[nrkeys];
        this.keyLookup = new String[nrkeys];
        this.fieldStream = new String[nrfields];
        this.fieldLookup = new String[nrfields];
        this.fieldUpdate = new int[nrfields];
    }

    @Override
    public Object clone() {
        int i;
        DimensionLookupMeta retval = (DimensionLookupMeta)super.clone();
        int nrkeys = this.keyStream.length;
        int nrfields = this.fieldStream.length;
        retval.allocate(nrkeys, nrfields);
        for (i = 0; i < nrkeys; ++i) {
            retval.keyStream[i] = this.keyStream[i];
            retval.keyLookup[i] = this.keyLookup[i];
        }
        for (i = 0; i < nrfields; ++i) {
            retval.fieldStream[i] = this.fieldStream[i];
            retval.fieldLookup[i] = this.fieldLookup[i];
            retval.fieldUpdate[i] = this.fieldUpdate[i];
        }
        return retval;
    }

    public static final int getUpdateType(boolean upd, String ty) {
        if (upd) {
            for (int i = 0; i < typeDesc.length; ++i) {
                if (!typeDesc[i].equalsIgnoreCase(ty)) continue;
                return i;
            }
            if ("Y".equalsIgnoreCase(ty)) {
                return 2;
            }
            return 0;
        }
        int retval = Value.getType(ty);
        if (retval == 0) {
            retval = 2;
        }
        return retval;
    }

    public static final String getUpdateType(boolean upd, int t) {
        if (!upd) {
            return Value.getTypeDesc(t);
        }
        return typeDesc[t];
    }

    private void readData(Node stepnode, List databases) throws ETLXMLException {
        try {
            this.tableName = XMLHandler.getTagValue(stepnode, "table");
            String con = XMLHandler.getTagValue(stepnode, "connection");
            this.databaseMeta = Const.findDatabase(databases, con);
            String commit = XMLHandler.getTagValue(stepnode, "commit");
            this.commitSize = Const.toInt(commit, 0);
            String upd = XMLHandler.getTagValue(stepnode, "update");
            this.update = upd.equalsIgnoreCase("Y");
            Node fields = XMLHandler.getSubNode(stepnode, "fields");
            int nrkeys = XMLHandler.countNodes(fields, "key");
            int nrfields = XMLHandler.countNodes(fields, "field");
            this.allocate(nrkeys, nrfields);
            for (int i = 0; i < nrkeys; ++i) {
                Node knode = XMLHandler.getSubNodeByNr(fields, "key", i);
                this.keyStream[i] = XMLHandler.getTagValue(knode, "name");
                this.keyLookup[i] = XMLHandler.getTagValue(knode, "lookup");
            }
            Node dnode = XMLHandler.getSubNode(fields, "date");
            this.dateField = XMLHandler.getTagValue(dnode, "name");
            this.dateFrom = XMLHandler.getTagValue(dnode, "from");
            this.dateTo = XMLHandler.getTagValue(dnode, "to");
            for (int i = 0; i < nrfields; ++i) {
                Node fnode = XMLHandler.getSubNodeByNr(fields, "field", i);
                this.fieldStream[i] = XMLHandler.getTagValue(fnode, "name");
                this.fieldLookup[i] = XMLHandler.getTagValue(fnode, "lookup");
                upd = XMLHandler.getTagValue(fnode, "update");
                this.fieldUpdate[i] = DimensionLookupMeta.getUpdateType(this.update, upd);
            }
            if (this.update) {
                this.sequenceName = XMLHandler.getTagValue(stepnode, "sequence");
            }
            this.maxYear = Const.toInt(XMLHandler.getTagValue(stepnode, "max_year"), 2199);
            this.minYear = Const.toInt(XMLHandler.getTagValue(stepnode, "min_year"), 1900);
            this.keyField = XMLHandler.getTagValue(fields, "return", "name");
            this.keyRename = XMLHandler.getTagValue(fields, "return", "rename");
            this.autoIncrement = !"N".equalsIgnoreCase(XMLHandler.getTagValue(fields, "return", "use_autoinc"));
            this.versionField = XMLHandler.getTagValue(fields, "return", "version");
        }
        catch (Exception e) {
            throw new ETLXMLException("Unable to load step info from XML", e);
        }
    }

    @Override
    public void setDefault() {
        int i;
        this.tableName = "dim table name";
        this.databaseMeta = null;
        this.commitSize = 0;
        this.update = true;
        int nrkeys = 0;
        int nrfields = 0;
        this.allocate(nrkeys, nrfields);
        for (i = 0; i < nrkeys; ++i) {
            this.keyStream[i] = "key" + i;
            this.keyLookup[i] = "keylookup" + i;
        }
        for (i = 0; i < nrfields; ++i) {
            this.fieldStream[i] = "field" + i;
            this.fieldLookup[i] = "lookup" + i;
            this.fieldUpdate[i] = 0;
        }
        this.dateField = "";
        this.dateFrom = "date_from";
        this.dateTo = "date_to";
        this.minYear = 1900;
        this.maxYear = 2199;
        this.keyField = "";
        this.keyRename = "";
        this.autoIncrement = true;
        this.versionField = "version";
    }

    @Override
    public Row getFields(Row r, String name, Row info) throws ETLStepException {
        Row row;
        block8: {
            LogWriter log = LogWriter.getInstance();
            row = r == null ? new Row() : r;
            Value v = new Value(this.keyField, 5);
            if (this.keyRename != null && this.keyRename.length() > 0) {
                v.setName(this.keyRename);
            }
            v.setLength(9, 0);
            v.setOrigin(name);
            row.addValue(v);
            if (!this.update && this.fieldLookup.length > 0) {
                try {
                    if (this.databaseMeta != null) {
                        Database db = new Database(this.databaseMeta);
                        Row extraFields = db.getTableFields(this.tableName);
                        for (int i = 0; i < this.fieldLookup.length; ++i) {
                            v = extraFields.searchValue(this.fieldLookup[i]);
                            if (v == null) {
                                String message = "Unable to find return field [" + this.fieldLookup[i] + "] in the dimension table.";
                                log.logError(this.toString(), message);
                                throw new ETLStepException(message);
                            }
                            if (this.fieldStream[i] != null && this.fieldStream[i].length() > 0) {
                                v.setName(this.fieldStream[i]);
                            }
                            v.setOrigin(name);
                            row.addValue(v);
                        }
                        break block8;
                    }
                    String message = "Unable to retrieve data type of return fields because no database connection was specified";
                    log.logError(this.toString(), message);
                    throw new ETLStepException(message);
                }
                catch (Exception e) {
                    String message = "Unable to retrieve data type of return fields because of an unexpected error";
                    log.logError(this.toString(), message);
                    throw new ETLStepException(message, e);
                }
            }
        }
        return row;
    }

    @Override
    public String getXML() {
        int i;
        String retval = "";
        retval = retval + "      " + XMLHandler.addTagValue("table", this.tableName);
        retval = retval + "      " + XMLHandler.addTagValue("connection", this.databaseMeta == null ? "" : this.databaseMeta.getName());
        retval = retval + "      " + XMLHandler.addTagValue("commit", this.commitSize);
        retval = retval + "      " + XMLHandler.addTagValue("update", this.update);
        retval = retval + "      <fields>" + Const.CR;
        for (i = 0; i < this.keyStream.length; ++i) {
            retval = retval + "        <key>" + Const.CR;
            retval = retval + "          " + XMLHandler.addTagValue("name", this.keyStream[i]);
            retval = retval + "          " + XMLHandler.addTagValue("lookup", this.keyLookup[i]);
            retval = retval + "          </key>" + Const.CR;
        }
        retval = retval + "        <date>" + Const.CR;
        retval = retval + "          " + XMLHandler.addTagValue("name", this.dateField);
        retval = retval + "          " + XMLHandler.addTagValue("from", this.dateFrom);
        retval = retval + "          " + XMLHandler.addTagValue("to", this.dateTo);
        retval = retval + "          </date>" + Const.CR;
        if (this.fieldStream != null) {
            for (i = 0; i < this.fieldStream.length; ++i) {
                if (this.fieldStream[i] == null) continue;
                retval = retval + "        <field>" + Const.CR;
                retval = retval + "          " + XMLHandler.addTagValue("name", this.fieldStream[i]);
                retval = retval + "          " + XMLHandler.addTagValue("lookup", this.fieldLookup[i]);
                retval = retval + "          " + XMLHandler.addTagValue("update", DimensionLookupMeta.getUpdateType(this.update, this.fieldUpdate[i]));
                retval = retval + "          </field>" + Const.CR;
            }
        }
        retval = retval + "        <return>" + Const.CR;
        retval = retval + "          " + XMLHandler.addTagValue("name", this.keyField);
        retval = retval + "          " + XMLHandler.addTagValue("rename", this.keyRename);
        retval = retval + "          " + XMLHandler.addTagValue("use_autoinc", this.autoIncrement);
        retval = retval + "          " + XMLHandler.addTagValue("version", this.versionField);
        retval = retval + "        </return>" + Const.CR;
        retval = retval + "      </fields>" + Const.CR;
        retval = retval + "      " + XMLHandler.addTagValue("sequence", this.sequenceName);
        retval = retval + "      " + XMLHandler.addTagValue("min_year", this.minYear);
        retval = retval + "      " + XMLHandler.addTagValue("max_year", this.maxYear);
        return retval;
    }

    @Override
    public void readRep(Repository rep, long id_step, List databases, Hashtable counters) throws ETLException {
        try {
            int i;
            long id_connection = rep.getStepAttributeInteger(id_step, "id_connection");
            this.databaseMeta = Const.findDatabase(databases, id_connection);
            this.tableName = rep.getStepAttributeString(id_step, "table");
            this.commitSize = (int)rep.getStepAttributeInteger(id_step, "commit");
            this.update = rep.getStepAttributeBoolean(id_step, "update");
            int nrkeys = rep.countNrStepAttributes(id_step, "lookup_key_name");
            int nrfields = rep.countNrStepAttributes(id_step, "field_name");
            this.allocate(nrkeys, nrfields);
            for (i = 0; i < nrkeys; ++i) {
                this.keyStream[i] = rep.getStepAttributeString(id_step, i, "lookup_key_name");
                this.keyLookup[i] = rep.getStepAttributeString(id_step, i, "lookup_key_field");
            }
            this.dateField = rep.getStepAttributeString(id_step, "date_name");
            this.dateFrom = rep.getStepAttributeString(id_step, "date_from");
            this.dateTo = rep.getStepAttributeString(id_step, "date_to");
            for (i = 0; i < nrfields; ++i) {
                this.fieldStream[i] = rep.getStepAttributeString(id_step, i, "field_name");
                this.fieldLookup[i] = rep.getStepAttributeString(id_step, i, "field_lookup");
                this.fieldUpdate[i] = DimensionLookupMeta.getUpdateType(this.update, rep.getStepAttributeString(id_step, i, "field_update"));
            }
            this.keyField = rep.getStepAttributeString(id_step, "return_name");
            this.keyRename = rep.getStepAttributeString(id_step, "return_rename");
            this.autoIncrement = rep.getStepAttributeBoolean(id_step, "use_autoinc");
            this.versionField = rep.getStepAttributeString(id_step, "version_field");
            this.sequenceName = rep.getStepAttributeString(id_step, "sequence");
            this.minYear = (int)rep.getStepAttributeInteger(id_step, "min_year");
            this.maxYear = (int)rep.getStepAttributeInteger(id_step, "max_year");
        }
        catch (Exception e) {
            throw new ETLException("Unexpected error reading step information from the repository", e);
        }
    }

    @Override
    public void saveRep(Repository rep, long id_transformation, long id_step) throws ETLException {
        try {
            int i;
            rep.saveStepAttribute(id_transformation, id_step, "table", this.tableName);
            rep.saveStepAttribute(id_transformation, id_step, "id_connection", this.databaseMeta == null ? -1.0 : (double)this.databaseMeta.getID());
            rep.saveStepAttribute(id_transformation, id_step, "commit", this.commitSize);
            rep.saveStepAttribute(id_transformation, id_step, "update", this.update);
            for (i = 0; i < this.keyStream.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "lookup_key_name", this.keyStream[i]);
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "lookup_key_field", this.keyLookup[i]);
            }
            rep.saveStepAttribute(id_transformation, id_step, "date_name", this.dateField);
            rep.saveStepAttribute(id_transformation, id_step, "date_from", this.dateFrom);
            rep.saveStepAttribute(id_transformation, id_step, "date_to", this.dateTo);
            if (this.fieldStream != null) {
                for (i = 0; i < this.fieldStream.length; ++i) {
                    if (this.fieldStream[i] == null) continue;
                    rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_name", this.fieldStream[i]);
                    rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_lookup", this.fieldLookup[i]);
                    rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_update", DimensionLookupMeta.getUpdateType(this.update, this.fieldUpdate[i]));
                }
            }
            rep.saveStepAttribute(id_transformation, id_step, "return_name", this.keyField);
            rep.saveStepAttribute(id_transformation, id_step, "return_rename", this.keyRename);
            rep.saveStepAttribute(id_transformation, id_step, "use_autoinc", this.autoIncrement);
            rep.saveStepAttribute(id_transformation, id_step, "version_field", this.versionField);
            rep.saveStepAttribute(id_transformation, id_step, "sequence", this.sequenceName);
            rep.saveStepAttribute(id_transformation, id_step, "min_year", this.minYear);
            rep.saveStepAttribute(id_transformation, id_step, "max_year", this.maxYear);
            if (this.databaseMeta != null) {
                rep.insertStepDatabase(id_transformation, id_step, this.databaseMeta.getID());
            }
        }
        catch (ETLDatabaseException dbe) {
            throw new ETLException("Unable to load dimension lookup info from the repository", dbe);
        }
    }

    public Date getMinDate() {
        Calendar mincal = Calendar.getInstance();
        mincal.set(1, this.minYear);
        mincal.set(2, 0);
        mincal.set(5, 1);
        mincal.set(11, 0);
        mincal.set(12, 0);
        mincal.set(13, 0);
        mincal.set(14, 0);
        return mincal.getTime();
    }

    public Date getMaxDate() {
        Calendar mincal = Calendar.getInstance();
        mincal.set(1, this.maxYear);
        mincal.set(2, 11);
        mincal.set(5, 31);
        mincal.set(11, 23);
        mincal.set(12, 59);
        mincal.set(13, 59);
        mincal.set(14, 999);
        return mincal.getTime();
    }

    @Override
    public void check(List remarks, StepMeta stepinfo, Row prev, String[] input, String[] output, Row info) {
        if (this.update) {
            this.checkUpdate(remarks, stepinfo, prev);
        } else {
            this.checkLookup(remarks, stepinfo, prev);
        }
        if (input.length > 0) {
            CheckResult cr = new CheckResult(1, "Step is receiving info from other steps.", stepinfo);
            remarks.add(cr);
        } else {
            CheckResult cr = new CheckResult(4, "No input received from other steps!", stepinfo);
            remarks.add(cr);
        }
    }

    private void checkUpdate(List remarks, StepMeta stepinfo, Row prev) {
        block30: {
            LogWriter log = LogWriter.getInstance();
            String error_message = "";
            if (this.databaseMeta != null) {
                Database db = new Database(this.databaseMeta);
                try {
                    CheckResult cr;
                    boolean error_found;
                    boolean first;
                    db.connect();
                    if (this.tableName != null && this.tableName.length() != 0) {
                        first = true;
                        error_found = false;
                        error_message = "";
                        Row r = db.getTableFields(this.tableName);
                        if (r != null) {
                            for (int i = 0; i < this.fieldLookup.length; ++i) {
                                String lufield = this.fieldLookup[i];
                                log.logDebug(this.toString(), "Check lookupfield #" + i + " --> " + lufield + " in lookup table...");
                                Value v = r.searchValue(lufield);
                                if (v != null) continue;
                                if (first) {
                                    first = false;
                                    error_message = error_message + "Missing compare fields in target table:" + Const.CR;
                                }
                                error_found = true;
                                error_message = error_message + "\t\t" + lufield + Const.CR;
                            }
                            cr = error_found ? new CheckResult(4, error_message, stepinfo) : new CheckResult(1, "All lookup fields found in the dimension table.", stepinfo);
                            remarks.add(cr);
                            if (this.keyField != null && this.keyField.length() > 0) {
                                if (r.searchValueIndex(this.keyField) < 0) {
                                    error_message = "Technical key [" + this.keyField + "] not found in target dimension table." + Const.CR;
                                    cr = new CheckResult(4, error_message, stepinfo);
                                } else {
                                    error_message = "Technical key [" + this.keyField + "] found in target dimension table." + Const.CR;
                                    cr = new CheckResult(1, error_message, stepinfo);
                                }
                                remarks.add(cr);
                            } else {
                                error_message = "Please specify a fieldname to store the technical/surrogate key of the dimension in." + Const.CR;
                                remarks.add(new CheckResult(4, error_message, stepinfo));
                            }
                            if (this.versionField != null && this.versionField.length() > 0) {
                                if (r.searchValueIndex(this.versionField) < 0) {
                                    error_message = "Version field [" + this.versionField + "] not found in target dimension table." + Const.CR;
                                    cr = new CheckResult(4, error_message, stepinfo);
                                } else {
                                    error_message = "Version field [" + this.versionField + "] found in target dimension table." + Const.CR;
                                    cr = new CheckResult(1, error_message, stepinfo);
                                }
                                remarks.add(cr);
                            } else {
                                error_message = "Please specify a fieldname to store the version of the dimension entry in." + Const.CR;
                                remarks.add(new CheckResult(4, error_message, stepinfo));
                            }
                            if (this.dateFrom != null && this.dateFrom.length() > 0) {
                                if (r.searchValueIndex(this.dateFrom) < 0) {
                                    error_message = "Start of daterange field [" + this.dateFrom + "] not found in target dimension table." + Const.CR;
                                    cr = new CheckResult(4, error_message, stepinfo);
                                } else {
                                    error_message = "Start of daterange field [" + this.dateFrom + "] found in target dimension table." + Const.CR;
                                    cr = new CheckResult(1, error_message, stepinfo);
                                }
                                remarks.add(cr);
                            } else {
                                error_message = "Please specify a fieldname to store the start of the date range of the dimension entry in." + Const.CR;
                                remarks.add(new CheckResult(4, error_message, stepinfo));
                            }
                            if (this.dateTo != null && this.dateTo.length() > 0) {
                                if (r.searchValueIndex(this.dateTo) < 0) {
                                    error_message = "End of daterange field [" + this.dateTo + "] not found in target dimension table." + Const.CR;
                                    cr = new CheckResult(4, error_message, stepinfo);
                                } else {
                                    error_message = "End of daterange field [" + this.dateTo + "] found in target dimension table." + Const.CR;
                                    cr = new CheckResult(1, error_message, stepinfo);
                                }
                                remarks.add(cr);
                            } else {
                                error_message = "Please specify a fieldname to store the end of the date range of the dimension entry in." + Const.CR;
                                remarks.add(new CheckResult(4, error_message, stepinfo));
                            }
                        } else {
                            error_message = "Couldn't read the table info, please check the table-name & permissions.";
                            cr = new CheckResult(4, error_message, stepinfo);
                            remarks.add(cr);
                        }
                    }
                    if (prev != null && prev.size() > 0) {
                        first = true;
                        error_message = "";
                        error_found = false;
                        for (int i = 0; i < this.fieldStream.length; ++i) {
                            log.logDebug(this.toString(), "Check field #" + i + " --> " + this.fieldStream[i] + ", in inputstream from previous steps");
                            Value v = prev.searchValue(this.fieldStream[i]);
                            if (v != null) continue;
                            if (first) {
                                first = false;
                                error_message = error_message + "Missing fields, not found in input from previous steps:" + Const.CR;
                            }
                            error_found = true;
                            error_message = error_message + "\t\t" + this.fieldStream[i] + Const.CR;
                        }
                        cr = error_found ? new CheckResult(4, error_message, stepinfo) : new CheckResult(1, "All fields found in the input stream.", stepinfo);
                        remarks.add(cr);
                    } else {
                        error_message = "Couldn't read fields from the previous step." + Const.CR;
                        cr = new CheckResult(4, error_message, stepinfo);
                        remarks.add(cr);
                    }
                    if (!this.databaseMeta.supportsSequences() || this.sequenceName == null || this.sequenceName.length() == 0) break block30;
                    if (db.checkSequenceExists(this.sequenceName)) {
                        error_message = "Sequence " + this.sequenceName + " exists.";
                        cr = new CheckResult(1, error_message, stepinfo);
                        remarks.add(cr);
                        break block30;
                    }
                    error_message = error_message + "Sequence " + this.sequenceName + " couldn't be found!";
                    cr = new CheckResult(4, error_message, stepinfo);
                    remarks.add(cr);
                }
                catch (ETLException e) {
                    error_message = "Couldn't connect to database, please check the connection: " + e.getMessage();
                    CheckResult cr = new CheckResult(4, error_message, stepinfo);
                    remarks.add(cr);
                }
            } else {
                error_message = "Please select a connection name!";
                CheckResult cr = new CheckResult(4, error_message, stepinfo);
                remarks.add(cr);
            }
        }
    }

    private void checkLookup(List remarks, StepMeta stepinfo, Row prev) {
        block23: {
            boolean error_found = false;
            String error_message = "";
            if (this.databaseMeta != null) {
                Database db = new Database(this.databaseMeta);
                try {
                    db.connect();
                    if (this.tableName == null || this.tableName.length() == 0) break block23;
                    Row tableFields = db.getTableFields(this.tableName);
                    if (tableFields != null) {
                        if (prev != null && prev.size() > 0) {
                            int i;
                            boolean first = true;
                            boolean warning_found = false;
                            for (i = 0; i < this.keyStream.length; ++i) {
                                String strfield = this.keyStream[i];
                                Value strvalue = prev.searchValue(strfield);
                                if (strvalue == null) {
                                    if (first) {
                                        first = false;
                                        error_message = error_message + "Keys with a problem:" + Const.CR;
                                    }
                                    error_found = true;
                                    error_message = error_message + "\t\t" + this.keyField + " (not present in input stream)" + Const.CR;
                                    continue;
                                }
                                String dimfield = this.keyLookup[i];
                                Value dimvalue = tableFields.searchValue(dimfield);
                                if (dimvalue == null) {
                                    if (first) {
                                        first = false;
                                        error_message = error_message + "Keys with a problem:" + Const.CR;
                                    }
                                    error_found = true;
                                    error_message = error_message + "\t\t" + dimfield + " (not present in dimension table " + this.tableName + ")" + Const.CR;
                                    continue;
                                }
                                if (strvalue.getType() == dimvalue.getType()) continue;
                                if (first) {
                                    first = false;
                                    error_message = error_message + "Keys with a problem:" + Const.CR;
                                }
                                warning_found = true;
                                error_message = error_message + "\t\t" + strfield + " (" + strvalue.getOrigin() + ") is not of the same type as " + dimfield + " (" + this.tableName + ")" + Const.CR;
                                error_message = error_message + "\t\tThis is a warning and in many cases (for ex. Oracle) the conversion is handled by the database.";
                            }
                            CheckResult cr = error_found ? new CheckResult(4, error_message, stepinfo) : (warning_found ? new CheckResult(3, error_message, stepinfo) : new CheckResult(1, "All keys fields found in the input stream and dimension table. (with matching types)", stepinfo));
                            remarks.add(cr);
                            error_found = false;
                            for (i = 0; i < this.fieldLookup.length; ++i) {
                                Value v;
                                String lufield = this.fieldLookup[i];
                                if (lufield == null || lufield.length() <= 0 || (v = tableFields.searchValue(lufield)) != null) continue;
                                if (first) {
                                    first = false;
                                    error_message = error_message + "Fields to retrieve that don't exist in the dimension:" + Const.CR;
                                }
                                error_found = true;
                                error_message = error_message + "\t\t" + lufield + Const.CR;
                            }
                            cr = error_found ? new CheckResult(4, error_message, stepinfo) : new CheckResult(1, "All fields to retrieve are found in the dimension.", stepinfo);
                            remarks.add(cr);
                            if (tableFields.searchValueIndex(this.keyField) < 0) {
                                error_message = "Technical key [" + this.keyField + "] not found in dimension lookup table." + Const.CR;
                                cr = new CheckResult(4, error_message, stepinfo);
                            } else {
                                error_message = "Technical key [" + this.keyField + "] found in dimension lookup table." + Const.CR;
                                cr = new CheckResult(1, error_message, stepinfo);
                            }
                            remarks.add(cr);
                            if (tableFields.searchValueIndex(this.versionField) < 0) {
                                error_message = "Version field [" + this.versionField + "] not found in dimension lookup table." + Const.CR;
                                cr = new CheckResult(4, error_message, stepinfo);
                            } else {
                                error_message = "Version field [" + this.versionField + "] found in dimension lookup table." + Const.CR;
                                cr = new CheckResult(1, error_message, stepinfo);
                            }
                            remarks.add(cr);
                            if (tableFields.searchValueIndex(this.dateFrom) < 0) {
                                error_message = "Start of daterange field [" + this.dateFrom + "] not found in dimension lookup table." + Const.CR;
                                cr = new CheckResult(4, error_message, stepinfo);
                            } else {
                                error_message = "Start of daterange field [" + this.dateFrom + "] found in dimension lookup table." + Const.CR;
                                cr = new CheckResult(1, error_message, stepinfo);
                            }
                            remarks.add(cr);
                            if (tableFields.searchValueIndex(this.dateTo) < 0) {
                                error_message = "End of daterange field [" + this.dateTo + "] not found in dimension lookup table." + Const.CR;
                                cr = new CheckResult(4, error_message, stepinfo);
                            } else {
                                error_message = "End of daterange field [" + this.dateTo + "] found in dimension lookup table.";
                                cr = new CheckResult(1, error_message, stepinfo);
                            }
                            remarks.add(cr);
                        } else {
                            error_message = "Couldn't read fields from the previous step." + Const.CR;
                            CheckResult cr = new CheckResult(4, error_message, stepinfo);
                            remarks.add(cr);
                        }
                        break block23;
                    }
                    error_message = "Couldn't read the table info, please check the table-name & permissions.";
                    CheckResult cr = new CheckResult(4, error_message, stepinfo);
                    remarks.add(cr);
                }
                catch (ETLException e) {
                    error_message = "Couldn't connect to database, please check the connection: " + e.getMessage();
                    CheckResult cr = new CheckResult(4, error_message, stepinfo);
                    remarks.add(cr);
                }
            } else {
                error_message = "Please select or create a connection!";
                CheckResult cr = new CheckResult(4, error_message, stepinfo);
                remarks.add(cr);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Row getTableFields() {
        LogWriter log = LogWriter.getInstance();
        Row fields = null;
        if (this.databaseMeta != null) {
            Database db = new Database(this.databaseMeta);
            try {
                db.connect();
                fields = db.getTableFields(this.tableName);
            }
            catch (ETLDatabaseException dbe) {
                log.logError(this.toString(), "A database error occurred: " + dbe.getMessage());
            }
            finally {
                db.disconnect();
            }
        }
        return fields;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SQLStatement getSQLStatements(TransMeta transMeta, StepMeta stepMeta, Row prev) {
        LogWriter log = LogWriter.getInstance();
        SQLStatement retval = new SQLStatement(stepMeta.getName(), this.databaseMeta, null);
        if (this.update) {
            log.logDebug(this.toString(), "Update!");
            if (this.databaseMeta != null) {
                if (prev != null && prev.size() > 0) {
                    if (this.tableName != null && this.tableName.length() > 0) {
                        Database db = new Database(this.databaseMeta);
                        try {
                            Value field;
                            Value vprev;
                            int i;
                            db.connect();
                            String sql = "";
                            Row fields = new Row();
                            Value vkeyfield = new Value(this.keyField, 5);
                            vkeyfield.setLength(10);
                            fields.addValue(vkeyfield);
                            Value vversion = new Value(this.versionField, 5);
                            vversion.setLength(5);
                            fields.addValue(vversion);
                            Value vdatefrom = new Value(this.dateFrom, 3);
                            fields.addValue(vdatefrom);
                            Value vdateto = new Value(this.dateTo, 3);
                            fields.addValue(vdateto);
                            String errors = "";
                            for (i = 0; i < this.keyLookup.length; ++i) {
                                vprev = prev.searchValue(this.keyStream[i]);
                                if (vprev != null) {
                                    field = new Value(vprev);
                                    field.setName(this.keyLookup[i]);
                                    fields.addValue(field);
                                    continue;
                                }
                                if (errors.length() > 0) {
                                    errors = errors + ", ";
                                }
                                errors = errors + this.keyStream[i];
                            }
                            for (i = 0; i < this.fieldLookup.length; ++i) {
                                vprev = prev.searchValue(this.fieldStream[i]);
                                if (vprev != null) {
                                    field = new Value(vprev);
                                    field.setName(this.fieldLookup[i]);
                                    fields.addValue(field);
                                    continue;
                                }
                                if (errors.length() > 0) {
                                    errors = errors + ", ";
                                }
                                errors = errors + this.fieldStream[i];
                            }
                            if (errors.length() > 0) {
                                retval.setError("Unable to find these fields in the input stream: " + errors);
                            }
                            log.logDebug(this.toString(), "Get DDL for table [" + this.tableName + "] : " + fields.toStringMeta());
                            sql = sql + db.getDDL(this.tableName, fields, this.sequenceName != null && this.sequenceName.length() == 0 ? this.keyField : null, this.autoIncrement, null, true);
                            log.logDebug(this.toString(), "sql = " + sql);
                            String[] idx_fields = null;
                            if (this.keyLookup != null && this.keyLookup.length > 0) {
                                idx_fields = new String[this.keyLookup.length];
                                for (int i2 = 0; i2 < this.keyLookup.length; ++i2) {
                                    idx_fields[i2] = this.keyLookup[i2];
                                }
                            } else {
                                retval.setError("No key fields are specified.  Please specify the fields use as key for this dimension.");
                            }
                            if (idx_fields != null && idx_fields.length > 0 && !db.checkIndexExists(this.tableName, idx_fields)) {
                                String indexname = "idx_" + this.tableName + "_lookup";
                                sql = sql + db.getCreateIndexStatement(this.tableName, indexname, idx_fields, false, false, false, true);
                            }
                            idx_fields = new String[]{this.keyField};
                            if (this.keyField != null && this.keyField.length() > 0) {
                                if (!db.checkIndexExists(this.tableName, idx_fields)) {
                                    String indexname = "idx_" + this.tableName + "_tk";
                                    sql = sql + db.getCreateIndexStatement(this.tableName, indexname, idx_fields, true, false, true, true);
                                }
                            } else {
                                retval.setError("Please specifiy the name of the technical key field (a.k.a. the surrogate key)");
                            }
                            if (!db.checkSequenceExists(this.sequenceName)) {
                                sql = sql + db.getCreateSequenceStatement(this.sequenceName, 1L, 1L, -1L, true);
                            }
                            if (sql.length() == 0) {
                                retval.setSQL(null);
                            }
                            retval.setSQL(sql);
                        }
                        catch (ETLDatabaseException dbe) {
                            retval.setError("An error occurred: " + dbe.getMessage());
                        }
                        finally {
                            db.disconnect();
                        }
                    } else {
                        retval.setError("No table is defined on this connection.");
                    }
                } else {
                    retval.setError("Not receiving any fields from previous steps. Check the previous steps for errors & the connecting hops.");
                }
            } else {
                retval.setError("There is no connection defined in this step.");
            }
        }
        return retval;
    }

    public void analyseImpact(ArrayList impact, TransMeta transMeta, StepMeta stepMeta, Row prev, String[] input, String[] output, Row info) {
        block6: {
            if (prev == null) break block6;
            if (!this.update) {
                DatabaseImpact ii;
                Value v;
                int i;
                for (i = 0; i < this.keyLookup.length; ++i) {
                    v = prev.searchValue(this.keyStream[i]);
                    ii = new DatabaseImpact(1, transMeta.getName(), stepMeta.getName(), this.databaseMeta.getDatabaseName(), this.tableName, this.keyLookup[i], this.keyStream[i], v != null ? v.getOrigin() : "?", "", "Type = " + v.toStringMeta());
                    impact.add(ii);
                }
                for (i = 0; i < this.fieldLookup.length; ++i) {
                    v = prev.searchValue(this.fieldStream[i]);
                    ii = new DatabaseImpact(1, transMeta.getName(), stepMeta.getName(), this.databaseMeta.getDatabaseName(), this.tableName, this.fieldLookup[i], this.fieldLookup[i], v != null ? v.getOrigin() : "?", "", "Type = " + v.toStringMeta());
                    impact.add(ii);
                }
            } else {
                DatabaseImpact ii;
                Value v;
                int i;
                for (i = 0; i < this.keyLookup.length; ++i) {
                    v = prev.searchValue(this.keyStream[i]);
                    ii = new DatabaseImpact(3, transMeta.getName(), stepMeta.getName(), this.databaseMeta.getDatabaseName(), this.tableName, this.keyLookup[i], this.keyStream[i], v.getOrigin(), "", "Type = " + v.toStringMeta());
                    impact.add(ii);
                }
                for (i = 0; i < this.fieldLookup.length; ++i) {
                    v = prev.searchValue(this.fieldStream[i]);
                    ii = new DatabaseImpact(3, transMeta.getName(), stepMeta.getName(), this.databaseMeta.getDatabaseName(), this.tableName, this.fieldLookup[i], this.fieldLookup[i], v.getOrigin(), "", "Type = " + v.toStringMeta());
                    impact.add(ii);
                }
            }
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta tr, Trans trans) {
        return new DimensionLookup(stepMeta, stepDataInterface, cnr, tr, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new DimensionLookupData();
    }
}

