/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.transformation.step.insertupdate;

import com.kingdee.bos.ctrl.etl.base.CheckResult;
import com.kingdee.bos.ctrl.etl.base.Row;
import com.kingdee.bos.ctrl.etl.base.SQLStatement;
import com.kingdee.bos.ctrl.etl.database.Database;
import com.kingdee.bos.ctrl.etl.database.DatabaseMeta;
import com.kingdee.bos.ctrl.etl.exception.ETLException;
import com.kingdee.bos.ctrl.etl.exception.ETLXMLException;
import com.kingdee.bos.ctrl.etl.repository.Repository;
import com.kingdee.bos.ctrl.etl.transformation.Trans;
import com.kingdee.bos.ctrl.etl.transformation.TransMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.BaseStepMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.StepDataInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMetaInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.insertupdate.InsertUpdate;
import com.kingdee.bos.ctrl.etl.transformation.step.insertupdate.InsertUpdateData;
import com.kingdee.bos.ctrl.etl.util.Const;
import com.kingdee.bos.ctrl.etl.util.XMLHandler;
import com.kingdee.bos.ctrl.etl.value.Value;
import java.util.Hashtable;
import java.util.List;
import org.w3c.dom.Node;

public class InsertUpdateMeta
extends BaseStepMeta
implements StepMetaInterface {
    private String tableName;
    private DatabaseMeta database;
    private String[] keyStream;
    private String[] keyLookup;
    private String[] keyCondition;
    private String[] keyStream2;
    private String[] updateLookup;
    private String[] updateStream;
    private int commitSize;

    public int getCommitSize() {
        return this.commitSize;
    }

    public void setCommitSize(int commitSize) {
        this.commitSize = commitSize;
    }

    public DatabaseMeta getDatabase() {
        return this.database;
    }

    public void setDatabase(DatabaseMeta database) {
        this.database = database;
    }

    public String[] getKeyCondition() {
        return this.keyCondition;
    }

    public void setKeyCondition(String[] keyCondition) {
        this.keyCondition = keyCondition;
    }

    public String[] getKeyLookup() {
        return this.keyLookup;
    }

    public void setKeyLookup(String[] keyLookup) {
        this.keyLookup = keyLookup;
    }

    public String[] getKeyStream() {
        return this.keyStream;
    }

    public void setKeyStream(String[] keyStream) {
        this.keyStream = keyStream;
    }

    public String[] getKeyStream2() {
        return this.keyStream2;
    }

    public void setKeyStream2(String[] keyStream2) {
        this.keyStream2 = keyStream2;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String[] getUpdateLookup() {
        return this.updateLookup;
    }

    public void setUpdateLookup(String[] updateLookup) {
        this.updateLookup = updateLookup;
    }

    public String[] getUpdateStream() {
        return this.updateStream;
    }

    public void setUpdateStream(String[] updateStream) {
        this.updateStream = updateStream;
    }

    @Override
    public void loadXML(Node stepnode, List databases, Hashtable counters) throws ETLXMLException {
        this.readData(stepnode, databases);
    }

    public void allocate(int nrkeys, int nrvalues) {
        this.keyStream = new String[nrkeys];
        this.keyLookup = new String[nrkeys];
        this.keyCondition = new String[nrkeys];
        this.keyStream2 = new String[nrkeys];
        this.updateLookup = new String[nrvalues];
        this.updateStream = new String[nrvalues];
    }

    @Override
    public Object clone() {
        int i;
        InsertUpdateMeta retval = (InsertUpdateMeta)super.clone();
        int nrkeys = this.keyStream.length;
        int nrvalues = this.updateLookup.length;
        retval.allocate(nrkeys, nrvalues);
        for (i = 0; i < nrkeys; ++i) {
            retval.keyStream[i] = this.keyStream[i];
            retval.keyLookup[i] = this.keyLookup[i];
            retval.keyCondition[i] = this.keyCondition[i];
            retval.keyStream2[i] = this.keyStream2[i];
        }
        for (i = 0; i < nrvalues; ++i) {
            retval.updateLookup[i] = this.updateLookup[i];
            retval.updateStream[i] = this.updateStream[i];
        }
        return retval;
    }

    private void readData(Node stepnode, List databases) throws ETLXMLException {
        try {
            int i;
            String con = XMLHandler.getTagValue(stepnode, "connection");
            this.database = Const.findDatabase(databases, con);
            String csize = XMLHandler.getTagValue(stepnode, "commit");
            this.commitSize = Const.toInt(csize, 0);
            this.tableName = XMLHandler.getTagValue(stepnode, "lookup", "table");
            Node lookup = XMLHandler.getSubNode(stepnode, "lookup");
            int nrkeys = XMLHandler.countNodes(lookup, "key");
            int nrvalues = XMLHandler.countNodes(lookup, "value");
            this.allocate(nrkeys, nrvalues);
            for (i = 0; i < nrkeys; ++i) {
                Node knode = XMLHandler.getSubNodeByNr(lookup, "key", i);
                this.keyStream[i] = XMLHandler.getTagValue(knode, "name");
                this.keyLookup[i] = XMLHandler.getTagValue(knode, "field");
                this.keyCondition[i] = XMLHandler.getTagValue(knode, "condition");
                if (this.keyCondition[i] == null) {
                    this.keyCondition[i] = "=";
                }
                this.keyStream2[i] = XMLHandler.getTagValue(knode, "name2");
            }
            for (i = 0; i < nrvalues; ++i) {
                Node vnode = XMLHandler.getSubNodeByNr(lookup, "value", i);
                this.updateLookup[i] = XMLHandler.getTagValue(vnode, "name");
                this.updateStream[i] = XMLHandler.getTagValue(vnode, "rename");
                if (this.updateStream[i] != null) continue;
                this.updateStream[i] = this.updateLookup[i];
            }
        }
        catch (Exception e) {
            throw new ETLXMLException("Unable to read step information from XML", e);
        }
    }

    @Override
    public void setDefault() {
        int i;
        this.keyStream = null;
        this.updateLookup = null;
        this.database = null;
        this.commitSize = 0;
        this.tableName = "lookup table";
        int nrkeys = 0;
        int nrvalues = 0;
        this.allocate(nrkeys, nrvalues);
        for (i = 0; i < nrkeys; ++i) {
            this.keyLookup[i] = "age";
            this.keyCondition[i] = "BETWEEN";
            this.keyStream[i] = "age_from";
            this.keyStream2[i] = "age_to";
        }
        for (i = 0; i < nrvalues; ++i) {
            this.updateLookup[i] = "return field #" + i;
            this.updateStream[i] = "new name #" + i;
        }
    }

    @Override
    public String getXML() {
        int i;
        String retval = "";
        retval = retval + "    " + XMLHandler.addTagValue("connection", this.database == null ? "" : this.database.getName());
        retval = retval + "    " + XMLHandler.addTagValue("commit", this.commitSize);
        retval = retval + "    <lookup>" + Const.CR;
        retval = retval + "      " + XMLHandler.addTagValue("table", this.tableName);
        for (i = 0; i < this.keyStream.length; ++i) {
            retval = retval + "      <key>" + Const.CR;
            retval = retval + "        " + XMLHandler.addTagValue("name", this.keyStream[i]);
            retval = retval + "        " + XMLHandler.addTagValue("field", this.keyLookup[i]);
            retval = retval + "        " + XMLHandler.addTagValue("condition", this.keyCondition[i]);
            retval = retval + "        " + XMLHandler.addTagValue("name2", this.keyStream2[i]);
            retval = retval + "        </key>" + Const.CR;
        }
        for (i = 0; i < this.updateLookup.length; ++i) {
            retval = retval + "      <value>" + Const.CR;
            retval = retval + "        " + XMLHandler.addTagValue("name", this.updateLookup[i]);
            retval = retval + "        " + XMLHandler.addTagValue("rename", this.updateStream[i]);
            retval = retval + "        </value>" + Const.CR;
        }
        retval = retval + "      </lookup>" + Const.CR;
        return retval;
    }

    @Override
    public void readRep(Repository rep, long id_step, List databases, Hashtable counters) throws ETLException {
        try {
            int i;
            long id_connection = rep.getStepAttributeInteger(id_step, "id_connection");
            this.database = Const.findDatabase(databases, id_connection);
            this.commitSize = (int)rep.getStepAttributeInteger(id_step, "commit");
            this.tableName = rep.getStepAttributeString(id_step, "table");
            int nrkeys = rep.countNrStepAttributes(id_step, "key_name");
            int nrvalues = rep.countNrStepAttributes(id_step, "value_name");
            this.allocate(nrkeys, nrvalues);
            for (i = 0; i < nrkeys; ++i) {
                this.keyStream[i] = rep.getStepAttributeString(id_step, i, "key_name");
                this.keyLookup[i] = rep.getStepAttributeString(id_step, i, "key_field");
                this.keyCondition[i] = rep.getStepAttributeString(id_step, i, "key_condition");
                this.keyStream2[i] = rep.getStepAttributeString(id_step, i, "key_name2");
            }
            for (i = 0; i < nrvalues; ++i) {
                this.updateLookup[i] = rep.getStepAttributeString(id_step, i, "value_name");
                this.updateStream[i] = rep.getStepAttributeString(id_step, i, "value_rename");
            }
        }
        catch (Exception e) {
            throw new ETLException("Unexpected error reading step information from the repository", e);
        }
    }

    @Override
    public void saveRep(Repository rep, long id_transformation, long id_step) throws ETLException {
        try {
            int i;
            rep.saveStepAttribute(id_transformation, id_step, "id_connection", this.database == null ? -1.0 : (double)this.database.getID());
            rep.saveStepAttribute(id_transformation, id_step, "commit", this.commitSize);
            rep.saveStepAttribute(id_transformation, id_step, "table", this.tableName);
            for (i = 0; i < this.keyStream.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "key_name", this.keyStream[i]);
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "key_field", this.keyLookup[i]);
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "key_condition", this.keyCondition[i]);
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "key_name2", this.keyStream2[i]);
            }
            for (i = 0; i < this.updateLookup.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "value_name", this.updateLookup[i]);
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "value_rename", this.updateStream[i]);
            }
            if (this.database != null) {
                rep.insertStepDatabase(id_transformation, id_step, this.database.getID());
            }
        }
        catch (Exception e) {
            throw new ETLException("Unable to save step information to the repository for id_step=" + id_step, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void check(List remarks, StepMeta stepMeta, Row prev, String[] input, String[] output, Row info) {
        CheckResult cr;
        String error_message = "";
        if (this.database != null) {
            Database db = new Database(this.database);
            try {
                boolean error_found;
                boolean first;
                db.connect();
                if (this.tableName != null && this.tableName.length() != 0) {
                    cr = new CheckResult(1, "Table name is filled in.", stepMeta);
                    remarks.add(cr);
                    first = true;
                    error_found = false;
                    error_message = "";
                    Row r = db.getTableFields(this.tableName);
                    if (r != null) {
                        Value v;
                        String lufield;
                        int i;
                        cr = new CheckResult(1, "Table exists and we can read data from it.", stepMeta);
                        remarks.add(cr);
                        for (i = 0; i < this.keyLookup.length; ++i) {
                            lufield = this.keyLookup[i];
                            v = r.searchValue(lufield);
                            if (v != null) continue;
                            if (first) {
                                first = false;
                                error_message = error_message + "Missing compare fields in target table:" + Const.CR;
                            }
                            error_found = true;
                            error_message = error_message + "\t\t" + lufield + Const.CR;
                        }
                        cr = error_found ? new CheckResult(4, error_message, stepMeta) : new CheckResult(1, "All lookup fields found in the table.", stepMeta);
                        remarks.add(cr);
                        first = true;
                        error_found = false;
                        error_message = "";
                        for (i = 0; i < this.updateLookup.length; ++i) {
                            lufield = this.updateLookup[i];
                            v = r.searchValue(lufield);
                            if (v != null) continue;
                            if (first) {
                                first = false;
                                error_message = error_message + "Missing fields to update/insert in target table:" + Const.CR;
                            }
                            error_found = true;
                            error_message = error_message + "\t\t" + lufield + Const.CR;
                        }
                        cr = error_found ? new CheckResult(4, error_message, stepMeta) : new CheckResult(1, "All insert/update fields found in the table.", stepMeta);
                        remarks.add(cr);
                    } else {
                        error_message = "Couldn't read the table info, please check the table-name & permissions.";
                        cr = new CheckResult(4, error_message, stepMeta);
                        remarks.add(cr);
                    }
                }
                if (prev != null && prev.size() > 0) {
                    int i;
                    cr = new CheckResult(1, "Step is connected to previous one, receiving " + prev.size() + " fields", stepMeta);
                    remarks.add(cr);
                    first = true;
                    error_message = "";
                    error_found = false;
                    for (i = 0; i < this.keyStream.length; ++i) {
                        Value v = prev.searchValue(this.keyStream[i]);
                        if (v != null) continue;
                        if (first) {
                            first = false;
                            error_message = error_message + "Missing fields, not found in input from previous steps:" + Const.CR;
                        }
                        error_found = true;
                        error_message = error_message + "\t\t" + this.keyStream[i] + Const.CR;
                    }
                    for (i = 0; i < this.keyStream2.length; ++i) {
                        Value v;
                        if (this.keyStream2[i] == null || this.keyStream2[i].length() <= 0 || (v = prev.searchValue(this.keyStream2[i])) != null) continue;
                        if (first) {
                            first = false;
                            error_message = error_message + "Missing fields, not found in input from previous steps:" + Const.CR;
                        }
                        error_found = true;
                        error_message = error_message + "\t\t" + this.keyStream[i] + Const.CR;
                    }
                    cr = error_found ? new CheckResult(4, error_message, stepMeta) : new CheckResult(1, "All fields found in the input stream.", stepMeta);
                    remarks.add(cr);
                    first = true;
                    error_found = false;
                    error_message = "";
                    for (i = 0; i < this.updateStream.length; ++i) {
                        String lufield = this.updateStream[i];
                        Value v = prev.searchValue(lufield);
                        if (v != null) continue;
                        if (first) {
                            first = false;
                            error_message = error_message + "Missing input stream fields to update/insert the target table with:" + Const.CR;
                        }
                        error_found = true;
                        error_message = error_message + "\t\t" + lufield + Const.CR;
                    }
                    cr = error_found ? new CheckResult(4, error_message, stepMeta) : new CheckResult(1, "All insert/update fields found in the input stream.", stepMeta);
                    remarks.add(cr);
                }
                error_message = "Couldn't read fields from the previous step." + Const.CR;
                cr = new CheckResult(4, error_message, stepMeta);
                remarks.add(cr);
            }
            catch (ETLException e) {
                error_message = "A database error occurred: " + e.getMessage();
                cr = new CheckResult(4, error_message, stepMeta);
                remarks.add(cr);
            }
            finally {
                db.disconnect();
            }
        } else {
            error_message = "Please select or create a connection!";
            cr = new CheckResult(4, error_message, stepMeta);
            remarks.add(cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, "Step is receiving info from other steps.", stepMeta);
            remarks.add(cr);
        } else {
            cr = new CheckResult(4, "No input received from other steps!", stepMeta);
            remarks.add(cr);
        }
    }

    @Override
    public SQLStatement getSQLStatements(TransMeta transMeta, StepMeta stepMeta, Row prev) {
        SQLStatement retval;
        block13: {
            retval = new SQLStatement(stepMeta.getName(), this.database, null);
            if (this.database != null) {
                if (prev != null && prev.size() > 0) {
                    if (this.tableName != null && this.tableName.length() > 0) {
                        Database db = new Database(this.database);
                        try {
                            String sql;
                            db.connect();
                            String cr_table = db.getDDL(this.tableName, prev, null, false, null, true);
                            String cr_index = "";
                            String[] idx_fields = null;
                            if (this.keyLookup != null && this.keyLookup.length > 0) {
                                idx_fields = new String[this.keyLookup.length];
                                for (int i = 0; i < this.keyLookup.length; ++i) {
                                    idx_fields[i] = this.keyLookup[i];
                                }
                            } else {
                                retval.setError("No key fields are specified.  Please specify the fields use as lookup key for this table.");
                            }
                            if (idx_fields != null && idx_fields.length > 0 && !db.checkIndexExists(this.tableName, idx_fields)) {
                                String indexname = "idx_" + this.tableName + "_lookup";
                                cr_index = db.getCreateIndexStatement(this.tableName, indexname, idx_fields, false, false, false, true);
                            }
                            if ((sql = cr_table + cr_index).length() == 0) {
                                retval.setSQL(null);
                                break block13;
                            }
                            retval.setSQL(sql);
                        }
                        catch (ETLException e) {
                            retval.setError("An error occurred: " + e.getMessage());
                        }
                    } else {
                        retval.setError("No table is defined on this connection.");
                    }
                } else {
                    retval.setError("Not receiving any fields from previous steps. Check the previous steps for errors & the connecting hops.");
                }
            } else {
                retval.setError("There is no connection defined in this step.");
            }
        }
        return retval;
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new InsertUpdate(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new InsertUpdateData();
    }
}

