/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.transformation.step.sql;

import com.kingdee.bos.ctrl.etl.base.Result;
import com.kingdee.bos.ctrl.etl.base.Row;
import com.kingdee.bos.ctrl.etl.database.Database;
import com.kingdee.bos.ctrl.etl.exception.ETLDatabaseException;
import com.kingdee.bos.ctrl.etl.exception.ETLException;
import com.kingdee.bos.ctrl.etl.exception.ETLStepException;
import com.kingdee.bos.ctrl.etl.transformation.Trans;
import com.kingdee.bos.ctrl.etl.transformation.TransMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.BaseStep;
import com.kingdee.bos.ctrl.etl.transformation.step.StepDataInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMetaInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.sql.ExecSQLData;
import com.kingdee.bos.ctrl.etl.transformation.step.sql.ExecSQLMeta;
import com.kingdee.bos.ctrl.etl.util.Const;
import com.kingdee.bos.ctrl.etl.value.Value;
import java.util.ArrayList;

public class ExecSQL
extends BaseStep
implements StepInterface {
    private ExecSQLMeta meta;
    private ExecSQLData data;

    public ExecSQL(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public static final Row getResultRow(Result result, String upd, String ins, String del, String read) {
        Row row = new Row();
        if (upd != null && upd.length() > 0) {
            Value rowsUpdated = new Value(upd, result.getNrLinesUpdated());
            rowsUpdated.setLength(9);
            row.addValue(rowsUpdated);
        }
        if (upd != null && upd.length() > 0) {
            Value rowsInserted = new Value(ins, result.getNrLinesOutput());
            rowsInserted.setLength(9);
            row.addValue(rowsInserted);
        }
        if (upd != null && upd.length() > 0) {
            Value rowsDeleted = new Value(del, result.getNrLinesDeleted());
            rowsDeleted.setLength(9);
            row.addValue(rowsDeleted);
        }
        if (upd != null && upd.length() > 0) {
            Value rowsRead = new Value(read, result.getNrLinesRead());
            rowsRead.setLength(9);
            row.addValue(rowsRead);
        }
        return row;
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws ETLException {
        int i;
        this.meta = (ExecSQLMeta)smi;
        this.data = (ExecSQLData)sdi;
        this.debug = "execute SQ start";
        Row row = null;
        if (!this.meta.isExecutedEachInputRow()) {
            this.debug = "exec once: return result";
            row = ExecSQL.getResultRow(this.data.result, this.meta.getUpdateField(), this.meta.getInsertField(), this.meta.getDeleteField(), this.meta.getReadField());
            this.putRow(row);
            this.setOutputDone();
            return false;
        }
        row = this.getRow();
        if (row == null) {
            this.setOutputDone();
            return false;
        }
        StringBuffer sql = new StringBuffer(this.meta.getSql());
        if (this.first) {
            this.first = false;
            this.debug = "Find the indexes of the arguments";
            this.data.argumentIndexes = new int[this.meta.getArguments().length];
            for (i = 0; i < this.meta.getArguments().length; ++i) {
                this.data.argumentIndexes[i] = row.searchValueIndex(this.meta.getArguments()[i]);
                if (this.data.argumentIndexes[i] >= 0) continue;
                this.logError("Error finding field: " + this.meta.getArguments()[i] + "]");
                throw new ETLStepException("Couldn't find field '" + this.meta.getArguments()[i] + "' in row!");
            }
            this.debug = "Find the locations of the question marks in the String...";
            this.data.markerPositions = new ArrayList();
            int len = sql.length();
            for (int pos = len - 1; pos >= 0; --pos) {
                if (sql.charAt(pos) != '?') continue;
                this.data.markerPositions.add(new Integer(pos));
            }
        }
        this.debug = "Replace the values in the SQL string...";
        for (i = 0; i < this.data.markerPositions.size(); ++i) {
            Value value = row.getValue(this.data.argumentIndexes[i]);
            int pos = (Integer)this.data.markerPositions.get(i);
            sql.replace(pos, pos + 1, value.getString());
        }
        this.debug = "Execute sql: " + sql;
        this.logRowlevel("Executing SQL script:" + Const.CR + sql);
        this.data.result = this.data.db.execStatements(sql.toString());
        this.debug = "Get result";
        Row add = ExecSQL.getResultRow(this.data.result, this.meta.getUpdateField(), this.meta.getInsertField(), this.meta.getDeleteField(), this.meta.getReadField());
        row.addRow(add);
        this.putRow(row);
        if (this.linesWritten > 0L && this.linesWritten % 5000L == 0L) {
            this.logBasic("linenr " + this.linesWritten);
        }
        return true;
    }

    @Override
    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (ExecSQLMeta)smi;
        this.data = (ExecSQLData)sdi;
        this.logBasic("Finished reading query, closing connection.");
        this.data.db.disconnect();
        super.dispose(smi, sdi);
    }

    @Override
    public void stopRunning() {
        try {
            if (this.data.db != null) {
                this.data.db.cancelQuery();
            }
        }
        catch (ETLDatabaseException eTLDatabaseException) {
            // empty catch block
        }
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (ExecSQLMeta)smi;
        this.data = (ExecSQLData)sdi;
        if (super.init(smi, sdi)) {
            this.data.db = new Database(this.meta.getDatabaseMeta());
            try {
                this.data.db.connect();
                this.logDetailed("Connected to database...");
                if (!this.meta.isExecutedEachInputRow()) {
                    this.data.result = this.data.db.execStatements(this.meta.getSql());
                }
                return true;
            }
            catch (ETLException e) {
                this.logError("An error occurred, processing will be stopped: " + e.getMessage());
                this.setErrors(1L);
                this.stopAll();
            }
        }
        return false;
    }

    @Override
    public void run() {
        try {
            this.logBasic("Starting to run...");
            while (!this.isStopped() && this.processRow(this.meta, this.data)) {
            }
        }
        catch (Exception e) {
            this.logError("Unexpected error in '" + this.debug + "' : " + e.toString());
            this.setErrors(1L);
            this.stopAll();
        }
        finally {
            this.dispose(this.meta, this.data);
            this.logSummary();
            this.markStop();
        }
    }
}

