/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.transformation.step.textfileoutput;

import com.kingdee.bos.ctrl.etl.base.CheckResult;
import com.kingdee.bos.ctrl.etl.base.Row;
import com.kingdee.bos.ctrl.etl.exception.ETLException;
import com.kingdee.bos.ctrl.etl.exception.ETLXMLException;
import com.kingdee.bos.ctrl.etl.repository.Repository;
import com.kingdee.bos.ctrl.etl.transformation.Trans;
import com.kingdee.bos.ctrl.etl.transformation.TransMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.BaseStepMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.StepDataInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMetaInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.textfileoutput.TextFileField;
import com.kingdee.bos.ctrl.etl.transformation.step.textfileoutput.TextFileOutput;
import com.kingdee.bos.ctrl.etl.transformation.step.textfileoutput.TextFileOutputData;
import com.kingdee.bos.ctrl.etl.util.Const;
import com.kingdee.bos.ctrl.etl.util.XMLHandler;
import com.kingdee.bos.ctrl.etl.value.Value;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import org.w3c.dom.Node;

public class TextFileOutputMeta
extends BaseStepMeta
implements StepMetaInterface {
    private String fileName;
    private String extension;
    private String separator;
    private String enclosure;
    private boolean headerEnabled;
    private boolean footerEnabled;
    private String fileFormat;
    private int splitEvery;
    private boolean fileAppended;
    private boolean stepNrInFilename;
    private boolean dateInFilename;
    private boolean timeInFilename;
    private boolean zipped;
    private boolean padded;
    private TextFileField[] outputFields;
    private String encoding;
    private String newline;

    public boolean isDateInFilename() {
        return this.dateInFilename;
    }

    public void setDateInFilename(boolean dateInFilename) {
        this.dateInFilename = dateInFilename;
    }

    public String getEnclosure() {
        return this.enclosure;
    }

    public void setEnclosure(String enclosure) {
        this.enclosure = enclosure;
    }

    public String getExtension() {
        return this.extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public boolean isFileAppended() {
        return this.fileAppended;
    }

    public void setFileAppended(boolean fileAppended) {
        this.fileAppended = fileAppended;
    }

    public String getFileFormat() {
        return this.fileFormat;
    }

    public void setFileFormat(String fileFormat) {
        this.fileFormat = fileFormat;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public boolean isFooterEnabled() {
        return this.footerEnabled;
    }

    public void setFooterEnabled(boolean footer) {
        this.footerEnabled = footer;
    }

    public boolean isHeaderEnabled() {
        return this.headerEnabled;
    }

    public void setHeaderEnabled(boolean header) {
        this.headerEnabled = header;
    }

    public String getNewline() {
        return this.newline;
    }

    public void setNewline(String newline) {
        this.newline = newline;
    }

    public boolean isPadded() {
        return this.padded;
    }

    public void setPadded(boolean padded) {
        this.padded = padded;
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public int getSplitEvery() {
        return this.splitEvery;
    }

    public void setSplitEvery(int splitEvery) {
        this.splitEvery = splitEvery;
    }

    public boolean isStepNrInFilename() {
        return this.stepNrInFilename;
    }

    public void setStepNrInFilename(boolean stepNrInFilename) {
        this.stepNrInFilename = stepNrInFilename;
    }

    public boolean isTimeInFilename() {
        return this.timeInFilename;
    }

    public void setTimeInFilename(boolean timeInFilename) {
        this.timeInFilename = timeInFilename;
    }

    public boolean isZipped() {
        return this.zipped;
    }

    public void setZipped(boolean zipped) {
        this.zipped = zipped;
    }

    public TextFileField[] getOutputFields() {
        return this.outputFields;
    }

    public void setOutputFields(TextFileField[] outputFields) {
        this.outputFields = outputFields;
    }

    @Override
    public void loadXML(Node stepnode, List databases, Hashtable counters) throws ETLXMLException {
        this.readData(stepnode);
    }

    public void allocate(int nrfields) {
        this.outputFields = new TextFileField[nrfields];
    }

    @Override
    public Object clone() {
        TextFileOutputMeta retval = (TextFileOutputMeta)super.clone();
        int nrfields = this.outputFields.length;
        retval.allocate(nrfields);
        for (int i = 0; i < nrfields; ++i) {
            retval.outputFields[i] = (TextFileField)this.outputFields[i].clone();
        }
        return retval;
    }

    private void readData(Node stepnode) throws ETLXMLException {
        try {
            this.separator = XMLHandler.getTagValue(stepnode, "separator");
            if (this.separator == null) {
                this.separator = "";
            }
            this.enclosure = XMLHandler.getTagValue(stepnode, "enclosure");
            if (this.enclosure == null) {
                this.enclosure = "";
            }
            this.headerEnabled = "Y".equalsIgnoreCase(XMLHandler.getTagValue(stepnode, "header"));
            this.footerEnabled = "Y".equalsIgnoreCase(XMLHandler.getTagValue(stepnode, "footer"));
            this.fileFormat = XMLHandler.getTagValue(stepnode, "format");
            this.encoding = XMLHandler.getTagValue(stepnode, "encoding");
            this.fileName = XMLHandler.getTagValue(stepnode, "file", "name");
            this.extension = XMLHandler.getTagValue(stepnode, "file", "extention");
            this.fileAppended = "Y".equalsIgnoreCase(XMLHandler.getTagValue(stepnode, "file", "append"));
            this.stepNrInFilename = "Y".equalsIgnoreCase(XMLHandler.getTagValue(stepnode, "file", "split"));
            this.dateInFilename = "Y".equalsIgnoreCase(XMLHandler.getTagValue(stepnode, "file", "add_date"));
            this.timeInFilename = "Y".equalsIgnoreCase(XMLHandler.getTagValue(stepnode, "file", "add_time"));
            this.zipped = "Y".equalsIgnoreCase(XMLHandler.getTagValue(stepnode, "file", "zipped"));
            this.padded = "Y".equalsIgnoreCase(XMLHandler.getTagValue(stepnode, "file", "pad"));
            this.splitEvery = Const.toInt(XMLHandler.getTagValue(stepnode, "file", "splitevery"), 0);
            this.newline = this.getNewLine(this.fileFormat);
            Node fields = XMLHandler.getSubNode(stepnode, "fields");
            int nrfields = XMLHandler.countNodes(fields, "field");
            this.allocate(nrfields);
            for (int i = 0; i < nrfields; ++i) {
                Node fnode = XMLHandler.getSubNodeByNr(fields, "field", i);
                this.outputFields[i] = new TextFileField();
                this.outputFields[i].setName(XMLHandler.getTagValue(fnode, "name"));
                this.outputFields[i].setType(XMLHandler.getTagValue(fnode, "type"));
                this.outputFields[i].setFormat(XMLHandler.getTagValue(fnode, "format"));
                this.outputFields[i].setCurrencySymbol(XMLHandler.getTagValue(fnode, "currency"));
                this.outputFields[i].setDecimalSymbol(XMLHandler.getTagValue(fnode, "decimal"));
                this.outputFields[i].setGroupingSymbol(XMLHandler.getTagValue(fnode, "group"));
                this.outputFields[i].setNullString(XMLHandler.getTagValue(fnode, "nullif"));
                this.outputFields[i].setLength(Const.toInt(XMLHandler.getTagValue(fnode, "length"), -1));
                this.outputFields[i].setPrecision(Const.toInt(XMLHandler.getTagValue(fnode, "precision"), -1));
            }
        }
        catch (Exception e) {
            throw new ETLXMLException("Unable to load step info from XML", e);
        }
    }

    public String getNewLine(String fformat) {
        String nl = System.getProperty("line.separator");
        if (fformat != null) {
            if (fformat.equalsIgnoreCase("DOS")) {
                nl = "\r\n";
            } else if (fformat.equalsIgnoreCase("UNIX")) {
                nl = "\n";
            }
        }
        return nl;
    }

    @Override
    public void setDefault() {
        this.separator = ";";
        this.enclosure = "\"";
        this.headerEnabled = true;
        this.footerEnabled = false;
        this.fileFormat = "DOS";
        this.fileName = "file";
        this.extension = "txt";
        this.stepNrInFilename = false;
        this.dateInFilename = false;
        this.timeInFilename = false;
        this.zipped = false;
        this.padded = false;
        this.splitEvery = 0;
        this.newline = this.getNewLine(this.fileFormat);
        int nrfields = 0;
        this.allocate(nrfields);
        for (int i = 0; i < nrfields; ++i) {
            this.outputFields[i] = new TextFileField();
            this.outputFields[i].setName("field" + i);
            this.outputFields[i].setType("Number");
            this.outputFields[i].setFormat(" 0,000,000.00;-0,000,000.00");
            this.outputFields[i].setCurrencySymbol("");
            this.outputFields[i].setDecimalSymbol(",");
            this.outputFields[i].setGroupingSymbol(".");
            this.outputFields[i].setNullString("");
            this.outputFields[i].setLength(-1);
            this.outputFields[i].setPrecision(-1);
        }
        this.fileAppended = false;
    }

    public String[] getFiles() {
        int nr;
        int copies = 1;
        int splits = 1;
        if (this.stepNrInFilename) {
            copies = 3;
        }
        if (this.splitEvery != 0) {
            splits = 3;
        }
        if ((nr = copies * splits) > 1) {
            ++nr;
        }
        String[] retval = new String[nr];
        int i = 0;
        for (int copy = 0; copy < copies; ++copy) {
            for (int split = 0; split < splits; ++split) {
                retval[i] = this.buildFilename(copy, split, false);
                ++i;
            }
        }
        if (i < nr) {
            retval[i] = "...";
        }
        return retval;
    }

    public String buildFilename(int stepnr, int splitnr, boolean ziparchive) {
        SimpleDateFormat daf = new SimpleDateFormat();
        String retval = Const.replEnv(this.fileName);
        Date now = new Date();
        if (this.dateInFilename) {
            daf.applyPattern("yyyMMdd");
            String d = daf.format(now);
            retval = retval + "_" + d;
        }
        if (this.timeInFilename) {
            daf.applyPattern("HHmmss");
            String t = daf.format(now);
            retval = retval + "_" + t;
        }
        if (this.stepNrInFilename) {
            retval = retval + "_" + stepnr;
        }
        if (this.splitEvery > 0) {
            retval = retval + "_" + splitnr;
        }
        if (this.zipped) {
            if (ziparchive) {
                retval = retval + ".zip";
            } else if (this.extension != null && this.extension.length() != 0) {
                retval = retval + "." + this.extension;
            }
        } else if (this.extension != null && this.extension.length() != 0) {
            retval = retval + "." + this.extension;
        }
        return retval;
    }

    @Override
    public Row getFields(Row r, String name, Row info) {
        Row row = r == null ? new Row() : r;
        for (int i = 0; i < this.outputFields.length; ++i) {
            TextFileField field = this.outputFields[i];
            Value v = row.searchValue(field.getName());
            if (v == null) continue;
            v.setLength(field.getLength(), field.getPrecision());
        }
        return row;
    }

    @Override
    public String getXML() {
        String retval = "";
        retval = retval + "    " + XMLHandler.addTagValue("separator", this.separator);
        retval = retval + "    " + XMLHandler.addTagValue("enclosure", this.enclosure);
        retval = retval + "    " + XMLHandler.addTagValue("header", this.headerEnabled);
        retval = retval + "    " + XMLHandler.addTagValue("footer", this.footerEnabled);
        retval = retval + "    " + XMLHandler.addTagValue("format", this.fileFormat);
        retval = retval + "    " + XMLHandler.addTagValue("encoding", this.encoding);
        retval = retval + "    <file>" + Const.CR;
        retval = retval + "      " + XMLHandler.addTagValue("name", this.fileName);
        retval = retval + "      " + XMLHandler.addTagValue("extention", this.extension);
        retval = retval + "      " + XMLHandler.addTagValue("append", this.fileAppended);
        retval = retval + "      " + XMLHandler.addTagValue("split", this.stepNrInFilename);
        retval = retval + "      " + XMLHandler.addTagValue("add_date", this.dateInFilename);
        retval = retval + "      " + XMLHandler.addTagValue("add_time", this.timeInFilename);
        retval = retval + "      " + XMLHandler.addTagValue("zipped", this.zipped);
        retval = retval + "      " + XMLHandler.addTagValue("pad", this.padded);
        retval = retval + "      " + XMLHandler.addTagValue("splitevery", this.splitEvery);
        retval = retval + "      </file>" + Const.CR;
        retval = retval + "    <fields>" + Const.CR;
        for (int i = 0; i < this.outputFields.length; ++i) {
            TextFileField field = this.outputFields[i];
            if (field.getName() == null || field.getName().length() == 0) continue;
            retval = retval + "      <field>" + Const.CR;
            retval = retval + "        " + XMLHandler.addTagValue("name", field.getName());
            retval = retval + "        " + XMLHandler.addTagValue("type", field.getType());
            retval = retval + "        " + XMLHandler.addTagValue("format", field.getFormat());
            retval = retval + "        " + XMLHandler.addTagValue("currency", field.getCurrencySymbol());
            retval = retval + "        " + XMLHandler.addTagValue("decimal", field.getDecimalSymbol());
            retval = retval + "        " + XMLHandler.addTagValue("group", field.getGroupingSymbol());
            retval = retval + "        " + XMLHandler.addTagValue("nullif", field.getNullString());
            retval = retval + "        " + XMLHandler.addTagValue("length", field.getLength());
            retval = retval + "        " + XMLHandler.addTagValue("precision", field.getPrecision());
            retval = retval + "        </field>" + Const.CR;
        }
        retval = retval + "      </fields>" + Const.CR;
        return retval;
    }

    @Override
    public void readRep(Repository rep, long id_step, List databases, Hashtable counters) throws ETLException {
        try {
            this.separator = rep.getStepAttributeString(id_step, "separator");
            this.enclosure = rep.getStepAttributeString(id_step, "enclosure");
            this.headerEnabled = rep.getStepAttributeBoolean(id_step, "header");
            this.footerEnabled = rep.getStepAttributeBoolean(id_step, "footer");
            this.fileFormat = rep.getStepAttributeString(id_step, "format");
            this.encoding = rep.getStepAttributeString(id_step, "encoding");
            this.fileName = rep.getStepAttributeString(id_step, "file_name");
            this.extension = rep.getStepAttributeString(id_step, "file_extention");
            this.fileAppended = rep.getStepAttributeBoolean(id_step, "file_append");
            this.splitEvery = (int)rep.getStepAttributeInteger(id_step, "file_split");
            this.stepNrInFilename = rep.getStepAttributeBoolean(id_step, "file_add_stepnr");
            this.dateInFilename = rep.getStepAttributeBoolean(id_step, "file_add_date");
            this.timeInFilename = rep.getStepAttributeBoolean(id_step, "file_add_time");
            this.zipped = rep.getStepAttributeBoolean(id_step, "file_zipped");
            this.padded = rep.getStepAttributeBoolean(id_step, "file_pad");
            this.newline = this.getNewLine(this.fileFormat);
            int nrfields = rep.countNrStepAttributes(id_step, "field_name");
            this.allocate(nrfields);
            for (int i = 0; i < nrfields; ++i) {
                this.outputFields[i] = new TextFileField();
                this.outputFields[i].setName(rep.getStepAttributeString(id_step, i, "field_name"));
                this.outputFields[i].setType(rep.getStepAttributeString(id_step, i, "field_type"));
                this.outputFields[i].setFormat(rep.getStepAttributeString(id_step, i, "field_format"));
                this.outputFields[i].setCurrencySymbol(rep.getStepAttributeString(id_step, i, "field_currency"));
                this.outputFields[i].setDecimalSymbol(rep.getStepAttributeString(id_step, i, "field_decimal"));
                this.outputFields[i].setGroupingSymbol(rep.getStepAttributeString(id_step, i, "field_group"));
                this.outputFields[i].setNullString(rep.getStepAttributeString(id_step, i, "field_nullif"));
                this.outputFields[i].setLength((int)rep.getStepAttributeInteger(id_step, i, "field_length"));
                this.outputFields[i].setPrecision((int)rep.getStepAttributeInteger(id_step, i, "field_precision"));
            }
        }
        catch (Exception e) {
            throw new ETLException("Unexpected error reading step information from the repository", e);
        }
    }

    @Override
    public void saveRep(Repository rep, long id_transformation, long id_step) throws ETLException {
        try {
            rep.saveStepAttribute(id_transformation, id_step, "separator", this.separator);
            rep.saveStepAttribute(id_transformation, id_step, "enclosure", this.enclosure);
            rep.saveStepAttribute(id_transformation, id_step, "header", this.headerEnabled);
            rep.saveStepAttribute(id_transformation, id_step, "footer", this.footerEnabled);
            rep.saveStepAttribute(id_transformation, id_step, "format", this.fileFormat);
            rep.saveStepAttribute(id_transformation, id_step, "encoding", this.encoding);
            rep.saveStepAttribute(id_transformation, id_step, "file_name", this.fileName);
            rep.saveStepAttribute(id_transformation, id_step, "file_extention", this.extension);
            rep.saveStepAttribute(id_transformation, id_step, "file_append", this.fileAppended);
            rep.saveStepAttribute(id_transformation, id_step, "file_split", this.splitEvery);
            rep.saveStepAttribute(id_transformation, id_step, "file_add_stepnr", this.stepNrInFilename);
            rep.saveStepAttribute(id_transformation, id_step, "file_add_date", this.dateInFilename);
            rep.saveStepAttribute(id_transformation, id_step, "file_add_time", this.timeInFilename);
            rep.saveStepAttribute(id_transformation, id_step, "file_zipped", this.zipped);
            rep.saveStepAttribute(id_transformation, id_step, "file_pad", this.padded);
            for (int i = 0; i < this.outputFields.length; ++i) {
                TextFileField field = this.outputFields[i];
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_name", field.getName());
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_type", field.getTypeDesc());
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_format", field.getFormat());
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_currency", field.getCurrencySymbol());
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_decimal", field.getDecimalSymbol());
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_group", field.getGroupingSymbol());
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_nullif", field.getNullString());
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_length", field.getLength());
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_precision", field.getPrecision());
            }
        }
        catch (Exception e) {
            throw new ETLException("Unable to save step information to the repository for id_step=" + id_step, e);
        }
    }

    @Override
    public void check(List remarks, StepMeta stepinfo, Row prev, String[] input, String[] output, Row info) {
        CheckResult cr;
        if (prev != null && prev.size() > 0) {
            cr = new CheckResult(1, "Step is connected to previous one, receiving " + prev.size() + " fields", stepinfo);
            remarks.add(cr);
            String error_message = "";
            boolean error_found = false;
            for (int i = 0; i < this.outputFields.length; ++i) {
                int idx = prev.searchValueIndex(this.outputFields[i].getName());
                if (idx >= 0) continue;
                error_message = error_message + "\t\t" + this.outputFields[i].getName() + Const.CR;
                error_found = true;
            }
            if (error_found) {
                error_message = "Fields that were not found in input stream:" + Const.CR + Const.CR + error_message;
                cr = new CheckResult(4, error_message, stepinfo);
                remarks.add(cr);
            } else {
                cr = new CheckResult(1, "All output fields are found in the input stream.", stepinfo);
                remarks.add(cr);
            }
        }
        if (input.length > 0) {
            cr = new CheckResult(1, "Step is receiving info from other steps.", stepinfo);
            remarks.add(cr);
        } else {
            cr = new CheckResult(4, "No input received from other steps!", stepinfo);
            remarks.add(cr);
        }
        cr = new CheckResult(2, "File specifications are not checked.", stepinfo);
        remarks.add(cr);
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new TextFileOutput(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new TextFileOutputData();
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }
}

