/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.util;

import com.kingdee.bos.ctrl.etl.database.DatabaseMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMeta;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;

public class Const {
    public static final String VERSION = "2.2.2";
    public static final int SLEEP_EMPTY_NANOS = 1;
    public static final int SLEEP_FULL_NANOS = 1;
    public static final int ROWS_UPDATE = 5000;
    public static final int ROWS_IN_ROWSET = 350;
    public static final int FETCH_SIZE = 100;
    public static final int SORT_SIZE = 5000;
    public static final String FILE_SEPARATOR = System.getProperty("file.separator");
    public static final String CR = System.getProperty("line.separator");
    public static final String JAVA_VERSION = System.getProperty("java.vm.version");
    public static final String IMAGE_DIRECTORY = "/be/ibridge/kettle/images/";
    public static final String PLUGIN_STEPS_DIRECTORY_PUBLIC = "plugins" + FILE_SEPARATOR + "steps";
    public static final String PLUGIN_STEPS_DIRECTORY_PRIVATE = Const.getETLDirectory() + FILE_SEPARATOR + "plugins" + FILE_SEPARATOR + "steps";
    public static final String PLUGIN_JOBENTRIES_DIRECTORY_PUBLIC = "plugins" + FILE_SEPARATOR + "jobentries";
    public static final String PLUGIN_JOBENTRIES_DIRECTORY_PRIVATE = Const.getETLDirectory() + FILE_SEPARATOR + "plugins" + FILE_SEPARATOR + "jobentries";
    public static final Date MIN_DATE = new Date(-2208992400000L);
    public static final Date MAX_DATE = new Date(7258114799468L);
    public static final int MIN_YEAR = 1900;
    public static final int MAX_YEAR = 2199;
    public static final int RIGHT = 400;
    public static final int LENGTH = 350;
    public static final int MARGIN = 5;
    public static final int MIDDLE_PCT = 35;
    public static final int ARROW_WIDTH = 1;
    public static final int FORM_MARGIN = 3;
    public static final int SHADOW_SIZE = 4;
    public static final int SYMBOLSIZE = 10;
    public static final int MAX_FILE_HIST = 9;
    public static final Locale DEFAULT_LOCALE = Locale.getDefault();
    public static final char DEFAULT_DECIMAL_SEPARATOR = new DecimalFormatSymbols(DEFAULT_LOCALE).getDecimalSeparator();
    public static final char DEFAULT_GROUPING_SEPARATOR = new DecimalFormatSymbols(DEFAULT_LOCALE).getGroupingSeparator();
    public static final String DEFAULT_CURRENCY_SYMBOL = new DecimalFormatSymbols(DEFAULT_LOCALE).getCurrencySymbol();
    public static final String DEFAULT_NUMBER_FORMAT = ((DecimalFormat)NumberFormat.getInstance()).toPattern();
    public static final String NULL_STRING = "";
    public static final String NULL_NUMBER = "";
    public static final String NULL_DATE = "";
    public static final String NULL_BIGNUMBER = "";
    public static final String NULL_BOOLEAN = "";
    public static final String NULL_INTEGER = "";
    public static final String NULL_NONE = "";
    public static final String FONT_FIXED_NAME = "Courier";
    public static final int FONT_FIXED_SIZE = 9;
    public static final int ICON_SIZE = 32;
    public static final int LINE_WIDTH = 1;
    public static final int GRID_SIZE = 20;
    public static final int NOTE_MIN_SIZE = 20;
    public static final int NOTE_MARGIN = 5;
    public static final int COLOR_BACKGROUND_RED = 255;
    public static final int COLOR_BACKGROUND_GREEN = 255;
    public static final int COLOR_BACKGROUND_BLUE = 255;
    public static final int COLOR_GRAPH_RED = 255;
    public static final int COLOR_GRAPH_GREEN = 255;
    public static final int COLOR_GRAPH_BLUE = 255;
    public static final int COLOR_TAB_RED = 200;
    public static final int COLOR_TAB_GREEN = 200;
    public static final int COLOR_TAB_BLUE = 255;
    public static final int MAX_UNDO = 100;
    public static final String USER_HOME_DIRECTORY = System.getProperty("user.home");
    public static final String CHEF_LOG_FILE = "chef";
    public static final String SPOON_LOG_FILE = "spoon";
    public static final String MENU_LOG_FILE = "menu";
    public static final String[] tips = new String[]{"You can create a new step, simply by dragging the step onto the graph view." + CR + "You can find steps and plugins to use in the tree on the left side of the screen under 'Base step types'", "You can define a new hop between 2 steps by using the middle or scrollwheel button." + CR + "Middle-click on the first step and drag onto the second." + CR + "You can also: " + CR + " - use SHIFT+Click and drag from one step to another" + CR + " - Select 2 steps and right click on one of them, then select 'new hop'" + CR + " - Drag 'Hops' onto the canvas", "Inserting a step between 2 steps that are already connected with a hop:" + CR + "simply move the step over the arrow until the arrow becomes drawn in bold." + CR + "Release the mouse-button and you'll be asked if you want to insert the step.", "Edit the step description by double clicking on a step using the middle-button", "Explore a database by clicking right on a connection and selecting 'explore database'", "Preview the rows that are passing throuqh a step (output) by selecting the step and by pressing F10 (preview)", "Check the settings of steps by first selecting one or more of them." + CR + "Then by using the right-click option 'Check selected steps'", "Click right on the first column in any dialog table (grid) for a list of all the options."};
    public static final String[] dateFormats = new String[]{"yyyy/MM/dd HH:mm:ss.SSS", "yyyy/MM/dd HH:mm:ss", "yyyyMMddHHmmss", "dd/MM/yyyy", "dd-MM-yyyy", "yyyy/MM/dd", "yyyy-MM-dd", "yyyyMMdd", "ddMMyyyy", "d-M-yyyy", "d/M/yyyy", "d-M-yy", "d/M/yy"};
    public static final String[] numberFormats = new String[]{DEFAULT_NUMBER_FORMAT, "0.00", "0000000000000", "#.#", "#", "###,###,###.#######", "###############.###############", "#####.###############%"};
    public static final String XML_ENCODING = "UTF-8";
    public static final String STRING_TRANS_DEFAULT_EXT = ".ktr";
    public static final String[] STRING_TRANS_FILTER_EXT = new String[]{"*.ktr;*.xml", "*.xml", "*.*"};
    public static final String[] STRING_TRANS_FILTER_NAMES = new String[]{"ETL Transformations", "XML Files", "All files"};
    public static final String STRING_JOB_DEFAULT_EXT = ".kjb";
    public static final String[] STRING_JOB_FILTER_EXT = new String[]{"*.kjb;*.xml", "*.xml", "*.*"};
    public static final String[] STRING_JOB_FILTER_NAMES = new String[]{"ETL Jobs", "XML Files", "All files"};
    public static final String protocal = "protocal";
    public static final String host = "host";
    public static final String port = "port";
    public static final String service = "service";
    public static final String account = "account";
    public static final String JobID = "jobid";
    public static final String JobName = "jobname";
    public static final String JobDesc = "jobdescription";
    public static final String JobCreateUser = "JobCreateUser";
    public static final String JobCreateTime = "JobCreateTime";
    public static final String ScheduleName = "schedulename";
    public static final String ScheduleID = "ScheduleID";
    public static final String IsUsed = "IsUsed";
    public static final String IsSuccess = "IsSuccess";
    public static final String StartTime = "StartTime";
    public static final String EndTime = "EndTime";
    public static final String ErrorDesc = "ErrorDesc";
    public static final String ErrorTime = "ErrorTime";
    public static final String ScheduleExpression = "ScheduleExpression";

    public static final float round(double f, int places) {
        float temp = (float)(f * Math.pow(10.0, places));
        temp = Math.round(temp);
        return temp /= (float)((int)Math.pow(10.0, places));
    }

    public static final int toInt(String str, int def) {
        int retval;
        try {
            retval = Integer.parseInt(str);
        }
        catch (Exception e) {
            retval = def;
        }
        return retval;
    }

    public static final long toLong(String str, long def) {
        long retval;
        try {
            retval = Long.parseLong(str);
        }
        catch (Exception e) {
            retval = def;
        }
        return retval;
    }

    public static final double toDouble(String str, double def) {
        double retval;
        try {
            retval = Double.parseDouble(str);
        }
        catch (Exception e) {
            retval = def;
        }
        return retval;
    }

    public static final Date toDate(String str, Date def) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS");
        try {
            return df.parse(str);
        }
        catch (ParseException e) {
            return def;
        }
    }

    public static final String rtrim(String str) {
        int max;
        for (max = str.length(); max > 0 && Const.isSpace(str.charAt(max - 1)); --max) {
        }
        return str.substring(0, max);
    }

    public static final boolean isSpace(char c) {
        return c == ' ' || c == '\t' || c == '\r' || c == '\n';
    }

    public static final String ltrim(String str) {
        int from;
        for (from = 0; from < str.length() && Const.isSpace(str.charAt(from)); ++from) {
        }
        return str.substring(from);
    }

    public static final String trim(String str) {
        int min;
        int max = str.length() - 1;
        for (min = 0; min <= max && Const.isSpace(str.charAt(min)); ++min) {
        }
        while (max >= 0 && Const.isSpace(str.charAt(max))) {
            --max;
        }
        if (max < min) {
            return "";
        }
        return str.substring(min, max + 1);
    }

    public static final String rightPad(String ret, int limit) {
        if (ret == null) {
            return Const.rightPad(new StringBuffer(), limit);
        }
        return Const.rightPad(new StringBuffer(ret), limit);
    }

    public static final String rightPad(StringBuffer ret, int limit) {
        int len = ret.length();
        if (len > limit) {
            ret.setLength(limit);
        } else {
            for (int l = len; l < limit; ++l) {
                ret.append(' ');
            }
        }
        return ret.toString();
    }

    public static final String replace(String string, String repl, String with) {
        StringBuffer str = new StringBuffer(string);
        for (int i = str.length() - 1; i >= 0; --i) {
            if (!str.substring(i).startsWith(repl)) continue;
            str.delete(i, i + repl.length());
            str.insert(i, with);
        }
        return str.toString();
    }

    public static void repl(StringBuffer str, String code, String repl) {
        int clength = code.length();
        for (int i = str.length() - clength; i >= 0; --i) {
            String look = str.substring(i, i + clength);
            if (!look.equalsIgnoreCase(code)) continue;
            str.replace(i, i + clength, repl);
        }
    }

    public static final int nrSpacesBefore(String field) {
        int nr;
        int len = field.length();
        for (nr = 0; nr < len && field.charAt(nr) == ' '; ++nr) {
        }
        return nr;
    }

    public static final int nrSpacesAfter(String field) {
        int nr;
        int len = field.length();
        for (nr = 0; nr < len && field.charAt(field.length() - 1 - nr) == ' '; ++nr) {
        }
        return nr;
    }

    public static final boolean onlySpaces(String str) {
        for (int i = 0; i < str.length(); ++i) {
            if (Const.isSpace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static final String getOS() {
        return System.getProperty("os.name");
    }

    public static final boolean isWindows() {
        return Const.getOS().startsWith("Windows");
    }

    public static final String getHostname() {
        try {
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            while (en.hasMoreElements()) {
                NetworkInterface nwi = en.nextElement();
                Enumeration<InetAddress> ip = nwi.getInetAddresses();
                while (ip.hasMoreElements()) {
                    InetAddress in = ip.nextElement();
                    if (in.getHostName().equalsIgnoreCase("localhost")) continue;
                    return in.getHostName();
                }
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return "localhost";
    }

    public static final String getIPAddress() {
        try {
            Enumeration<NetworkInterface> enumInterfaces = NetworkInterface.getNetworkInterfaces();
            while (enumInterfaces.hasMoreElements()) {
                NetworkInterface nwi = enumInterfaces.nextElement();
                Enumeration<InetAddress> ip = nwi.getInetAddresses();
                while (ip.hasMoreElements()) {
                    InetAddress in = ip.nextElement();
                    if (in.isLoopbackAddress() || in.toString().indexOf(":") >= 0) continue;
                    return in.getHostAddress();
                }
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return "127.0.0.1";
    }

    public static final String getMACAddress() {
        String ip = Const.getIPAddress();
        String mac = "none";
        String os = Const.getOS();
        String s = "";
        if (os.equalsIgnoreCase("Windows NT") || os.equalsIgnoreCase("Windows 2000") || os.equalsIgnoreCase("Windows XP") || os.equalsIgnoreCase("Windows 95") || os.equalsIgnoreCase("Windows 98") || os.equalsIgnoreCase("Windows Me") || os.startsWith("Windows")) {
            try {
                Process p = Runtime.getRuntime().exec("nbtstat -a " + ip);
                BufferedReader stdInput = new BufferedReader(new InputStreamReader(p.getInputStream()));
                while (!Const.procDone(p)) {
                    while ((s = stdInput.readLine()) != null) {
                        if (s.indexOf("MAC") < 0) continue;
                        int idx = s.indexOf("=");
                        mac = s.substring(idx + 2);
                    }
                }
                stdInput.close();
            }
            catch (Exception p) {}
        } else if (os.equalsIgnoreCase("Linux")) {
            try {
                Process p = Runtime.getRuntime().exec("/sbin/ifconfig -a");
                BufferedReader stdInput = new BufferedReader(new InputStreamReader(p.getInputStream()));
                while (!Const.procDone(p)) {
                    while ((s = stdInput.readLine()) != null) {
                        int idx = s.indexOf("HWaddr");
                        if (idx < 0) continue;
                        mac = s.substring(idx + 7);
                    }
                }
                stdInput.close();
            }
            catch (Exception p) {}
        } else if (os.equalsIgnoreCase("Solaris")) {
            try {
                Process p = Runtime.getRuntime().exec("/usr/sbin/ifconfig -a");
                BufferedReader stdInput = new BufferedReader(new InputStreamReader(p.getInputStream()));
                while (!Const.procDone(p)) {
                    while ((s = stdInput.readLine()) != null) {
                        int idx = s.indexOf("ether");
                        if (idx < 0) continue;
                        mac = s.substring(idx + 6);
                    }
                }
                stdInput.close();
            }
            catch (Exception p) {}
        } else if (os.equalsIgnoreCase("HP-UX")) {
            try {
                Process p = Runtime.getRuntime().exec("/usr/sbin/lanscan -a");
                BufferedReader stdInput = new BufferedReader(new InputStreamReader(p.getInputStream()));
                while (!Const.procDone(p)) {
                    while ((s = stdInput.readLine()) != null) {
                        if (s.indexOf("MAC") < 0) continue;
                        int idx = s.indexOf("0x");
                        mac = s.substring(idx + 2);
                    }
                }
                stdInput.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return Const.trim(mac);
    }

    private static final boolean procDone(Process p) {
        try {
            p.exitValue();
            return true;
        }
        catch (IllegalThreadStateException e) {
            return false;
        }
    }

    public static final String getETLDirectory() {
        return System.getProperty("user.home") + FILE_SEPARATOR + ".kettle";
    }

    public static final String getETLLocalRepositoriesFile() {
        return "repositories.xml";
    }

    public static final String getETLUserRepositoriesFile() {
        return Const.getETLDirectory() + FILE_SEPARATOR + Const.getETLLocalRepositoriesFile();
    }

    public static final String getCommandlineOption(ArrayList args, String option) {
        String[] optionStart = new String[]{"-", "/"};
        String[] optionDelim = new String[]{"=", ":"};
        for (int s = 0; s < optionStart.length; ++s) {
            for (int d = 0; d < optionDelim.length; ++d) {
                String optstr = optionStart[s] + option + optionDelim[d];
                String retval = Const.searchCommandLineOption(args, optstr);
                if (retval == null) continue;
                return retval;
            }
        }
        return null;
    }

    private static final String searchCommandLineOption(List args, String prefix) {
        String retval = null;
        for (int i = args.size() - 1; i >= 0; --i) {
            String arg = (String)args.get(i);
            if (arg == null || !arg.toUpperCase().startsWith(prefix.toUpperCase())) continue;
            retval = arg.substring(prefix.length());
            args.remove(i);
        }
        return retval;
    }

    public static String getEnvironmentVariable(String variable, String deflt) {
        return System.getProperty(variable, deflt);
    }

    public static final String replEnv(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer str = new StringBuffer(string);
        int idx = str.indexOf("%%");
        while (idx >= 0) {
            int to = str.indexOf("%%", idx + 2);
            if (to >= 0) {
                String newval;
                String marker = str.substring(idx, to + 2);
                String var = str.substring(idx + 2, to);
                if (var != null && var.length() > 0 && (newval = Const.getEnvironmentVariable(var, null)) != null) {
                    str.replace(idx, to + 2, newval);
                    to += newval.length() - marker.length();
                }
            } else {
                to = idx;
            }
            idx = str.indexOf("%%", to + 1);
        }
        return str.toString();
    }

    public static final String[] replEnv(String[] string) {
        String[] retval = new String[string.length];
        for (int i = 0; i < string.length; ++i) {
            retval[i] = Const.replEnv(string[i]);
        }
        return retval;
    }

    public static final String NVL(String source, String def) {
        if (source == null) {
            return def;
        }
        return source;
    }

    public static final int indexOfString(String lookup, String[] array) {
        if (array == null) {
            return -1;
        }
        if (lookup == null) {
            return -1;
        }
        for (int i = 0; i < array.length; ++i) {
            if (!lookup.equalsIgnoreCase(array[i])) continue;
            return i;
        }
        return -1;
    }

    public static final int indexOfString(String lookup, ArrayList array) {
        if (array == null) {
            return -1;
        }
        for (int i = 0; i < array.size(); ++i) {
            String compare = (String)array.get(i);
            if (!lookup.equalsIgnoreCase(compare)) continue;
            return i;
        }
        return -1;
    }

    public static final String[] sortStrings(String[] input) {
        for (int i = 0; i < input.length; ++i) {
            for (int j = 0; j < input.length - 1; ++j) {
                if (input[j].compareTo(input[j + 1]) <= 0) continue;
                String dummy = input[j];
                input[j] = input[j + 1];
                input[j + 1] = dummy;
            }
        }
        return input;
    }

    public static final String[] splitString(String string, String separator) {
        int from;
        ArrayList<String> list = new ArrayList<String>();
        if (string == null || string.length() == 0) {
            return new String[0];
        }
        int sepLen = separator.length();
        for (int i = from = 0; i < string.length(); i += sepLen) {
            if (!string.substring(i, i + sepLen).equalsIgnoreCase(separator)) continue;
            list.add(Const.NVL(string.substring(from, i), ""));
            from = i + sepLen;
        }
        if (from + sepLen <= string.length()) {
            list.add(Const.NVL(string.substring(from, string.length()), ""));
        }
        return list.toArray(new String[list.size()]);
    }

    public static final String[] splitPath(String path, String separator) {
        int from;
        if (path == null || path.length() == 0 || path.equals(separator)) {
            return new String[0];
        }
        int sepLen = separator.length();
        int nr_separators = 0;
        int n = from = path.startsWith(separator) ? sepLen : 0;
        if (from != 0) {
            ++nr_separators;
        }
        for (int i = from; i < path.length(); i += sepLen) {
            if (!path.substring(i, i + sepLen).equalsIgnoreCase(separator)) continue;
            ++nr_separators;
        }
        String[] spath = new String[nr_separators];
        int nr = 0;
        for (int i = from; i < path.length(); i += sepLen) {
            if (!path.substring(i, i + sepLen).equalsIgnoreCase(separator)) continue;
            spath[nr] = path.substring(from, i);
            ++nr;
            from = i + sepLen;
        }
        if (nr < spath.length) {
            spath[nr] = path.substring(from);
        }
        if (spath.length == 0 && path.length() > 0) {
            spath = new String[]{path};
        }
        return spath;
    }

    public static final void quickSort(List elements) {
        if (!elements.isEmpty()) {
            Const.quickSort(elements, 0, elements.size() - 1);
        }
    }

    private static final void quickSort(List elements, int lowIndex, int highIndex) {
        int lowToHighIndex = lowIndex;
        int highToLowIndex = highIndex;
        int pivotIndex = (lowToHighIndex + highToLowIndex) / 2;
        Comparable pivotValue = (Comparable)elements.get(pivotIndex);
        int newLowIndex = highIndex + 1;
        int newHighIndex = lowIndex - 1;
        while (newHighIndex + 1 < newLowIndex) {
            int compareResult;
            Comparable lowToHighValue = (Comparable)elements.get(lowToHighIndex);
            while (lowToHighIndex < newLowIndex & lowToHighValue.compareTo(pivotValue) < 0) {
                newHighIndex = lowToHighIndex++;
                lowToHighValue = (Comparable)elements.get(lowToHighIndex);
            }
            Comparable highToLowValue = (Comparable)elements.get(highToLowIndex);
            while (newHighIndex <= highToLowIndex & highToLowValue.compareTo(pivotValue) > 0) {
                newLowIndex = highToLowIndex--;
                highToLowValue = (Comparable)elements.get(highToLowIndex);
            }
            if (lowToHighIndex == highToLowIndex) {
                newHighIndex = lowToHighIndex;
                continue;
            }
            if (lowToHighIndex >= highToLowIndex || (compareResult = lowToHighValue.compareTo(highToLowValue)) < 0) continue;
            Comparable parking = lowToHighValue;
            elements.set(lowToHighIndex, highToLowValue);
            elements.set(highToLowIndex, parking);
            newLowIndex = highToLowIndex--;
            newHighIndex = lowToHighIndex++;
        }
        if (lowIndex < newHighIndex) {
            Const.quickSort(elements, lowIndex, newHighIndex);
        }
        if (newLowIndex < highIndex) {
            Const.quickSort(elements, newLowIndex, highIndex);
        }
    }

    public static String[] getConversionFormats() {
        int x;
        String[] dats = dateFormats;
        String[] nums = numberFormats;
        int totsize = dats.length + nums.length;
        String[] formats = new String[totsize];
        for (x = 0; x < dats.length; ++x) {
            formats[x] = dats[x];
        }
        for (x = 0; x < nums.length; ++x) {
            formats[dats.length + x] = nums[x];
        }
        return formats;
    }

    public static final DatabaseMeta findDatabase(List databases, long id) {
        if (databases == null) {
            return null;
        }
        if (id < 0L) {
            id = 0L;
        }
        for (int i = 0; i < databases.size(); ++i) {
            DatabaseMeta ci = (DatabaseMeta)databases.get(i);
            if (ci.getID() != id) continue;
            return ci;
        }
        return null;
    }

    public static final DatabaseMeta findDatabase(List databases, String dbname) {
        if (databases == null) {
            return null;
        }
        if (dbname == null) {
            dbname = "";
        }
        for (int i = 0; i < databases.size(); ++i) {
            DatabaseMeta ci = (DatabaseMeta)databases.get(i);
            if (!ci.getName().equalsIgnoreCase(dbname)) continue;
            return ci;
        }
        return null;
    }

    public static final StepMeta findStep(List steps, long id) {
        if (steps == null) {
            return null;
        }
        for (int i = 0; i < steps.size(); ++i) {
            StepMeta stepMeta = (StepMeta)steps.get(i);
            if (stepMeta.getID() != id) continue;
            return stepMeta;
        }
        return null;
    }

    public static final StepMeta findStep(List steps, String stepname) {
        if (steps == null) {
            return null;
        }
        for (int i = 0; i < steps.size(); ++i) {
            StepMeta stepMeta = (StepMeta)steps.get(i);
            if (!stepMeta.getName().equalsIgnoreCase(stepname)) continue;
            return stepMeta;
        }
        return null;
    }
}

