/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.util;

import com.kingdee.bos.ctrl.etl.base.Row;
import com.kingdee.bos.ctrl.etl.util.Const;
import com.kingdee.bos.ctrl.etl.value.Value;
import com.kingdee.bos.ctrl.kdf.util.CloseUtil;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import org.apache.commons.io.FilenameUtils;

public class Props
implements Cloneable {
    private static Props props;
    public static final String STRING_FONT_FIXED_NAME = "FontFixedName";
    public static final String STRING_FONT_FIXED_SIZE = "FontFixedSize";
    public static final String STRING_FONT_FIXED_STYLE = "FontFixedStyle";
    public static final String STRING_FONT_DEFAULT_NAME = "FontDefaultName";
    public static final String STRING_FONT_DEFAULT_SIZE = "FontDefaultSize";
    public static final String STRING_FONT_DEFAULT_STYLE = "FontDefaultStyle";
    public static final String STRING_FONT_GRAPH_NAME = "FontGraphName";
    public static final String STRING_FONT_GRAPH_SIZE = "FontGraphSize";
    public static final String STRING_FONT_GRAPH_STYLE = "FontGraphStyle";
    public static final String STRING_FONT_GRID_NAME = "FontGridName";
    public static final String STRING_FONT_GRID_SIZE = "FontGridSize";
    public static final String STRING_FONT_GRID_STYLE = "FontGridStyle";
    public static final String STRING_FONT_NOTE_NAME = "FontNoteName";
    public static final String STRING_FONT_NOTE_SIZE = "FontNoteSize";
    public static final String STRING_FONT_NOTE_STYLE = "FontNoteStyle";
    public static final String STRING_BACKGROUND_COLOR_R = "BackgroundColorR";
    public static final String STRING_BACKGROUND_COLOR_G = "BackgroundColorG";
    public static final String STRING_BACKGROUND_COLOR_B = "BackgroundColorB";
    public static final String STRING_GRAPH_COLOR_R = "GraphColorR";
    public static final String STRING_GRAPH_COLOR_G = "GraphColorG";
    public static final String STRING_GRAPH_COLOR_B = "GraphColorB";
    public static final String STRING_TAB_COLOR_R = "TabColorR";
    public static final String STRING_TAB_COLOR_G = "TabColorG";
    public static final String STRING_TAB_COLOR_B = "TabColorB";
    public static final String STRING_ICON_SIZE = "IconSize";
    public static final String STRING_LINE_WIDTH = "LineWidth";
    public static final String STRING_SHADOW_SIZE = "ShadowSize";
    public static final String STRING_LOG_LEVEL = "LogLevel";
    public static final String STRING_LOG_FILTER = "LogFilter";
    public static final String STRING_MIDDLE_PCT = "MiddlePct";
    public static final String STRING_LAST_PREVIEW_TRANS = "LastPreviewTrans";
    public static final String STRING_LAST_PREVIEW_STEP = "LastPreviewStep";
    public static final String STRING_LAST_PREVIEW_SIZE = "LastPreviewSize";
    public static final String STRING_MAX_UNDO = "MaxUndo";
    public static final String STRING_SIZE_MAX = "SizeMax";
    public static final String STRING_SIZE_X = "SizeX";
    public static final String STRING_SIZE_Y = "SizeY";
    public static final String STRING_SIZE_W = "SizeW";
    public static final String STRING_SIZE_H = "SizeH";
    public static final String STRING_SASH_W1 = "SashWeight1";
    public static final String STRING_SASH_W2 = "SashWeight2";
    public static final String STRING_SHOW_TIPS = "ShowTips";
    public static final String STRING_TIP_NR = "TipNr";
    public static final String STRING_AUTO_SAVE = "AutoSave";
    public static final String STRING_SAVE_CONF = "SaveConfirmation";
    public static final String STRING_AUTO_SPLIT = "AutoSplit";
    public static final String STRING_USE_DB_CACHE = "UseDBCache";
    public static final String STRING_OPEN_LAST_FILE = "OpenLastFile";
    public static final String STRING_LAST_REPOSITORY_LOGIN = "RepositoryLastLogin";
    public static final String STRING_LAST_REPOSITORY = "RepositoryLast";
    public static final String STRING_ONLY_ACTIVE_STEPS = "OnlyActiveSteps";
    public static final String STRING_START_SHOW_REPOSITORIES = "ShowRepositoriesAtStartup";
    public static final String STRING_ANTI_ALIASING = "EnableAntiAliasing";
    public static final String STRING_SHOW_EXIT_WARNING = "ShowExitWarning";
    public static final String STRING_SHOW_OS_LOOK = "ShowOSLook";
    public static final String STRING_LAST_ARGUMENT = "LastArgument";
    public static final String STRING_CUSTOM_PARAMETER = "CustomParameter";
    public static final String STRING_PLUGIN_HISTORY = "PluginHistory";
    private Properties properties;
    private String[] lastfiles;
    private String[] lastdirs;
    private boolean[] lasttypes;
    private String[] lastrepos;
    private ArrayList pluginHistory;
    private int type;
    public static final int TYPE_PROPERTIES_EMPTY = 0;
    public static final int TYPE_PROPERTIES_SPOON = 1;
    public static final int TYPE_PROPERTIES_PAN = 2;
    public static final int TYPE_PROPERTIES_CHEF = 3;
    public static final int TYPE_PROPERTIES_KITCHEN = 4;
    public static final int TYPE_PROPERTIES_MENU = 5;
    public static final int TYPE_PROPERTIES_PLATE = 6;
    public static final int WIDGET_STYLE_DEFAULT = 0;
    public static final int WIDGET_STYLE_FIXED = 1;
    public static final int WIDGET_STYLE_TABLE = 2;
    public static final int WIDGET_STYLE_NOTEPAD = 3;
    public static final int WIDGET_STYLE_GRAPH = 4;
    public static final int WIDGET_STYLE_TAB = 5;

    public static final boolean isInitialized() {
        return props != null;
    }

    public static final Props getInstance() {
        if (props != null) {
            return props;
        }
        throw new RuntimeException("Properties, ETL systems settings, not initialised!");
    }

    public String getFilename() {
        String directory = Const.getETLDirectory();
        String filename = "";
        File dir = new File(FilenameUtils.normalize((String)directory));
        try {
            dir.mkdirs();
        }
        catch (Exception exception) {
            // empty catch block
        }
        switch (this.type) {
            case 1: 
            case 2: {
                filename = directory + Const.FILE_SEPARATOR + ".spoonrc";
                break;
            }
            case 3: 
            case 4: {
                filename = directory + Const.FILE_SEPARATOR + ".chefrc";
                break;
            }
            case 5: {
                filename = directory + Const.FILE_SEPARATOR + ".menu";
                break;
            }
            case 6: {
                filename = directory + Const.FILE_SEPARATOR + ".plate";
                break;
            }
        }
        return filename;
    }

    public String getLicenseFilename() {
        String directory = Const.getETLDirectory();
        String filename = directory + Const.FILE_SEPARATOR + ".licence";
        File dir = new File(FilenameUtils.normalize((String)directory));
        if (!dir.exists()) {
            try {
                dir.mkdirs();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return filename;
    }

    public boolean fileExists() {
        File f = new File(FilenameUtils.normalize((String)this.getFilename()));
        return f.exists();
    }

    public void setType(int t) {
        this.type = t;
    }

    public int getType() {
        return this.type;
    }

    public void setDefault() {
        this.lastfiles = new String[0];
        this.lasttypes = new boolean[0];
        this.lastrepos = new String[0];
        this.properties.setProperty(STRING_LOG_LEVEL, this.getLogLevel());
        this.properties.setProperty(STRING_LOG_FILTER, this.getLogFilter());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadProps() {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(FilenameUtils.normalize((String)this.getFilename()));
            this.properties.load(fis);
        }
        catch (Exception e) {
            boolean bl;
            try {
                bl = false;
            }
            catch (Throwable throwable) {
                CloseUtil.close((Closeable[])new Closeable[]{fis});
                throw throwable;
            }
            CloseUtil.close((Closeable[])new Closeable[]{fis});
            return bl;
        }
        CloseUtil.close((Closeable[])new Closeable[]{fis});
        return true;
    }

    public void saveProps() {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(new File(FilenameUtils.normalize((String)this.getFilename())));
            this.properties.store(fos, "ETL Properties file");
        }
        catch (IOException iOException) {
            CloseUtil.close((Closeable[])new Closeable[]{fos});
        }
        catch (Throwable throwable) {
            CloseUtil.close((Closeable[])new Closeable[]{fos});
            throw throwable;
        }
        CloseUtil.close((Closeable[])new Closeable[]{fos});
    }

    public void setLastFiles(String[] lf, String[] ld, boolean[] lt, String[] lr) {
        int i;
        if (lf.length > 9) {
            this.lastfiles = new String[9];
            this.lastdirs = new String[9];
            this.lasttypes = new boolean[9];
            this.lastrepos = new String[9];
            for (i = 0; i < 9; ++i) {
                this.lastfiles[i] = lf[i];
                this.lastdirs[i] = ld[i];
                this.lasttypes[i] = lt[i];
                this.lastrepos[i] = lr[i];
            }
        } else {
            this.lastfiles = lf;
            this.lastdirs = ld;
            this.lasttypes = lt;
            this.lastrepos = lr;
        }
        this.properties.setProperty("lastfiles", "" + lf.length);
        for (i = 0; i < lf.length; ++i) {
            this.properties.setProperty("lastfile" + (i + 1), lf[i] == null ? "" : lf[i]);
            this.properties.setProperty("lastdir" + (i + 1), ld[i] == null ? "" : ld[i]);
            this.properties.setProperty("lasttype" + (i + 1), lt[i] ? "Y" : "N");
            this.properties.setProperty("lastrepo" + (i + 1), lr[i] == null ? "" : lr[i]);
        }
    }

    public void addLastFile(int propType, String lf, String ld, boolean lt, String lr) {
        if (propType != this.getType()) {
            return;
        }
        boolean exists = false;
        int idx = -1;
        for (int i = 0; i < this.lastfiles.length; ++i) {
            if (!lf.equalsIgnoreCase(this.lastfiles[i]) || this.lasttypes[i] != lt || ld == null || !ld.equalsIgnoreCase(this.lastdirs[i])) continue;
            exists = true;
            idx = i;
        }
        if (!exists) {
            String[] newlf = new String[this.lastfiles.length + 1];
            String[] newld = new String[this.lastfiles.length + 1];
            boolean[] newlt = new boolean[this.lastfiles.length + 1];
            String[] newlr = new String[this.lastfiles.length + 1];
            for (int i = 0; i < newlf.length; ++i) {
                if (i == 0) {
                    newlf[i] = lf;
                    newld[i] = ld;
                    newlt[i] = lt;
                    newlr[i] = lt ? lr : "";
                    continue;
                }
                newlf[i] = this.lastfiles[i - 1];
                newld[i] = this.lastdirs[i - 1];
                newlt[i] = this.lasttypes[i - 1];
                newlr[i] = this.lastrepos[i - 1];
            }
            this.setLastFiles(newlf, newld, newlt, newlr);
        } else {
            String[] newlf = new String[this.lastfiles.length];
            String[] newld = new String[this.lastfiles.length];
            boolean[] newlt = new boolean[this.lastfiles.length];
            String[] newlr = new String[this.lastfiles.length];
            newlf[0] = lf;
            newld[0] = ld;
            newlt[0] = lt;
            newlr[0] = lt ? lr : "";
            for (int i = 1; i < this.lastfiles.length; ++i) {
                if (i <= idx) {
                    newlf[i] = this.lastfiles[i - 1];
                    newld[i] = this.lastdirs[i - 1];
                    newlt[i] = this.lasttypes[i - 1];
                    newlr[i] = this.lastrepos[i - 1];
                    continue;
                }
                newlf[i] = this.lastfiles[i];
                newld[i] = this.lastdirs[i];
                newlt[i] = this.lasttypes[i];
                newlr[i] = this.lastrepos[i];
            }
            this.setLastFiles(newlf, newld, newlt, newlr);
        }
    }

    public String[] getLastFiles() {
        int nr = Const.toInt(this.properties.getProperty("lastfiles"), 0);
        String[] lf = new String[nr];
        for (int i = 0; i < nr; ++i) {
            lf[i] = this.properties.getProperty("lastfile" + (i + 1), "");
        }
        return lf;
    }

    public String[] getLastDirs() {
        int nr = Const.toInt(this.properties.getProperty("lastfiles"), 0);
        String[] ld = new String[nr];
        for (int i = 0; i < nr; ++i) {
            ld[i] = this.properties.getProperty("lastdir" + (i + 1), "");
        }
        return ld;
    }

    public boolean[] getLastTypes() {
        int nr = Const.toInt(this.properties.getProperty("lastfiles"), 0);
        boolean[] lt = new boolean[nr];
        for (int i = 0; i < nr; ++i) {
            lt[i] = "Y".equalsIgnoreCase(this.properties.getProperty("lasttype" + (i + 1), "N"));
        }
        return lt;
    }

    public String[] getLastRepositories() {
        String snr = this.properties.getProperty("lastfiles");
        int nr = Const.toInt(snr, 0);
        String[] lr = new String[nr];
        for (int i = 0; i < nr; ++i) {
            lr[i] = this.properties.getProperty("lastrepo" + (i + 1));
        }
        return lr;
    }

    public void setLogLevel(String level) {
        this.properties.setProperty(STRING_LOG_LEVEL, level);
    }

    public String getLogLevel() {
        String level = this.properties.getProperty(STRING_LOG_LEVEL, "Basic");
        return level;
    }

    public void setLogFilter(String filter) {
        this.properties.setProperty(STRING_LOG_FILTER, Const.NVL(filter, ""));
    }

    public String getLogFilter() {
        String level = this.properties.getProperty(STRING_LOG_FILTER, "");
        return level;
    }

    public void setIconSize(int size) {
        this.properties.setProperty(STRING_ICON_SIZE, "" + size);
    }

    public int getIconSize() {
        return Const.toInt(this.properties.getProperty(STRING_ICON_SIZE), 32);
    }

    public void setLineWidth(int width) {
        this.properties.setProperty(STRING_LINE_WIDTH, "" + width);
    }

    public int getLineWidth() {
        return Const.toInt(this.properties.getProperty(STRING_LINE_WIDTH), 1);
    }

    public void setShadowSize(int size) {
        this.properties.setProperty(STRING_SHADOW_SIZE, "" + size);
    }

    public int getShadowSize() {
        return Const.toInt(this.properties.getProperty(STRING_SHADOW_SIZE), 4);
    }

    public void setLastTrans(String trans) {
        this.properties.setProperty(STRING_LAST_PREVIEW_TRANS, trans);
    }

    public String getLastTrans() {
        return this.properties.getProperty(STRING_LAST_PREVIEW_TRANS, "");
    }

    public void setLastPreview(String[] lastpreview, int[] stepsize) {
        this.properties.setProperty(STRING_LAST_PREVIEW_STEP, "" + lastpreview.length);
        for (int i = 0; i < lastpreview.length; ++i) {
            this.properties.setProperty(STRING_LAST_PREVIEW_STEP + (i + 1), lastpreview[i]);
            this.properties.setProperty(STRING_LAST_PREVIEW_SIZE + (i + 1), "" + stepsize[i]);
        }
    }

    public String[] getLastPreview() {
        String snr = this.properties.getProperty(STRING_LAST_PREVIEW_STEP);
        int nr = Const.toInt(snr, 0);
        String[] lp = new String[nr];
        for (int i = 0; i < nr; ++i) {
            lp[i] = this.properties.getProperty(STRING_LAST_PREVIEW_STEP + (i + 1), "");
        }
        return lp;
    }

    public int[] getLastPreviewSize() {
        String snr = this.properties.getProperty(STRING_LAST_PREVIEW_STEP);
        int nr = Const.toInt(snr, 0);
        int[] si = new int[nr];
        for (int i = 0; i < nr; ++i) {
            si[i] = Const.toInt(this.properties.getProperty(STRING_LAST_PREVIEW_SIZE + (i + 1), ""), 0);
        }
        return si;
    }

    public void setMaxUndo(int max) {
        this.properties.setProperty(STRING_MAX_UNDO, "" + max);
    }

    public int getMaxUndo() {
        return Const.toInt(this.properties.getProperty(STRING_MAX_UNDO), 100);
    }

    public void setMiddlePct(int pct) {
        this.properties.setProperty(STRING_MIDDLE_PCT, "" + pct);
    }

    public int getMiddlePct() {
        return Const.toInt(this.properties.getProperty(STRING_MIDDLE_PCT), 35);
    }

    public void setUseDBCache(boolean use) {
        this.properties.setProperty(STRING_USE_DB_CACHE, use ? "Y" : "N");
    }

    public boolean useDBCache() {
        String use = this.properties.getProperty(STRING_USE_DB_CACHE);
        return !"N".equalsIgnoreCase(use);
    }

    public void setOpenLastFile(boolean open) {
        this.properties.setProperty(STRING_OPEN_LAST_FILE, open ? "Y" : "N");
    }

    public boolean openLastFile() {
        String open = this.properties.getProperty(STRING_OPEN_LAST_FILE);
        return !"N".equalsIgnoreCase(open);
    }

    public void setLastRepository(String repname) {
        this.properties.setProperty(STRING_LAST_REPOSITORY, repname);
    }

    public String getLastRepository() {
        return this.properties.getProperty(STRING_LAST_REPOSITORY);
    }

    public void setLastRepositoryLogin(String login) {
        this.properties.setProperty(STRING_LAST_REPOSITORY_LOGIN, login);
    }

    public String getLastRepositoryLogin() {
        return this.properties.getProperty(STRING_LAST_REPOSITORY_LOGIN);
    }

    public void setAutoSave(boolean autosave) {
        this.properties.setProperty(STRING_AUTO_SAVE, autosave ? "Y" : "N");
    }

    public boolean getAutoSave() {
        String autosave = this.properties.getProperty(STRING_AUTO_SAVE);
        return "Y".equalsIgnoreCase(autosave);
    }

    public void setSaveConfirmation(boolean saveconf) {
        this.properties.setProperty(STRING_SAVE_CONF, saveconf ? "Y" : "N");
    }

    public boolean getSaveConfirmation() {
        String saveconf = this.properties.getProperty(STRING_SAVE_CONF);
        return "Y".equalsIgnoreCase(saveconf);
    }

    public void setAutoSplit(boolean autosplit) {
        this.properties.setProperty(STRING_AUTO_SPLIT, autosplit ? "Y" : "N");
    }

    public boolean getAutoSplit() {
        String autosplit = this.properties.getProperty(STRING_AUTO_SPLIT);
        return "Y".equalsIgnoreCase(autosplit);
    }

    public void setOnlyActiveSteps(boolean only) {
        this.properties.setProperty(STRING_ONLY_ACTIVE_STEPS, only ? "Y" : "N");
    }

    public boolean getOnlyActiveSteps() {
        String only = this.properties.getProperty(STRING_ONLY_ACTIVE_STEPS, "N");
        return "Y".equalsIgnoreCase(only);
    }

    public String getCustomParameter(String parameterName, String defaultValue) {
        return this.properties.getProperty(STRING_CUSTOM_PARAMETER + parameterName, defaultValue);
    }

    public void setCustomParameter(String parameterName, String value) {
        this.properties.setProperty(STRING_CUSTOM_PARAMETER + parameterName, value);
    }

    public void clearCustomParameters() {
        Enumeration<Object> keys = this.properties.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            if (!key.startsWith(STRING_CUSTOM_PARAMETER)) continue;
            this.properties.remove(key);
        }
    }

    public boolean showRepositoriesDialogAtStartup() {
        String show = this.properties.getProperty(STRING_START_SHOW_REPOSITORIES, "Y");
        return "Y".equalsIgnoreCase(show);
    }

    public void setExitWarningShown(boolean show) {
        this.properties.setProperty(STRING_SHOW_EXIT_WARNING, show ? "Y" : "N");
    }

    public boolean isAntiAliasingEnabled() {
        String anti = this.properties.getProperty(STRING_ANTI_ALIASING, "N");
        return "Y".equalsIgnoreCase(anti);
    }

    public void setAntiAliasingEnabled(boolean anti) {
        this.properties.setProperty(STRING_ANTI_ALIASING, anti ? "Y" : "N");
    }

    public boolean showExitWarning() {
        String show = this.properties.getProperty(STRING_SHOW_EXIT_WARNING, "Y");
        return "Y".equalsIgnoreCase(show);
    }

    public void setRepositoriesDialogAtStartupShown(boolean show) {
        this.properties.setProperty(STRING_START_SHOW_REPOSITORIES, show ? "Y" : "N");
    }

    public boolean isOSLookShown() {
        String show = this.properties.getProperty(STRING_SHOW_OS_LOOK, "N");
        return "Y".equalsIgnoreCase(show);
    }

    public void setOSLookShown(boolean show) {
        this.properties.setProperty(STRING_SHOW_OS_LOOK, show ? "Y" : "N");
    }

    public static final int getArgumentNumber(Value value) {
        if (value != null && value.getName().startsWith("Argument ")) {
            return Const.toInt(value.getName().substring("Argument ".length()), -1);
        }
        return -1;
    }

    public static final String[] convertArguments(Row row) {
        String[] args = new String[10];
        for (int i = 0; i < row.size(); ++i) {
            Value value = row.getValue(i);
            int argNr = Props.getArgumentNumber(value);
            if (argNr < 0 || argNr >= 10) continue;
            args[argNr] = value.getString();
        }
        return args;
    }

    public void setLastArguments(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (args[i] == null) continue;
            this.properties.setProperty("LastArgument_" + i, args[i]);
        }
    }

    public String[] getLastArguments() {
        String[] args = new String[10];
        for (int i = 0; i < args.length; ++i) {
            args[i] = this.properties.getProperty("LastArgument_" + i);
        }
        return args;
    }

    public List getPluginHistory() {
        return this.pluginHistory;
    }

    public void addPluginHistory(String pluginID) {
        this.pluginHistory.add(0, pluginID);
        for (int i = this.pluginHistory.size() - 1; i > 0; --i) {
            String id = (String)this.pluginHistory.get(i);
            if (!id.equalsIgnoreCase(pluginID)) continue;
            this.pluginHistory.remove(i);
        }
        this.savePluginHistory();
    }

    private void loadPluginHistory() {
        this.pluginHistory = new ArrayList();
        int i = 0;
        String pluginID = this.properties.getProperty("PluginHistory_" + i);
        while (pluginID != null) {
            this.pluginHistory.add(pluginID);
            pluginID = this.properties.getProperty("PluginHistory_" + ++i);
        }
    }

    private void savePluginHistory() {
        for (int i = 0; i < this.pluginHistory.size(); ++i) {
            String id = (String)this.pluginHistory.get(i);
            this.properties.setProperty("PluginHistory_" + i, id);
        }
    }
}

