/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.cipher.asn1.test;

import com.kingdee.bos.ctrl.cipher.asn1.ASN1InputStream;
import com.kingdee.bos.ctrl.cipher.asn1.ASN1Sequence;
import com.kingdee.bos.ctrl.cipher.asn1.DERObjectIdentifier;
import com.kingdee.bos.ctrl.cipher.asn1.DERUTF8String;
import com.kingdee.bos.ctrl.cipher.asn1.ess.ContentHints;
import com.kingdee.bos.ctrl.cipher.asn1.test.ASN1UnitTest;
import java.io.IOException;

public class ContentHintsUnitTest
extends ASN1UnitTest {
    @Override
    public String getName() {
        return "ContentHints";
    }

    @Override
    public void performTest() throws Exception {
        DERUTF8String contentDescription = new DERUTF8String("Description");
        DERObjectIdentifier contentType = new DERObjectIdentifier("1.2.2.3");
        ContentHints hints = new ContentHints(contentType);
        this.checkConstruction(hints, contentType, null);
        hints = new ContentHints(contentType, contentDescription);
        this.checkConstruction(hints, contentType, contentDescription);
        hints = ContentHints.getInstance(null);
        if (hints != null) {
            this.fail("null getInstance() failed.");
        }
        try {
            ContentHints.getInstance(new Object());
            this.fail("getInstance() failed to detect bad object.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void checkConstruction(ContentHints hints, DERObjectIdentifier contentType, DERUTF8String description) throws IOException {
        this.checkValues(hints, contentType, description);
        hints = ContentHints.getInstance(hints);
        this.checkValues(hints, contentType, description);
        ASN1InputStream aIn = new ASN1InputStream(hints.toASN1Object().getEncoded());
        ASN1Sequence seq = (ASN1Sequence)aIn.readObject();
        hints = ContentHints.getInstance(seq);
        this.checkValues(hints, contentType, description);
    }

    private void checkValues(ContentHints hints, DERObjectIdentifier contentType, DERUTF8String description) {
        this.checkMandatoryField("contentType", contentType, hints.getContentType());
        this.checkOptionalField("description", description, hints.getContentDescription());
    }

    public static void main(String[] args) {
        ContentHintsUnitTest.runTest(new ContentHintsUnitTest());
    }
}

