/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.cipher.asn1.test;

import com.kingdee.bos.ctrl.cipher.asn1.ASN1InputStream;
import com.kingdee.bos.ctrl.cipher.asn1.ASN1OctetString;
import com.kingdee.bos.ctrl.cipher.asn1.ASN1Sequence;
import com.kingdee.bos.ctrl.cipher.asn1.DEROctetString;
import com.kingdee.bos.ctrl.cipher.asn1.icao.DataGroupHash;
import com.kingdee.bos.ctrl.cipher.util.test.SimpleTest;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;

public class DataGroupHashUnitTest
extends SimpleTest {
    @Override
    public String getName() {
        return "DataGroupHash";
    }

    private byte[] generateHash() {
        SecureRandom rand = null;
        byte[] bytes = new byte[20];
        try {
            rand = SecureRandom.getInstanceStrong();
            for (int i = 0; i != bytes.length; ++i) {
                bytes[i] = (byte)rand.nextInt();
            }
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return bytes;
    }

    @Override
    public void performTest() throws Exception {
        int dataGroupNumber = 1;
        DEROctetString dataHash = new DEROctetString(this.generateHash());
        DataGroupHash dg = new DataGroupHash(dataGroupNumber, dataHash);
        this.checkConstruction(dg, dataGroupNumber, dataHash);
        dg = DataGroupHash.getInstance(null);
        if (dg != null) {
            this.fail("null getInstance() failed.");
        }
        try {
            DataGroupHash.getInstance(new Object());
            this.fail("getInstance() failed to detect bad object.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void checkConstruction(DataGroupHash dg, int dataGroupNumber, ASN1OctetString dataGroupHashValue) throws IOException {
        this.checkValues(dg, dataGroupNumber, dataGroupHashValue);
        dg = DataGroupHash.getInstance(dg);
        this.checkValues(dg, dataGroupNumber, dataGroupHashValue);
        ASN1InputStream aIn = new ASN1InputStream(dg.toASN1Object().getEncoded());
        ASN1Sequence seq = (ASN1Sequence)aIn.readObject();
        dg = DataGroupHash.getInstance(seq);
        this.checkValues(dg, dataGroupNumber, dataGroupHashValue);
    }

    private void checkValues(DataGroupHash dg, int dataGroupNumber, ASN1OctetString dataGroupHashValue) {
        if (dg.getDataGroupNumber() != dataGroupNumber) {
            this.fail("group number don't match.");
        }
        if (!dg.getDataGroupHashValue().equals(dataGroupHashValue)) {
            this.fail("hash value don't match.");
        }
    }

    public static void main(String[] args) {
        DataGroupHashUnitTest.runTest(new DataGroupHashUnitTest());
    }
}

