/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.cipher.asn1.test;

import com.kingdee.bos.ctrl.cipher.asn1.ASN1InputStream;
import com.kingdee.bos.ctrl.cipher.asn1.DERString;
import com.kingdee.bos.ctrl.cipher.asn1.isismtt.x509.Restriction;
import com.kingdee.bos.ctrl.cipher.asn1.test.ASN1UnitTest;
import com.kingdee.bos.ctrl.cipher.asn1.x500.DirectoryString;
import java.io.IOException;

public class RestrictionUnitTest
extends ASN1UnitTest {
    @Override
    public String getName() {
        return "Restriction";
    }

    @Override
    public void performTest() throws Exception {
        DirectoryString res = new DirectoryString("test");
        Restriction restriction = new Restriction(res.getString());
        this.checkConstruction(restriction, res);
        restriction = Restriction.getInstance(null);
        if (restriction != null) {
            this.fail("null getInstance() failed.");
        }
        try {
            Restriction.getInstance(new Object());
            this.fail("getInstance() failed to detect bad object.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void checkConstruction(Restriction restriction, DirectoryString res) throws IOException {
        this.checkValues(restriction, res);
        restriction = Restriction.getInstance(restriction);
        this.checkValues(restriction, res);
        ASN1InputStream aIn = new ASN1InputStream(restriction.toASN1Object().getEncoded());
        DERString str = (DERString)((Object)aIn.readObject());
        restriction = Restriction.getInstance(str);
        this.checkValues(restriction, res);
    }

    private void checkValues(Restriction restriction, DirectoryString res) {
        this.checkMandatoryField("restriction", res, restriction.getRestriction());
    }

    public static void main(String[] args) {
        RestrictionUnitTest.runTest(new RestrictionUnitTest());
    }
}

