/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.cipher.asn1.test;

import com.kingdee.bos.ctrl.cipher.asn1.ASN1EncodableVector;
import com.kingdee.bos.ctrl.cipher.asn1.ASN1Set;
import com.kingdee.bos.ctrl.cipher.asn1.BERSet;
import com.kingdee.bos.ctrl.cipher.asn1.DERBitString;
import com.kingdee.bos.ctrl.cipher.asn1.DERBoolean;
import com.kingdee.bos.ctrl.cipher.asn1.DERInteger;
import com.kingdee.bos.ctrl.cipher.asn1.DEROctetString;
import com.kingdee.bos.ctrl.cipher.asn1.DERSequence;
import com.kingdee.bos.ctrl.cipher.asn1.DERSet;
import com.kingdee.bos.ctrl.cipher.asn1.DERTaggedObject;
import com.kingdee.bos.ctrl.cipher.util.test.SimpleTest;

public class SetTest
extends SimpleTest {
    @Override
    public String getName() {
        return "Set";
    }

    private void checkedSortedSet(int attempt, ASN1Set s) {
        if (s.getObjectAt(0) instanceof DERBoolean && s.getObjectAt(1) instanceof DERInteger && s.getObjectAt(2) instanceof DERBitString && s.getObjectAt(3) instanceof DEROctetString) {
            return;
        }
        this.fail("sorting failed on attempt: " + attempt);
    }

    @Override
    public void performTest() {
        DERTaggedObject tag;
        ASN1EncodableVector v = new ASN1EncodableVector();
        byte[] data = new byte[10];
        v.add(new DEROctetString(data));
        v.add(new DERBitString(data));
        v.add(new DERInteger(100));
        v.add(new DERBoolean(true));
        this.checkedSortedSet(0, new DERSet(v));
        v = new ASN1EncodableVector();
        v.add(new DERInteger(100));
        v.add(new DERBoolean(true));
        v.add(new DEROctetString(data));
        v.add(new DERBitString(data));
        this.checkedSortedSet(1, new DERSet(v));
        v = new ASN1EncodableVector();
        v.add(new DERBoolean(true));
        v.add(new DEROctetString(data));
        v.add(new DERBitString(data));
        v.add(new DERInteger(100));
        this.checkedSortedSet(2, new DERSet(v));
        v = new ASN1EncodableVector();
        v.add(new DERBitString(data));
        v.add(new DEROctetString(data));
        v.add(new DERInteger(100));
        v.add(new DERBoolean(true));
        this.checkedSortedSet(3, new DERSet(v));
        v = new ASN1EncodableVector();
        v.add(new DEROctetString(data));
        v.add(new DERBitString(data));
        v.add(new DERInteger(100));
        v.add(new DERBoolean(true));
        ASN1Set s = new BERSet(v);
        if (!(s.getObjectAt(0) instanceof DEROctetString)) {
            this.fail("BER set sort order changed.");
        }
        if ((s = ASN1Set.getInstance(tag = new DERTaggedObject(false, 1, new DERSequence(v)), false)).getObjectAt(0) instanceof DERBoolean) {
            this.fail("sorted when shouldn't be.");
        }
        v = new ASN1EncodableVector();
        v.add(new DERBoolean(true));
        v.add(new DERBoolean(true));
        v.add(new DERBoolean(true));
        s = new DERSet(v);
    }

    public static void main(String[] args) {
        SetTest.runTest(new SetTest());
    }
}

