/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.cipher.asn1.test;

import com.kingdee.bos.ctrl.cipher.asn1.ASN1InputStream;
import com.kingdee.bos.ctrl.cipher.asn1.ASN1OctetString;
import com.kingdee.bos.ctrl.cipher.asn1.DERObject;
import com.kingdee.bos.ctrl.cipher.asn1.DEROutputStream;
import com.kingdee.bos.ctrl.cipher.asn1.pkcs.PrivateKeyInfo;
import com.kingdee.bos.ctrl.cipher.asn1.sec.ECPrivateKeyStructure;
import com.kingdee.bos.ctrl.cipher.asn1.x509.AlgorithmIdentifier;
import com.kingdee.bos.ctrl.cipher.asn1.x509.SubjectPublicKeyInfo;
import com.kingdee.bos.ctrl.cipher.asn1.x9.X962NamedCurves;
import com.kingdee.bos.ctrl.cipher.asn1.x9.X962Parameters;
import com.kingdee.bos.ctrl.cipher.asn1.x9.X9ECParameters;
import com.kingdee.bos.ctrl.cipher.asn1.x9.X9ECPoint;
import com.kingdee.bos.ctrl.cipher.asn1.x9.X9IntegerConverter;
import com.kingdee.bos.ctrl.cipher.asn1.x9.X9ObjectIdentifiers;
import com.kingdee.bos.ctrl.cipher.math.ec.ECFieldElement;
import com.kingdee.bos.ctrl.cipher.math.ec.ECPoint;
import com.kingdee.bos.ctrl.cipher.util.encoders.Base64;
import com.kingdee.bos.ctrl.cipher.util.test.SimpleTest;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.math.BigInteger;

public class X9Test
extends SimpleTest {
    private byte[] namedPub = Base64.decode("MBowEwYHKoZIzj0CAQYIKoZIzj0DAQEDAwADAQ==");
    private byte[] expPub = Base64.decode("MIHfMIHXBgcqhkjOPQIBMIHLAgEBMCkGByqGSM49AQECHn///////////////3///////4AAAAAAAH///////zBXBB5///////////////9///////+AAAAAAAB///////wEHiVXBfoqMGZUsfTLA9anUKMMJQEC1JiHF9m6FattPgMVAH1zdBaP/jRxtgqFdoahlHXTv6L/BB8DZ2iujhi7ks/PAFyUmqLG2UhT0OZgu/hUsclQX+laAh5///////////////9///+XXetBs6YFfDxDIUZSZVECAQEDAwADAQ==");
    private byte[] namedPriv = Base64.decode("MCICAQAwEwYHKoZIzj0CAQYIKoZIzj0DAQEECDAGAgEBBAEK");
    private byte[] expPriv = Base64.decode("MIHnAgEAMIHXBgcqhkjOPQIBMIHLAgEBMCkGByqGSM49AQECHn///////////////3///////4AAAAAAAH///////zBXBB5///////////////9///////+AAAAAAAB///////wEHiVXBfoqMGZUsfTLA9anUKMMJQEC1JiHF9m6FattPgMVAH1zdBaP/jRxtgqFdoahlHXTv6L/BB8DZ2iujhi7ks/PAFyUmqLG2UhT0OZgu/hUsclQX+laAh5///////////////9///+XXetBs6YFfDxDIUZSZVECAQEECDAGAgEBBAEU");

    private void encodePublicKey() throws Exception {
        ASN1InputStream aIn;
        DERObject o;
        ASN1OctetString p;
        X962Parameters params;
        SubjectPublicKeyInfo info;
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        DEROutputStream dOut = new DEROutputStream(bOut);
        X9IntegerConverter conv = new X9IntegerConverter();
        X9ECParameters ecP = X962NamedCurves.getByOID(X9ObjectIdentifiers.prime239v3);
        if (conv.getByteLength(ecP.getCurve()) != 30) {
            this.fail("wrong byte length reported for curve");
        }
        if (ecP.getCurve().getFieldSize() != 239) {
            this.fail("wrong field size reported for curve");
        }
        if (!this.areEqual((info = new SubjectPublicKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, params = new X962Parameters(X9ObjectIdentifiers.prime192v1)), (p = (ASN1OctetString)new X9ECPoint(new ECPoint.Fp(ecP.getCurve(), new ECFieldElement.Fp(BigInteger.valueOf(2L), BigInteger.valueOf(1L)), new ECFieldElement.Fp(BigInteger.valueOf(4L), BigInteger.valueOf(3L)), true)).getDERObject()).getOctets())).getEncoded(), this.namedPub)) {
            this.fail("failed public named generation");
        }
        if (!info.equals(o = (aIn = new ASN1InputStream(new ByteArrayInputStream(this.namedPub))).readObject())) {
            this.fail("failed public named equality");
        }
        if (!this.areEqual((info = new SubjectPublicKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, params = new X962Parameters(ecP)), p.getOctets())).getEncoded(), this.expPub)) {
            this.fail("failed public explicit generation");
        }
        if (!info.equals(o = (aIn = new ASN1InputStream(new ByteArrayInputStream(this.expPub))).readObject())) {
            this.fail("failed public explicit equality");
        }
    }

    private void encodePrivateKey() throws Exception {
        ASN1InputStream aIn;
        DERObject o;
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        DEROutputStream dOut = new DEROutputStream(bOut);
        X9ECParameters ecP = X962NamedCurves.getByOID(X9ObjectIdentifiers.prime239v3);
        X962Parameters params = new X962Parameters(X9ObjectIdentifiers.prime192v1);
        ASN1OctetString p = (ASN1OctetString)new X9ECPoint(new ECPoint.Fp(ecP.getCurve(), new ECFieldElement.Fp(BigInteger.valueOf(2L), BigInteger.valueOf(1L)), new ECFieldElement.Fp(BigInteger.valueOf(4L), BigInteger.valueOf(3L)), true)).getDERObject();
        PrivateKeyInfo info = new PrivateKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, params), new ECPrivateKeyStructure(BigInteger.valueOf(10L)).getDERObject());
        if (!this.areEqual(info.getEncoded(), this.namedPriv)) {
            this.fail("failed private named generation");
        }
        if (!info.equals(o = (aIn = new ASN1InputStream(new ByteArrayInputStream(this.namedPriv))).readObject())) {
            this.fail("failed private named equality");
        }
        if (!this.areEqual((info = new PrivateKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, params = new X962Parameters(ecP)), new ECPrivateKeyStructure(BigInteger.valueOf(20L)).toASN1Object())).getEncoded(), this.expPriv)) {
            this.fail("failed private explicit generation");
        }
        if (!info.equals(o = (aIn = new ASN1InputStream(new ByteArrayInputStream(this.expPriv))).readObject())) {
            this.fail("failed private explicit equality");
        }
    }

    @Override
    public void performTest() throws Exception {
        this.encodePublicKey();
        this.encodePrivateKey();
    }

    @Override
    public String getName() {
        return "X9";
    }

    public static void main(String[] args) {
        X9Test.runTest(new X9Test());
    }
}

