/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.cipher.asn1.util;

import com.kingdee.bos.ctrl.cipher.asn1.ASN1OctetString;
import com.kingdee.bos.ctrl.cipher.asn1.ASN1Sequence;
import com.kingdee.bos.ctrl.cipher.asn1.ASN1Set;
import com.kingdee.bos.ctrl.cipher.asn1.BERApplicationSpecific;
import com.kingdee.bos.ctrl.cipher.asn1.BERConstructedOctetString;
import com.kingdee.bos.ctrl.cipher.asn1.BERConstructedSequence;
import com.kingdee.bos.ctrl.cipher.asn1.BERSequence;
import com.kingdee.bos.ctrl.cipher.asn1.BERSet;
import com.kingdee.bos.ctrl.cipher.asn1.BERTaggedObject;
import com.kingdee.bos.ctrl.cipher.asn1.DERApplicationSpecific;
import com.kingdee.bos.ctrl.cipher.asn1.DERBMPString;
import com.kingdee.bos.ctrl.cipher.asn1.DERBitString;
import com.kingdee.bos.ctrl.cipher.asn1.DERBoolean;
import com.kingdee.bos.ctrl.cipher.asn1.DERConstructedSequence;
import com.kingdee.bos.ctrl.cipher.asn1.DERConstructedSet;
import com.kingdee.bos.ctrl.cipher.asn1.DEREncodable;
import com.kingdee.bos.ctrl.cipher.asn1.DERGeneralizedTime;
import com.kingdee.bos.ctrl.cipher.asn1.DERIA5String;
import com.kingdee.bos.ctrl.cipher.asn1.DERInteger;
import com.kingdee.bos.ctrl.cipher.asn1.DERNull;
import com.kingdee.bos.ctrl.cipher.asn1.DERObject;
import com.kingdee.bos.ctrl.cipher.asn1.DERObjectIdentifier;
import com.kingdee.bos.ctrl.cipher.asn1.DEROctetString;
import com.kingdee.bos.ctrl.cipher.asn1.DERPrintableString;
import com.kingdee.bos.ctrl.cipher.asn1.DERSequence;
import com.kingdee.bos.ctrl.cipher.asn1.DERSet;
import com.kingdee.bos.ctrl.cipher.asn1.DERT61String;
import com.kingdee.bos.ctrl.cipher.asn1.DERTaggedObject;
import com.kingdee.bos.ctrl.cipher.asn1.DERUTCTime;
import com.kingdee.bos.ctrl.cipher.asn1.DERUTF8String;
import com.kingdee.bos.ctrl.cipher.asn1.DERUnknownTag;
import com.kingdee.bos.ctrl.cipher.asn1.DERVisibleString;
import com.kingdee.bos.ctrl.cipher.util.encoders.Hex;
import java.io.IOException;
import java.util.Enumeration;

public class ASN1Dump {
    private static final String TAB = "    ";
    private static final int SAMPLE_SIZE = 32;

    static String _dumpAsString(String indent, boolean verbose, DERObject obj) {
        String nl = System.getProperty("line.separator");
        if (obj instanceof ASN1Sequence) {
            StringBuffer buf = new StringBuffer();
            Enumeration e = ((ASN1Sequence)obj).getObjects();
            String tab = indent + TAB;
            buf.append(indent);
            if (obj instanceof BERConstructedSequence) {
                buf.append("BER ConstructedSequence");
            } else if (obj instanceof DERConstructedSequence) {
                buf.append("DER ConstructedSequence");
            } else if (obj instanceof BERSequence) {
                buf.append("BER Sequence");
            } else if (obj instanceof DERSequence) {
                buf.append("DER Sequence");
            } else {
                buf.append("Sequence");
            }
            buf.append(nl);
            while (e.hasMoreElements()) {
                Object o = e.nextElement();
                if (o == null || o.equals(new DERNull())) {
                    buf.append(tab);
                    buf.append("NULL");
                    buf.append(nl);
                    continue;
                }
                if (o instanceof DERObject) {
                    buf.append(ASN1Dump._dumpAsString(tab, verbose, (DERObject)o));
                    continue;
                }
                buf.append(ASN1Dump._dumpAsString(tab, verbose, ((DEREncodable)o).getDERObject()));
            }
            return buf.toString();
        }
        if (obj instanceof DERTaggedObject) {
            StringBuffer buf = new StringBuffer();
            String tab = indent + TAB;
            buf.append(indent);
            if (obj instanceof BERTaggedObject) {
                buf.append("BER Tagged [");
            } else {
                buf.append("Tagged [");
            }
            DERTaggedObject o = (DERTaggedObject)obj;
            buf.append(Integer.toString(o.getTagNo()));
            buf.append(']');
            if (!o.isExplicit()) {
                buf.append(" IMPLICIT ");
            }
            buf.append(nl);
            if (o.isEmpty()) {
                buf.append(tab);
                buf.append("EMPTY");
                buf.append(nl);
            } else {
                buf.append(ASN1Dump._dumpAsString(tab, verbose, o.getObject()));
            }
            return buf.toString();
        }
        if (obj instanceof DERConstructedSet) {
            StringBuffer buf = new StringBuffer();
            Enumeration e = ((ASN1Set)obj).getObjects();
            String tab = indent + TAB;
            buf.append(indent);
            buf.append("ConstructedSet");
            buf.append(nl);
            while (e.hasMoreElements()) {
                Object o = e.nextElement();
                if (o == null) {
                    buf.append(tab);
                    buf.append("NULL");
                    buf.append(nl);
                    continue;
                }
                if (o instanceof DERObject) {
                    buf.append(ASN1Dump._dumpAsString(tab, verbose, (DERObject)o));
                    continue;
                }
                buf.append(ASN1Dump._dumpAsString(tab, verbose, ((DEREncodable)o).getDERObject()));
            }
            return buf.toString();
        }
        if (obj instanceof BERSet) {
            StringBuffer buf = new StringBuffer();
            Enumeration e = ((ASN1Set)obj).getObjects();
            String tab = indent + TAB;
            buf.append(indent);
            buf.append("BER Set");
            buf.append(nl);
            while (e.hasMoreElements()) {
                Object o = e.nextElement();
                if (o == null) {
                    buf.append(tab);
                    buf.append("NULL");
                    buf.append(nl);
                    continue;
                }
                if (o instanceof DERObject) {
                    buf.append(ASN1Dump._dumpAsString(tab, verbose, (DERObject)o));
                    continue;
                }
                buf.append(ASN1Dump._dumpAsString(tab, verbose, ((DEREncodable)o).getDERObject()));
            }
            return buf.toString();
        }
        if (obj instanceof DERSet) {
            StringBuffer buf = new StringBuffer();
            Enumeration e = ((ASN1Set)obj).getObjects();
            String tab = indent + TAB;
            buf.append(indent);
            buf.append("DER Set");
            buf.append(nl);
            while (e.hasMoreElements()) {
                Object o = e.nextElement();
                if (o == null) {
                    buf.append(tab);
                    buf.append("NULL");
                    buf.append(nl);
                    continue;
                }
                if (o instanceof DERObject) {
                    buf.append(ASN1Dump._dumpAsString(tab, verbose, (DERObject)o));
                    continue;
                }
                buf.append(ASN1Dump._dumpAsString(tab, verbose, ((DEREncodable)o).getDERObject()));
            }
            return buf.toString();
        }
        if (obj instanceof DERObjectIdentifier) {
            return indent + "ObjectIdentifier(" + ((DERObjectIdentifier)obj).getId() + ")" + nl;
        }
        if (obj instanceof DERBoolean) {
            return indent + "Boolean(" + ((DERBoolean)obj).isTrue() + ")" + nl;
        }
        if (obj instanceof DERInteger) {
            return indent + "Integer(" + ((DERInteger)obj).getValue() + ")" + nl;
        }
        if (obj instanceof BERConstructedOctetString) {
            ASN1OctetString oct = (ASN1OctetString)obj;
            if (verbose) {
                return indent + "BER Constructed Octet String[" + oct.getOctets().length + "] " + ASN1Dump.dumpBinaryDataAsString(indent, oct.getOctets()) + nl;
            }
            return indent + "BER Constructed Octet String[" + oct.getOctets().length + "] " + nl;
        }
        if (obj instanceof DEROctetString) {
            ASN1OctetString oct = (ASN1OctetString)obj;
            if (verbose) {
                return indent + "DER Octet String[" + oct.getOctets().length + "] " + ASN1Dump.dumpBinaryDataAsString(indent, oct.getOctets()) + nl;
            }
            return indent + "DER Octet String[" + oct.getOctets().length + "] " + nl;
        }
        if (obj instanceof DERBitString) {
            DERBitString bt = (DERBitString)obj;
            if (verbose) {
                return indent + "DER Bit String[" + bt.getBytes().length + ", " + bt.getPadBits() + "] " + ASN1Dump.dumpBinaryDataAsString(indent, bt.getBytes()) + nl;
            }
            return indent + "DER Bit String[" + bt.getBytes().length + ", " + bt.getPadBits() + "] " + nl;
        }
        if (obj instanceof DERIA5String) {
            return indent + "IA5String(" + ((DERIA5String)obj).getString() + ") " + nl;
        }
        if (obj instanceof DERUTF8String) {
            return indent + "UTF8String(" + ((DERUTF8String)obj).getString() + ") " + nl;
        }
        if (obj instanceof DERPrintableString) {
            return indent + "PrintableString(" + ((DERPrintableString)obj).getString() + ") " + nl;
        }
        if (obj instanceof DERVisibleString) {
            return indent + "VisibleString(" + ((DERVisibleString)obj).getString() + ") " + nl;
        }
        if (obj instanceof DERBMPString) {
            return indent + "BMPString(" + ((DERBMPString)obj).getString() + ") " + nl;
        }
        if (obj instanceof DERT61String) {
            return indent + "T61String(" + ((DERT61String)obj).getString() + ") " + nl;
        }
        if (obj instanceof DERUTCTime) {
            return indent + "UTCTime(" + ((DERUTCTime)obj).getTime() + ") " + nl;
        }
        if (obj instanceof DERGeneralizedTime) {
            return indent + "GeneralizedTime(" + ((DERGeneralizedTime)obj).getTime() + ") " + nl;
        }
        if (obj instanceof DERUnknownTag) {
            return indent + "Unknown " + Integer.toString(((DERUnknownTag)obj).getTag(), 16) + " " + new String(Hex.encode(((DERUnknownTag)obj).getData())) + nl;
        }
        if (obj instanceof BERApplicationSpecific) {
            return ASN1Dump.outputApplicationSpecific("BER", indent, verbose, obj, nl);
        }
        if (obj instanceof DERApplicationSpecific) {
            return ASN1Dump.outputApplicationSpecific("DER", indent, verbose, obj, nl);
        }
        return indent + obj.toString() + nl;
    }

    private static String outputApplicationSpecific(String type, String indent, boolean verbose, DERObject obj, String nl) {
        DERApplicationSpecific app = (DERApplicationSpecific)obj;
        StringBuffer buf = new StringBuffer();
        if (app.isConstructed()) {
            try {
                ASN1Sequence s = ASN1Sequence.getInstance(app.getObject(16));
                buf.append(indent + type + " ApplicationSpecific[" + app.getApplicationTag() + "]" + nl);
                Enumeration e = s.getObjects();
                while (e.hasMoreElements()) {
                    buf.append(ASN1Dump._dumpAsString(indent + TAB, verbose, (DERObject)e.nextElement()));
                }
            }
            catch (IOException e) {
                buf.append(e);
            }
            return buf.toString();
        }
        return indent + type + " ApplicationSpecific[" + app.getApplicationTag() + "] (" + new String(Hex.encode(app.getContents())) + ")" + nl;
    }

    public static String dumpAsString(Object obj) {
        return ASN1Dump.dumpAsString(obj, false);
    }

    public static String dumpAsString(Object obj, boolean verbose) {
        if (obj instanceof DERObject) {
            return ASN1Dump._dumpAsString("", verbose, (DERObject)obj);
        }
        if (obj instanceof DEREncodable) {
            return ASN1Dump._dumpAsString("", verbose, ((DEREncodable)obj).getDERObject());
        }
        return "unknown object type " + obj.toString();
    }

    private static String dumpBinaryDataAsString(String indent, byte[] bytes) {
        String nl = System.getProperty("line.separator");
        StringBuffer buf = new StringBuffer();
        indent = indent + TAB;
        buf.append(nl);
        for (int i = 0; i < bytes.length; i += 32) {
            if (bytes.length - i > 32) {
                buf.append(indent);
                buf.append(new String(Hex.encode(bytes, i, 32)));
                buf.append(TAB);
                buf.append(ASN1Dump.calculateAscString(bytes, i, 32));
                buf.append(nl);
                continue;
            }
            buf.append(indent);
            buf.append(new String(Hex.encode(bytes, i, bytes.length - i)));
            for (int j = bytes.length - i; j != 32; ++j) {
                buf.append("  ");
            }
            buf.append(TAB);
            buf.append(ASN1Dump.calculateAscString(bytes, i, bytes.length - i));
            buf.append(nl);
        }
        return buf.toString();
    }

    private static String calculateAscString(byte[] bytes, int off, int len) {
        StringBuffer buf = new StringBuffer();
        for (int i = off; i != off + len; ++i) {
            if (bytes[i] < 32 || bytes[i] > 126) continue;
            buf.append((char)bytes[i]);
        }
        return buf.toString();
    }
}

