/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.cipher.crypto.generators;

import com.kingdee.bos.ctrl.cipher.crypto.DataLengthException;
import com.kingdee.bos.ctrl.cipher.crypto.DerivationFunction;
import com.kingdee.bos.ctrl.cipher.crypto.DerivationParameters;
import com.kingdee.bos.ctrl.cipher.crypto.Digest;
import com.kingdee.bos.ctrl.cipher.crypto.params.ISO18033KDFParameters;
import com.kingdee.bos.ctrl.cipher.crypto.params.KDFParameters;

public class BaseKDFBytesGenerator
implements DerivationFunction {
    private int counterStart;
    private Digest digest;
    private byte[] shared;
    private byte[] iv;

    protected BaseKDFBytesGenerator(int counterStart, Digest digest) {
        this.counterStart = counterStart;
        this.digest = digest;
    }

    @Override
    public void init(DerivationParameters param) {
        if (param instanceof KDFParameters) {
            KDFParameters p = (KDFParameters)param;
            this.shared = p.getSharedSecret();
            this.iv = p.getIV();
        } else if (param instanceof ISO18033KDFParameters) {
            ISO18033KDFParameters p = (ISO18033KDFParameters)param;
            this.shared = p.getSeed();
            this.iv = null;
        } else {
            throw new IllegalArgumentException("KDF parameters required for KDF2Generator");
        }
    }

    @Override
    public Digest getDigest() {
        return this.digest;
    }

    @Override
    public int generateBytes(byte[] out, int outOff, int len) throws DataLengthException, IllegalArgumentException {
        if (out.length - len < outOff) {
            throw new DataLengthException("output buffer too small");
        }
        long oBytes = len;
        int outLen = this.digest.getDigestSize();
        if (oBytes > 0x1FFFFFFFFL) {
            throw new IllegalArgumentException("Output length too large");
        }
        int cThreshold = (int)((oBytes + (long)outLen - 1L) / (long)outLen);
        byte[] dig = null;
        dig = new byte[this.digest.getDigestSize()];
        int counter = this.counterStart;
        for (int i = 0; i < cThreshold; ++i) {
            this.digest.update(this.shared, 0, this.shared.length);
            this.digest.update((byte)(counter >> 24));
            this.digest.update((byte)(counter >> 16));
            this.digest.update((byte)(counter >> 8));
            this.digest.update((byte)counter);
            if (this.iv != null) {
                this.digest.update(this.iv, 0, this.iv.length);
            }
            this.digest.doFinal(dig, 0);
            if (len > outLen) {
                System.arraycopy(dig, 0, out, outOff, outLen);
                outOff += outLen;
                len -= outLen;
            } else {
                System.arraycopy(dig, 0, out, outOff, len);
            }
            ++counter;
        }
        this.digest.reset();
        return len;
    }
}

