/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.cipher.util.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class Streams {
    private static int BUFFER_SIZE = 512;

    public static void drain(InputStream inStr) throws IOException {
        byte[] bs = new byte[BUFFER_SIZE];
        while (inStr.read(bs, 0, bs.length) >= 0) {
        }
    }

    public static byte[] readAll(InputStream inStr) throws IOException {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        Streams.pipeAll(inStr, buf);
        return buf.toByteArray();
    }

    public static int readFully(InputStream inStr, byte[] buf) throws IOException {
        return Streams.readFully(inStr, buf, 0, buf.length);
    }

    public static int readFully(InputStream inStr, byte[] buf, int off, int len) throws IOException {
        int totalRead;
        int numRead;
        for (totalRead = 0; totalRead < len && (numRead = inStr.read(buf, off + totalRead, len - totalRead)) >= 0; totalRead += numRead) {
        }
        return totalRead;
    }

    public static void pipeAll(InputStream inStr, OutputStream outStr) throws IOException {
        int numRead;
        byte[] bs = new byte[BUFFER_SIZE];
        while ((numRead = inStr.read(bs, 0, bs.length)) >= 0) {
            outStr.write(bs, 0, numRead);
        }
    }
}

