/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.ext.pe.beans.editor;

import com.kingdee.bos.ctrl.ext.pe.beans.editor.AbstractPropertyEditor;
import java.awt.Component;
import javax.swing.JFormattedTextField;
import javax.swing.UIManager;

public class PrimitiveNumberPropertyEditor
extends AbstractPropertyEditor {
    private JFormattedTextField editor;
    private final Class type;
    private Object lastGoodValue;

    public PrimitiveNumberPropertyEditor(Class type) {
        if (!Number.class.isAssignableFrom(type)) {
            throw new IllegalArgumentException("type must be a subclass of Number");
        }
        this.editor = new JFormattedTextField();
        this.type = type;
        this.editor.setValue(this.getDefaultValue());
    }

    @Override
    public Component getCustomEditor() {
        return this.editor;
    }

    protected Object getNumberByText() {
        String text = this.editor.getText();
        if (text == null || text.trim().length() == 0) {
            return this.getDefaultValue();
        }
        text = text.replace(',', '.');
        StringBuffer number = new StringBuffer();
        number.ensureCapacity(text.length());
        int c = text.length();
        for (int i = 0; i < c; ++i) {
            char character = text.charAt(i);
            if ('.' == character || '-' == character || Double.class.equals((Object)this.type) && 'E' == character || Float.class.equals((Object)this.type) && 'E' == character || Character.isDigit(character)) {
                number.append(character);
                continue;
            }
            if (' ' != character) break;
        }
        try {
            this.lastGoodValue = this.type.getConstructor(String.class).newInstance(number.toString());
        }
        catch (Exception e) {
            UIManager.getLookAndFeel().provideErrorFeedback(this.editor);
        }
        return this.lastGoodValue;
    }

    private Object getDefaultValue() {
        try {
            return this.type.getConstructor(String.class).newInstance("0");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setValue(Object value) {
        if (value != null) {
            if (!value.getClass().isAssignableFrom(this.type)) {
                value = this.getDefaultValue();
            }
            this.editor.setText(value.toString());
        } else {
            this.editor.setText("");
        }
        this.lastGoodValue = value;
    }

    @Override
    public Object getValue() {
        return this.getNumberByText();
    }
}

