/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.ext.ui.wizards.chart.extend.pattern;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.common.util.xml.XmlUtil;
import com.kingdee.bos.ctrl.ext.ui.wizards.chart.extend.pattern.ComponentDes;
import com.kingdee.bos.ctrl.ext.ui.wizards.chart.extend.pattern.NumberFormatTemplateEditor;
import com.kingdee.bos.ctrl.ext.ui.wizards.chart.extend.pattern.NumberFormatVFPair;
import com.kingdee.bos.ctrl.ext.util.MessageUtil;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDRadioButton;
import com.kingdee.bos.ctrl.swing.KDSeparator;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ctrl.swing.KDTextField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdom2.Element;

class FormatEditor
extends KDDialog {
    private KDRadioButton radioNumber = new KDRadioButton("\u6570\u503c");
    private KDRadioButton radioPercent = new KDRadioButton("\u767e\u5206\u6570");
    private KDPanel panel;
    private KDPanel panel1;
    private NumberFormatVFPair _value;
    private ArrayList _compsDes;
    private KDTextField _display;
    private static HashMap nameMap = new HashMap();
    private List<KDLabelContainer> list = new ArrayList<KDLabelContainer>();

    FormatEditor(Component parent, NumberFormatVFPair value) {
        super((Dialog)((KDDialog)SwingUtilities.getWindowAncestor(parent)));
        this.setTitle("\u8bbe\u7f6e\u56fe\u8868\u6570\u503c\u683c\u5f0f");
        this.setDefaultCloseOperation(2);
        this.setModal(true);
        this.setResizable(false);
        this._value = value;
        this._compsDes = new ArrayList();
        this.radioNumber.setSelected(true);
        this.parseXML();
    }

    public void parseXML(NumberFormatVFPair value) {
        this._value = value;
        this.parseXML();
    }

    public void parseXML() {
        try {
            if (StringUtil.isEmptyString((String)this._value.getXmlValue())) {
                this._value.setXmlValue(NumberFormatTemplateEditor.getCommonFormatXML());
            }
            Element root = XmlUtil.loadXmlBytes((byte[])this._value.getXmlValue().getBytes("UTF-8"));
            List contents = root.getContent();
            this._compsDes.clear();
            for (int i = 0; i < contents.size(); ++i) {
                Element ele;
                Object next = contents.get(i);
                if (!(next instanceof Element) || (ele = (Element)next).getName().equals("formatNumberScale")) continue;
                String type = ele.getAttributeValue("type");
                String value = ele.getAttributeValue("value");
                KDSpinner comp = null;
                if ("Integer".equals(type)) {
                    comp = new KDSpinner();
                    ((SpinnerNumberModel)comp.getModel()).setMinimum(new Integer(0));
                    ((SpinnerNumberModel)comp.getModel()).setStepSize(new Integer(1));
                    ((SpinnerNumberModel)comp.getModel()).setValue(Integer.valueOf(value));
                    comp.setNullable(false);
                } else if ("Boolean".equals(type)) {
                    comp = new KDCheckBox();
                    ((KDCheckBox)comp).setSelected(Boolean.parseBoolean(value));
                } else if ("String".equals(type)) {
                    comp = new KDTextField();
                    ((KDTextField)comp).setText(value);
                    if ("numberSuffix".equals(ele.getName()) && this.radioPercent.isSelected()) {
                        ((KDTextField)comp).setText(value.substring(1));
                    }
                } else if (ele.getName().equals("percent")) {
                    if ("false".equals(value)) {
                        this.radioPercent.setSelected(false);
                        this.radioNumber.setSelected(true);
                        continue;
                    }
                    if (!"true".equals(value)) continue;
                    this.radioNumber.setSelected(false);
                    this.radioPercent.setSelected(true);
                    continue;
                }
                ComponentDes des = new ComponentDes((JComponent)comp);
                des.id = ele.getName();
                des.type = type;
                des.name = (String)nameMap.get(des.id);
                des.value = value;
                this._compsDes.add(des);
            }
            this.initComponents();
            this.applayPattern();
            this.setVisible(true);
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            MessageUtil.msgboxInfo((Component)this.getParent(), "\u521d\u59cb\u5316\u6570\u503c\u683c\u5f0f\u65b9\u6848\u51fa\u9519\uff01\u5c06\u4ee5\u9ed8\u8ba4\u65b9\u6848\u8fdb\u884c\u521d\u59cb\u5316\uff01", sw.toString());
            this._value.setXmlValue(NumberFormatTemplateEditor.getCommonFormatXML());
        }
    }

    private void initComponents() {
        KDLabelContainer lc;
        final Container c = this.getContentPane();
        c.removeAll();
        c.setLayout(null);
        int height = 10;
        ButtonGroup btnGroup = new ButtonGroup();
        this.radioNumber.setBounds(18, 120, 50, 20);
        this.radioPercent.setBounds(73, 120, 60, 20);
        this.panel = new KDPanel();
        this.panel.setBorder((Border)BorderFactory.createTitledBorder(""));
        this.panel.setBounds(10, 140, 308, 115);
        this.panel.setLayout(null);
        c.add((Component)this.panel);
        this.panel1 = new KDPanel();
        this.panel1.setBorder((Border)BorderFactory.createTitledBorder(""));
        this.panel1.setBounds(10, 140, 308, 115);
        this.panel1.setLayout(null);
        this.radioNumber.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1 && FormatEditor.this.radioNumber.isSelected()) {
                    FormatEditor.this.panel1.remove((Component)FormatEditor.this.list.get(4));
                    c.remove((Component)FormatEditor.this.panel1);
                    FormatEditor.this.panel.add((Component)FormatEditor.this.list.get(4));
                    c.add((Component)FormatEditor.this.panel);
                    c.validate();
                    c.repaint();
                    FormatEditor.this.applayPattern();
                }
            }
        });
        this.radioPercent.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1 && FormatEditor.this.radioPercent.isSelected()) {
                    FormatEditor.this.panel.remove((Component)FormatEditor.this.list.get(4));
                    c.remove((Component)FormatEditor.this.panel);
                    FormatEditor.this.panel1.add((Component)FormatEditor.this.list.get(4));
                    c.add((Component)FormatEditor.this.panel1);
                    c.validate();
                    c.repaint();
                    FormatEditor.this.applayPattern();
                }
            }
        });
        btnGroup.add((AbstractButton)this.radioNumber);
        btnGroup.add((AbstractButton)this.radioPercent);
        c.add((Component)this.radioNumber);
        c.add((Component)this.radioPercent);
        int i = 1;
        for (ComponentDes des : this._compsDes) {
            lc = new KDLabelContainer(des.name, des.editor);
            this.list.add(lc);
            if ("Integer".equals(des.type)) {
                ((KDSpinner)des.editor).getModel().addChangeListener(new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent e) {
                        FormatEditor.this.applayPattern();
                    }
                });
            } else if ("Boolean".equals(des.type)) {
                ((KDCheckBox)des.editor).addChangeListener(new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent e) {
                        FormatEditor.this.applayPattern();
                    }
                });
            } else if ("String".equals(des.type)) {
                ((KDTextField)des.editor).addFocusListener((FocusListener)new FocusAdapter(){

                    @Override
                    public void focusLost(FocusEvent e) {
                        FormatEditor.this.applayPattern();
                    }
                });
            }
            lc.setBoundLabelUnderline(true);
            lc.setBoundLabelLength(110);
            if (i <= 4) {
                lc.setBounds(18, height, 290, 20);
                height += 25;
                c.add((Component)lc);
            } else {
                lc.setBounds(8, height - 100, 290, 20);
                height += 25;
                this.panel.add((Component)lc);
            }
            ++i;
        }
        this.list.get(6).getBoundEditor().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                KDCheckBox k = (KDCheckBox)e.getSource();
                if (k.isSelected()) {
                    FormatEditor.this.panel.add((Component)FormatEditor.this.list.get(7));
                    FormatEditor.this.panel.repaint();
                } else {
                    FormatEditor.this.panel.remove((Component)FormatEditor.this.list.get(7));
                    FormatEditor.this.panel.repaint();
                }
            }
        });
        if (this.radioPercent.isSelected()) {
            this.panel.remove((Component)this.list.get(4));
            c.remove((Component)this.panel);
            this.panel1.add((Component)this.list.get(4));
            c.add((Component)this.panel1);
            c.validate();
            c.repaint();
        }
        this._display = new KDTextField();
        this._display.setEnabled(false);
        lc = new KDLabelContainer("\u683c\u5f0f\u5316\u6570\u503c", (JComponent)this._display);
        lc.setBoundLabelLength(110);
        lc.setBounds(18, 260, 290, 20);
        lc.setBoundLabelUnderline(true);
        c.add((Component)lc);
        KDSeparator sep = new KDSeparator();
        sep.setBounds(0, 295, 340, 360);
        c.add((Component)sep);
        KDButton confirm = new KDButton("\u786e\u5b9a");
        confirm.setBounds(165, 305, 40, 20);
        c.add((Component)confirm);
        confirm.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FormatEditor.this._value.setXmlValue(FormatEditor.this.serializeToXML().getXmlValue());
                FormatEditor.this.dispose();
            }
        });
        KDButton cancle = new KDButton("\u53d6\u6d88");
        cancle.setBounds(245, 305, 40, 20);
        c.add((Component)cancle);
        cancle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FormatEditor.this.dispose();
            }
        });
        this.setSize(340, 370);
        this.setLocationRelativeTo(null);
    }

    public NumberFormatVFPair serializeToXML() {
        NumberFormatVFPair nfvp = new NumberFormatVFPair(this._value.getBean(), null);
        StringBuilder sb = new StringBuilder("<template>");
        if (this.radioPercent.isSelected()) {
            sb.append("<percent value='true' />");
        } else if (this.radioNumber.isSelected()) {
            sb.append("<percent value='false' />");
        }
        for (ComponentDes des : this._compsDes) {
            sb.append("<");
            sb.append(des.id);
            sb.append(" type='");
            sb.append(des.type);
            String value = des.getValue();
            if ("numberSuffix".equals(des.id) && this.radioPercent.isSelected()) {
                value = "%" + value;
            }
            if (!StringUtil.isEmptyString((String)value)) {
                sb.append("' value='");
                sb.append(value);
            }
            sb.append("' />");
        }
        sb.append("</template>");
        nfvp.setXmlValue(sb.toString());
        return nfvp;
    }

    private void applayPattern() {
        String value = "12345.6789";
        String formatXml = this.serializeToXML().getXmlValue();
        try {
            value = NumberFormatTemplateEditor.applayPattern(value, formatXml);
        }
        catch (Exception e) {
            this._display.setText("\u83b7\u53d6\u683c\u5f0f\u5316\u4e32\u5931\u8d25,\u65e0\u6cd5\u5f97\u5230\u6b63\u786e\u7684\u683c\u5f0f\u5316\u7ed3\u679c!");
            e.printStackTrace();
        }
        this._display.setText(value);
    }

    static {
        nameMap.put("forceDecimals", "\u7f3a\u4f4d\u8865\u96f6");
        nameMap.put("numberPrefix", "\u6570\u503c\u524d\u7f00");
        nameMap.put("numberSuffix", "\u6570\u503c\u540e\u7f00");
        nameMap.put("sNumberSuffix", "\u53f3Y\u8f74\u7cfb\u5217\u6570\u503c\u540e\u7f00");
        nameMap.put("decimals", "\u5c0f\u6570\u4f4d\u6570");
        nameMap.put("decimalSeparator", "\u5c0f\u6570\u70b9\u5b57\u7b26");
        nameMap.put("formatNumber", "\u542f\u7528\u5343\u5206\u4f4d\u5206\u9694\u7b26");
        nameMap.put("thousandSeparator", "\u5343\u5206\u4f4d\u5b57\u7b26");
        nameMap.put("formatNumberScale", "\u81ea\u52a8\u6dfb\u52a0K,M\u5355\u4f4d");
    }
}

