/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.ext.ui.wizards.convenientkeys;

import com.kingdee.bos.ctrl.ext.ui.wizards.convenientkeys.ConvenientKeysWizzard;
import com.kingdee.bos.ctrl.ext.ui.wizards.convenientkeys.ExtConvenientKeysSync;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.kds.impl.SpreadContext;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.KeyStroke;

public class ConvenientKeysUtil {
    static HashMap styleMap;
    static HashMap wizzardMap;
    static HashMap viewMap;
    static ExtConvenientKeysSync sync;
    static final int STYLE_MAP = 0;
    static final int WIZZARD_MAP = 1;
    static final int VIEW_MAP = 2;
    static ConvenientKeysWizzard wizzard;

    private static void initActionNameMap() {
        if (styleMap != null) {
            return;
        }
        styleMap = new HashMap();
        wizzardMap = new HashMap();
        viewMap = new HashMap();
        styleMap.put("Font_Bold", "\u7c97\u4f53");
        styleMap.put("Font_Italic", "\u659c\u4f53");
        styleMap.put("Font_UnderLine", "\u4e0b\u5212\u7ebf");
        styleMap.put("Alignment_Center", "\u5c45\u4e2d");
        styleMap.put("Alignment_Left", "\u5de6\u5bf9\u9f50");
        styleMap.put("Alignment_Right", "\u53f3\u5bf9\u9f50");
        wizzardMap.put("Redo", "\u64a4\u9500");
        wizzardMap.put("Undo", "\u91cd\u505a");
        wizzardMap.put("Sort_Ascending", "\u5347\u5e8f\u6392\u5217");
        wizzardMap.put("Sort_Descending", "\u964d\u5e8f\u6392\u5217");
        wizzardMap.put("Freeze", "\u51bb\u7ed3");
        wizzardMap.put("Unfreeze", "\u53d6\u6d88\u51bb\u7ed3");
        wizzardMap.put("inner_CancelEditing", "\u53d6\u6d88\u7f16\u8f91");
        wizzardMap.put("inner_StopEditing", "\u505c\u6b62\u7f16\u8f91");
        viewMap.put("JUMP_DOWN_DATA_CELL", "\u7126\u70b9\u4e0b\u79fb");
        viewMap.put("JUMP_UP_DATA_CELL", "\u7126\u70b9\u4e0a\u79fb");
        viewMap.put("JUMP_RIGHT_DATA_CELL", "\u7126\u70b9\u53f3\u79fb");
        viewMap.put("JUMP_LEFT_DATA_CELL", "\u7126\u70b9\u5de6\u79fb");
        viewMap.put("JUMP_DOWN_CELL", "\u4e0b\u79fb\u4e00\u683c");
        viewMap.put("JUMP_UP_CELL", "\u4e0a\u79fb\u4e00\u683c");
        viewMap.put("JUMP_RIGHT_CELL", "\u53f3\u79fb\u4e00\u683c");
        viewMap.put("JUMP_LEFT_CELL", "\u5de6\u79fb\u4e00\u683c");
        wizzardMap.put("JUMP_ACTIVE_CELL_DOWN", "\u5411\u4e0b\u8fed\u4ee3");
        wizzardMap.put("JUMP_ACTIVE_CELL_UP", "\u5411\u4e0a\u8fed\u4ee3");
        wizzardMap.put("JUMP_ACTIVE_CELL_RIGHT", "\u5411\u53f3\u8fed\u4ee3");
        wizzardMap.put("JUMP_ACTIVE_CELL_LEFT", "\u5411\u5de6\u8fed\u4ee3");
        viewMap.put("SELECTION_EXTEND_RIGHT", "\u5411\u53f3\u5ef6\u4f38");
        viewMap.put("SELECTION_EXTEND_LEFT", "\u5411\u5de6\u5ef6\u4f38");
        viewMap.put("SELECTION_EXTEND_UP", "\u5411\u4e0a\u5ef6\u4f38");
        viewMap.put("SELECTION_EXTEND_DOWN", "\u5411\u4e0b\u5ef6\u4f38");
        viewMap.put("SELECTION_EXTEND_RIGHT_DATA", "\u53f3\u5ef6\u5230\u6570\u636e");
        viewMap.put("SELECTION_EXTEND_LEFT_DATA", "\u5de6\u5ef6\u5230\u6570\u636e");
        viewMap.put("SELECTION_EXTEND_UP_DATA", "\u4e0a\u5ef6\u5230\u6570\u636e");
        viewMap.put("SELECTION_EXTEND_DOWN_DATA", "\u4e0b\u5ef6\u5230\u6570\u636e");
        viewMap.put("CHANGE_TO_NEXT_SHEET", "\u4e0b\u4e00\u5de5\u4f5c\u8868");
        viewMap.put("CHANGE_TO_LAST_SHEET", "\u4e0a\u4e00\u5de5\u4f5c\u8868");
        viewMap.put("JUMP_NEXT_PAGE", "\u5411\u4e0b\u7ffb\u9875");
        viewMap.put("JUMP_LAST_PAGE", "\u5411\u4e0a\u7ffb\u9875");
        viewMap.put("SELECTION_EXTEND_NEXT_PAGE", "\u5ef6\u4f38\u5411\u4e0b\u7ffb\u9875");
        viewMap.put("SELECTION_EXTEND_LAST_PAGE", "\u5ef6\u4f38\u5411\u4e0a\u7ffb\u9875");
        viewMap.put("JUMP_UP_LEFT_CELL", "\u8df3\u8f6c\u5230\u5de6\u4e0a");
        viewMap.put("JUMP_DOWN_RIGHT_CELL", "\u8df3\u8f6c\u5230\u53f3\u4e0b");
        viewMap.put("JUMP_HOME_CELL", "\u8df3\u8f6c\u5230\u5de6");
        viewMap.put("JUMP_END_CELL", "\u8df3\u8f6c\u5230\u53f3");
        viewMap.put("SELECTION_EXTEND_HOME_CELL", "\u5ef6\u4f38\u9009\u62e9\u5757:\u5de6");
        viewMap.put("SELECTION_EXTEND_END_CELL", "\u5ef6\u4f38\u9009\u62e9\u5feb:\u53f3");
        viewMap.put("SELECTION_EXTEND_UPLEFT_CELL", "\u5ef6\u4f38\u9009\u62e9\u5757:\u5de6\u4e0a");
        viewMap.put("SELECTION_EXTEND_DOWNRIGHT_CELL", "\u5ef6\u4f38\u9009\u62e9\u5757:\u53f3\u4e0b");
    }

    public static void initTable(SpreadContext context, KDTable table, int index) {
        ConvenientKeysUtil.initTableKeyListener(table);
        InputMap inputMap = context.getSpread().getInputMap(1);
        InputMap inputMap2 = context.getSpread().getInputMap();
        KeyStroke[] strokes = inputMap.allKeys();
        KeyStroke[] strokes2 = inputMap2.allKeys();
        ActionMap actionMap = context.getSpread().getActionMap();
        ConvenientKeysUtil.initActionNameMap();
        HashMap map = index == 0 ? styleMap : (index == 1 ? wizzardMap : viewMap);
        Set keySet = map.keySet();
        Iterator iter = keySet.iterator();
        while (iter.hasNext()) {
            int i;
            IRow row = table.addRow();
            ICell cell = row.getCell(0);
            Object temp = iter.next();
            cell.setValue(map.get(temp));
            cell.setUserObject(temp);
            cell = row.getCell(1);
            ConvenientKeysWizzard.CellContent content = new ConvenientKeysWizzard.CellContent();
            String value = null;
            for (i = 0; i < strokes.length; ++i) {
                if (!temp.equals(inputMap.get(strokes[i]))) continue;
                value = strokes[i].toString();
                break;
            }
            if (value == null) {
                for (i = 0; i < strokes2.length; ++i) {
                    if (!temp.equals(inputMap2.get(strokes2[i]))) continue;
                    value = strokes[i].toString();
                    break;
                }
            }
            if (value != null && actionMap.get(temp) == null) {
                value = null;
            }
            if (value != null) {
                content.isCtrl = (value = value.toLowerCase()).indexOf("ctrl") != -1;
                content.isAlt = value.indexOf("alt") != -1;
                content.isShift = value.indexOf("shift") != -1;
                content.key = value.substring(value.lastIndexOf(" "), value.length());
            }
            cell.setValue((Object)ConvenientKeysUtil.getFormatString(content));
            cell.setUserObject((Object)content);
        }
    }

    public static String getFormatString(ConvenientKeysWizzard.CellContent content) {
        String txt = "";
        if (content.isShift) {
            txt = txt + "Shift + ";
        }
        if (content.isCtrl) {
            txt = txt + "Ctrl + ";
        }
        if (content.isAlt) {
            txt = txt + "Alt + ";
        }
        txt = txt + (content.key == null ? "" : content.key);
        return txt;
    }

    private static void initTableKeyListener(final KDTable table) {
        table.getListeners(KeyListener.class);
        table.addKeyListener((KeyListener)new KeyAdapter(){
            KDTable refer;
            {
                this.refer = table;
            }

            @Override
            public void keyReleased(KeyEvent e) {
                IRow row = KDTableUtil.getSelectedRow((KDTable)this.refer);
                if (row == null) {
                    return;
                }
                ICell cell = row.getCell(1);
                ConvenientKeysWizzard.CellContent content = (ConvenientKeysWizzard.CellContent)cell.getUserObject();
                if (e.getKeyCode() == 17) {
                    content.isCtrl = !content.isCtrl;
                } else if (e.getKeyCode() == 18) {
                    content.isAlt = !content.isAlt;
                } else if (e.getKeyCode() == 16) {
                    content.isShift = !content.isShift;
                } else {
                    String keyText = KeyEvent.getKeyText(e.getKeyCode());
                    if (ConvenientKeysUtil.checkContainedKey(keyText, ConvenientKeysUtil.wizzard.keyComboLetter, content, 0) || ConvenientKeysUtil.checkContainedKey(keyText, ConvenientKeysUtil.wizzard.keyComboControl, content, 1) || ConvenientKeysUtil.checkContainedKey(keyText, ConvenientKeysUtil.wizzard.keyComboArrow, content, 2) || !ConvenientKeysUtil.checkContainedKey(keyText, ConvenientKeysUtil.wizzard.keyComboNumber, content, 3)) {
                        // empty if block
                    }
                }
                ConvenientKeysUtil.updateTableAndItems(cell, content);
                System.out.println("keyReleased" + KeyEvent.getKeyText(e.getKeyCode()));
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
    }

    private static boolean checkContainedKey(String keyText, KDComboBox box, ConvenientKeysWizzard.CellContent content, int comboIndex) {
        int index = box.getItemCount();
        for (int i = 0; i < index; ++i) {
            if (!keyText.equals(box.getItemAt(i))) continue;
            content.index = comboIndex;
            content.key = keyText.equals(content.key) ? "" : keyText;
            return true;
        }
        return false;
    }

    private static void updateTableAndItems(ICell cell, ConvenientKeysWizzard.CellContent content) {
        if (wizzard == null) {
            return;
        }
        String format = ConvenientKeysUtil.getFormatString(content);
        cell.setValue((Object)format);
        ConvenientKeysUtil.wizzard.altCheckBox.setSelected(content.isAlt);
        ConvenientKeysUtil.wizzard.ctrlCheckBox.setSelected(content.isCtrl);
        ConvenientKeysUtil.wizzard.shiftCheckBox.setSelected(content.isShift);
        if (content.index == 0) {
            ConvenientKeysUtil.wizzard.keyComboLetter.setSelectedItem((Object)content.key);
        } else if (content.index == 1) {
            ConvenientKeysUtil.wizzard.keyComboControl.setSelectedItem((Object)content.key);
        } else if (content.index == 2) {
            ConvenientKeysUtil.wizzard.keyComboArrow.setSelectedItem((Object)content.key);
        } else {
            ConvenientKeysUtil.wizzard.keyComboNumber.setSelectedItem((Object)content.key);
        }
    }

    public static void syncTable(KDTable table) {
        if (sync == null) {
            sync = new ExtConvenientKeysSync(table);
        }
        sync.sync();
    }
}

