/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.ext.ui.wizards.data;

import com.kingdee.bos.ctrl.common.LanguageManager;
import com.kingdee.bos.ctrl.common.layout.table2.TableLayout2;
import com.kingdee.bos.ctrl.common.ui.SimpleDialog;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.ext.IExtWizardManager;
import com.kingdee.bos.ctrl.ext.KDExt;
import com.kingdee.bos.ctrl.ext.immit.IExtCallback;
import com.kingdee.bos.ctrl.ext.ui.icons.ResourceManager;
import com.kingdee.bos.ctrl.ext.ui.wizards.data.inner.TextFileDatasetConfiger;
import com.kingdee.bos.ctrl.ext.ui.wizards.report.IWizardStep;
import com.kingdee.bos.ctrl.ext.ui.wizards.report.ReportComposerWizard;
import com.kingdee.bos.ctrl.ext.util.MessageUtil;
import com.kingdee.bos.ctrl.ext.util.MiscUtil;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.kds.expans.model.data.ExtColumn;
import com.kingdee.bos.ctrl.kds.expans.model.data.ExtDataSet;
import com.kingdee.bos.ctrl.kds.expans.model.data.ExtDataSetManager;
import com.kingdee.bos.ctrl.kds.expans.model.data.ExtDataSetType;
import com.kingdee.bos.ctrl.kds.expans.model.data.ExtDynamicDataSet;
import com.kingdee.bos.ctrl.kds.model.expr.Expr;
import com.kingdee.bos.ctrl.kds.model.expr.ExprParams;
import com.kingdee.bos.ctrl.kds.model.expr.IExprNode;
import com.kingdee.bos.ctrl.kds.model.struct.Book;
import com.kingdee.bos.ctrl.kds.model.struct.Dependents;
import com.kingdee.bos.ctrl.kds.model.struct.Sheet;
import com.kingdee.bos.ctrl.kds.model.struct.node.CellBlockNode;
import com.kingdee.bos.ctrl.kds.model.struct.node.NamedObjectNode;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.KDTreeView;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class DatasetImporter
extends KDPanel
implements IWizardStep {
    public static final String KEY_MSG_DS_ALIAS_EMPTY = "msg_ds_alias_empty";
    public static final String KEY_MSG_DS_ALIAS_CONFLICT1 = "msg_ds_alias_conflict1";
    public static final String KEY_MSG_DS_ALIAS_CONFLICT2 = "msg_ds_alias_conflict2";
    public static final String KEY_MSG_COL_ALIAS_EMPTY1 = "msg_col_alias_empty1";
    public static final String KEY_MSG_COL_ALIAS_EMPTY2 = "msg_col_alias_empty2";
    public static final String KEY_MSG_COL_ALIAS_CONFLICT1 = "msg_col_alias_conflict1";
    public static final String KEY_MSG_COL_ALIAS_CONFLICT2 = "msg_col_alias_conflict2";
    public static final String KEY_MSG_COL_ALIAS_CONFLICT3 = "msg_col_alias_conflict3";
    public static final String KEY_MSG_DS_COL_ALIAS_CONFLICT1 = "msg_ds_col_alias_conflict1";
    public static final String KEY_MSG_DS_COL_ALIAS_CONFLICT2 = "msg_ds_col_alias_conflict2";
    public static final String KEY_MSG_DS_COL_ALIAS_CONFLICT3 = "msg_ds_col_alias_conflict3";
    public static final String KEY_MSG_CONFLICT_PREFIX = "msg_conflict_prefix";
    public static final String KEY_MSG_TITLE = "msg_title";
    public static final String KEY_MSG_CONFIRM_DEL = "msg_confirm_del";
    public static final String KEY_MSG_COL_ALIAS_CONFLICT_WITH_NO1 = "msg_col_alias_conflict_with_no1";
    public static final String KEY_MSG_COL_ALIAS_CONFLICT_WITH_NO2 = "msg_col_alias_conflict_with_no2";
    public static final String KEY_MSG_COL_ALIAS_CONFLICT_WITH_NO3 = "msg_col_alias_conflict_with_no3";
    public static final String KEY_MSG_DS_ALIAS_CONFLICT_WITH_NO1 = "msg_ds_alias_conflict_with_no1";
    public static final String KEY_MSG_DS_ALIAS_CONFLICT_WITH_NO2 = "msg_ds_alias_conflict_with_no2";
    public static final String KEY_MSG_COL_ALIAS_CONFLICT_WITH_CELL1 = "msg_col_alias_conflict_with_cell1";
    public static final String KEY_MSG_COL_ALIAS_CONFLICT_WITH_CELL2 = "msg_col_alias_conflict_with_cell2";
    public static final String KEY_MSG_COL_ALIAS_CONFLICT_WITH_CELL3 = "msg_col_alias_conflict_with_cell3";
    public static final String KEY_MSG_DS_ALIAS_CONFLICT_WITH_CELL1 = "msg_ds_alias_conflict_with_cell1";
    public static final String KEY_MSG_DS_ALIAS_CONFLICT_WITH_CELL2 = "msg_ds_alias_conflict_with_cell2";
    public static final String KEY_MSG_COL_ALIAS_NOT_VALID1 = "msg_col_alias_not_valid1";
    public static final String KEY_MSG_COL_ALIAS_NOT_VALID2 = "msg_col_alias_not_valid2";
    public static final String KEY_MSG_COL_ALIAS_NOT_VALID3 = "msg_col_alias_not_valid3";
    public static final String KEY_MSG_DS_ALIAS_NOT_VALID1 = "msg_ds_alias_not_valid1";
    public static final String KEY_MSG_DS_ALIAS_NOT_VALID2 = "msg_ds_alias_not_valid2";
    public static final String KEY_TXT_DATASET = "txtDataset";
    public static final String KEY_SELECTED_DATASETS = "selectedDatasets";
    public static final String KEY_DS_REF_NAME = "dsRefName";
    public static final String KEY_DS_TYPE = "dsType";
    public static final String KEY_DS_PATH = "dsPath";
    public static final String KEY_COL_ALIAS_MODIFY = "colAliasModify";
    public static final String KEY_OK = "ok";
    public static final String KEY_CANCEL = "cancel";
    public static final String KEY_NAME = "name";
    public static final String KEY_ALIAS = "alias";
    private KDWorkButton refresh;
    private KDWorkButton edit;
    private KDWorkButton inline;
    private KDWorkButton del;
    private KDWorkButton add;
    private KDLabel jLabel1;
    private KDTable table;
    private KDTree tree;
    private KDCheckBox useTxtData;
    private KDExt _ext;
    private ReportComposerWizard.ReportTypeDispatcher stepOne;
    private Dialog dialog;
    private Map sawtoothMap = new HashMap();
    private SortedColumns sortedColumns = new SortedColumns();
    private List original;
    private List all;
    private KDFileChooser fileChooser;
    private TableChangeListener listener;
    private int borderValue = 10;
    private FileFilter filter = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            return pathname.isDirectory() || pathname.getName().toLowerCase(Locale.ENGLISH).endsWith(".txt");
        }

        @Override
        public String getDescription() {
            return TextFileDatasetConfiger.getLocalText("txtFile");
        }
    };

    public static String getLocalText(String key, String defaultStr) {
        return LanguageManager.getLangMessage((String)key, DatasetImporter.class, (String)defaultStr);
    }

    public DatasetImporter(KDExt ext) {
        this._ext = ext;
        this.initComponents();
        this.initListeners();
    }

    @Override
    public IWizardStep getNextStep() {
        return ((ReportComposerWizard)this._ext.getExtWizardManager().getWizard(IExtWizardManager.Wizard_ReportComposer)).getComposeStepOneByType();
    }

    @Override
    public IWizardStep getPrevStep() {
        if (this.stepOne == null) {
            this.stepOne = (ReportComposerWizard.ReportTypeDispatcher)((ReportComposerWizard)this._ext.getExtWizardManager().getWizard(IExtWizardManager.Wizard_ReportComposer)).getStepOne();
        }
        return this.stepOne;
    }

    public void addNotify() {
        super.addNotify();
        this.dialog = (Dialog)SwingUtilities.getWindowAncestor((Component)((Object)this));
    }

    @Override
    public boolean prepare() {
        if (this._ext.getExtCallback().isCloudView()) {
            this.inline.setEnabled(false);
        } else {
            this.inline.setEnabled(true);
        }
        if (this.original != null) {
            return true;
        }
        this.refreshTable();
        if (this.table.getRowCount() != 0) {
            this.table.getSelectManager().select(0, 0);
        } else {
            this.refreshTree();
        }
        return true;
    }

    public String[] getEditingInfo(ExtDataSet key) {
        return (String[])this.sawtoothMap.get(key);
    }

    private void refreshTable() {
        this.sawtoothMap.clear();
        this.sortedColumns.clear();
        this.table.removeRows();
        ExtDataSetManager dsm = MiscUtil.getActiveSpreadContext(this._ext).getBook().getDataSetManager();
        this.original = new ArrayList();
        this.all = new ArrayList();
        for (int i = dsm.size() - 1; i >= 0; --i) {
            ExtDataSet ds = dsm.getAt(i);
            if (ds instanceof ExtDynamicDataSet) continue;
            this.original.add(ds);
            this.all.add(ds);
            IRow row = this.table.addRow();
            row.getCell(0).setValue((Object)ds.getAlias());
            row.getCell(1).setValue((Object)ds.getDataSetType().getDisplayName());
            row.getCell(2).setValue((Object)this.getMeaningfulDefine(ds.getDefine()));
            row.setUserObject((Object)ds);
            this.sawtoothMap.put(ds, this.genSawtooth(ds));
        }
        dsm.removeAll();
    }

    private String getMeaningfulDefine(String define) {
        block4: {
            KDExt.IPathDefiner definer = this._ext.getPathDefiner();
            if (definer != null) {
                try {
                    return definer.defineName(define);
                }
                catch (Throwable th) {
                    if (!MiscUtil.shouldLog()) break block4;
                    MiscUtil.error(th.getMessage());
                }
            }
        }
        if (define.indexOf("InnerLink") > 0) {
            return define.replaceFirst("InnerLink", "\u5185\u5d4c\u6570\u636e\u96c6");
        }
        return define;
    }

    public void refreshTree() {
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.tree.getModel().getRoot();
        this.tree.removeAllChildrenFromParent((MutableTreeNode)root);
        int[] rows = KDTableUtil.getSelectedRows((KDTable)this.table);
        for (int i = 0; i < rows.length; ++i) {
            ExtDataSet ds = (ExtDataSet)this.table.getRow(rows[i]).getUserObject();
            DefaultKingdeeTreeNode node = new DefaultKingdeeTreeNode((Object)((String[])this.sawtoothMap.get(ds))[0]);
            node.setUserObject((Object)ds);
            this.tree.addNodeInto((MutableTreeNode)node, (MutableTreeNode)root);
            Object[] cols = this.sortedColumns.get(ds);
            int size = cols.length;
            for (int j = 0; j < size; ++j) {
                DefaultKingdeeTreeNode nnode = new DefaultKingdeeTreeNode((Object)this.getTreeNodeText(ds, j));
                nnode.setUserObject((Object)new Integer(j));
                nnode.setAllowsChildren(false);
                this.tree.addNodeInto((MutableTreeNode)nnode, (MutableTreeNode)node);
            }
            this.tree.expandAllNodes(true, (TreeNode)root);
        }
        if (this.listener != null) {
            if (rows.length == 0) {
                this.listener.tableChanged(true);
            } else {
                this.listener.tableChanged(false);
            }
        }
    }

    private String[] genSawtooth(ExtDataSet ds) {
        Object[] cols = this.sortedColumns.get(ds);
        int columnCount = cols.length;
        String[] sawtooth = new String[columnCount + 1];
        sawtooth[0] = ds.getAlias();
        for (int j = 1; j <= columnCount; ++j) {
            sawtooth[j] = ((ExtColumn)cols[j - 1]).getAlias();
        }
        return sawtooth;
    }

    public void commitEdit() {
        ExtDataSetManager dsm = MiscUtil.getActiveSpreadContext(this._ext).getBook().getDataSetManager();
        for (int i = 0; i < this.all.size(); ++i) {
            ExtDataSet ds = (ExtDataSet)this.all.get(i);
            String[] sawtooth = (String[])this.sawtoothMap.get(ds);
            ds.setAlias(sawtooth[0]);
            Object[] cols = this.sortedColumns.get(ds);
            for (int j = 1; j <= cols.length; ++j) {
                ((ExtColumn)cols[j - 1]).setAlias(sawtooth[j]);
            }
            dsm.addDataSet(ds);
        }
        this.original = null;
        this.all = null;
    }

    public void cancelEdit() {
        if (this.original == null) {
            return;
        }
        ExtDataSetManager dsm = MiscUtil.getActiveSpreadContext(this._ext).getBook().getDataSetManager();
        for (int i = 0; i < this.original.size(); ++i) {
            ExtDataSet ds = (ExtDataSet)this.original.get(i);
            dsm.addDataSet(ds);
        }
        this.original = null;
        this.all = null;
    }

    @Override
    public boolean checkValid() {
        int j;
        int i;
        String colAlias;
        String[] sawtooth;
        int i2;
        boolean valid = true;
        StringBuffer sb = new StringBuffer();
        HashSet<String> alias = new HashSet<String>();
        HashSet<String> colAliases = new HashSet<String>();
        int count = this.table.getRowCount();
        for (i2 = 0; i2 < count; ++i2) {
            sawtooth = (String[])this.sawtoothMap.get(this.table.getRow(i2).getUserObject());
            String datasetName = sawtooth[0];
            if (StringUtil.isEmptyString((String)datasetName)) {
                sb.append(DatasetImporter.getLocalText(KEY_MSG_DS_ALIAS_EMPTY, "\u5b58\u5728\u7a7a\u522b\u540d\u6570\u636e\u96c6\uff1b\n"));
                valid = false;
            } else if (!alias.add(datasetName)) {
                sb.append(DatasetImporter.getLocalText(KEY_MSG_DS_ALIAS_CONFLICT1, "\u6570\u636e\u96c6 {"));
                sb.append(datasetName);
                sb.append(DatasetImporter.getLocalText(KEY_MSG_DS_ALIAS_CONFLICT2, "} \u5b58\u5728\u522b\u540d\u51b2\u7a81\uff1b\n"));
                valid = false;
            }
            colAliases.clear();
            for (int j2 = 1; j2 < sawtooth.length; ++j2) {
                colAlias = sawtooth[j2];
                if (StringUtil.isEmptyString((String)colAlias)) {
                    sb.append(DatasetImporter.getLocalText(KEY_MSG_COL_ALIAS_EMPTY1, "\u6570\u636e\u96c6 {"));
                    sb.append(datasetName);
                    sb.append(DatasetImporter.getLocalText(KEY_MSG_COL_ALIAS_EMPTY2, "} \u5b58\u5728\u7a7a\u522b\u540d\u5217\uff1b\n"));
                    valid = false;
                    continue;
                }
                if (colAliases.add(colAlias)) continue;
                sb.append(DatasetImporter.getLocalText(KEY_MSG_COL_ALIAS_CONFLICT1, "\u6570\u636e\u96c6 {"));
                sb.append(datasetName);
                sb.append(DatasetImporter.getLocalText(KEY_MSG_COL_ALIAS_CONFLICT2, "} \u7684\u5217 {"));
                sb.append(sawtooth[j2]);
                sb.append(DatasetImporter.getLocalText(KEY_MSG_COL_ALIAS_CONFLICT3, "} \u5b58\u5728\u522b\u540d\u51b2\u7a81\uff1b\n"));
                valid = false;
            }
        }
        for (i2 = 0; i2 < count; ++i2) {
            sawtooth = (String[])this.sawtoothMap.get(this.table.getRow(i2).getUserObject());
            for (int j3 = 1; j3 < sawtooth.length; ++j3) {
                String colAlias2 = sawtooth[j3];
                if (!alias.contains(colAlias2)) continue;
                sb.append(DatasetImporter.getLocalText(KEY_MSG_DS_COL_ALIAS_CONFLICT1, "\u6570\u636e\u96c6 {"));
                sb.append(colAlias2);
                sb.append(DatasetImporter.getLocalText(KEY_MSG_DS_COL_ALIAS_CONFLICT2, "} \u548c\u5217 {"));
                sb.append(colAlias2);
                sb.append(DatasetImporter.getLocalText(KEY_MSG_DS_COL_ALIAS_CONFLICT3, "} \u5b58\u5728\u522b\u540d\u51b2\u7a81\uff1b\n"));
                valid = false;
            }
        }
        HashSet<String> exclusives = new HashSet<String>();
        for (i = 0; i < count; ++i) {
            String dsAlias = ((String[])this.sawtoothMap.get(this.table.getRow(i).getUserObject()))[0];
            if (StringUtil.isEmptyString((String)dsAlias) || !this.isNameExistent(dsAlias, sb, null)) continue;
            exclusives.add(dsAlias);
            valid = false;
        }
        for (i = 0; i < count; ++i) {
            String[] sawtooth2 = (String[])this.sawtoothMap.get(this.table.getRow(i).getUserObject());
            for (j = 1; j < sawtooth2.length; ++j) {
                colAlias = sawtooth2[j];
                if (StringUtil.isEmptyString((String)colAlias) || !this.isNameExistent(colAlias, sb, sawtooth2[0])) continue;
                exclusives.add(colAlias);
                valid = false;
            }
        }
        for (i = 0; i < count; ++i) {
            String dsAlias = ((String[])this.sawtoothMap.get(this.table.getRow(i).getUserObject()))[0];
            if (exclusives.contains(dsAlias) || StringUtil.isEmptyString((String)dsAlias) || this.isNamedValid(dsAlias, sb, null)) continue;
            valid = false;
        }
        for (i = 0; i < count; ++i) {
            String[] sawtooth3 = (String[])this.sawtoothMap.get(this.table.getRow(i).getUserObject());
            for (j = 1; j < sawtooth3.length; ++j) {
                colAlias = sawtooth3[j];
                if (!StringUtil.isEmptyString((String)colAlias) && colAlias.length() > 255) {
                    valid = false;
                    sb.append("\u522b\u540d\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7255\u4e2a\u5b57\u7b26\u3002");
                }
                if (exclusives.contains(colAlias) || StringUtil.isEmptyString((String)colAlias) || this.isNamedValid(colAlias, sb, sawtooth3[0])) continue;
                valid = false;
            }
        }
        if (this.all != null && this.all.size() > 0) {
            for (i = 0; i < this.all.size(); ++i) {
                ExtDataSet dataSet;
                int columnCount;
                Object object = this.all.get(i);
                if (!(object instanceof ExtDataSet) || (columnCount = (dataSet = (ExtDataSet)object).getColumnCount()) != 0) continue;
                sb.append("\u6570\u636e\u96c6{");
                sb.append(dataSet.getAlias());
                sb.append("}\u6ca1\u6709\u8f93\u51fa\u5b57\u6bb5\uff0c\u8bf7\u91cd\u65b0\u8bbe\u8ba1\u6570\u636e\u96c6.");
                valid = false;
            }
        }
        if (!valid) {
            this.showMessage(DatasetImporter.getLocalText(KEY_MSG_CONFLICT_PREFIX, "\u68c0\u6d4b\u65f6\u53d1\u73b0\u5982\u4e0b\u9519\u8bef\uff1a\n") + sb.toString());
        }
        return valid;
    }

    private void popAliasModifier() {
        TreePath tp = this.tree.getSelectionPath();
        if (tp == null) {
            return;
        }
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)tp.getLastPathComponent();
        Object obj = node.getUserObject();
        if (node.isLeaf() && obj instanceof Integer) {
            AliasModifier modifier = new AliasModifier();
            modifier.prepare((Integer)obj);
            modifier.showDialog(this.dialog);
        }
    }

    public List getAllExtDataSets() {
        return this.all;
    }

    public List getSelectedExtDataSets() {
        ArrayList<Object> list = new ArrayList<Object>();
        int[] rows = KDTableUtil.getSelectedRows((KDTable)this.table);
        for (int i = 0; i < rows.length; ++i) {
            list.add(this.table.getRow(rows[i]).getUserObject());
        }
        return list;
    }

    private void dealWithDataSetReplace(ExtDataSet newDs, ExtDataSet oldDs) {
        IRow row = this.table.getRow(this.table.getSelectManager().getActiveRowIndex());
        row.setUserObject((Object)newDs);
        this.sawtoothMap.put(newDs, this.genSawtooth(newDs));
        newDs.setAlias(oldDs.getAlias());
        Object[] newCols = this.sortedColumns.get(newDs);
        Object[] oldCols = this.sortedColumns.get(oldDs);
        String[] oldAliases = (String[])this.sawtoothMap.get(oldDs);
        String[] newAliases = (String[])this.sawtoothMap.get(newDs);
        newAliases[0] = oldAliases[0];
        row.getCell(0).setValue((Object)oldAliases[0]);
        row.getCell(1).setValue((Object)newDs.getDataSetType().getDisplayName());
        row.getCell(2).setValue((Object)this.getMeaningfulDefine(newDs.getDefine()));
        for (int i = 0; i < newCols.length; ++i) {
            for (int j = 0; j < oldCols.length; ++j) {
                ExtColumn newCol = (ExtColumn)newCols[i];
                ExtColumn oldCol = (ExtColumn)oldCols[j];
                if (!newCol.getName().equals(oldCol)) continue;
                newCol.setAlias(oldCol.getAlias());
                newAliases[i + 1] = oldAliases[j + 1];
            }
        }
        this.sawtoothMap.remove(oldDs);
        this.all.remove(oldDs);
        this.all.add(newDs);
    }

    private void initListeners() {
        this.refresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean changed = false;
                int[] rows = KDTableUtil.getSelectedRows((KDTable)DatasetImporter.this.table);
                for (int i = rows.length - 1; i >= 0; --i) {
                    ExtDataSet oldDs = (ExtDataSet)DatasetImporter.this.table.getRow(rows[i]).getUserObject();
                    ExtDataSet newds = DatasetImporter.this._ext.getExtCallback().refreshDataSet(oldDs);
                    if (newds == null) continue;
                    DatasetImporter.this.dealWithDataSetReplace(newds, oldDs);
                    changed = true;
                }
                if (changed) {
                    DatasetImporter.this.refreshTree();
                }
            }
        });
        this.edit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DatasetImporter.this.table.getSelectManager().getActiveRowIndex() < 0) {
                    return;
                }
                ExtDataSet oldDs = (ExtDataSet)DatasetImporter.this.table.getRow(DatasetImporter.this.table.getSelectManager().getActiveRowIndex()).getUserObject();
                ExtDataSet newds = DatasetImporter.this._ext.getExtCallback().editDataSet(oldDs, (Window)((Object)DatasetImporter.this._ext));
                if (newds != null) {
                    DatasetImporter.this.dealWithDataSetReplace(newds, oldDs);
                    DatasetImporter.this.refreshTree();
                }
            }
        });
        this.inline.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] rows = KDTableUtil.getSelectedRows((KDTable)DatasetImporter.this.table);
                ExtDataSet[] dss = new ExtDataSet[rows.length];
                for (int i = rows.length - 1; i >= 0; --i) {
                    dss[i] = (ExtDataSet)DatasetImporter.this.table.getRow(rows[i]).getUserObject();
                }
                DatasetImporter.this._ext.getExtCallback().saveAsExternalDataSets(dss);
            }
        });
        this.del.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DatasetImporter.this.table.getRowCount() == 0) {
                    return;
                }
                if (!MessageUtil.msgboxOkCancel((Component)((Object)DatasetImporter.this), DatasetImporter.getLocalText(DatasetImporter.KEY_MSG_CONFIRM_DEL, "\u662f\u5426\u786e\u8ba4\u5220\u9664\uff1f"))) {
                    return;
                }
                int[] rows = KDTableUtil.getSelectedRows((KDTable)DatasetImporter.this.table);
                for (int i = rows.length - 1; i >= 0; --i) {
                    int selected = rows[i];
                    Object ds = DatasetImporter.this.table.getRow(selected).getUserObject();
                    DatasetImporter.this.sawtoothMap.remove(ds);
                    DatasetImporter.this.all.remove(ds);
                    DatasetImporter.this.table.removeRow(selected);
                    DatasetImporter.this.refreshTree();
                }
            }
        });
        this.add.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List<ExtDataSet> list;
                if (DatasetImporter.this.useTxtData.isSelected()) {
                    if (DatasetImporter.this.fileChooser == null) {
                        DatasetImporter.this.fileChooser = new KDFileChooser();
                        DatasetImporter.this.fileChooser.setFileFilter(DatasetImporter.this.filter);
                        DatasetImporter.this.fileChooser.setFileSelectionMode(2);
                        DatasetImporter.this.fileChooser.setMultiSelectionEnabled(true);
                        DatasetImporter.this.fileChooser.setCurrentDirectory(new File("C:" + File.separator + "kd" + File.separator + "txt"));
                    }
                    list = new ArrayList();
                    if (0 == DatasetImporter.this.fileChooser.showOpenDialog((Component)((Object)DatasetImporter.this))) {
                        File[] files = DatasetImporter.this.fileChooser.getSelectedFiles();
                        for (int i = 0; i < files.length; ++i) {
                            File file = files[i];
                            String fileName = file.getName();
                            int end = fileName.indexOf(46);
                            if (end > 0) {
                                fileName = fileName.substring(0, end);
                            }
                            Book book = MiscUtil.getActiveSpreadContext(DatasetImporter.this._ext).getBook();
                            list.add(book.getDataSetManager().getExtDataSetFactory().getDataSet(book, ExtDataSetType.TXT, fileName, file.getPath()));
                        }
                    }
                    list = DatasetImporter.this.exclusiveDatasetAssured(list);
                } else {
                    IExtCallback callback = DatasetImporter.this._ext.getExtCallback();
                    list = DatasetImporter.this.exclusiveDatasetAssured(callback.fetchDataSets(MiscUtil.getActiveSpreadContext(DatasetImporter.this._ext).getBook()));
                }
                ArrayList<Integer> rows = new ArrayList<Integer>();
                for (ExtDataSet dataset : list) {
                    DatasetImporter.this.removeEnumTypeBracePart(dataset);
                    DatasetImporter.this.sawtoothMap.put(dataset, DatasetImporter.this.genSawtooth(dataset));
                    DatasetImporter.this.all.add(dataset);
                    IRow row = DatasetImporter.this.table.addRow();
                    rows.add(new Integer(row.getRowIndex()));
                    row.setUserObject((Object)dataset);
                    row.getCell(0).setValue((Object)dataset.getAlias());
                    row.getCell(1).setValue((Object)dataset.getDataSetType().getDisplayName());
                    row.getCell(2).setValue((Object)DatasetImporter.this.getMeaningfulDefine(dataset.getDefine()));
                }
                if (rows.size() != 0) {
                    KDTSelectManager manager = DatasetImporter.this.table.getSelectManager();
                    Iterator iterator2 = rows.iterator();
                    while (iterator2.hasNext()) {
                        manager.add(((Integer)iterator2.next()).intValue(), 0);
                    }
                }
            }
        });
        this.table.getSelectManager().addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                DatasetImporter.this.refreshTree();
            }
        });
        this.table.getActionMap().put("Delete", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DatasetImporter.this.del.doClick();
            }
        });
        this.table.getEditManager().addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStopping(KDTEditEvent e) {
                if (e.getColIndex() == 0) {
                    String alias = (String)e.getValue();
                    String[] sawtooth = (String[])DatasetImporter.this.sawtoothMap.get(DatasetImporter.this.table.getRow(DatasetImporter.this.table.getSelectManager().getActiveRowIndex()).getUserObject());
                    sawtooth[0] = alias;
                    DatasetImporter.this.tree.setNodeText((DefaultKingdeeTreeNode)((DefaultKingdeeTreeNode)DatasetImporter.this.tree.getModel().getRoot()).getChildAt(0), alias);
                }
            }
        });
        this.tree.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    DatasetImporter.this.popAliasModifier();
                }
            }
        });
    }

    private void removeEnumTypeBracePart(ExtDataSet dataset) {
        String alias;
        if (dataset == null) {
            return;
        }
        if (!"sql_enum".equals(dataset.getDataSetType().getType())) {
            return;
        }
        int begin = 0;
        String name = dataset.getName();
        if (!StringUtil.isEmptyString((String)name)) {
            begin = name.lastIndexOf("[");
            dataset.setName(name.substring(0, begin).trim());
        }
        if (!StringUtil.isEmptyString((String)(alias = dataset.getAlias()))) {
            begin = alias.lastIndexOf("[");
            dataset.setAlias(alias.substring(0, begin).trim());
        }
    }

    private boolean isNameExistent(String name, StringBuffer sb, String dsAlias) {
        Book book = MiscUtil.getActiveSpreadContext(this._ext).getBook();
        NamedObjectNode node = book.getNamedObject(name);
        if (this.checkNamedObjectNode(node, name, sb, dsAlias)) {
            return true;
        }
        for (int i = 0; i < book.getSheetCount(); ++i) {
            Sheet sheet = book.getSheet(i);
            node = sheet.getNamedObject(name, false);
            if (!this.checkNamedObjectNode(node, name, sb, dsAlias)) continue;
            return true;
        }
        return false;
    }

    private boolean checkNamedObjectNode(NamedObjectNode node, String name, StringBuffer sb, String dsAlias) {
        if (node != null && !MiscUtil.isExtUsed(node) && !node.isUndefined()) {
            if (dsAlias != null) {
                sb.append(DatasetImporter.getLocalText(KEY_MSG_COL_ALIAS_CONFLICT_WITH_NO1, "\u6570\u636e\u96c6 {"));
                sb.append(dsAlias);
                sb.append(DatasetImporter.getLocalText(KEY_MSG_COL_ALIAS_CONFLICT_WITH_NO2, "} \u7684\u5217\u522b\u540d {"));
                sb.append(name);
                sb.append("} \u4e0e\u6269\u5c55\u62a5\u8868\u5185\u90e8\u540d\u79f0\u5bf9\u8c61\u51b2\u7a81\uff1b\n");
            } else {
                sb.append(DatasetImporter.getLocalText(KEY_MSG_DS_ALIAS_CONFLICT_WITH_NO1, "\u6570\u636e\u96c6\u522b\u540d {"));
                sb.append(name);
                sb.append("} \u4e0e\u6269\u5c55\u62a5\u8868\u5185\u90e8\u540d\u79f0\u5bf9\u8c61\u51b2\u7a81\uff1b\n");
            }
            return true;
        }
        return false;
    }

    private boolean isNamedValid(String name, StringBuffer sb, String dsAlias) {
        ExprParams ep;
        NamedObjectNode node = null;
        Sheet sheet = MiscUtil.getActiveSpreadContext(this._ext).getBook().getActiveSheet();
        Dependents deps = sheet.getBook().getDeps();
        boolean old = deps.isA1Style();
        deps.setA1Style(true);
        Expr expr = sheet.getExpr(null, sheet.getSyntaxName() + '!' + name);
        deps.setA1Style(old);
        if (expr != null && !expr.isSyntaxError() && expr.getExprOps().getNodes().length == 1 && (ep = expr.getExprParams()) != null) {
            IExprNode[] nodes = ep.getNodes();
            if (nodes[0] instanceof NamedObjectNode) {
                node = (NamedObjectNode)nodes[0];
            } else if (nodes[0] instanceof CellBlockNode) {
                if (dsAlias != null) {
                    sb.append(DatasetImporter.getLocalText(KEY_MSG_COL_ALIAS_CONFLICT_WITH_CELL1, "\u6570\u636e\u96c6 {"));
                    sb.append(dsAlias);
                    sb.append(DatasetImporter.getLocalText(KEY_MSG_COL_ALIAS_CONFLICT_WITH_CELL2, "} \u7684\u5217\u522b\u540d {"));
                    sb.append(name);
                    sb.append(DatasetImporter.getLocalText(KEY_MSG_COL_ALIAS_CONFLICT_WITH_CELL3, "} \u4e0e\u5355\u5143\u683c\u540d\u79f0\u53d1\u751f\u51b2\u7a81\u3002\u5178\u578b\u60c5\u51b5\uff1a\"ds1\"\u5728Excel\u4e2d\u4e3a\u7b2c1\u884c\u7b2c123\u5217\u7684\u5355\u5143\u683c\u540d\u79f0\uff1b\n"));
                } else {
                    sb.append(DatasetImporter.getLocalText(KEY_MSG_DS_ALIAS_CONFLICT_WITH_CELL1, "\u6570\u636e\u96c6\u522b\u540d {"));
                    sb.append(name);
                    sb.append(DatasetImporter.getLocalText(KEY_MSG_DS_ALIAS_CONFLICT_WITH_CELL2, "} \u4e0e\u5355\u5143\u683c\u540d\u79f0\u53d1\u751f\u51b2\u7a81\u3002\u5178\u578b\u60c5\u51b5\uff1a\"ds1\"\u5728Excel\u4e2d\u4e3a\u7b2c1\u884c\u7b2c123\u5217\u7684\u5355\u5143\u683c\u540d\u79f0\uff1b\n"));
                }
                return false;
            }
        }
        if (node == null) {
            if (dsAlias != null) {
                sb.append(DatasetImporter.getLocalText(KEY_MSG_COL_ALIAS_NOT_VALID1, "\u6570\u636e\u96c6 {"));
                sb.append(dsAlias);
                sb.append(DatasetImporter.getLocalText(KEY_MSG_COL_ALIAS_NOT_VALID2, "} \u7684\u5217\u522b\u540d {"));
                sb.append(name);
                sb.append(DatasetImporter.getLocalText(KEY_MSG_COL_ALIAS_NOT_VALID3, "} \u4e0d\u89c4\u8303\uff1b\n"));
            } else {
                sb.append(DatasetImporter.getLocalText(KEY_MSG_DS_ALIAS_NOT_VALID1, "\u6570\u636e\u96c6\u5f15\u7528\u540d {"));
                sb.append(name);
                sb.append(DatasetImporter.getLocalText(KEY_MSG_DS_ALIAS_NOT_VALID2, "} \u4e0d\u89c4\u8303:\n1.\u4e0d\u652f\u6301\u6570\u5b57\u5f00\u5934;\n2.\u4e0d\u80fd\u542b\u7279\u6b8a\u7b26\u53f7(+\u3001-\u3001*\u3001/\u3001%\u7b49)\u3002\n"));
            }
            return false;
        }
        sheet.getNames().remove(name);
        return true;
    }

    private void showMessage(String message) {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().clearGlobalFocusOwner();
        MessageUtil.msgboxWarning((Component)((Object)this), message);
    }

    private String getTreeNodeText(ExtDataSet ds, int colIndex) {
        String dataTypeName;
        StringBuffer sb = new StringBuffer();
        ExtColumn col = (ExtColumn)this.sortedColumns.get(ds)[colIndex];
        sb.append(((String[])this.sawtoothMap.get(ds))[colIndex + 1]);
        sb.append("\uff08");
        sb.append(col.getName());
        sb.append("\uff09\uff1a");
        switch (col.getDataType()) {
            case 5: {
                dataTypeName = "decimal";
                break;
            }
            case 10: {
                dataTypeName = "string";
                break;
            }
            case 6: {
                dataTypeName = "date";
                break;
            }
            case 7: {
                dataTypeName = "time";
                break;
            }
            case 8: {
                dataTypeName = "boolean";
                break;
            }
            case 2: {
                dataTypeName = "int";
                break;
            }
            case 3: {
                dataTypeName = "long";
                break;
            }
            case 9: {
                dataTypeName = "object";
                break;
            }
            case 4: {
                dataTypeName = "double";
                break;
            }
            case 0: {
                dataTypeName = "byte";
                break;
            }
            case 1: {
                dataTypeName = "short";
                break;
            }
            default: {
                throw new IllegalArgumentException("unsupportted data type.");
            }
        }
        sb.append(dataTypeName);
        return sb.toString();
    }

    private List exclusiveDatasetAssured(List list) {
        if (list.size() == 0) {
            return list;
        }
        HashSet<String> temp = new HashSet<String>();
        int count = this.table.getRowCount();
        for (int j = 0; j < count; ++j) {
            temp.add(((ExtDataSet)this.table.getRow(j).getUserObject()).getAlias());
        }
        KDTSelectManager manager = this.table.getSelectManager();
        manager.removeAll();
        for (int i = list.size() - 1; i >= 0; --i) {
            ExtDataSet ds = (ExtDataSet)list.get(i);
            int count2 = this.table.getRowCount();
            for (int j = 0; j < count2; ++j) {
                if (!((ExtDataSet)this.table.getRow(j).getUserObject()).equals(ds)) continue;
                list.remove(ds);
                manager.add(j, 0);
            }
            String alias = ds.getAlias();
            int m = 1;
            String test = alias;
            while (!temp.add(test)) {
                test = alias + "_" + m;
                ++m;
            }
            alias = test;
            ds.setAlias(alias);
        }
        return list;
    }

    private void initComponents() {
        this.jLabel1 = new KDLabel();
        this.refresh = new KDWorkButton();
        this.edit = new KDWorkButton();
        this.inline = new KDWorkButton();
        this.del = new KDWorkButton();
        this.add = new KDWorkButton();
        this.useTxtData = new KDCheckBox();
        this.useTxtData.setText(DatasetImporter.getLocalText(KEY_TXT_DATASET, "\u6587\u672c\u6570\u636e\u96c6"));
        this.jLabel1.setText(DatasetImporter.getLocalText(KEY_SELECTED_DATASETS, "\u5df2\u9009\u6570\u636e\u96c6:"));
        this.refresh.setIcon((Icon)ResourceManager.getImageIcon("tbtn_Refresh.gif"));
        this.refresh.setToolTipText("\u5237\u65b0\u6570\u636e\u96c6");
        this.edit.setIcon((Icon)ResourceManager.getImageIcon("tbtn_edit.gif"));
        this.edit.setToolTipText("\u7f16\u8f91\u6570\u636e\u96c6");
        this.inline.setIcon((Icon)ResourceManager.getImageIcon("tbtn_inline.gif"));
        this.inline.setToolTipText("\u5171\u4eab\u6570\u636e\u96c6");
        this.del.setToolTipText("\u5220\u9664\u6570\u636e\u96c6");
        this.add.setToolTipText("\u5f15\u5165\u6570\u636e\u96c6");
        this.del.setIcon((Icon)ResourceManager.getImageIcon("tbtn_Delete.gif"));
        this.add.setIcon((Icon)ResourceManager.getImageIcon("tbtn_New.gif"));
        this.table = new KDTable();
        this.table.setDefaultRowHeight(38);
        this.table.getSelectManager().setSelectMode(10);
        Dimension d = new Dimension(760, 220);
        this.table.setPreferredSize(d);
        this.table.setMinimumSize(d);
        this.table.setMaximumSize(d);
        int colCount = 3;
        for (int i = 0; i < colCount; ++i) {
            this.table.addColumn(i);
        }
        this.table.getColumn(1).setWidth(120);
        this.table.getColumn(1).getStyleAttributes().setLocked(true);
        this.table.getColumn(2).setWidth(480);
        this.table.getColumn(2).getStyleAttributes().setLocked(true);
        this.table.getColumn(2).getStyleAttributes().setWrapText(true);
        this.table.addHeadRow();
        this.table.getHeadRow(0).getCell(0).setValue((Object)DatasetImporter.getLocalText(KEY_DS_REF_NAME, "\u5f15\u7528\u540d"));
        this.table.getHeadRow(0).getCell(1).setValue((Object)DatasetImporter.getLocalText(KEY_DS_TYPE, "\u7c7b\u578b"));
        this.table.getHeadRow(0).getCell(2).setValue((Object)DatasetImporter.getLocalText(KEY_DS_PATH, "\u8def\u5f84"));
        KDTreeView treeView = new KDTreeView();
        d = new Dimension(760, 240);
        Dimension d1 = new Dimension(760, 180);
        d1 = new Dimension(760, 170);
        treeView.setPreferredSize(d);
        treeView.setMinimumSize(d1);
        treeView.setMaximumSize(d);
        treeView.setShowButton(false);
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode((Object)"root");
        this.tree = new KDTree((TreeModel)new KingdeeTreeModel((TreeNode)root, true), false);
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        KDWorkButton modify = new KDWorkButton((Icon)ResourceManager.getImageIcon("tbtn_edit.gif"));
        modify.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DatasetImporter.this.popAliasModifier();
            }
        });
        treeView.getControlPane().add((Component)modify);
        this.tree.getSelectionModel().setSelectionMode(1);
        treeView.setTree(this.tree);
        TableLayout2 layout = new TableLayout2(7, 10);
        layout.setFixedHeight(new int[]{0, 6}, this.borderValue);
        layout.setFixedHeight(1, 20);
        layout.setFixedHeight(new int[]{2, 4}, 8);
        layout.setRatableHeight(3, 50);
        layout.setRatableHeight(5, 50);
        layout.setFixedWidth(new int[]{0, 9}, this.borderValue);
        layout.setFixedWidth(1, 70);
        layout.setRatableWidth(2, 100);
        layout.setFixedWidth(3, 90);
        layout.setFixedWidth(new int[]{4, 5, 6, 7, 8}, 25);
        layout.setColsSpacing(new int[]{3, 4, 5, 6, 7}, 4);
        this.setLayout((LayoutManager)layout);
        this.add((Component)this.jLabel1, TableLayout2.param((int)1, (int)1));
        this.add((Component)this.useTxtData, TableLayout2.param((int)1, (int)3));
        this.add((Component)this.refresh, TableLayout2.param((int)1, (int)4));
        this.add((Component)this.edit, TableLayout2.param((int)1, (int)5));
        this.add((Component)this.inline, TableLayout2.param((int)1, (int)6));
        this.add((Component)this.add, TableLayout2.param((int)1, (int)7));
        this.add((Component)this.del, TableLayout2.param((int)1, (int)8));
        this.add((Component)this.table, TableLayout2.param((int)3, (int)1, (int)3, (int)8));
        this.add((Component)treeView, TableLayout2.param((int)5, (int)1, (int)5, (int)8));
    }

    public KDWorkButton getAdd() {
        return this.add;
    }

    public void setTableChangeListener(TableChangeListener listener) {
        this.listener = listener;
    }

    public void removeBorder() {
        this.borderValue = 0;
        this.removeAll();
        this.initComponents();
        this.initListeners();
    }

    public static interface TableChangeListener {
        public void tableChanged(boolean var1);
    }

    private static class SortedColumns {
        Map data = new HashMap();

        private SortedColumns() {
        }

        void clear() {
            this.data.clear();
        }

        Object[] get(ExtDataSet ds) {
            Object[] cols = (Object[])this.data.get(ds);
            if (cols != null) {
                return cols;
            }
            cols = MiscUtil.sortColumnsByIndex(ds.getColumns());
            this.data.put(ds, cols);
            return cols;
        }
    }

    private class AliasModifier {
        private KDPanel contentPanel = new KDPanel();
        private KDTextField jTextField1;
        private KDTextField jTextField2;
        private int colIndex;

        public AliasModifier() {
            this.initComps();
        }

        private void initComps() {
            this.jTextField1 = new KDTextField();
            this.jTextField2 = new KDTextField();
            this.jTextField1.setEditable(false);
            this.contentPanel.setLayout(null);
            KDLabelContainer label1 = CtrlSwingUtilities.createLabelContainer((JComponent)this.jTextField1, (String)DatasetImporter.getLocalText(DatasetImporter.KEY_NAME, "\u540d\u79f0"), (int)80);
            KDLabelContainer label2 = CtrlSwingUtilities.createLabelContainer((JComponent)this.jTextField2, (String)DatasetImporter.getLocalText(DatasetImporter.KEY_ALIAS, "\u522b\u540d"), (int)80);
            label1.setBounds(0, 5, 273, 20);
            label2.setBounds(0, 45, 273, 20);
            this.contentPanel.add((Component)label1);
            this.contentPanel.add((Component)label2);
        }

        public void prepare(int colIndex) {
            this.colIndex = colIndex;
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)DatasetImporter.this.tree.getSelectionPath().getLastPathComponent();
            ExtDataSet ds = (ExtDataSet)((DefaultKingdeeTreeNode)node.getParent()).getUserObject();
            ExtColumn column = (ExtColumn)DatasetImporter.this.sortedColumns.get(ds)[colIndex];
            this.jTextField1.setText(column.getName());
            this.jTextField2.setText(((String[])DatasetImporter.this.sawtoothMap.get(ds))[colIndex + 1]);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AliasModifier.this.jTextField2.requestFocusInWindow();
                }
            });
        }

        public void showDialog(Component parent) {
            SimpleDialog simpleDialog = SimpleDialog.create((Component)parent);
            simpleDialog.setTitle(DatasetImporter.getLocalText(DatasetImporter.KEY_COL_ALIAS_MODIFY, "\u4fee\u6539\u5b57\u6bb5\u522b\u540d"));
            simpleDialog.setComponent((Component)this.contentPanel);
            simpleDialog.setSize(300, 160);
            simpleDialog.setLocationRelativeTo(null);
            simpleDialog.setResizable(false);
            if (simpleDialog.showDialog()) {
                DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)DatasetImporter.this.tree.getSelectionPath().getLastPathComponent();
                ExtDataSet ds = (ExtDataSet)((DefaultKingdeeTreeNode)node.getParent()).getUserObject();
                String[] sawtooth = (String[])DatasetImporter.this.sawtoothMap.get(ds);
                int index = this.colIndex + 1;
                String oldValue = sawtooth[index];
                sawtooth[index] = this.jTextField2.getText();
                if (!DatasetImporter.this.checkValid()) {
                    sawtooth[index] = oldValue;
                    return;
                }
                DatasetImporter.this.tree.setNodeText(node, DatasetImporter.this.getTreeNodeText(ds, this.colIndex));
            }
        }
    }
}

