/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.ext.util;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.common.util.xml.XmlUtil;
import com.kingdee.bos.ctrl.ext.immit.SavedSpan;
import com.kingdee.bos.ctrl.ext.immit.ShowcaseConfig;
import com.kingdee.bos.ctrl.ext.immit.ShowcaseConfigCollection;
import com.kingdee.bos.ctrl.ext.immit.ShowcaseType;
import com.kingdee.bos.ctrl.ext.util.MiscUtil;
import com.kingdee.bos.ctrl.kds.model.struct.SortedAttributeSpanArray;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.DataConversionException;
import org.jdom2.Element;

public class ShowcaseUtil {
    public static Element parseFromString(String[] str) {
        Element root = new Element("report");
        Element caseNode = null;
        root.setAttribute("name", str[0]);
        for (int i = 1; i < str.length; ++i) {
            Element span;
            String[] attr;
            int j;
            caseNode = new Element("case");
            String[] temp = str[i].split(",");
            caseNode.setAttribute("name", temp[0]);
            caseNode.setAttribute("editable", temp[1]);
            caseNode.setAttribute("showformula", temp[2]);
            caseNode.setAttribute("rowCountVisible", temp[3]);
            caseNode.setAttribute("colCountVisible", temp[4]);
            caseNode.setAttribute("hideEditable", temp[5]);
            caseNode.setAttribute("cellSelect", temp[6]);
            caseNode.setAttribute("showcaseLevel", temp[7]);
            caseNode.setAttribute("showcaseID", temp[8]);
            caseNode.setAttribute("isDefault", temp[9]);
            int index = 0;
            Element rowSpan = new Element("rowSpans");
            Element colSpan = new Element("colSpans");
            caseNode.addContent((Content)rowSpan);
            caseNode.addContent((Content)colSpan);
            for (j = 10; j < temp.length; ++j) {
                if (temp[j].equals("other")) {
                    index = ++j;
                    break;
                }
                attr = temp[j].split(":");
                span = new Element("span");
                span.setAttribute("start", attr[0]);
                span.setAttribute("end", attr[1]);
                span.setAttribute("length", attr[2]);
                span.setAttribute("visible", attr[3]);
                rowSpan.addContent((Content)span);
            }
            for (j = index; j < temp.length; ++j) {
                attr = temp[j].split(":");
                span = new Element("span");
                span.setAttribute("start", attr[0]);
                span.setAttribute("end", attr[1]);
                span.setAttribute("length", attr[2]);
                span.setAttribute("visible", attr[3]);
                colSpan.addContent((Content)span);
            }
            root.addContent((Content)caseNode);
        }
        return root;
    }

    public static String[] toShowcaseConfigs(Element elm) {
        List children = elm.getChildren();
        String[] cList = new String[children.size() + 1];
        cList[0] = elm.getAttributeValue("name");
        StringBuffer buffer = new StringBuffer();
        Element temp = null;
        for (int i = 0; i < children.size(); ++i) {
            Element element;
            StringBuffer text;
            int j;
            buffer = new StringBuffer();
            temp = (Element)children.get(i);
            List aList = temp.getAttributes();
            for (int j2 = 0; j2 < aList.size(); ++j2) {
                if (j2 != aList.size() - 1) {
                    buffer.append(((Attribute)aList.get(j2)).getValue() + ",");
                    continue;
                }
                buffer.append(((Attribute)aList.get(j2)).getValue());
            }
            List spanList = temp.getChildren();
            Element row = (Element)spanList.get(0);
            Element col = (Element)spanList.get(1);
            for (j = 0; j < row.getChildren().size(); ++j) {
                text = new StringBuffer();
                element = (Element)row.getChildren().get(j);
                text.append(element.getAttribute("start").getValue());
                text.append(":" + element.getAttribute("end").getValue());
                text.append(":" + element.getAttribute("length").getValue());
                text.append(":" + element.getAttribute("visible").getValue());
                buffer.append("," + text.toString());
            }
            buffer.append(",other");
            for (j = 0; j < col.getChildren().size(); ++j) {
                text = new StringBuffer();
                element = (Element)col.getChildren().get(j);
                text.append(element.getAttribute("start").getValue());
                text.append(":" + element.getAttribute("end").getValue());
                text.append(":" + element.getAttribute("length").getValue());
                text.append(":" + element.getAttribute("visible").getValue());
                buffer.append("," + text);
            }
            cList[i + 1] = buffer.toString();
        }
        return cList;
    }

    public static ShowcaseConfig toShowcaseConfig(String configFormatString, ShowcaseConfig srcConfig) {
        block9: {
            try {
                SavedSpan span;
                String[] attr;
                int j;
                if (srcConfig == null || configFormatString == null) {
                    throw new NullPointerException(srcConfig == null ? "srcConfig = null \u53c2\u6570\u975e\u6cd5" : "configFormatString = null \u53c2\u6570\u975e\u6cd5");
                }
                if (StringUtil.isEmptyString((String)configFormatString)) {
                    configFormatString = ShowcaseUtil.toShowcaseConfig(new ShowcaseConfig().toElement());
                }
                String[] temp = configFormatString.split(",");
                srcConfig.setShowcaseName(temp[0]);
                srcConfig.setEditable(temp[1].equals("true"));
                srcConfig.setShowFormula(temp[2].equals("true"));
                srcConfig.setRowCountVisible(temp[3].equals("true"));
                srcConfig.setColCountVisible(temp[4].equals("true"));
                srcConfig.setHideEditable(temp[5].equals("true"));
                srcConfig.setCellSelect(temp[6].equals("true"));
                int level = 0;
                try {
                    level = Integer.parseInt(temp[7]);
                }
                catch (Exception ex) {
                    level = 1;
                }
                srcConfig.setLevel(new ShowcaseType("default", level));
                srcConfig.setShowcaseID(temp[8]);
                srcConfig.setDefault(temp[9].equals("true"));
                ArrayList<SavedSpan> rowList = new ArrayList<SavedSpan>();
                ArrayList<SavedSpan> colList = new ArrayList<SavedSpan>();
                int index = 0;
                for (j = 10; j < temp.length; ++j) {
                    if (temp[j].equals("other")) {
                        index = ++j;
                        break;
                    }
                    attr = temp[j].split(":");
                    span = new SavedSpan(Integer.valueOf(attr[0]), Integer.valueOf(attr[1]), Integer.valueOf(attr[2]), Boolean.valueOf(attr[3]));
                    rowList.add(span);
                }
                for (j = index; j < temp.length; ++j) {
                    attr = temp[j].split(":");
                    span = new SavedSpan(Integer.valueOf(attr[0]), Integer.valueOf(attr[1]), Integer.valueOf(attr[2]), Boolean.valueOf(attr[3]));
                    colList.add(span);
                }
                srcConfig.setRowSpans(rowList.toArray());
                srcConfig.setColSpans(colList.toArray());
            }
            catch (Exception ex) {
                ex.printStackTrace();
                if (!MiscUtil.shouldLog()) break block9;
                MiscUtil.error(ex.getMessage());
            }
        }
        return srcConfig;
    }

    private static SavedSpan[] changeSpans(Element spans) {
        SavedSpan[] spansArray = new SavedSpan[]{};
        List rSpans = spans.getChildren();
        for (int s = 0; s < rSpans.size(); ++s) {
            Element rSpan = (Element)rSpans.get(s);
            List rSpanAttributes = rSpan.getAttributes();
            SavedSpan span = null;
            for (int rs = 0; rs < rSpanAttributes.size(); ++rs) {
                if (span == null) {
                    span = new SavedSpan();
                }
                Attribute rsAttribute = (Attribute)rSpanAttributes.get(rs);
                spansArray[rs] = ShowcaseUtil.setSpan(span, rsAttribute);
            }
            span = null;
        }
        return spansArray;
    }

    private static SavedSpan setSpan(SavedSpan span, Attribute attribute) {
        if (span == null) {
            span = new SavedSpan();
        }
        try {
            if (StringUtil.equals((String)attribute.getName(), (String)"start")) {
                span.setStart(attribute.getIntValue());
            } else if (StringUtil.equals((String)attribute.getName(), (String)"end")) {
                span.setEnd(attribute.getIntValue());
            } else if (StringUtil.equals((String)attribute.getName(), (String)"length")) {
                span.setLength(attribute.getIntValue());
            } else if (StringUtil.equals((String)attribute.getName(), (String)"visible")) {
                span.setVisible(attribute.getBooleanValue());
            }
        }
        catch (DataConversionException e) {
            e.printStackTrace();
        }
        return span;
    }

    private static ShowcaseConfig setShowcaseConfig(Attribute attribute, ShowcaseConfig srcConfig) {
        try {
            if (srcConfig == null) {
                srcConfig = new ShowcaseConfig();
            }
            if (StringUtil.equals((String)attribute.getName(), (String)"name")) {
                srcConfig.setShowcaseName(attribute.getValue());
            } else if (StringUtil.equals((String)attribute.getName(), (String)"editable")) {
                srcConfig.setEditable(attribute.getBooleanValue());
            } else if (StringUtil.equals((String)attribute.getName(), (String)"showformula")) {
                srcConfig.setShowFormula(attribute.getBooleanValue());
            } else if (StringUtil.equals((String)attribute.getName(), (String)"rowCountVisible")) {
                srcConfig.setRowCountVisible(attribute.getBooleanValue());
            } else if (StringUtil.equals((String)attribute.getName(), (String)"colCountVisible")) {
                srcConfig.setColCountVisible(attribute.getBooleanValue());
            } else if (StringUtil.equals((String)attribute.getName(), (String)"hideEditable")) {
                srcConfig.setHideEditable(attribute.getBooleanValue());
            } else if (StringUtil.equals((String)attribute.getName(), (String)"cellSelect")) {
                srcConfig.setCellSelect(attribute.getBooleanValue());
            } else if (StringUtil.equals((String)attribute.getName(), (String)"showcaseLevel")) {
                srcConfig.setLevel(new ShowcaseType("default", attribute.getIntValue()));
            } else if (StringUtil.equals((String)attribute.getName(), (String)"showcaseID")) {
                srcConfig.setShowcaseID(attribute.getValue());
            } else if (StringUtil.equals((String)attribute.getName(), (String)"isDefault")) {
                srcConfig.setDefault(attribute.getBooleanValue());
            }
        }
        catch (DataConversionException e) {
            e.printStackTrace();
        }
        return srcConfig;
    }

    public static String toShowcaseConfig(Element elm) {
        Element element;
        StringBuffer text;
        int j;
        StringBuffer buffer = new StringBuffer();
        List aList = elm.getAttributes();
        int k = aList.size();
        for (int j2 = 0; j2 < k; ++j2) {
            if (j2 != aList.size() - 1) {
                buffer.append(((Attribute)aList.get(j2)).getValue() + ",");
                continue;
            }
            buffer.append(((Attribute)aList.get(j2)).getValue());
        }
        List spanList = elm.getChildren();
        Element row = (Element)spanList.get(0);
        Element col = (Element)spanList.get(1);
        for (j = 0; j < row.getChildren().size(); ++j) {
            text = new StringBuffer();
            element = (Element)row.getChildren().get(j);
            text.append(element.getAttribute("start").getValue());
            text.append(":" + element.getAttribute("end").getValue());
            text.append(":" + element.getAttribute("length").getValue());
            text.append(":" + element.getAttribute("visible").getValue());
            buffer.append("," + text.toString());
        }
        buffer.append(",other");
        for (j = 0; j < col.getChildren().size(); ++j) {
            text = new StringBuffer();
            element = (Element)col.getChildren().get(j);
            text.append(element.getAttribute("start").getValue());
            text.append(":" + element.getAttribute("end").getValue());
            text.append(":" + element.getAttribute("length").getValue());
            text.append(":" + element.getAttribute("visible").getValue());
            buffer.append("," + text);
        }
        return buffer.toString();
    }

    public static ShowcaseConfigCollection toShowcaseConfigs(String[] str, ShowcaseType[] levels) {
        if (str == null || str.length == 0) {
            return null;
        }
        ShowcaseConfigCollection collection = new ShowcaseConfigCollection(true);
        collection.setName(str[0]);
        ShowcaseConfig config = null;
        for (int i = 1; i < str.length; ++i) {
            SavedSpan span;
            String[] attr;
            int j;
            config = new ShowcaseConfig();
            String[] temp = str[i].split(",");
            config.setShowcaseName(temp[0]);
            config.setEditable(temp[1].equals("true"));
            config.setShowFormula(temp[2].equals("true"));
            config.setRowCountVisible(temp[3].equals("true"));
            config.setColCountVisible(temp[4].equals("true"));
            config.setHideEditable(temp[5].equals("true"));
            config.setCellSelect(temp[6].equals("true"));
            int level = Integer.parseInt(temp[7]);
            if (level > 0) {
                for (int k = 0; k < levels.length; ++k) {
                    if (levels[k].getLevel() != level) continue;
                    config.setLevel(levels[k]);
                }
            }
            config.setShowcaseID(temp[8]);
            config.setDefault(temp[9].equals("true"));
            ArrayList<SavedSpan> rowList = new ArrayList<SavedSpan>();
            ArrayList<SavedSpan> colList = new ArrayList<SavedSpan>();
            int index = 0;
            for (j = 10; j < temp.length; ++j) {
                if (temp[j].equals("other")) {
                    index = ++j;
                    break;
                }
                attr = temp[j].split(":");
                span = new SavedSpan(Integer.valueOf(attr[0]), Integer.valueOf(attr[1]), Integer.valueOf(attr[2]), Boolean.valueOf(attr[3]));
                rowList.add(span);
            }
            for (j = index; j < temp.length; ++j) {
                attr = temp[j].split(":");
                span = new SavedSpan(Integer.valueOf(attr[0]), Integer.valueOf(attr[1]), Integer.valueOf(attr[2]), Boolean.valueOf(attr[3]));
                colList.add(span);
            }
            config.setRowSpans(rowList.toArray());
            config.setColSpans(colList.toArray());
            if (config.isDefault()) {
                collection.setDefaultConfig(config);
            }
            collection.addShowcaseConfig(config);
        }
        return collection;
    }

    public static void saveFile(String path, Element root) {
        try {
            File file = new File(path);
            if (!file.exists()) {
                if (file.getParentFile() != null) {
                    file.getParentFile().mkdir();
                }
                file.createNewFile();
            }
            String name = file.getName().substring(0, file.getName().lastIndexOf("."));
            name = name.substring(0, name.lastIndexOf("."));
            root.setAttribute("name", name);
            XmlUtil.saveXmlFile((File)file, (Element)root);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static Element loadFile(String path) {
        if (StringUtil.isEmptyString((String)path)) {
            return new Element("report");
        }
        try {
            File file = new File(path);
            if (!file.exists()) {
                return new Element("report");
            }
            return XmlUtil.loadXmlFile((File)file);
        }
        catch (Exception e) {
            return new Element("report");
        }
    }

    public static Element loadFile(File file) {
        if (file == null) {
            return new Element("report");
        }
        try {
            if (!file.exists()) {
                return new Element("report");
            }
            return XmlUtil.loadXmlFile((File)file);
        }
        catch (Exception e) {
            return new Element("report");
        }
    }

    public static String parseFilePath(String src) {
        if (src == null) {
            return null;
        }
        String newPath = null;
        File file = new File(src);
        if (file.getParentFile() != null) {
            newPath = file.getParentFile() + "/showcases/" + file.getName() + ".xml";
        }
        return newPath;
    }

    public static synchronized SavedSpan[] toSavedSpan(SortedAttributeSpanArray array) {
        SavedSpan[] span = null;
        if (array != null) {
            int size = array.size();
            span = new SavedSpan[size];
            for (int i = 0; i < size; ++i) {
                Object obj = array.get(i);
                if (!(obj instanceof SortedAttributeSpanArray.AttributeSpan)) continue;
                SortedAttributeSpanArray.AttributeSpan temp = (SortedAttributeSpanArray.AttributeSpan)obj;
                span[i] = new SavedSpan(temp.getStart(), temp.getEnd(), temp.getLength(), temp.isVisible());
            }
        }
        return span;
    }
}

