/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.core;

import com.kingdee.bos.ctrl.kds.core.RenderUtil;
import com.kingdee.bos.ctrl.kds.core.SpreadView;
import com.kingdee.bos.ctrl.kds.core.SpreadViewUI;
import com.kingdee.bos.ctrl.kds.model.struct.Sheet;
import com.kingdee.bos.ctrl.kds.model.struct.SheetBaseMath;
import com.kingdee.bos.ctrl.kds.model.struct.embed.EmbedhLayer;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;

final class RowHeaderUI
extends SpreadViewUI {
    private static RowHeaderUI rowHeaderUI = new RowHeaderUI();
    private SpreadView _view;
    private Graphics2D _g2d;
    private Sheet _sheet;
    private int _sizeOfRows;
    private SpreadView.RowBuffer[] _rbs;
    private int _rinx;
    private int _rinx2;

    RowHeaderUI() {
    }

    public static ComponentUI createUI(JComponent c) {
        return rowHeaderUI;
    }

    @Override
    protected void installDefaults(SpreadView view) {
        view.setAutoscrolls(true);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        SpreadView view = (SpreadView)c;
        int w = view.getSpread().getBook().getActiveSheet().getRowHeaderWidth();
        return new Dimension(w, view.getPreferredHeight());
    }

    @Override
    protected boolean prePaint(Graphics2D g, SpreadView view) {
        int i;
        this._g2d = g;
        this._view = view;
        this._sheet = view.getSpread().getBook().getActiveSheet();
        Rectangle clip = this._g2d.getClipBounds();
        Point upperLeft = clip.getLocation();
        Point lowerRight = new Point(clip.x + clip.width - 1, clip.y + clip.height - 1);
        int cRow = SheetBaseMath.rowAtPoint(this._sheet, upperLeft);
        int cRow2 = SheetBaseMath.rowAtPoint(this._sheet, lowerRight);
        if (cRow < 0) {
            return false;
        }
        cRow2 = SheetBaseMath.dealInvalidRow(cRow2);
        this._rbs = this._view.getRowBuffers(cRow, cRow2);
        if (this._rbs == null) {
            return false;
        }
        this._sizeOfRows = this._rbs.length;
        for (i = 0; i < this._sizeOfRows; ++i) {
            if (cRow > this._rbs[i].getRow()) continue;
            this._rinx = i;
            break;
        }
        for (i = this._sizeOfRows - 1; i >= 0; --i) {
            if (cRow2 < this._rbs[i].getRow()) continue;
            this._rinx2 = i;
            break;
        }
        return true;
    }

    @Override
    protected void paintBase(Graphics2D g, SpreadView view) {
        Graphics2D g2d = g;
        Rectangle clip = g2d.getClipBounds();
        g2d.setBackground(view.getBackground());
        g2d.clearRect(clip.x, clip.y, clip.width, clip.height);
        this.paintImpl();
    }

    @Override
    protected void afterPaint(Graphics2D g, SpreadView view) {
        this._view = null;
        this._g2d = null;
        this._rbs = null;
        this._sheet = null;
    }

    private int calcLastRow() {
        if (this._rinx > 0) {
            return this._rbs[this._rinx - 1].getRow();
        }
        int temp = this._rbs[this._rinx].getRow();
        if (temp == 0) {
            return -1;
        }
        int index = this._sheet.getRowSpans().searchSpan(temp - 1);
        if (index < 0 || this._sheet.getRowSpans().getAttributeSpan(index).isVisible()) {
            return temp - 1;
        }
        return temp - 2;
    }

    private void paintImpl() {
        int lastRow = this.calcLastRow();
        int x = 0;
        int w = this._sheet.getRowHeaderWidth();
        int x2 = w - 1;
        int spacing = SheetBaseMath.getRowSpacing();
        Rectangle rect = new Rectangle();
        int maxRow = -1;
        boolean isMobile = this._sheet.getBook().is4Mobile();
        if (isMobile) {
            maxRow = this._sheet.getMaxRowIndex();
        }
        for (int cIndex = this._rinx; cIndex <= this._rinx2; ++cIndex) {
            SpreadView.RowBuffer rb = this._rbs[cIndex];
            int row = rb.getRow();
            int height = rb.getRowHeight();
            int y = rb.getRowY();
            rect.setBounds(x, y, w, height + spacing);
            this._g2d.setColor(RenderUtil.HEAD_GRID_COLOR);
            if (row > lastRow + 1) {
                this._g2d.fillRect(x, y, w, 1);
            }
            this._g2d.fillRect(x, y - 1, w, 1);
            String txt = SheetBaseMath.getRowName(this._sheet, row);
            RenderUtil.paintHeaderContent(this._g2d, this._sheet, txt, rect);
            EmbedhLayer gl = this._sheet.getEmbedments(false);
            if (gl == null || !gl.hasSelection()) {
                RenderUtil.paintHeaderBackground(this._g2d, this._sheet.getSheetOption().getSelection().getSelectModeAtRow(row), rect);
            }
            RenderUtil.paintRptContentHeaderArea(this._g2d, rect, isMobile, maxRow, row);
            lastRow = row;
        }
        this._g2d.setColor(RenderUtil.HEAD_GRID_COLOR);
        SpreadView.RowBuffer rb = this._rbs[this._rinx];
        SpreadView.RowBuffer rb2 = this._rbs[this._rinx2];
        this._g2d.fillRect(x, rb2.getRowY() + rb2.getRowHeight() + 1, w, 1);
        this._g2d.fillRect(x, rb.getRowY(), 1, rb2.getRowY() + rb2.getRowHeight() - rb.getRowY() + 1);
        this._g2d.fillRect(x2, rb.getRowY(), 1, rb2.getRowY() + rb2.getRowHeight() - rb.getRowY() + 1);
    }
}

