/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.core;

import com.kingdee.bos.ctrl.kds.core.KDSpread;
import com.kingdee.bos.ctrl.kds.model.struct.Cell;
import com.kingdee.bos.ctrl.kds.model.struct.Sheet;
import com.kingdee.bos.ctrl.kds.model.struct.SheetBaseMath;
import java.awt.Point;
import java.awt.Rectangle;

public class SpreadAutoTestProxy {
    private KDSpread _spread;

    SpreadAutoTestProxy(KDSpread spread) {
        this._spread = spread;
    }

    public String getTextAt(int rowIndex, int colIndex) {
        Cell cell = this._spread.getBook().getActiveSheet().getCell(rowIndex, colIndex, false);
        if (cell != null) {
            return cell.getText();
        }
        return null;
    }

    public Object getValueAt(int rowIndex, int colIndex) {
        Cell cell = this._spread.getBook().getActiveSheet().getCell(rowIndex, colIndex, false);
        if (cell != null) {
            return cell.getValue().getValue();
        }
        return null;
    }

    public Point cellAtPoint(Point point) {
        return new Point(this.rowAtPoint(point), this.colAtPoint(point));
    }

    public void scrollCellVisible(int row, int col) {
        this._spread.scrollCellVisible(row, col);
    }

    public int rowAtPoint(Point point) {
        Sheet sheet = this._spread.getBook().getActiveSheet();
        return SheetBaseMath.rowAtPoint(sheet, point);
    }

    public int colAtPoint(Point point) {
        Sheet sheet = this._spread.getBook().getActiveSheet();
        return SheetBaseMath.colAtPoint(sheet, point);
    }

    public int getColX(int col) {
        Sheet sheet = this._spread.getBook().getActiveSheet();
        return SheetBaseMath.getColX(sheet, col);
    }

    public int getRowY(int row) {
        Sheet sheet = this._spread.getBook().getActiveSheet();
        return SheetBaseMath.getRowY(sheet, row);
    }

    public int getEndRow() {
        return this._spread.getActiveView().getEndRow();
    }

    public int getEndCol() {
        return this._spread.getActiveView().getEndCol();
    }

    public int findRow(int col, Object value) {
        Sheet sheet = this._spread.getBook().getActiveSheet();
        Sheet.ICellsIterator iter = sheet.getCellsIterator(0, col, 1048575, col, true, true);
        while (iter.hasNext()) {
            Cell cell = iter.next();
            Object o = cell.getValue().getValue();
            if (o == null || !o.equals(value)) continue;
            return cell.getRow();
        }
        return -1;
    }

    public int findCol(int row, Object value) {
        Sheet sheet = this._spread.getBook().getActiveSheet();
        Sheet.ICellsIterator iter = sheet.getEntireRowCellsIterator(row, row, true, true);
        while (iter.hasNext()) {
            Cell cell = iter.next();
            Object o = cell.getValue().getValue();
            if (o == null || !o.equals(value)) continue;
            return cell.getRow();
        }
        return -1;
    }

    public String getColName(int col) {
        return SheetBaseMath.getColumnName(col, 0, true, false);
    }

    public int getColIndexByName(String name) {
        return SheetBaseMath.getColumnIndexByName(name);
    }

    public Rectangle getCellRect(int row, int col) {
        this._spread.getActiveView().scrollCellVisible(row, col);
        int newRow = this._spread.getActiveView().calcFirstRowByVisibleRow(row);
        int newCol = this._spread.getActiveView().calcFirstColByVisibleCol(col);
        newRow = row - newRow;
        newCol = col - newCol;
        return SheetBaseMath.getCellRect(this._spread.getBook().getActiveSheet(), newRow, newCol, true);
    }
}

