/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.impl.state;

import com.kingdee.bos.ctrl.kdf.util.style.LineStyle;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.kds.core.SpreadView;
import com.kingdee.bos.ctrl.kds.impl.SpreadContext;
import com.kingdee.bos.ctrl.kds.impl.facade.fairy.FairyButton;
import com.kingdee.bos.ctrl.kds.impl.state.DefaultState;
import com.kingdee.bos.ctrl.kds.impl.state.SpreadStateManager;
import com.kingdee.bos.ctrl.kds.model.struct.Book;
import com.kingdee.bos.ctrl.kds.model.struct.CellBlock;
import com.kingdee.bos.ctrl.kds.model.struct.Range;
import com.kingdee.bos.ctrl.kds.model.struct.Sheet;
import com.kingdee.bos.ctrl.kds.model.struct.SheetBaseMath;
import com.kingdee.bos.ctrl.kds.model.struct.event.BookChangeEvent;
import com.kingdee.bos.ctrl.kds.model.struct.event.SheetChangeEvent;
import java.awt.Component;

public class InsertState
extends DefaultState {
    private SpreadView _insertView;
    private Sheet _dstSheet;
    private boolean _yDir;

    InsertState(SpreadContext context, boolean yDir) {
        super(context);
        this.init(yDir);
    }

    void init(boolean yDir) {
        this._yDir = yDir;
    }

    @Override
    public int getKey() {
        return SpreadStateManager.Key_Insert;
    }

    @Override
    public boolean start(int preKey) {
        boolean ret = false;
        Range rg = this._context.getRangeManager().getSelectionRange();
        if (rg.isSingleBlock()) {
            boolean showOption = false;
            Sheet sheet = this._context.getBook().getActiveSheet();
            CellBlock cb = rg.getBlock(0);
            if (this._yDir) {
                StyleAttributes saI;
                StyleAttributes sa;
                if (cb.getRow2() < 1048575) {
                    if (SheetBaseMath.getRowHeight(sheet, cb.getRow2() + 1) != sheet.getDefRowHeight()) {
                        showOption = true;
                    } else {
                        sa = Styles.getEmptySA();
                        saI = Styles.getEmptySA();
                        CellBlock block = CellBlock.getCellBlock(cb.getRow2() + 1, cb.getCol(), cb.getRow2() + 1, cb.getCol2());
                        this._context.getRangeManager().getRange(block).getStyle(sa, saI);
                        showOption = this.needShowOption(sa, saI);
                    }
                }
                if (!showOption && cb.getRow() > 0) {
                    if (SheetBaseMath.getRowHeight(sheet, cb.getRow() - 1) != sheet.getDefRowHeight()) {
                        showOption = true;
                    } else {
                        sa = Styles.getEmptySA();
                        saI = Styles.getEmptySA();
                        this._context.getRangeManager().getRange(CellBlock.getCellBlock(cb.getRow() - 1, cb.getCol(), cb.getRow() - 1, cb.getCol2())).getStyle(sa, saI);
                        showOption = this.needShowOption(sa, saI);
                    }
                }
            } else {
                StyleAttributes saI;
                StyleAttributes sa;
                if (cb.getCol2() < 65535) {
                    if (SheetBaseMath.getColWidth(sheet, cb.getCol2() + 1) != sheet.getDefColWidth()) {
                        showOption = true;
                    } else {
                        sa = Styles.getEmptySA();
                        saI = Styles.getEmptySA();
                        this._context.getRangeManager().getRange(CellBlock.getCellBlock(cb.getRow(), cb.getCol2() + 1, cb.getRow2(), cb.getCol2() + 1)).getStyle(sa, saI);
                        showOption = this.needShowOption(sa, saI);
                    }
                }
                if (!showOption && cb.getCol() > 0) {
                    if (SheetBaseMath.getColWidth(sheet, cb.getCol() - 1) != sheet.getDefColWidth()) {
                        showOption = true;
                    } else {
                        sa = Styles.getEmptySA();
                        saI = Styles.getEmptySA();
                        this._context.getRangeManager().getRange(CellBlock.getCellBlock(cb.getRow(), cb.getCol() - 1, cb.getRow2(), cb.getCol() - 1)).getStyle(sa, saI);
                        showOption = this.needShowOption(sa, saI);
                    }
                }
            }
            if (showOption) {
                this._insertView = this._context.getSpread().getActiveView();
                this._context.getFacadeManager().showInsertOption(this._insertView, rg, cb.isRow() ? true : (cb.isCol() ? false : this._yDir));
                this._dstSheet = this._context.getBook().getActiveSheet();
                ret = true;
            }
        }
        return ret;
    }

    private boolean needShowOption(StyleAttributes sa, StyleAttributes saI) {
        Style sheetStyle;
        if (!saI.isEmpty() && saI.get(ShareStyleAttributes.getBorderLineStyleIndex((Styles.Position)Styles.Position.LEFT)) != LineStyle.NULL_LINE && saI.get(ShareStyleAttributes.getBorderLineStyleIndex((Styles.Position)Styles.Position.TOP)) != LineStyle.NULL_LINE) {
            return true;
        }
        Book book = this._context.getBook();
        Style style = book.getStyle(book.getSSA(sa));
        return style != (sheetStyle = book.getActiveSheet().getStyle());
    }

    @Override
    public boolean stop(int forceKey) {
        FairyButton fb = this._context.getFacadeManager().getInsertOptionButton();
        this._insertView.remove((Component)((Object)fb));
        this._insertView.repaint(fb.getBounds());
        return true;
    }

    @Override
    public boolean cancel(int forceKey) {
        return this.stop(forceKey);
    }

    @Override
    public void changed(BookChangeEvent e) {
        if (e.isSheetActive() || e.isSheetInsert()) {
            FairyButton fb = this._context.getFacadeManager().getInsertOptionButton();
            fb.setVisible(this._dstSheet == this._context.getSpread().getBook().getActiveSheet());
        }
    }

    @Override
    public void changed(SheetChangeEvent e) {
        if (e.hasState(SheetChangeEvent.Changed_UndoRedo)) {
            FairyButton fb = this._context.getFacadeManager().getInsertOptionButton();
            fb.setVisible(false);
        }
    }
}

