/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.model.struct;

import com.kingdee.bos.ctrl.extcommon.util.SortedObjectArray;
import com.kingdee.bos.ctrl.extcommon.variant.Variant;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kds.model.struct.Cell;
import com.kingdee.bos.ctrl.kds.model.struct.CellBlock;
import com.kingdee.bos.ctrl.kds.model.struct.Selection;
import com.kingdee.bos.ctrl.kds.model.struct.Sheet;
import com.kingdee.bos.ctrl.kds.model.struct.UserObject;
import com.kingdee.bos.ctrl.kds.model.util.IntMarkEntry;
import com.kingdee.bos.ctrl.kds.model.util.SortedSheetArray;

public class CellFinder {
    public static final Variant CANT_REPLACE = new Variant("\u4e0d\u80fd\u66ff\u6362\u5f53\u524d\u5355\u5143\u683c", 11);
    public static final Variant CANT_FIND = new Variant("\u4e0d\u80fd\u67e5\u5230\u7b26\u5408\u6761\u4ef6\u7684\u5355\u5143\u683c", 11);
    public static final int SCOPE_IN_BOOK = 1;
    public static final int SCOPE_IN_SHEET = 0;
    public static final int ORDER_BY_ROW = 0;
    public static final int ORDER_BY_COLUMN = 1;
    private int _scope;
    private int _order;
    private ICellMatcher _cellMatcher;
    private ICellReplacer _cellReplacer;

    public void setCellMatcher(ICellMatcher cellMatcher) {
        this._cellMatcher = cellMatcher;
    }

    public void setCellReplacer(ICellReplacer cellReplacer) {
        this._cellReplacer = cellReplacer;
    }

    public ICellMatcher getCellMatcher() {
        return this._cellMatcher;
    }

    public ICellReplacer getCellReplacer() {
        return this._cellReplacer;
    }

    public int getScope() {
        return this._scope;
    }

    public void setScope(int scope) {
        this._scope = scope;
    }

    public int getOrder() {
        return this._order;
    }

    public void setOrder(int order) {
        this._order = order;
    }

    public Object findAll(Sheet sheet) {
        Selection sel = sheet.getSheetOption().getSelection();
        SortedObjectArray cells = new SortedObjectArray();
        if (this._scope == 1) {
            int sheetCount = sheet.getBook().getSheetCount();
            CellBlock block = CellBlock.getCellBlock(0, 0, 1048575, 65535);
            for (int i = 0; i < sheetCount; ++i) {
                Sheet tsheet = sheet.getBook().getSheet(i);
                cells.insertAll(this.findAllCells(tsheet, this.getCellMatcher(), block));
            }
        } else if (this._scope == 0) {
            if (sel.isBaseUnit()) {
                CellBlock block = CellBlock.getCellBlock(0, 0, 1048575, 65535);
                SortedSheetArray sheets = sheet.getBook().getSelectSheets();
                int sheetCount = sheets.size();
                for (int i = 0; i < sheetCount; ++i) {
                    Sheet tsheet = sheets.getSheet(i);
                    cells.insertAll(this.findAllCells(tsheet, this.getCellMatcher(), block));
                }
            } else {
                SortedSheetArray sheets = sheet.getBook().getSelectSheets();
                int sheetCount = sheets.size();
                for (int i = 0; i < sheetCount; ++i) {
                    Sheet tsheet = sheets.getSheet(i);
                    Selection.SelectIterator iter = sel.getSelectIterator();
                    while (iter.hasNext()) {
                        CellBlock block = iter.next();
                        cells.insertAll(this.findAllCells(tsheet, this.getCellMatcher(), block));
                    }
                }
            }
        }
        if (cells.isEmpty()) {
            return CANT_FIND;
        }
        return cells;
    }

    public Object findNext(Sheet sheet) {
        boolean bScopeSheet;
        Selection sel = sheet.getSheetOption().getSelection();
        Selection.ActivePosition retPos = new Selection.ActivePosition(sel);
        Cell retCell = null;
        int row = sel.getActiveRow();
        int col = sel.getActiveCol();
        boolean bRow = 0 == this._order;
        boolean bl = bScopeSheet = this._scope == 0;
        if (bScopeSheet && !sel.isBaseUnit()) {
            int fCol;
            int fRow;
            int fCol2;
            SortedSheetArray sheets = sheet.getBook().getSelectSheets();
            int sheetInx = sheets.search(sheet.getIntMark());
            int blockInx = sel.getActiveIndex();
            Sheet tsheet = sheet;
            CellBlock block = sel.getBlock(blockInx);
            retCell = this.findCell(tsheet, this.getCellMatcher(), block, true, row, col, true, bRow);
            if (retCell != null) {
                retPos.setRowCol(retCell.getRow(), retCell.getCol());
                retPos.setObject(retCell);
                return retPos;
            }
            CellBlocksIterator blockIter = new CellBlocksIterator(sel, blockInx, true, true);
            while (blockIter.hasNext()) {
                block = blockIter.next();
                int fRow2 = block.getRow();
                fCol2 = block.getCol();
                if (bRow) {
                    --fCol2;
                } else {
                    --fRow2;
                }
                if ((retCell = this.findCell(tsheet, this.getCellMatcher(), block, true, fRow2, fCol2, true, bRow)) == null) continue;
                retPos.setActive(retCell.getRow(), retCell.getCol(), blockIter.getCurIndex());
                retPos.setObject(retCell);
                return retPos;
            }
            if (sheetInx < sheets.size() - 1) {
                SheetsIterator sheetIter = new SheetsIterator(sheets, sheetInx, true, true);
                while (sheetIter.hasNext()) {
                    tsheet = sheetIter.next();
                    blockIter.reset(-1, true, true);
                    while (blockIter.hasNext()) {
                        fRow = block.getRow();
                        fCol = block.getCol();
                        if (bRow) {
                            --fCol;
                        } else {
                            --fRow;
                        }
                        if ((retCell = this.findCell(tsheet, this.getCellMatcher(), block, true, fRow, fCol, true, bRow)) == null) continue;
                        retPos.setActive(retCell.getRow(), retCell.getCol(), blockIter.getCurIndex());
                        retPos.setObject(retCell);
                        return retPos;
                    }
                }
            }
            if (sheetInx > 0) {
                SheetsIterator sheetIter = new SheetsIterator(sheets, sheetInx, true, false);
                while (sheetIter.hasNext()) {
                    tsheet = sheetIter.next();
                    blockIter.reset(-1, true, true);
                    while (blockIter.hasNext()) {
                        fRow = block.getRow();
                        fCol = block.getCol();
                        if (bRow) {
                            --fCol;
                        } else {
                            --fRow;
                        }
                        if ((retCell = this.findCell(tsheet, this.getCellMatcher(), block, true, fRow, fCol, true, bRow)) == null) continue;
                        retPos.setActive(retCell.getRow(), retCell.getCol(), blockIter.getCurIndex());
                        retPos.setObject(retCell);
                        return retPos;
                    }
                }
            }
            blockIter.reset(blockInx, true, false);
            while (blockIter.hasNext()) {
                block = blockIter.next();
                int fRow3 = block.getRow();
                fCol2 = block.getCol();
                if (bRow) {
                    --fCol2;
                } else {
                    --fRow3;
                }
                if ((retCell = this.findCell(tsheet, this.getCellMatcher(), block, true, fRow3, fCol2, true, bRow)) == null) continue;
                retPos.setActive(retCell.getRow(), retCell.getCol(), blockIter.getCurIndex());
                retPos.setObject(retCell);
                return retPos;
            }
            retCell = this.findCell(tsheet, this.getCellMatcher(), sel.getBlock(blockInx), false, row, col, true, bRow);
            if (retCell != null) {
                retPos.setRowCol(retCell.getRow(), retCell.getCol());
                retPos.setObject(retCell);
                return retPos;
            }
            return CANT_FIND;
        }
        int sheetInx4Find = sheet.getBook().getSheetIndexByName(sheet.getSheetName());
        int sheetCount = sheet.getBook().getSheetCount();
        CellBlock block = CellBlock.getCellBlock(0, 0, 1048575, 65535);
        retCell = this.findCell(sheet, this.getCellMatcher(), block, true, row, col, true, bRow);
        if (retCell != null) {
            retPos.setRowCol(retCell.getRow(), retCell.getCol());
            retPos.setObject(retCell);
            return retPos;
        }
        if (!bScopeSheet) {
            int fCol;
            int fRow;
            Sheet tsheet;
            int i;
            for (i = sheetInx4Find + 1; i < sheetCount; ++i) {
                tsheet = sheet.getBook().getSheet(i);
                fRow = block.getRow();
                fCol = block.getCol();
                if (bRow) {
                    --fCol;
                } else {
                    --fRow;
                }
                retCell = this.findCell(tsheet, this.getCellMatcher(), block, true, fRow, fCol, true, bRow);
                if (retCell == null) continue;
                retPos.setRowCol(retCell.getRow(), retCell.getCol());
                retPos.setObject(retCell);
                return retPos;
            }
            for (i = 0; i < sheetInx4Find; ++i) {
                tsheet = sheet.getBook().getSheet(i);
                fRow = block.getRow();
                fCol = block.getCol();
                if (bRow) {
                    --fCol;
                } else {
                    --fRow;
                }
                retCell = this.findCell(tsheet, this.getCellMatcher(), block, true, fRow, fCol, true, bRow);
                if (retCell == null) continue;
                retPos.setRowCol(retCell.getRow(), retCell.getCol());
                retPos.setObject(retCell);
                return retPos;
            }
        }
        if ((retCell = this.findCell(sheet, this.getCellMatcher(), block, false, row, col, true, bRow)) != null) {
            retPos.setRowCol(retCell.getRow(), retCell.getCol());
            retPos.setObject(retCell);
            return retPos;
        }
        return CANT_FIND;
    }

    public Object replace(Sheet sheet) {
        Selection sel = sheet.getSheetOption().getSelection();
        Cell curCell = sheet.getCell(sel.getActiveRow(), sel.getActiveCol(), false);
        if (curCell == null || !this.getCellMatcher().isMatched(curCell)) {
            return CANT_REPLACE;
        }
        SortedObjectArray sa = new SortedObjectArray();
        sa.insert(curCell);
        sheet.getRange(0, 0).replace(sa, this.getCellReplacer());
        return curCell;
    }

    public Object replaceAll(Sheet sheet) {
        Object cells = this.findAll(sheet);
        if (cells instanceof SortedObjectArray) {
            sheet.getRange(0, 0).replace((SortedObjectArray)cells, this.getCellReplacer());
        }
        return cells;
    }

    private Cell findCell(Sheet sheet, ICellMatcher matcher, CellBlock scopeB, boolean bSecPart, int afterRow, int afterCol, boolean bNext, boolean bRow) {
        Cell cell = null;
        cell = bNext && bRow ? this.getNextCellByRows(sheet, matcher, scopeB, bSecPart, afterRow, afterCol) : (bNext && !bRow ? this.getNextCellByColumns(sheet, matcher, scopeB, bSecPart, afterRow, afterCol) : (!bNext && bRow ? this.getPreviousCellByRows(sheet, matcher, scopeB, bSecPart, afterRow, afterCol) : this.getPreviousCellByColumns(sheet, matcher, scopeB, bSecPart, afterRow, afterCol)));
        return cell;
    }

    private SortedObjectArray findAllCells(Sheet sheet, ICellMatcher matcher, CellBlock scopeB) {
        SortedObjectArray cells = new SortedObjectArray();
        Sheet.ICellsIterator iter = sheet.getCellsIterator(scopeB, true, true);
        while (iter.hasNext()) {
            Cell cell = iter.next();
            if (matcher == null || !matcher.isMatched(cell)) continue;
            cells.insert(cell);
        }
        return cells;
    }

    private Cell getPreviousCellByRows(Sheet sheet, ICellMatcher matcher, CellBlock scopeB, boolean bSecPart, int afterRow, int afterCol) {
        Cell cell = null;
        Sheet.ICellsIterator iter = null;
        if (!bSecPart) {
            iter = sheet.getCellsIterator(afterRow, scopeB.getCol(), afterRow, afterCol - 1, true, true);
            cell = this.findCell(iter, matcher);
            if (cell != null) {
                return cell;
            }
            iter = sheet.getCellsIterator(scopeB.getRow(), scopeB.getCol(), afterRow - 1, scopeB.getCol2(), true, true);
            cell = this.findCell(iter, matcher);
            if (cell != null) {
                return cell;
            }
        } else {
            iter = sheet.getCellsIterator(afterRow + 1, scopeB.getCol(), scopeB.getRow2(), scopeB.getCol2(), true, true);
            cell = this.findCell(iter, matcher);
            if (cell != null) {
                return cell;
            }
            iter = sheet.getCellsIterator(afterRow, afterCol, afterRow, scopeB.getCol2(), true, true);
            cell = this.findCell(iter, matcher);
            if (cell != null) {
                return cell;
            }
        }
        return cell;
    }

    private Cell getPreviousCellByColumns(Sheet sheet, ICellMatcher matcher, CellBlock scopeB, boolean bSecPart, int afterRow, int afterCol) {
        Cell cell = null;
        Sheet.ICellsIterator iter = null;
        if (!bSecPart) {
            iter = sheet.getCellsIterator(scopeB.getRow(), afterCol, afterRow - 1, afterCol, true, true);
            cell = this.findCell(iter, matcher);
            if (cell != null) {
                return cell;
            }
            IntMarkEntry[] actualCols = sheet.getCols().subset(scopeB.getCol(), afterCol - 1);
            cell = this.findCellByColumns(sheet, actualCols, matcher, scopeB.getRow(), scopeB.getRow2(), false);
            if (cell != null) {
                return cell;
            }
        } else {
            IntMarkEntry[] actualCols = sheet.getCols().subset(afterCol + 1, scopeB.getCol2());
            cell = this.findCellByColumns(sheet, actualCols, matcher, scopeB.getRow(), scopeB.getRow2(), false);
            if (cell != null) {
                return cell;
            }
            iter = sheet.getCellsIterator(afterRow, afterCol, scopeB.getRow2(), afterCol, true, true);
            cell = this.findCell(iter, matcher);
            if (cell != null) {
                return cell;
            }
        }
        return cell;
    }

    private Cell getNextCellByRows(Sheet sheet, ICellMatcher matcher, CellBlock scopeB, boolean bSecPart, int afterRow, int afterCol) {
        Cell cell = null;
        if (bSecPart) {
            Sheet.ICellsIterator iter = sheet.getCellsIterator(afterRow, afterCol + 1, afterRow, scopeB.getCol2(), false, true);
            cell = this.findCell(iter, matcher);
            if (cell != null) {
                return cell;
            }
            iter = sheet.getCellsIterator(afterRow + 1, scopeB.getCol(), scopeB.getRow2(), scopeB.getCol2(), false, true);
            cell = this.findCell(iter, matcher);
            if (cell != null) {
                return cell;
            }
        } else {
            Sheet.ICellsIterator iter = sheet.getCellsIterator(scopeB.getRow(), scopeB.getCol(), afterRow - 1, scopeB.getCol2(), false, true);
            cell = this.findCell(iter, matcher);
            if (cell != null) {
                return cell;
            }
            iter = sheet.getCellsIterator(afterRow, scopeB.getCol(), afterRow, afterCol, false, true);
            cell = this.findCell(iter, matcher);
            if (cell != null) {
                return cell;
            }
        }
        return cell;
    }

    private Cell getNextCellByColumns(Sheet sheet, ICellMatcher matcher, CellBlock scopeB, boolean bSecPart, int afterRow, int afterCol) {
        Cell cell = null;
        if (bSecPart) {
            Sheet.ICellsIterator iter = sheet.getCellsIterator(afterRow + 1, afterCol, scopeB.getRow2(), afterCol, false, true);
            cell = this.findCell(iter, matcher);
            if (cell != null) {
                return cell;
            }
            IntMarkEntry[] actualCols = sheet.getCols().subset(afterCol + 1, scopeB.getCol2());
            cell = this.findCellByColumns(sheet, actualCols, matcher, scopeB.getRow(), scopeB.getRow2(), true);
            if (cell != null) {
                return cell;
            }
        } else {
            IntMarkEntry[] actualCols = sheet.getCols().subset(scopeB.getCol(), afterCol - 1);
            cell = this.findCellByColumns(sheet, actualCols, matcher, scopeB.getRow(), scopeB.getRow2(), true);
            if (cell != null) {
                return cell;
            }
            Sheet.ICellsIterator iter = sheet.getCellsIterator(scopeB.getRow(), afterCol, afterRow, afterCol, false, true);
            cell = this.findCell(iter, matcher);
            if (cell != null) {
                return cell;
            }
        }
        return cell;
    }

    private Cell findCell(Sheet.ICellsIterator iter, ICellMatcher matcher) {
        Cell retCell = null;
        while (iter.hasNext()) {
            retCell = iter.next();
            if (matcher != null && matcher.isMatched(retCell)) break;
            retCell = null;
        }
        return retCell;
    }

    private Cell findCellByColumns(Sheet sheet, IntMarkEntry[] cols, ICellMatcher matcher, int row1, int row2, boolean bNext) {
        Cell cell = null;
        if (cols != null) {
            int cIndex;
            Sheet.ICellsIterator iter;
            int start = bNext ? 0 : cols.length - 1;
            int end = bNext ? cols.length - 1 : 0;
            int delta = bNext ? 1 : -1;
            for (int i = start; i != end + delta && (cell = this.findCell(iter = sheet.getCellsIterator(row1, cIndex = cols[i].getIntMark(), row2, cIndex, !bNext, true), matcher)) == null; i += delta) {
            }
        }
        return cell;
    }

    public static interface ICellReplacer {
        public StyleAttributes getReplaceSA();

        public StyleAttributes getSA(Cell var1);

        public String getFormula(Cell var1);

        public UserObject getUseObject(Cell var1);

        public boolean canReplaceStyle();

        public boolean canReplaceFormula();

        public boolean canReplaceUseObject();
    }

    public static interface ICellMatcher {
        public boolean isMatched(Cell var1);
    }

    private class CellBlocksIterator {
        private Selection _sel;
        private int _dIndex;
        private int _curIndex;
        private boolean _bAscend;
        private boolean _bSecPart;

        CellBlocksIterator(Selection sel, int dividIndex, boolean bAscend, boolean bSecPart) {
            this._sel = sel;
            this.reset(dividIndex, bAscend, bSecPart);
        }

        public void reset(int dividIndex, boolean bAscend, boolean bSecPart) {
            this._dIndex = dividIndex;
            this._bAscend = bAscend;
            this._bSecPart = bSecPart;
            this._curIndex = this._bSecPart ? (this._bAscend ? this._dIndex : this._sel.size()) : (this._bAscend ? -1 : this._dIndex);
        }

        public int getCurIndex() {
            return this._curIndex;
        }

        public void getNextIndex() {
            this._curIndex = this._bAscend ? this._curIndex + 1 : this._curIndex - 1;
        }

        public boolean hasNext() {
            this.getNextIndex();
            return this._bSecPart ? (this._bAscend ? this._curIndex < this._sel.size() : this._curIndex > this._dIndex) : (this._bAscend ? this._curIndex < this._dIndex : this._curIndex > 0);
        }

        public CellBlock next() {
            return this._sel.getBlock(this._curIndex);
        }
    }

    private class SheetsIterator {
        protected int _dIndex;
        protected int _curIndex;
        protected boolean _bAscend;
        protected boolean _bSecPart;
        private SortedSheetArray _sheets;

        SheetsIterator(SortedSheetArray sheets, int dividIndex, boolean bAscend, boolean bSecPart) {
            this.reset(sheets, dividIndex, bAscend, bSecPart);
        }

        public void reset(SortedSheetArray sheets, int dividIndex, boolean bAscend, boolean bSecPart) {
            this._dIndex = dividIndex;
            this._bAscend = bAscend;
            this._bSecPart = bSecPart;
            this.getNextIndex();
        }

        public void getNextIndex() {
            this._curIndex = this._bSecPart ? (this._bAscend ? this._dIndex + 1 : this._sheets.size() - 1) : (this._bAscend ? 0 : this._dIndex - 1);
        }

        public int getCurIndex() {
            return this._curIndex;
        }

        public boolean hasNext() {
            return this._bSecPart ? (this._bAscend ? this._curIndex < this._sheets.size() : this._curIndex > this._dIndex) : (this._bAscend ? this._curIndex < this._dIndex : this._curIndex > 0);
        }

        public Sheet next() {
            return this._sheets.getSheet(this._curIndex);
        }
    }
}

