/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.model.struct;

public class Span
implements Comparable,
Cloneable {
    protected int _start;
    protected int _end;

    public Span(int start, int end) {
        this.setPos(start, end);
    }

    public Span(Span span) {
        this._start = span._start;
        this._end = span._end;
    }

    public Span setPos(int start, int end) {
        if (start <= end) {
            this._start = start;
            this._end = end;
        } else {
            this._start = end;
            this._end = start;
        }
        return this;
    }

    public Object clone() {
        Object obj = null;
        try {
            obj = super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return obj;
    }

    public int getStart() {
        return this._start;
    }

    public void setStart(int start) {
        if (this._start != start) {
            this.setPos(start, this._end);
        }
    }

    public int getEnd() {
        return this._end;
    }

    public void setEnd(int end) {
        if (this._end != end) {
            this.setPos(this._start, end);
        }
    }

    public void offset(int offset) {
        this._start += offset;
        this._end += offset;
    }

    public Span increase(int startStep, int endStep) {
        this._start -= startStep;
        this._end += endStep;
        return this;
    }

    public int getExtent() {
        return this._end - this._start + 1;
    }

    public boolean contains(int pos) {
        return pos >= this._start && pos <= this._end;
    }

    public boolean contains(Span range) {
        return range._start >= this._start && range._end <= this._end;
    }

    public boolean isSeparate(Span range) {
        return this._start > range._end + 1 || this._end < range._start - 1;
    }

    public boolean isIntersect(Span range) {
        return this._start <= range._end && this._end >= range._start;
    }

    public int trim(Span trim, Span strip) {
        if (this._start > trim._end || this._end < trim._start) {
            return 0;
        }
        int trimDir = 0;
        if (trim._start <= this._start) {
            strip._start = this._start;
            this._start = trim._end + 1;
            strip._end = this._start - 1;
            this._end = Math.max(this._end, trim._end - 1);
            trimDir = -1;
        } else if (trim._end >= this._end) {
            strip._end = this._end;
            this._end = trim._start - 1;
            strip._start = this._end + 1;
            trimDir = 1;
        }
        return trimDir;
    }

    public boolean isReversed() {
        return this._start > this._end;
    }

    public boolean followBy(Span sp) {
        return this._end == sp.getStart() - 1;
    }

    public boolean isSameAttrs(Span as) {
        return this.equals(as);
    }

    public boolean union(Span range) {
        if (!this.isSeparate(range)) {
            this._start = Math.min(this._start, range._start);
            this._end = Math.max(this._end, range._end);
            return true;
        }
        return false;
    }

    public int compareTo(Object obj) {
        if (this == obj) {
            return 0;
        }
        if (obj instanceof Span) {
            Span cmp = (Span)obj;
            return this._end < cmp._start ? -1 : (this._start > cmp._end ? 1 : 0);
        }
        return -1;
    }

    public int compareToPos(int pos) {
        return pos < this._start ? 1 : (pos > this._end ? -1 : 0);
    }

    public int hashCode() {
        return this._start << 16 | this._end;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Span) {
            Span cmp = (Span)obj;
            return this._start == cmp._start && this._end == cmp._end;
        }
        return false;
    }

    public String toString() {
        return "[" + this._start + "," + this._end + "]=" + this.getExtent();
    }
}

