/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.model.struct;

import com.kingdee.bos.ctrl.extcommon.util.ObjectArray;
import com.kingdee.bos.ctrl.extcommon.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.extcommon.variant.Variant;
import com.kingdee.bos.ctrl.kds.model.expr.Expr;
import com.kingdee.bos.ctrl.kds.model.expr.ExprConst;
import com.kingdee.bos.ctrl.kds.model.expr.ExprContext;
import com.kingdee.bos.ctrl.kds.model.expr.ExprMethod;
import com.kingdee.bos.ctrl.kds.model.expr.ExprOperator;
import com.kingdee.bos.ctrl.kds.model.expr.IExprNode;
import com.kingdee.bos.ctrl.kds.model.struct.FillType;
import com.kingdee.bos.ctrl.kds.model.struct.Parameter;
import com.kingdee.bos.ctrl.kds.model.struct.PartNumberString;
import com.kingdee.bos.ctrl.kds.model.struct.Sheet;
import com.kingdee.bos.ctrl.kds.model.struct.Span;
import com.kingdee.bos.ctrl.kds.model.struct.TrendFactor;
import com.kingdee.bos.ctrl.kds.model.struct.UDFSerials;
import com.kingdee.bos.ctrl.kds.model.util.SortedParameterArray;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;

public class TrendHelper {
    public static void makeFactor(Sheet sheet, Object[] aFactor, FillType goalType, FillType resultType) {
        Object obj;
        int i;
        int from = -1;
        int to = -1;
        Object groupType = FillType.COPY;
        for (i = 0; i < aFactor.length; ++i) {
            Object thisType;
            obj = aFactor[i];
            if (obj == null) {
                to = i;
                continue;
            }
            Variant var = (Variant)obj;
            if (var.isNumber()) {
                thisType = FillType.NUMBER;
            } else if (var.isDate()) {
                thisType = FillType.DATE;
            } else if (var.isEmpty()) {
                thisType = FillType.SERIES;
            } else {
                String strValue = var.toString();
                UDFSerials.UDFSerial al = UDFSerials.getSerial(strValue);
                if (al != null) {
                    thisType = al;
                } else {
                    PartNumberString pnStr = TrendHelper.parsePartNumber(strValue);
                    if (pnStr != null) {
                        thisType = pnStr;
                        aFactor[i] = pnStr;
                    } else {
                        thisType = FillType.COPY;
                    }
                }
            }
            if (from < 0) {
                from = to = i;
                groupType = thisType;
                continue;
            }
            if (groupType.equals(thisType) && thisType != FillType.SERIES) {
                to = i;
                continue;
            }
            TrendHelper.calcGroupFactor(sheet, aFactor, goalType, from, to, groupType, resultType);
            from = to = i;
            groupType = thisType;
        }
        if (from >= 0) {
            TrendHelper.calcGroupFactor(sheet, aFactor, goalType, from, to, groupType, resultType);
        }
        if (resultType != null) {
            for (i = 0; i < aFactor.length; ++i) {
                obj = aFactor[i];
                if (obj == null || !(obj instanceof TrendFactor)) continue;
                resultType.setFlag(((TrendFactor)obj).getType(), true);
            }
        }
    }

    private static PartNumberString parsePartNumber(String str) {
        Span sp = null;
        for (int i = str.length() - 1; i >= 0; --i) {
            char ch = str.charAt(i);
            if (ch >= '0' && ch <= '9') {
                if (sp == null) {
                    sp = new Span(i, i);
                    continue;
                }
                sp.setStart(i);
                continue;
            }
            if (sp != null) break;
        }
        if (sp == null) {
            return null;
        }
        return new PartNumberString(str, sp);
    }

    public static void getFunctionInfo(Sheet sheet, Expr expr, HashMap bag, HashMap pos) {
        if (expr.isSyntaxError() || !expr.hasMethod()) {
            return;
        }
        int[] uid = new int[]{0};
        ExprContext ctx = new ExprContext(sheet.getBook(), sheet.getDeps());
        ObjectArray list = expr.getDecodeList(ctx);
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            int type = ((IExprNode)list.get(i)).getExprType();
            if (type != 128) continue;
            i = TrendHelper.function(list, i, bag, pos, uid);
        }
    }

    private static int function(ObjectArray list, int from, HashMap bag, HashMap pos, int[] uid) {
        int i;
        ExprMethod method = (ExprMethod)list.get(from);
        boolean hasParameter = method.getParamCount() > 0;
        boolean bFill = method.isFillParameter();
        Variant param = Variant.nullVariant;
        ArrayList<Variant> al = bFill ? new ArrayList<Variant>() : null;
        ArrayList<Object> aPos = bFill ? new ArrayList<Object>() : null;
        int size = list.size();
        int lpCount = 0;
        for (i = from + 1; i < size; ++i) {
            IExprNode node = (IExprNode)list.get(i);
            int type = node.getExprType();
            if (type == 128) {
                i = TrendHelper.function(list, i, bag, pos, uid);
                continue;
            }
            if (type == 2) {
                Variant value;
                IExprNode nextNode;
                if (!bFill) continue;
                IExprNode iExprNode = nextNode = i + 1 >= size ? null : (IExprNode)list.get(i + 1);
                if (nextNode != ExprOperator.COMMA && nextNode != ExprOperator.RP) continue;
                param = value = ((ExprConst)node).getValue();
                continue;
            }
            if (node == ExprOperator.COMMA) {
                if (bFill) {
                    al.add(param);
                    aPos.add(new Integer(i - 1));
                }
                param = Variant.nullVariant;
                continue;
            }
            if (node == ExprOperator.LP) {
                ++lpCount;
                continue;
            }
            if (node != ExprOperator.RP || --lpCount > 0) continue;
            if (!hasParameter || !bFill) break;
            al.add(param);
            aPos.add(new Integer(i - 1));
            break;
        }
        if (bFill) {
            String methodName = method.getName();
            SortedParameterArray sa = (SortedParameterArray)bag.get(methodName);
            if (sa == null) {
                sa = new SortedParameterArray();
                bag.put(methodName, sa);
            }
            Parameter p = new Parameter(al.toArray(), "");
            aPos.add(method);
            aPos.add(p);
            pos.put(new Integer(uid[0]), aPos);
            int n = uid[0];
            uid[0] = n + 1;
            p.setUID(new Integer(n));
            sa.insert(p);
        }
        return i;
    }

    private static void calcGroupFactor(Sheet sheet, Object[] aFactor, FillType goalType, int from, int to, Object groupType, FillType resultType) {
        try {
            if (goalType.touchFlag(34)) {
                if (groupType instanceof UDFSerials.UDFSerial) {
                    TrendHelper.calcSerialFactor(aFactor, from, to, goalType, resultType);
                    return;
                }
                if (groupType instanceof PartNumberString) {
                    TrendHelper.calcTrendFactor(aFactor, from, to, true, goalType, resultType, true);
                    return;
                }
                if (groupType instanceof FillType) {
                    FillType gType = (FillType)groupType;
                    if (gType.touchFlag(4)) {
                        TrendHelper.calcTrendFactor(aFactor, from, to, true, goalType, resultType, false);
                        return;
                    }
                    if (gType.touchFlag(16)) {
                        TrendHelper.calcDateFactor(aFactor, from, to, goalType, resultType);
                        return;
                    }
                    if (gType.includeFlag(514)) {
                        TrendHelper.calcFunctionFactor(sheet, aFactor, from, to, goalType, resultType);
                        return;
                    }
                }
            } else if (goalType == FillType.GROWTHTREND) {
                if (groupType instanceof FillType && ((FillType)groupType).touchFlag(4)) {
                    TrendHelper.calcTrendFactor(aFactor, from, to, true, goalType, resultType, false);
                    return;
                }
            } else if (goalType == FillType.LINEARTREND) {
                if (groupType instanceof FillType && ((FillType)groupType).touchFlag(8)) {
                    TrendHelper.calcTrendFactor(aFactor, from, to, false, goalType, resultType, false);
                    return;
                }
            } else {
                if (goalType.touchFlag(208)) {
                    TrendHelper.calcDateFactor(aFactor, from, to, goalType, resultType);
                    return;
                }
                if (goalType == FillType.FORMAT) {
                    TrendHelper.fillFormatFactor(aFactor, from, to);
                    return;
                }
            }
            TrendHelper.fillCopyFactor(aFactor, from, to);
        }
        catch (SyntaxErrorException e) {
            e.printStackTrace();
        }
    }

    private static void calcSerialFactor(Object[] aFactor, int from, int to, FillType ft, FillType resultType) {
        UDFSerials.UDFSerial serial = UDFSerials.getSerial(aFactor[from].toString());
        Integer step = null;
        int prevIndex = -1;
        for (int i = from; i <= to; ++i) {
            Object obj = aFactor[i];
            if (obj == null) continue;
            int index = UDFSerials.getSerialIndex(serial, obj.toString());
            if (prevIndex >= 0) {
                int offset = index - prevIndex;
                if (step == null) {
                    step = new Integer(offset);
                } else if (step != offset) {
                    TrendHelper.fillFactor(aFactor, from, to, null, null, 256);
                    return;
                }
            }
            prevIndex = index;
        }
        if (step == null) {
            step = new Integer(1);
        }
        int type = ft == FillType.WEEKDAYS && serial.isWeek() ? 32 : 2;
        TrendHelper.fillFactor(aFactor, from, to, (Variant)aFactor[from], new Variant(step, 3), type);
        if (resultType != null && serial.isWeek()) {
            resultType.addFlag(32);
        }
    }

    private static void calcDateFactor(Object[] aFactor, int from, int to, FillType goalType, FillType resultType) throws SyntaxErrorException {
        Variant step = null;
        Variant prev = null;
        for (int i = from; i <= to; ++i) {
            Object obj = aFactor[i];
            if (obj == null) continue;
            Variant date = (Variant)obj;
            if (prev != null) {
                if (step == null) {
                    step = new Variant();
                    date.subtract(prev, step);
                } else {
                    Variant tmp = new Variant();
                    date.subtract(prev, tmp);
                    if (!step.equals(tmp)) {
                        TrendHelper.fillFactor(aFactor, from, to, null, null, 256);
                        return;
                    }
                }
            }
            prev = date;
        }
        if (step == null) {
            step = new Variant(86400000L);
        }
        int type = 16;
        if (goalType.touchFlag(32)) {
            type = 32;
        } else if (goalType.touchFlag(64)) {
            type = 64;
        } else if (goalType.touchFlag(128)) {
            type = 128;
        }
        TrendHelper.fillFactor(aFactor, from, to, (Variant)aFactor[from], step, type);
        if (resultType != null) {
            resultType.addFlag(240);
        }
    }

    private static void calcFunctionFactor(Sheet sheet, Object[] aFactor, int from, int to, FillType goalType, FillType resultType) {
        if (from != to) {
            TrendHelper.fillCopyFactor(aFactor, from, to);
            return;
        }
        HashMap bag = new HashMap();
        HashMap pos = new HashMap();
        TrendHelper.getFunctionInfo(sheet, (Expr)((Variant)aFactor[from]).getValue(), bag, pos);
        if (!bag.isEmpty()) {
            Variant a = new Variant(bag, 17);
            Variant b = new Variant(pos, 17);
            TrendHelper.fillFactor(aFactor, from, to, a, b, 514);
        } else {
            TrendHelper.fillCopyFactor(aFactor, from, to);
        }
    }

    private static void fillFactor(Object[] aFactor, int from, int to, Variant a, Variant b, int type) {
        if (a == null) {
            TrendFactor tf = new TrendFactor(type, a, b, from, 0, 0);
            for (int i = from; i <= to; ++i) {
                if (aFactor[i] == null) continue;
                aFactor[i] = tf;
            }
        } else {
            int count = 0;
            for (int i = from; i <= to; ++i) {
                if (aFactor[i] == null) continue;
                ++count;
            }
            int ix = 0;
            for (int i = from; i <= to; ++i) {
                if (aFactor[i] == null) continue;
                aFactor[i] = new TrendFactor(type, a, b, from, count, ix++);
            }
        }
    }

    private static void fillCopyFactor(Object[] aFactor, int from, int to) {
        TrendHelper.fillFactor(aFactor, from, to, null, null, 256);
    }

    private static void fillFormatFactor(Object[] aFactor, int from, int to) {
        TrendHelper.fillFactor(aFactor, from, to, null, null, 512);
    }

    private static void calcTrendFactor(Object[] aFactor, int from, int to, boolean growthTrend, FillType goalType, FillType resultType, boolean partNumber) throws SyntaxErrorException {
        int type;
        Variant b;
        Variant a;
        int n = to - from + 1;
        if (n <= 0) {
            return;
        }
        if (n == 1) {
            Variant a2;
            if (partNumber) {
                PartNumberString pns = (PartNumberString)aFactor[from];
                pns.setA(new Variant(pns.getValue()));
                a2 = new Variant(pns, 17);
            } else {
                a2 = (Variant)aFactor[from];
            }
            if (goalType == FillType.DEFAULT) {
                if (resultType != null) {
                    resultType.addFlag(2);
                    resultType.setStatCount(1);
                }
                if (partNumber) {
                    aFactor[from] = new TrendFactor(6, a2, new Variant(1), from, 1, 0);
                } else {
                    TrendHelper.fillCopyFactor(aFactor, from, to);
                }
            } else {
                aFactor[from] = new TrendFactor(partNumber ? 6 : 4, a2, new Variant(1), from, 1, 0);
            }
            return;
        }
        BigDecimal zero = new BigDecimal(0.0);
        Variant X = new Variant(zero, 10);
        Variant Y = new Variant(zero, 10);
        Variant XY = new Variant(zero, 10);
        Variant X2 = new Variant(zero, 10);
        boolean bError = false;
        int count = 0;
        Variant y = new Variant();
        Variant x = new Variant();
        Variant x2 = new Variant();
        Variant xy = new Variant();
        for (int i = from; i <= to; ++i) {
            Object obj = aFactor[i];
            if (obj == null) continue;
            if (growthTrend) {
                y = partNumber ? new Variant(((PartNumberString)obj).getValue()) : new Variant((Variant)obj);
            } else {
                double df;
                double d = df = partNumber ? ((PartNumberString)obj).getValue() : ((Variant)obj).doubleValue();
                if (df <= 0.0) {
                    bError = true;
                    break;
                }
                y.setObject(new BigDecimal(String.valueOf(Math.log(df))), 10);
            }
            Y.add(y);
            x.setInt(count++);
            X.add(x);
            x.multiply(x, x2);
            X2.add(x2);
            y.multiply(x, xy);
            XY.add(xy);
        }
        Variant c = new Variant(count);
        Variant den = new Variant(X2);
        den.multiply(c);
        Variant tmp = new Variant(X);
        tmp.multiply(tmp);
        den.subtract(tmp);
        if (bError) {
            a = new Variant(Y);
            b = new Variant(new BigDecimal("0"), 10);
        } else {
            double df;
            Variant tmp2;
            b = new Variant(XY);
            if (!bError) {
                b.multiply(c);
                tmp2 = new Variant(X);
                tmp2.multiply(Y);
                b.subtract(tmp2);
                if (den.doubleValue() == 0.0) {
                    b = new Variant(new BigDecimal("0"), 10);
                } else {
                    b.divide(den);
                    if (!growthTrend) {
                        df = Math.exp(b.doubleValue());
                        b.setObject(new BigDecimal(String.valueOf(df)), 10);
                    }
                }
            }
            a = new Variant(Y);
            if (growthTrend) {
                a.divide(c);
                X.divide(c);
                X.multiply(b);
                a.subtract(X);
            } else {
                a.multiply(X2);
                tmp2 = new Variant(X);
                tmp2.multiply(XY);
                a.subtract(tmp2);
                a.divide(den);
                if (!growthTrend) {
                    df = Math.exp(a.doubleValue());
                    a.setObject(new BigDecimal(String.valueOf(df)), 10);
                }
            }
        }
        int n2 = partNumber ? 6 : (type = growthTrend ? 4 : 8);
        if (partNumber) {
            PartNumberString pns = (PartNumberString)aFactor[from];
            pns.setA(a);
            a = new Variant(pns, 17);
        }
        TrendHelper.fillFactor(aFactor, from, to, a, b, type);
    }
}

