/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.model.struct.borders;

import com.kingdee.bos.ctrl.extcommon.util.ObjectArray;
import com.kingdee.bos.ctrl.extcommon.util.SortedObjectArray;
import com.kingdee.bos.ctrl.extcommon.variant.WeakHashSet;
import com.kingdee.bos.ctrl.kdf.util.style.LineStyle;
import com.kingdee.bos.ctrl.kdf.util.style.PenStyle;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.kds.model.struct.Cell;
import com.kingdee.bos.ctrl.kds.model.struct.CellBlock;
import com.kingdee.bos.ctrl.kds.model.struct.MergeBlocks;
import com.kingdee.bos.ctrl.kds.model.struct.Sheet;
import com.kingdee.bos.ctrl.kds.model.struct.SortedAttributeSpanArray;
import com.kingdee.bos.ctrl.kds.model.struct.Span;
import com.kingdee.bos.ctrl.kds.model.struct.borders.Border;
import com.kingdee.bos.ctrl.kds.model.struct.borders.BorderSpan;
import com.kingdee.bos.ctrl.kds.model.struct.borders.BordersSpan;
import com.kingdee.bos.ctrl.kds.model.struct.borders.SortedBorderSpanArray;
import com.kingdee.bos.ctrl.kds.model.struct.borders.SortedBordersSpanArray;
import java.awt.Color;
import java.util.Iterator;

public class Borders {
    private static final WeakHashSet _bdrs = new WeakHashSet();
    private Sheet _sheet;
    private SortedBordersSpanArray _rows;
    private SortedBordersSpanArray _cols;

    public static Border getBorder(PenStyle ps, LineStyle ls, Color clr) {
        Border bdr = new Border(ps, ls, clr);
        Object obj = _bdrs.get(bdr);
        if (obj == null) {
            bdr.setUID(Styles.getUID());
            _bdrs.add(bdr);
        } else {
            bdr = (Border)obj;
        }
        return bdr;
    }

    public static Border getBorderFromSSA(ShareStyleAttributes ssa, Styles.Position pos) {
        return Borders.getBorder(ssa.getBorderPenStyle(pos), ssa.getBorderLineStyle(pos), ssa.getBorderColor(pos));
    }

    public Borders(Sheet sheet) {
        this._sheet = sheet;
        this._rows = new SortedBordersSpanArray(sheet, false);
        this._cols = new SortedBordersSpanArray(sheet, true);
    }

    public boolean isEmpty() {
        return this._rows.isEmpty() && this._cols.isEmpty();
    }

    public void clear() {
        this._rows.clear();
        this._cols.clear();
    }

    private int getPos(CellBlock cb, Styles.Position dir) {
        int pos;
        switch (dir.getIndex()) {
            case 0: {
                pos = cb.getCol() - 1;
                break;
            }
            case 1: {
                pos = cb.getRow() - 1;
                break;
            }
            case 2: {
                pos = cb.getCol2();
                break;
            }
            default: {
                pos = cb.getRow2();
            }
        }
        return pos;
    }

    private boolean mixOneSide(CellBlock cb, StyleAttributes sa, Styles.Position dir) {
        SortedBordersSpanArray root;
        boolean vert;
        if (dir == Styles.Position.LEFT || dir == Styles.Position.RIGHT) {
            vert = true;
            root = this._cols;
        } else {
            vert = false;
            root = this._rows;
        }
        int pos = root.searchSpan(this.getPos(cb, dir));
        if (pos >= 0) {
            SortedBorderSpanArray bdrArray = root.getBordersSpan(pos).getBorderArray();
            return this.mixOneSide(sa, dir, bdrArray, vert ? cb.getRow() : cb.getCol(), vert ? cb.getRow2() : cb.getCol2());
        }
        this.fillSA(sa, dir, this._sheet.getDefaultBorder(vert));
        return false;
    }

    private boolean mixOneSide(StyleAttributes sa, Styles.Position dir, SortedBorderSpanArray array, int from, int to) {
        int clrIndex = ShareStyleAttributes.getBorderColorIndex((Styles.Position)dir);
        int psIndex = ShareStyleAttributes.getBorderPenStyleIndex((Styles.Position)dir);
        int lsIndex = ShareStyleAttributes.getBorderLineStyleIndex((Styles.Position)dir);
        boolean clrMixed = sa.isMixedAttribute(clrIndex);
        boolean psMixed = sa.isMixedAttribute(psIndex);
        boolean lsMixed = sa.isMixedAttribute(lsIndex);
        boolean allMixed = false;
        Iterator i = array.iterator(from, to, true);
        while (i.hasNext()) {
            Border bdr = ((BorderSpan)i.next()).getBorder();
            if (!clrMixed) {
                boolean bl = clrMixed = sa.putMix(clrIndex, (Object)bdr.getColor()) == 2;
            }
            if (!psMixed) {
                boolean bl = psMixed = sa.putMix(psIndex, (Object)bdr.getPenStyle()) == 2;
            }
            if (!lsMixed) {
                boolean bl = lsMixed = sa.putMix(lsIndex, (Object)bdr.getLineStyle()) == 2;
            }
            if (!clrMixed || !psMixed || !lsMixed) continue;
            allMixed = true;
            break;
        }
        return allMixed;
    }

    public void fillSA(StyleAttributes sa, Styles.Position pos, Border bdr) {
        sa.setBorderColor(pos, bdr.getColor());
        sa.setBorderPenStyle(pos, bdr.getPenStyle());
        sa.setBorderLineStyle(pos, bdr.getLineStyle());
    }

    public Border getCellBorder(int row, int col, boolean vert) {
        SortedBorderSpanArray bdrArray;
        SortedBordersSpanArray root = vert ? this._cols : this._rows;
        int pos = root.searchSpan(vert ? col : row);
        if (pos >= 0 && (pos = (bdrArray = root.getBordersSpan(pos).getBorderArray()).searchSpan(vert ? row : col)) >= 0) {
            return bdrArray.getBorderSpan(pos).getBorder();
        }
        return this._sheet.getDefaultBorder(vert);
    }

    public void getCellBorders(int row, int col, CellBlock mergeBlock, StyleAttributes sa) {
        this.fillSA(sa, Styles.Position.LEFT, this.getCellBorder(row, col - 1, true));
        this.fillSA(sa, Styles.Position.TOP, this.getCellBorder(row - 1, col, false));
        if (mergeBlock == null) {
            this.fillSA(sa, Styles.Position.RIGHT, this.getCellBorder(row, col, true));
            this.fillSA(sa, Styles.Position.BOTTOM, this.getCellBorder(row, col, false));
        } else {
            row = mergeBlock.getRow2();
            col = mergeBlock.getCol2();
            this.fillSA(sa, Styles.Position.RIGHT, this.getCellBorder(row, col, true));
            this.fillSA(sa, Styles.Position.BOTTOM, this.getCellBorder(row, col, false));
        }
        sa.clearDirtyFlag();
    }

    public void getMixedOuterBorders(CellBlock cb, StyleAttributes sa) {
        if (cb.isSingleCell()) {
            this.getCellBorders(cb.getRow(), cb.getCol(), null, sa);
        } else {
            this.mixOneSide(cb, sa, Styles.Position.LEFT);
            this.mixOneSide(cb, sa, Styles.Position.TOP);
            this.mixOneSide(cb, sa, Styles.Position.RIGHT);
            this.mixOneSide(cb, sa, Styles.Position.BOTTOM);
            sa.clearDirtyFlag();
        }
    }

    public void getMixedInnerBorders(CellBlock cb, StyleAttributes sa) {
        block4: {
            SortedBorderSpanArray bdrArray;
            Iterator i;
            if (cb.isSingleCell()) {
                return;
            }
            if (cb.getWidth() > 1) {
                i = this._cols.iterator(cb.getCol(), cb.getCol2() - 1, true);
                while (i.hasNext() && !this.mixOneSide(sa, Styles.Position.INNER_V, bdrArray = ((BordersSpan)i.next()).getBorderArray(), cb.getRow(), cb.getRow2())) {
                }
            }
            if (cb.getHeight() <= 1) break block4;
            i = this._rows.iterator(cb.getRow(), cb.getRow2() - 1, true);
            while (i.hasNext() && !this.mixOneSide(sa, Styles.Position.INNER_H, bdrArray = ((BordersSpan)i.next()).getBorderArray(), cb.getCol(), cb.getCol2())) {
            }
        }
    }

    public SortedBordersSpanArray getRoot(boolean vert) {
        return vert ? this._cols : this._rows;
    }

    public void setOneBorder(SortedBordersSpanArray dstRoot, Span spMaster, Span spMinor, Border bdr, SortedBordersSpanArray rootBak) {
        boolean bState = rootBak != null;
        spMaster = dstRoot.makeContinuousSpanList(spMaster);
        int iEnd = spMaster.getEnd();
        for (int i = spMaster.getStart(); i <= iEnd; ++i) {
            BordersSpan bss = dstRoot.getBordersSpan(i);
            BordersSpan bssBak = null;
            if (bState) {
                bssBak = (BordersSpan)dstRoot.createDefaultSpan(bss);
                rootBak.insert(bssBak);
            }
            SortedBorderSpanArray bssBorders = bss.getBorderArray();
            Span span = bssBorders.makeContinuousSpanList(spMinor);
            int minorPos = span.getStart();
            BorderSpan bs = bssBorders.getBorderSpan(minorPos);
            if (bState) {
                bssBak.getBorderArray().fillSpans(bssBorders.getArray(), minorPos, span.getEnd() + 1, false);
                bs = (BorderSpan)bs.clone();
                bssBorders.getArray()[minorPos] = bs;
            }
            if (span.getExtent() > 1) {
                bssBorders.removeByPos(minorPos + 1, span.getEnd(), false);
            }
            bs.setEnd(spMinor.getEnd());
            bs.setBorder(bdr);
            bssBorders.merge(minorPos, minorPos, true);
        }
        dstRoot.merge(spMaster, true);
        if (bState) {
            rootBak.merge(spMaster, false);
        }
    }

    public Borders setBySA(CellBlock cb, StyleAttributes sa, StyleAttributes saInner, boolean bState) {
        Border bdr;
        Styles.Position pos;
        Borders state = bState ? new Borders(this._sheet) : null;
        Span rowSpan = cb.getRowSpan();
        Span colSpan = cb.getColSpan();
        Span sp = new Span(0, 0);
        if (sa.isDirtyBorder()) {
            pos = Styles.Position.LEFT;
            if (sa.isDirtyBorder(pos)) {
                bdr = Borders.getBorderFromSSA((ShareStyleAttributes)sa, pos);
                int col = cb.getCol();
                this.setOneBorder(this._cols, sp.setPos(col - 1, col - 1), rowSpan, bdr, bState ? state._cols : null);
            }
            if (sa.isDirtyBorder(pos = Styles.Position.TOP)) {
                bdr = Borders.getBorderFromSSA((ShareStyleAttributes)sa, pos);
                int row = cb.getRow();
                this.setOneBorder(this._rows, sp.setPos(row - 1, row - 1), colSpan, bdr, bState ? state._rows : null);
            }
            if (sa.isDirtyBorder(pos = Styles.Position.RIGHT)) {
                bdr = Borders.getBorderFromSSA((ShareStyleAttributes)sa, pos);
                int col2 = cb.getCol2();
                this.setOneBorder(this._cols, sp.setPos(col2, col2), rowSpan, bdr, bState ? state._cols : null);
            }
            if (sa.isDirtyBorder(pos = Styles.Position.BOTTOM)) {
                bdr = Borders.getBorderFromSSA((ShareStyleAttributes)sa, pos);
                int row2 = cb.getRow2();
                this.setOneBorder(this._rows, sp.setPos(row2, row2), colSpan, bdr, bState ? state._rows : null);
            }
        }
        if (saInner.isDirtyBorder()) {
            pos = Styles.Position.INNER_V;
            if (saInner.isDirtyBorder(pos) && cb.getWidth() > 1) {
                bdr = Borders.getBorderFromSSA((ShareStyleAttributes)saInner, pos);
                this.setOneBorder(this._cols, sp.setPos(cb.getCol(), cb.getCol2() - 1), rowSpan, bdr, bState ? state._cols : null);
            }
            if (saInner.isDirtyBorder(pos = Styles.Position.INNER_H) && cb.getHeight() > 1) {
                bdr = Borders.getBorderFromSSA((ShareStyleAttributes)saInner, pos);
                this.setOneBorder(this._rows, sp.setPos(cb.getRow(), cb.getRow2() - 1), colSpan, bdr, bState ? state._rows : null);
            }
        }
        return state;
    }

    private boolean setRoot(SortedBordersSpanArray src, boolean vert, Borders state) {
        SortedBordersSpanArray dst;
        boolean changed = false;
        SortedBordersSpanArray sortedBordersSpanArray = dst = vert ? this._cols : this._rows;
        SortedBordersSpanArray dstBak = state == null ? null : (vert ? state._cols : state._rows);
        Iterator iMaster = src.iterator(null, false);
        while (iMaster.hasNext()) {
            BordersSpan bss = (BordersSpan)iMaster.next();
            Iterator iMinor = bss.getBorderArray().iterator(null, false);
            while (iMinor.hasNext()) {
                BorderSpan bs = (BorderSpan)iMinor.next();
                this.setOneBorder(dst, bss, bs, bs.getBorder(), dstBak);
                changed = true;
            }
        }
        return changed;
    }

    public boolean set(Borders bdrs) {
        boolean changed = this.setRoot(bdrs._cols, true, null);
        return changed |= this.setRoot(bdrs._rows, false, null);
    }

    private boolean exist(int row, int col, int row2, int col2, boolean vert) {
        int p2;
        int p;
        SortedBorderSpanArray bsArray;
        int pos;
        boolean exist = false;
        int pos2 = this._cols.getProperPos(col2, true);
        for (pos = this._cols.getProperPos(col - 1, false); pos <= pos2; ++pos) {
            bsArray = this._cols.getBordersSpan(pos).getBorderArray();
            p = bsArray.getProperPos(row, false);
            if (p > (p2 = bsArray.getProperPos(vert ? 1048575 : row2, true))) continue;
            exist = true;
            break;
        }
        if (!exist) {
            pos2 = this._rows.getProperPos(row2, true);
            for (pos = this._rows.getProperPos(row - 1, false); pos <= pos2; ++pos) {
                bsArray = this._rows.getBordersSpan(pos).getBorderArray();
                p = bsArray.getProperPos(col, false);
                if (p > (p2 = bsArray.getProperPos(vert ? col2 : 65535, true))) continue;
                exist = true;
                break;
            }
        }
        return exist;
    }

    public Borders insdel(CellBlock cb, boolean insert, boolean vert, boolean bState) {
        Borders state;
        int col2;
        int row2;
        int col;
        int row = cb.getRow();
        if (!this.exist(row, col = cb.getCol(), row2 = cb.getRow2(), col2 = cb.getCol2(), vert)) {
            return null;
        }
        SortedBordersSpanArray root = vert ? this._cols : this._rows;
        SortedBordersSpanArray root2 = vert ? this._rows : this._cols;
        int masterFrom = vert ? col : row;
        int masterTo = vert ? col2 : row2;
        int minorFrom = vert ? row : col;
        int minorTo = vert ? row2 : col2;
        Borders borders = state = bState ? new Borders(this._sheet) : null;
        SortedBordersSpanArray stateRoot = bState ? (vert ? state._cols : state._rows) : null;
        Span spPos = new Span(0, 0);
        Span spMaster = root.makeContinuousSpanList(spPos.setPos(masterFrom - 1, masterTo));
        int iEnd = spMaster.getEnd();
        for (int i = spMaster.getStart(); i <= iEnd; ++i) {
            ObjectArray out;
            BordersSpan bss = root.getBordersSpan(i);
            SortedBorderSpanArray bssBorders = bss.getBorderArray();
            ObjectArray objectArray = out = insert ? bssBorders.insertSpace(minorFrom, minorTo, bState) : bssBorders.deleteSpace(minorFrom, minorTo, bState);
            if (out == null) continue;
            int jEnd = out.size();
            for (int j = 0; j < jEnd; ++j) {
                BorderSpan bs = (BorderSpan)out.get(j);
                this.setOneBorder(stateRoot, bss, bs, bs.getBorder(), null);
            }
        }
        SortedBordersSpanArray offset = new SortedBordersSpanArray(this._sheet, !vert);
        spMaster = root2.makeContinuousSpanList(spPos.setPos(minorFrom - 1, vert ? 1048575 : 65535));
        int iEnd2 = spMaster.getEnd();
        for (int i = spMaster.getStart(); i <= iEnd2; ++i) {
            Span spMinor;
            BordersSpan bss = root2.getBordersSpan(i);
            SortedBorderSpanArray bssBorders = bss.getBorderArray();
            Object[] out = bssBorders.removeByPos((spMinor = bssBorders.makeContinuousSpanList(spPos.setPos(masterFrom, masterTo))).getStart(), spMinor.getEnd(), true);
            if (out == null) continue;
            for (int j = 0; j < out.length; ++j) {
                BorderSpan bs = (BorderSpan)out[j];
                this.setOneBorder(offset, bss, bs, bs.getBorder(), null);
            }
        }
        if (bState) {
            if (vert) {
                state._rows = offset;
            } else {
                state._cols = offset;
            }
            offset = (SortedBordersSpanArray)offset.clone();
        }
        if (insert) {
            offset.insertSpace(minorFrom - 1, minorTo - 1, false);
        } else {
            offset.deleteSpace(minorFrom - 1, minorTo - 1, false);
        }
        this.setRoot(offset, !vert, null);
        return state;
    }

    public void clearInner(CellBlock cb, Borders bdrsBak) {
        if (cb.getHeight() > 1) {
            this.setOneBorder(this._rows, new Span(cb.getRow(), cb.getRow2() - 1), cb.getColSpan(), this._sheet.getDefaultBorder(false), bdrsBak == null ? null : bdrsBak._rows);
        }
        if (cb.getWidth() > 1) {
            this.setOneBorder(this._cols, new Span(cb.getCol(), cb.getCol2() - 1), cb.getRowSpan(), this._sheet.getDefaultBorder(true), bdrsBak == null ? null : bdrsBak._cols);
        }
    }

    public void clearOuter(CellBlock cb, Borders bdrsBak) {
        Span colSpan = cb.getColSpan();
        Border defaultBdr = this._sheet.getDefaultBorder(false);
        SortedBordersSpanArray rows = bdrsBak == null ? null : bdrsBak._rows;
        int row = cb.getRow() - 1;
        this.setOneBorder(this._rows, new Span(row, row), colSpan, defaultBdr, rows);
        row = cb.getRow2();
        this.setOneBorder(this._rows, new Span(row, row), colSpan, defaultBdr, rows);
        Span rowSpan = cb.getRowSpan();
        defaultBdr = this._sheet.getDefaultBorder(true);
        SortedBordersSpanArray cols = bdrsBak == null ? null : bdrsBak._cols;
        int col = cb.getCol() - 1;
        this.setOneBorder(this._cols, new Span(col, col), rowSpan, defaultBdr, cols);
        col = cb.getCol2();
        this.setOneBorder(this._cols, new Span(col, col), rowSpan, defaultBdr, cols);
    }

    public SortedObjectArray collectBorderObjs() {
        int j;
        int jEnd;
        SortedBorderSpanArray bsArray;
        int i;
        SortedObjectArray array = new SortedObjectArray();
        int iEnd = this._cols.size();
        for (i = 0; i < iEnd; ++i) {
            bsArray = this._cols.getBordersSpan(i).getBorderArray();
            jEnd = bsArray.size();
            for (j = 0; j < jEnd; ++j) {
                array.insert(bsArray.getBorderSpan(j).getBorder());
            }
        }
        iEnd = this._rows.size();
        for (i = 0; i < iEnd; ++i) {
            bsArray = this._rows.getBordersSpan(i).getBorderArray();
            jEnd = bsArray.size();
            for (j = 0; j < jEnd; ++j) {
                array.insert(bsArray.getBorderSpan(j).getBorder());
            }
        }
        return array;
    }

    public void buildCellBorderFromSSA(Cell cll, Span spMaster, Span spMinor) {
        ShareStyleAttributes ssa = cll.getSSA();
        if (ssa.hasBordersAttributes()) {
            Border bdr;
            Styles.Position pos;
            int row = cll.getRow();
            int col = cll.getCol();
            int row2 = row;
            int col2 = col;
            CellBlock mergeBlock = cll.getMerge(false);
            if (mergeBlock != null) {
                row2 = mergeBlock.getRow2();
                col2 = mergeBlock.getCol2();
            }
            if (ssa.hasBorderAttributes(pos = Styles.Position.LEFT) && ssa.getBorderLineStyle(pos) != LineStyle.NULL_LINE) {
                bdr = Borders.getBorderFromSSA(ssa, pos);
                this.setOneBorder(this._cols, spMaster.setPos(col - 1, col - 1), spMinor.setPos(row, row2), bdr, null);
            }
            if (ssa.hasBorderAttributes(pos = Styles.Position.RIGHT) && ssa.getBorderLineStyle(pos) != LineStyle.NULL_LINE) {
                bdr = Borders.getBorderFromSSA(ssa, pos);
                this.setOneBorder(this._cols, spMaster.setPos(col2, col2), spMinor.setPos(row, row2), bdr, null);
            }
            if (ssa.hasBorderAttributes(pos = Styles.Position.TOP) && ssa.getBorderLineStyle(pos) != LineStyle.NULL_LINE) {
                bdr = Borders.getBorderFromSSA(ssa, pos);
                this.setOneBorder(this._rows, spMaster.setPos(row - 1, row - 1), spMinor.setPos(col, col2), bdr, null);
            }
            if (ssa.hasBorderAttributes(pos = Styles.Position.BOTTOM) && ssa.getBorderLineStyle(pos) != LineStyle.NULL_LINE) {
                bdr = Borders.getBorderFromSSA(ssa, pos);
                this.setOneBorder(this._rows, spMaster.setPos(row2, row2), spMinor.setPos(col, col2), bdr, null);
            }
        }
    }

    public void buildFromSSA() {
        Border bdr;
        Styles.Position pos;
        ShareStyleAttributes ssa;
        SortedAttributeSpanArray.AttributeSpan as;
        Span spMaster = new Span(0, 0);
        Span spMinor = new Span(0, 0);
        spMinor.setPos(0, 1048575);
        Iterator i = this._sheet.getColSpans().iterator(0, 65535, false);
        while (i.hasNext()) {
            as = (SortedAttributeSpanArray.AttributeSpan)i.next();
            ssa = as.getSSA();
            if (!ssa.hasBordersAttributes()) continue;
            pos = Styles.Position.LEFT;
            if (ssa.hasBorderAttributes(pos) && ssa.getBorderLineStyle(pos) != LineStyle.NULL_LINE) {
                bdr = Borders.getBorderFromSSA(ssa, pos);
                this.setOneBorder(this._cols, spMaster.setPos(as.getStart() - 1, as.getStart() - 1), spMinor, bdr, null);
            }
            if (ssa.hasBorderAttributes(pos = Styles.Position.RIGHT) && ssa.getBorderLineStyle(pos) != LineStyle.NULL_LINE) {
                bdr = Borders.getBorderFromSSA(ssa, pos);
                this.setOneBorder(this._cols, as, spMinor, bdr, null);
            }
            if (ssa.hasBorderAttributes(pos = Styles.Position.TOP) && ssa.getBorderLineStyle(pos) != LineStyle.NULL_LINE) {
                bdr = Borders.getBorderFromSSA(ssa, pos);
                this.setOneBorder(this._rows, spMaster.setPos(-1, -1), as, bdr, null);
            }
            if (!ssa.hasBorderAttributes(pos = Styles.Position.BOTTOM) || ssa.getBorderLineStyle(pos) == LineStyle.NULL_LINE) continue;
            bdr = Borders.getBorderFromSSA(ssa, pos);
            this.setOneBorder(this._rows, spMinor, as, bdr, null);
        }
        spMinor.setPos(0, 65535);
        i = this._sheet.getRowSpans().iterator(0, 1048575, false);
        while (i.hasNext()) {
            as = (SortedAttributeSpanArray.AttributeSpan)i.next();
            ssa = as.getSSA();
            if (!ssa.hasBordersAttributes()) continue;
            pos = Styles.Position.LEFT;
            if (ssa.hasBorderAttributes(pos) && ssa.getBorderLineStyle(pos) != LineStyle.NULL_LINE) {
                bdr = Borders.getBorderFromSSA(ssa, pos);
                this.setOneBorder(this._cols, spMaster.setPos(-1, -1), as, bdr, null);
            }
            if (ssa.hasBorderAttributes(pos = Styles.Position.RIGHT) && ssa.getBorderLineStyle(pos) != LineStyle.NULL_LINE) {
                bdr = Borders.getBorderFromSSA(ssa, pos);
                this.setOneBorder(this._cols, spMinor, as, bdr, null);
            }
            if (ssa.hasBorderAttributes(pos = Styles.Position.TOP) && ssa.getBorderLineStyle(pos) != LineStyle.NULL_LINE) {
                bdr = Borders.getBorderFromSSA(ssa, pos);
                this.setOneBorder(this._rows, spMaster.setPos(as.getStart() - 1, as.getStart() - 1), spMinor, bdr, null);
            }
            if (!ssa.hasBorderAttributes(pos = Styles.Position.BOTTOM) || ssa.getBorderLineStyle(pos) == LineStyle.NULL_LINE) continue;
            bdr = Borders.getBorderFromSSA(ssa, pos);
            this.setOneBorder(this._rows, as, spMinor, bdr, null);
        }
        Sheet.ICellsIterator ci = this._sheet.getCellsIterator(null, false, false);
        while (ci.hasNext()) {
            Border bdr2;
            Styles.Position pos2;
            Cell cll = ci.next();
            ssa = cll.getSSA();
            if (!ssa.hasBordersAttributes()) continue;
            int row = cll.getRow();
            int col = cll.getCol();
            int row2 = row;
            int col2 = col;
            CellBlock mergeBlock = cll.getMerge(false);
            if (mergeBlock != null) {
                row2 = mergeBlock.getRow2();
                col2 = mergeBlock.getCol2();
            }
            if (ssa.hasBorderAttributes(pos2 = Styles.Position.LEFT)) {
                bdr2 = Borders.getBorderFromSSA(ssa, pos2);
                this.setOneBorder(this._cols, spMaster.setPos(col - 1, col - 1), spMinor.setPos(row, row2), bdr2, null);
            }
            if (ssa.hasBorderAttributes(pos2 = Styles.Position.RIGHT)) {
                bdr2 = Borders.getBorderFromSSA(ssa, pos2);
                this.setOneBorder(this._cols, spMaster.setPos(col2, col2), spMinor.setPos(row, row2), bdr2, null);
            }
            if (ssa.hasBorderAttributes(pos2 = Styles.Position.TOP)) {
                bdr2 = Borders.getBorderFromSSA(ssa, pos2);
                this.setOneBorder(this._rows, spMaster.setPos(row - 1, row - 1), spMinor.setPos(col, col2), bdr2, null);
            }
            if (!ssa.hasBorderAttributes(pos2 = Styles.Position.BOTTOM)) continue;
            bdr2 = Borders.getBorderFromSSA(ssa, pos2);
            this.setOneBorder(this._rows, spMaster.setPos(row2, row2), spMinor.setPos(col, col2), bdr2, null);
        }
        MergeBlocks merger = this._sheet.getMerger(false);
        if (merger != null) {
            int iEnd = merger.size();
            for (int i2 = 0; i2 < iEnd; ++i2) {
                this.clearInner(merger.getBlock(i2), null);
            }
        }
    }
}

