/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.model.struct.embed.chart;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.extcommon.variant.Variant;
import com.kingdee.bos.ctrl.kds.expans.model.data.ExtDataSetManager;
import com.kingdee.bos.ctrl.kds.model.expr.Expr;
import com.kingdee.bos.ctrl.kds.model.expr.ExprContext;
import com.kingdee.bos.ctrl.kds.model.expr.IExprNode;
import com.kingdee.bos.ctrl.kds.model.struct.AbstractCalculable;
import com.kingdee.bos.ctrl.kds.model.struct.Book;
import com.kingdee.bos.ctrl.kds.model.struct.CellBlock;
import com.kingdee.bos.ctrl.kds.model.struct.ICalculable;
import com.kingdee.bos.ctrl.kds.model.struct.Sheet;
import com.kingdee.bos.ctrl.kds.model.struct.SheetBaseMath;
import com.kingdee.bos.ctrl.kds.model.struct.embed.chart.ChartCellCalculator;
import com.kingdee.bos.ctrl.kds.model.struct.embed.chart.ChartDatasetCalculator;
import com.kingdee.bos.ctrl.kds.model.struct.embed.chart.ChartResultData;
import com.kingdee.bos.ctrl.kds.model.struct.embed.chart.IChartCalculator;
import com.kingdee.bos.ctrl.kds.model.struct.embed.dataset.DataFromDataset;
import com.kingdee.bos.ctrl.kds.model.struct.node.NamedObjectNode;
import com.kingdee.bos.ctrl.kds.model.util.SortedCellBlockArray;
import com.kingdee.bos.ctrl.swing.chart.AbstractType;

public class ChartDataNode
extends AbstractCalculable
implements Comparable {
    private static final double[][] _demoData = new double[][]{{1.0, 2.0, 3.0}, {2.0, 3.0, 4.0}, {3.0, 2.0, 1.0}};
    protected static final int Flag_Data = 1;
    protected static final int Flag_GroupKeys = 2;
    protected static final int Flag_SerialKeys = 4;
    protected static final int Flag_ChartTitle = 8;
    protected static final int Flag_CategoryAxisTitle = 16;
    protected static final int Flag_ValueAxisTitle = 32;
    protected static final int Flag_Angle = 64;
    protected static final int Flag_ALL = 127;
    protected static final int INT_GROUP = 0;
    protected static final int INT_SERIES = 1;
    protected static final int INT_CHART_TITLE = 2;
    protected static final int INT_C_AXISTITLE = 3;
    protected static final int INT_V_AXISTITLE = 4;
    private Sheet _sheet;
    private boolean _serialByCol;
    private int _dirty;
    private Expr _dataExpr;
    private Object _data;
    private Expr _groupExpr;
    private String[] _groupKeys;
    private Expr _seriesExpr;
    private Object _seriesKeys;
    private Expr _chartTitleExpr;
    private String _chartTitle;
    private Expr _categoryAxisTitleExpr;
    private String _categoryAxisTitle;
    private Expr _valueAxisTitleExpr;
    private String _valueAxisTitle;
    private String[] _chartShowTypes;
    private String[] _yAxisPostion;
    private int _angle;
    private AbstractType _chartType;
    private DataFromDataset _fromDataset;
    protected String _dataFrom = "cell";
    protected ChartResultData resultData;

    public ChartDataNode(Sheet sheet) {
        this._sheet = sheet;
        this._serialByCol = true;
        this._dirty = 127;
    }

    protected IChartCalculator createChartCalculator(Sheet sheet, String dataFrom) {
        if ("dataset".equals(dataFrom)) {
            return new ChartDatasetCalculator(sheet, this._chartType, this._fromDataset);
        }
        return new ChartCellCalculator(sheet, this);
    }

    public String toString() {
        return "ChartNode " + this.hashCode();
    }

    public boolean isSerialByCol() {
        return this._serialByCol;
    }

    public void setSerialByCol(boolean serialByCol) {
        if (this._serialByCol != serialByCol) {
            this._serialByCol = serialByCol;
            this._dirty |= 0x7F;
        }
    }

    public static String getSelectionString(Sheet sheet) {
        SortedCellBlockArray array = sheet.getSheetOption().getSelection().toSortedBlocks();
        return SheetBaseMath.getBlocksName(array, sheet.getDeps().isA1Style(), false);
    }

    private String getFormula(Expr expr) {
        return expr != null ? expr.decode(this._sheet.getDeps().getExprContext(), this) : "";
    }

    protected Expr parseFormula(String newFormula) {
        Expr expr = null;
        if (!StringUtil.isEmptyString((String)newFormula)) {
            expr = this._sheet.getExpr(this, newFormula);
            if (!expr.isSyntaxError()) {
                ExtDataSetManager dm = this._sheet.getBook().getDataSetManager();
                expr = dm.replaceDSNode(this, expr, null);
            } else {
                expr = null;
            }
        }
        return expr;
    }

    public String getDataFormula() {
        return this.getFormula(this._dataExpr);
    }

    public boolean setDataFormula(String formula) {
        boolean bOK = true;
        if (this.getDataFormula().compareToIgnoreCase(formula) != 0) {
            this._dataExpr = this.parseFormula(formula);
            if (!StringUtil.isEmptyString((String)formula)) {
                bOK = this._dataExpr != null;
            }
            this._data = null;
            this._dirty |= 1;
        }
        return bOK;
    }

    public Object getData() {
        return this.calcData()._data;
    }

    public String getGroupFormula() {
        return this.getFormula(this._groupExpr);
    }

    public boolean setGroupFormula(String formula) {
        boolean bOK = true;
        if (this.getGroupFormula().compareToIgnoreCase(formula) != 0) {
            this._groupExpr = this.parseFormula(formula);
            if (!StringUtil.isEmptyString((String)formula)) {
                bOK = this._dataExpr != null;
            }
            this._groupKeys = null;
            this._dirty |= 2;
        }
        return bOK;
    }

    public String[] getGroupKeys() {
        return this.calcData()._groupKeys;
    }

    public String getChartTitleFormula() {
        return this.getFormula(this._chartTitleExpr);
    }

    public boolean setChartTitleFormula(String formula) {
        boolean bOK = true;
        if (this.getChartTitleFormula().compareToIgnoreCase(formula) != 0) {
            this._chartTitleExpr = this.parseFormula(formula);
            if (!StringUtil.isEmptyString((String)formula)) {
                bOK = this._chartTitleExpr != null;
            }
            this._chartTitle = null;
            this._dirty |= 8;
        }
        return bOK;
    }

    public String getChartTitle() {
        String title = this.calcData()._chartTitle;
        return title == null ? "" : title;
    }

    public String getCategoryAxisTitleFormula() {
        return this.getFormula(this._categoryAxisTitleExpr);
    }

    public boolean setCategoryAxisTitleFormula(String formula) {
        boolean bOK = true;
        if (this.getCategoryAxisTitleFormula().compareToIgnoreCase(formula) != 0) {
            this._categoryAxisTitleExpr = this.parseFormula(formula);
            if (!StringUtil.isEmptyString((String)formula)) {
                bOK = this._categoryAxisTitleExpr != null;
            }
            this._categoryAxisTitle = null;
            this._dirty |= 0x10;
        }
        return bOK;
    }

    public String getCategoryAxisTitle() {
        String title = this.calcData()._categoryAxisTitle;
        return title == null ? "" : title;
    }

    public String getValueAxisTitleFormula() {
        return this.getFormula(this._valueAxisTitleExpr);
    }

    public boolean setValueAxisTitleFormula(String formula) {
        boolean bOK = true;
        if (this.getValueAxisTitleFormula().compareToIgnoreCase(formula) != 0) {
            this._valueAxisTitleExpr = this.parseFormula(formula);
            if (!StringUtil.isEmptyString((String)formula)) {
                bOK = this._valueAxisTitleExpr != null;
            }
            this._valueAxisTitle = null;
            this._dirty |= 0x20;
        }
        return bOK;
    }

    public String getValueAxisTitle() {
        String title = this.calcData()._valueAxisTitle;
        return title == null ? "" : title;
    }

    public String getSeriesKeysFormula() {
        return this.getFormula(this._seriesExpr);
    }

    public boolean setSeriesKeysFormula(String formula) {
        boolean bOK = true;
        if (this.getSeriesKeysFormula().compareToIgnoreCase(formula) != 0) {
            this._seriesExpr = this.parseFormula(formula);
            if (!StringUtil.isEmptyString((String)formula)) {
                bOK = this._seriesExpr != null;
            }
            this._seriesKeys = null;
            this._dirty |= 4;
        }
        return bOK;
    }

    public Object getSeriesKeys() {
        return this.calcData()._seriesKeys;
    }

    public int getAngle() {
        return this.calcData()._angle;
    }

    public void setAngle(int angle) {
        if (this._angle != angle) {
            this._angle = angle;
            this._dirty |= 0x40;
        }
    }

    protected ChartDataNode calcData() {
        if (this._dirty != 0) {
            if (this._sheet.getBook().getUserObject("EXT_EXECUTED") == null) {
                this._data = _demoData;
            } else {
                IChartCalculator chartCalculator = this.createChartCalculator(this._sheet, this._dataFrom);
                this.resultData = chartCalculator.calc();
                if (this.resultData == null) {
                    return this;
                }
                this._data = this.resultData.getData();
                this._groupKeys = this.resultData.getGroups();
                this._seriesKeys = this.resultData.getSeries();
                this._chartShowTypes = this.resultData.getShowTypes();
                this._yAxisPostion = this.resultData.getYAxisPostion();
                this._dataExpr = this.resultData.getDataExpr();
                this._groupExpr = this.resultData.getGroupExpr();
                this._seriesExpr = this.resultData.getSeriesExpr();
                this._chartTitle = this.resultData.getChartTitle();
                this._chartTitleExpr = this.resultData.getChartTitleExpr();
                this._categoryAxisTitle = this.resultData.getCategoryAxisTitle();
                this._categoryAxisTitleExpr = this.resultData.getCategoryAxisTitleExpr();
                this._valueAxisTitle = this.resultData.getValueAxisTitle();
                this._valueAxisTitleExpr = this.resultData.getValueAxisTitleExpr();
            }
            this._dirty = 0;
        }
        return this;
    }

    protected ICalculable getCalcOwner(Expr expr) {
        Comparable owner = null;
        Book book = this._sheet.getBook();
        if (expr != null && expr.hasNamedObject()) {
            IExprNode[] nodes = expr.getAllNodes();
            for (int i = 0; i < nodes.length; ++i) {
                NamedObjectNode no;
                IExprNode node = nodes[i];
                if (node.getExprType() != 8 || (no = (NamedObjectNode)node).getName().compareToIgnoreCase("$Selection") != 0) continue;
                book.setDependent((ICalculable)this, no);
                Variant value = no.getValue();
                if (value.isError()) continue;
                CellBlock cb = (CellBlock)value.getValue();
                owner = this._sheet.getFirstCell(cb, false);
                break;
            }
        }
        if (owner == null) {
            owner = this;
        }
        return owner;
    }

    @Override
    public boolean calc(ExprContext ctx) {
        return true;
    }

    @Override
    public Sheet getSheet() {
        return this._sheet;
    }

    @Override
    public Variant getValue() {
        return null;
    }

    @Override
    public void updateExpr(boolean queue) {
        if (this._dataExpr != null) {
            this._dataExpr = this._sheet.getExpr(this, this.getDataFormula());
        }
        if (this._groupExpr != null) {
            this._groupExpr = this._sheet.getExpr(this, this.getGroupFormula());
        }
        if (this._categoryAxisTitleExpr != null) {
            this._categoryAxisTitleExpr = this._sheet.getExpr(this, this.getCategoryAxisTitleFormula());
        }
        if (this._chartTitleExpr != null) {
            this._chartTitleExpr = this._sheet.getExpr(this, this.getChartTitleFormula());
        }
        if (this._seriesExpr != null) {
            this._seriesExpr = this._sheet.getExpr(this, this.getSeriesKeysFormula());
        }
        if (this._valueAxisTitleExpr != null) {
            this._valueAxisTitleExpr = this._sheet.getExpr(this, this.getValueAxisTitleFormula());
        }
    }

    @Override
    public void setNeedRecalc(boolean bRecalc) {
        super.setNeedRecalc(bRecalc);
        this._dirty = 127;
    }

    protected int getDirty() {
        return this._dirty;
    }

    public boolean isDirty() {
        return this._dirty != 0;
    }

    public void setDirty(boolean dirty) {
        this._dirty = dirty ? 127 : 0;
    }

    public int compareTo(Object obj) {
        if (this == obj) {
            return 0;
        }
        int cmp = 1;
        if (obj instanceof ICalculable) {
            cmp = this.getCalculableType() - ((ICalculable)obj).getCalculableType();
        }
        if (cmp == 0) {
            cmp = this.hashCode() - ((ChartDataNode)obj).hashCode();
        }
        return cmp;
    }

    public int hashCode() {
        return this._sheet.hashCode() + (this._dataExpr == null ? 0 : this._dataExpr.hashCode()) + (this._groupExpr == null ? 0 : this._groupExpr.hashCode()) + (this._seriesExpr == null ? 0 : this._seriesExpr.hashCode()) + (this._chartTitleExpr == null ? 0 : this._chartTitleExpr.hashCode()) + (this._categoryAxisTitleExpr == null ? 0 : this._categoryAxisTitleExpr.hashCode()) + (this._valueAxisTitleExpr == null ? 0 : this._valueAxisTitleExpr.hashCode());
    }

    @Override
    public int getCalculableType() {
        return 2;
    }

    @Override
    public Expr getExpr() {
        return this._dataExpr;
    }

    @Override
    public void setExpr(Expr expr) {
        this._dataExpr = expr;
    }

    public Expr[] getExprs() {
        return new Expr[]{this._groupExpr, this._seriesExpr, this._chartTitleExpr, this._categoryAxisTitleExpr, this._valueAxisTitleExpr};
    }

    public void setExprs(Expr[] exprs) {
        if (exprs[0] != null) {
            this._groupExpr = exprs[0];
        }
        if (exprs[1] != null) {
            this._seriesExpr = exprs[1];
        }
        if (exprs[2] != null) {
            this._chartTitleExpr = exprs[2];
        }
        if (exprs[3] != null) {
            this._categoryAxisTitleExpr = exprs[3];
        }
        if (exprs[4] != null) {
            this._valueAxisTitleExpr = exprs[4];
        }
    }

    public void setFromDataset(DataFromDataset fromDataset) {
        this._fromDataset = fromDataset;
    }

    public DataFromDataset getFromDataset() {
        return this._fromDataset;
    }

    public String getDataFrom() {
        return this._dataFrom;
    }

    public void setDataFrom(String dataFrom) {
        this._dataFrom = dataFrom;
    }

    public void setChartType(AbstractType chartType) {
        this._chartType = chartType;
    }

    public AbstractType getChartType() {
        return this._chartType;
    }

    public String[] getChartShowTypes() {
        return this.calcData()._chartShowTypes;
    }

    public String[] getYAxisPostion() {
        return this.calcData()._yAxisPostion;
    }

    public boolean isFillNullWithZero() {
        return true;
    }
}

