/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.model.struct.embed.echarts.transfer.impls.column;

import com.github.abel533.echarts.DataZoom;
import com.github.abel533.echarts.Option;
import com.github.abel533.echarts.axis.CategoryAxis;
import com.github.abel533.echarts.axis.ValueAxis;
import com.github.abel533.echarts.code.DataZoomType;
import com.github.abel533.echarts.code.PointerType;
import com.github.abel533.echarts.code.SeriesType;
import com.github.abel533.echarts.code.Trigger;
import com.github.abel533.echarts.data.Data;
import com.github.abel533.echarts.series.Bar;
import com.github.abel533.echarts.series.Series;
import com.kingdee.bos.ctrl.ext.ui.wizards.chart.model.beans.column.ScrollStackedColumn2DBean;
import com.kingdee.bos.ctrl.ext.ui.wizards.chart.model.struct.Chart;
import com.kingdee.bos.ctrl.kds.model.struct.embed.echarts.constants.EChartsType;
import com.kingdee.bos.ctrl.kds.model.struct.embed.echarts.transfer.impls.AbstractSrollableTransfer;
import com.kingdee.bos.ctrl.kds.model.struct.embed.flashchart.FusionChartDataNode;
import java.util.Arrays;
import java.util.List;

public class ScrollStackedColumn2DBeanTransferImpl
extends AbstractSrollableTransfer<ScrollStackedColumn2DBean> {
    private Data last = null;
    private int lastSeriesIndex = -1;
    private int lastDataIndexIndex = -1;

    public ScrollStackedColumn2DBeanTransferImpl() {
        super(EChartsType.BAR, "\u5e26\u6eda\u52a8\u6761\u7684\u5806\u79ef2D\u67f1\u5f62\u56fe");
        this.setxValueAxis(false);
        this.setyValueAxis(true);
        this.setXScrollable(true);
    }

    @Override
    protected void setBlowZeroDataRoundEdges(Data d, boolean x, int seriesIndex, int dataIndex) {
        super.setBlowZeroDataRoundEdges(d, x, seriesIndex, dataIndex);
        if (this.lastDataIndexIndex == dataIndex && seriesIndex > this.lastSeriesIndex && null != this.last) {
            this.last.itemStyle().normal().barBorderRadius(null);
        }
        this.last = d;
        this.lastSeriesIndex = seriesIndex;
        this.lastDataIndexIndex = dataIndex;
    }

    @Override
    public Option transfer2Opiton(ScrollStackedColumn2DBean bean, FusionChartDataNode dataNode) {
        Option p = super.transfer2Opiton(bean, dataNode);
        p.title().setText(bean.getChartTitle());
        String[] labels = dataNode.getGroupKeys();
        double[][] data = (double[][])dataNode.getData();
        if (null == labels || null == data) {
            return null;
        }
        Object[] series = (String[])dataNode.getSeriesKeys();
        if (null != p.getLegend()) {
            p.legend().data(series);
        }
        ValueAxis valueAxis = new ValueAxis();
        p.yAxis().add(valueAxis);
        if (null != p.getTooltip()) {
            p.tooltip().trigger(Trigger.axis);
            p.tooltip().axisPointer().type(PointerType.shadow);
        }
        CategoryAxis caxis = new CategoryAxis();
        for (String label : labels) {
            caxis.data().add(label);
        }
        for (int i = 0; i < data.length; ++i) {
            Bar bar = new Bar();
            bar.stack("total");
            bar.name((String)series[i]);
            for (int j = 0; j < data[i].length; ++j) {
                bar.data().add(data[i][j]);
            }
            p.series().add(bar);
        }
        p.xAxis().add(caxis);
        return p;
    }

    @Override
    public Option mockOption(ScrollStackedColumn2DBean bean) {
        Option p = super.mockOption(bean);
        CategoryAxis caxis = new CategoryAxis();
        caxis.setData(Arrays.asList("Mon", "Tue", "Wed", "Thu", "Fri", "Sat", "Sun"));
        DataZoom xZoom = new DataZoom();
        xZoom.start(Integer.valueOf(0));
        xZoom.type(DataZoomType.slider);
        xZoom.end(Integer.valueOf(40));
        xZoom.handleSize(Integer.valueOf(20));
        xZoom.height(Integer.valueOf(20));
        xZoom.show(Boolean.valueOf(true));
        xZoom.xAxisIndex((Object)new Integer[]{0});
        xZoom.bottom(Integer.valueOf(40));
        DataZoom xZoomInline = new DataZoom();
        xZoomInline.type(DataZoomType.inside);
        xZoomInline.show(Boolean.valueOf(true));
        xZoomInline.start(Integer.valueOf(0));
        xZoomInline.end(Integer.valueOf(40));
        xZoomInline.xAxisIndex((Object)new Integer[]{0});
        xZoomInline.bottom(Integer.valueOf(60));
        p.dataZoom(new DataZoom[]{xZoom, xZoomInline});
        p.xAxis().add(caxis);
        p.yAxis().add(new ValueAxis());
        p.tooltip().trigger(Trigger.axis);
        p.tooltip().axisPointer().type(PointerType.shadow);
        p.legend().data(Arrays.asList("2020\u5e74", "2021\u5e74"));
        p.legend().bottom(Integer.valueOf(10));
        Bar bar1 = new Bar();
        bar1.name("2020\u5e74");
        bar1.stack("total");
        bar1.setData(Arrays.asList(120, 200, 150, 80, 70, 110, 130));
        Bar bar2 = new Bar();
        bar2.name("2021\u5e74");
        bar2.stack("total");
        bar2.setData(Arrays.asList(50, 120, 200, 30, 120, 60, 150));
        p.series().add(bar1);
        p.series().add(bar2);
        p.grid().bottom(Integer.valueOf(80));
        return p;
    }

    private void resetDataRoundEdges(List<Series> series, boolean x) {
        Object d;
        int i;
        int[] index = new int[series.get(0).getData().size()];
        for (i = series.size() - 1; i >= 0; --i) {
            List data = series.get(i).getData();
            for (int j = 0; j < data.size(); ++j) {
                d = data.get(j);
                if (d instanceof Data || index[j] != 0) continue;
                index[j] = i;
            }
        }
        for (i = 0; i < index.length; ++i) {
            int serialIndex = index[i];
            if (serialIndex == series.size() - 1) continue;
            List data = series.get(serialIndex).getData();
            d = data.get(i);
            Data sData = new Data();
            sData.setValue(d);
            if (this.isxValueAxis()) {
                sData.itemStyle().normal().barBorderRadius((Object)new Integer[]{0, 15, 15, 0});
            } else if (this.isyValueAxis()) {
                sData.itemStyle().normal().barBorderRadius((Object)new Integer[]{15, 15, 0, 0});
            }
            data.set(i, sData);
        }
    }

    @Override
    public String afterScript(ScrollStackedColumn2DBean b, FusionChartDataNode data, Option p) {
        String s = super.afterScript(b, data, p);
        if ("1".equals(b.getChart().useRoundEdges)) {
            this.resetDataRoundEdges(p.getSeries(), this.isxValueAxis());
        }
        return s;
    }

    @Override
    protected void configureSeriesFillet(Option p, Chart chart) {
        Series s = (Series)p.getSeries().get(p.getSeries().size() - 1);
        if (s.getType() == SeriesType.bar && "1".equals(chart.useRoundEdges)) {
            if (this.isxValueAxis()) {
                s.itemStyle().normal().barBorderRadius((Object)new Integer[]{0, 15, 15, 0});
            } else if (this.isyValueAxis()) {
                s.itemStyle().normal().barBorderRadius((Object)new Integer[]{15, 15, 0, 0});
            }
        }
    }
}

