/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.model.struct.embed.echarts.transfer.impls.combination;

import com.github.abel533.echarts.Option;
import com.github.abel533.echarts.axis.Axis;
import com.github.abel533.echarts.axis.CategoryAxis;
import com.github.abel533.echarts.axis.ValueAxis;
import com.github.abel533.echarts.code.AxisType;
import com.github.abel533.echarts.code.PointerType;
import com.github.abel533.echarts.code.Position;
import com.github.abel533.echarts.code.Trigger;
import com.github.abel533.echarts.series.Bar;
import com.github.abel533.echarts.series.Line;
import com.github.abel533.echarts.series.PictorialBar;
import com.github.abel533.echarts.series.Series;
import com.kingdee.bos.ctrl.ext.ui.wizards.chart.model.beans.combination.StackedColumn3DLineDYBean;
import com.kingdee.bos.ctrl.ext.ui.wizards.chart.util.FusionChartXmlBuilder;
import com.kingdee.bos.ctrl.kds.model.struct.embed.echarts.constants.EChartConstants;
import com.kingdee.bos.ctrl.kds.model.struct.embed.echarts.constants.EChartsType;
import com.kingdee.bos.ctrl.kds.model.struct.embed.echarts.transfer.TransferUtils;
import com.kingdee.bos.ctrl.kds.model.struct.embed.echarts.transfer.impls.AbstractStackedTransfer;
import com.kingdee.bos.ctrl.kds.model.struct.embed.echarts.transfer.script.JSUtils;
import com.kingdee.bos.ctrl.kds.model.struct.embed.flashchart.FusionChartDataNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class MSStackedCombiDY3DBeanTransferImpl
extends AbstractStackedTransfer<StackedColumn3DLineDYBean> {
    private List<Series<Bar>> otherSeries = new ArrayList<Series<Bar>>();
    private List<Series> barSeries = new ArrayList<Series>();
    private List<Axis> yList = new ArrayList<Axis>();

    public MSStackedCombiDY3DBeanTransferImpl() {
        super(EChartsType.BAR, "\u53ccy3d\u5806\u79ef\u67f1\u5f62\u52a0\u6298\u7ebf\u7ec4\u5408\u56fe\uff0c\u4f7f\u75282d\u5806\u79ef\u56fe\u6a21\u62df3d\u6548\u679c\u5916\u52a0\u6298\u7ebf\u56fe\u3002");
    }

    @Override
    public String initScript(StackedColumn3DLineDYBean bean, FusionChartDataNode dataNode) {
        String s = super.initScript(bean, dataNode);
        HashMap<String, Integer> yAxisMap = new HashMap<String, Integer>();
        int count = 0;
        for (int n = 0; n < this.yAxis.length; ++n) {
            String chartYAxis = FusionChartXmlBuilder.getChartYAxis(this.yAxis[n]);
            if (null != yAxisMap.get(chartYAxis)) continue;
            ValueAxis valueAxis = new ValueAxis();
            valueAxis.type(AxisType.value);
            valueAxis.axisLabel().show(Boolean.valueOf(true));
            if (null != chartYAxis) {
                valueAxis.setPosition((Object)Position.right);
            }
            this.yList.add((Axis)valueAxis);
            yAxisMap.put(chartYAxis, count);
            ++count;
        }
        for (int i = 0; i < this.seriesNames.length; ++i) {
            Object[] ns = (Object[])this.seriesNames[i];
            int l = null == ns ? 1 : ns.length;
            for (int d = 0; d < l; ++d) {
                Bar serie = new Bar();
                boolean createBar = true;
                if (TransferUtils.isColumnType(this.types[i])) {
                    serie.stack(this.groups[i]);
                } else if (TransferUtils.isLineType(this.types[i])) {
                    serie = new Line();
                    serie.z(Integer.valueOf(4));
                    this.otherSeries.add((Series<Bar>)serie);
                    createBar = false;
                } else if (TransferUtils.isAreaType(this.types[i])) {
                    serie = new Line();
                    ((Line)serie).areaStyle();
                    serie.z(Integer.valueOf(4));
                    this.otherSeries.add((Series<Bar>)serie);
                    createBar = false;
                }
                String[] names = (String[])this.seriesNames[i];
                String name = "";
                name = null != names ? names[d] : this.series[i];
                serie.name(name);
                String chartYAxis = FusionChartXmlBuilder.getChartYAxis(this.yAxis[i]);
                Integer index = (Integer)yAxisMap.get(chartYAxis);
                if (null != index) {
                    serie.yAxisIndex(index);
                }
                if (createBar) {
                    this.barSeries.add((Series)serie);
                }
                TransferUtils.fillData(this.dataValues[i], this.isSeriesByCol, (Series)serie, d);
            }
        }
        return s + this.buildColorStopsLeft(this.barSeries.size());
    }

    @Override
    public Option transfer2Opiton(StackedColumn3DLineDYBean bean, FusionChartDataNode dataNode) {
        Option p = super.transfer2Opiton(bean, dataNode);
        if (null != p.getTooltip()) {
            p.tooltip().trigger(Trigger.axis);
            p.tooltip().axisPointer().type(PointerType.shadow);
        }
        if (null != p.getLegend()) {
            for (int i = 0; i < this.seriesNames.length; ++i) {
                String[] s = (String[])this.seriesNames[i];
                if (null != s) {
                    for (int j = 0; j < s.length; ++j) {
                        p.legend().data().add(s[j]);
                    }
                    continue;
                }
                p.legend().data().add(this.series[i]);
            }
        }
        if (null == this.groups) {
            return null;
        }
        double[][] numbers = TransferUtils.toDoubleValues(this.dataValues);
        CategoryAxis caxis = new CategoryAxis();
        for (String group : this.groups) {
            caxis.data().add(group);
        }
        ArrayList<List<Object>> barDataList = new ArrayList<List<Object>>();
        ArrayList<Object> seriesList = new ArrayList<Object>();
        double[] proportion = TransferUtils.getStackedDiamondProportion(numbers);
        for (int i = 0; i < this.barSeries.size(); ++i) {
            Series bar = this.barSeries.get(i);
            seriesList.add(bar);
            bar.itemStyle().normal().color((Object)("function(){return colorStop" + i + " ;}"));
            PictorialBar p2 = new PictorialBar();
            p2.name(bar.name());
            p2.z(Integer.valueOf(3));
            p2.symbol((Object)"diamond");
            p2.symbolOffset((Object)0, (Object)"-50%");
            p2.symbolSize((Object)new String[]{"100%", proportion[i] * 30.0 + "%"});
            int colorIndex = i % this.getColorList().size();
            p2.itemStyle().normal().color((Object)("function(index){return colors[" + colorIndex + "];}"));
            p2.setSymbolPosition((Object)"end");
            barDataList.add(bar.getData());
            p2.setData(TransferUtils.stackValue(barDataList, i));
            p2.setYAxisIndex(bar.getYAxisIndex());
            seriesList.add(p2);
        }
        seriesList.addAll(this.otherSeries);
        p.yAxis(this.yList);
        p.xAxis().add(caxis);
        p.series().addAll(seriesList);
        return p;
    }

    @Override
    public String initMockScript(StackedColumn3DLineDYBean bean) {
        return super.initMockScript(bean) + this.buildColorStopsLeft(5) + TransferUtils.getResourceAsString(this.getClass(), "MSStackedCombiDY3DBeanTransferImpl.json", EChartConstants.DEMOFILE_ENCODING);
    }

    @Override
    public Option mockOption(StackedColumn3DLineDYBean bean) {
        return null;
    }

    @Override
    public String afterMockScript(StackedColumn3DLineDYBean bean) {
        return super.afterMockScript(bean) + JSUtils.ONLEGENDCHANGED_FUNCTION;
    }

    @Override
    public String afterScript(StackedColumn3DLineDYBean b, FusionChartDataNode data, Option p) {
        return super.afterScript(b, data, p) + JSUtils.ONLEGENDCHANGED_FUNCTION;
    }
}

