/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.model.util;

import java.util.Arrays;

public class SortedIntArray {
    private static final int MIN_SIZE = 4;
    protected int[] _array;
    protected int _count;

    public SortedIntArray() {
        this._array = null;
        this._count = 0;
    }

    public SortedIntArray(int initCap) {
        this._array = new int[initCap];
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("[");
        if (!this.isNull()) {
            for (int i = 0; i < this._count; ++i) {
                if (i != 0) {
                    sb.append(',');
                }
                sb.append(String.valueOf(this._array[i]));
            }
        }
        sb.append(']');
        return sb.toString();
    }

    public int getAt(int index) {
        return this._array[index];
    }

    public int size() {
        return this._count;
    }

    public boolean isNull() {
        return this._count == 0 || this._array == null;
    }

    public void clear() {
        if (this._array != null) {
            Arrays.fill(this._array, 0, this._count, -1);
        }
        this._count = 0;
    }

    public int getMaxIntMark() {
        return this.isNull() ? -1 : this._array[this._count - 1];
    }

    public void insert(int i) {
        if (this.isNull()) {
            if (this._array == null) {
                this._array = new int[4];
            }
            this._array[0] = i;
            this._count = 1;
        } else if (this._array[this._count - 1] < i) {
            this.append(i);
        } else {
            int pos = this.search(i);
            if (pos < 0) {
                pos = -(pos + 1);
                if (this._count + 1 > this._array.length) {
                    int[] newArray = new int[this.getIncreasedCellsSize()];
                    System.arraycopy(this._array, 0, newArray, 0, pos);
                    System.arraycopy(this._array, pos, newArray, pos + 1, this._count - pos);
                    this._array = newArray;
                } else {
                    System.arraycopy(this._array, pos, this._array, pos + 1, this._count - pos);
                }
                this._array[pos] = i;
                ++this._count;
            }
        }
    }

    public void insert(int pos, int i) {
        if (this.isNull()) {
            if (this._array == null) {
                this._array = new int[4];
            }
            this._array[0] = i;
            this._count = 1;
        } else {
            if (pos < 0) {
                pos = -(pos + 1);
            }
            if (this._count + 1 > this._array.length) {
                int[] newArray = new int[this.getIncreasedCellsSize()];
                System.arraycopy(this._array, 0, newArray, 0, pos);
                if (this._count > pos) {
                    System.arraycopy(this._array, pos, newArray, pos + 1, this._count - pos);
                }
                this._array = newArray;
            } else if (this._count > pos) {
                System.arraycopy(this._array, pos, this._array, pos + 1, this._count - pos);
            }
            this._array[pos] = i;
            ++this._count;
        }
    }

    protected void append(int i) {
        if (this._count + 1 > this._array.length) {
            int[] newArray = new int[this.getIncreasedCellsSize()];
            System.arraycopy(this._array, 0, newArray, 0, this._count);
            this._array = newArray;
        }
        this._array[this._count] = i;
        ++this._count;
    }

    protected int getIncreasedCellsSize() {
        return this._array.length * 3 / 2 + 1;
    }

    public void ensureCapacity(int minCapacity) {
        if (this._array == null) {
            this._array = new int[4];
        }
        if (minCapacity > this._array.length) {
            int[] oldArray = this._array;
            int newCapacity = this.getIncreasedCellsSize();
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this._array = new int[newCapacity];
            System.arraycopy(oldArray, 0, this._array, 0, this._count);
        }
    }

    public int search(int i) {
        if (this.isNull()) {
            return -1;
        }
        int low = 0;
        int high = this._count - 1;
        while (low <= high) {
            int mid = low + high >> 1;
            int midVal = this._array[mid];
            if (midVal < i) {
                low = mid + 1;
                continue;
            }
            if (midVal > i) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public int remove(int i) {
        return this.removeByPos(this.search(i));
    }

    public int removeByPos(int pos) {
        if (pos < 0 || pos >= this._count) {
            return -1;
        }
        int old = this._array[pos];
        int remain = this._count - (pos + 1);
        System.arraycopy(this._array, pos + 1, this._array, pos, remain);
        this._array[--this._count] = -1;
        return old;
    }

    public int[] remove(int from, int to, boolean updateIntMark) {
        if (from > to) {
            return null;
        }
        int pos = this.getProperPos(from, false);
        int pos2 = this.getProperPos(to, true);
        int[] aOut = null;
        if (pos <= pos2) {
            aOut = new int[pos2 - pos + 1];
            System.arraycopy(this._array, pos, aOut, 0, aOut.length);
            int remain = this._count - (pos2 + 1);
            System.arraycopy(this._array, pos2 + 1, this._array, pos, remain);
            Arrays.fill(this._array, this._count - aOut.length, this._count, -1);
            this._count -= aOut.length;
        }
        return aOut;
    }

    public void trimToSize() {
        if (!this.isNull() && this._array.length != this._count) {
            int[] newArray = new int[this._count];
            System.arraycopy(this._array, 0, newArray, 0, this._count);
            this._array = newArray;
        }
    }

    public int getProperPos(int index, boolean bLater) {
        int pos = this.search(index);
        if (pos < 0) {
            pos = -(pos + 1);
            if (bLater) {
                --pos;
            }
        }
        return pos;
    }

    public int[] subset(int from, int to) {
        int pos2;
        int[] array = null;
        int pos = this.getProperPos(from, false);
        if (pos <= (pos2 = this.getProperPos(to, true))) {
            array = new int[pos2 - pos + 1];
            System.arraycopy(this._array, pos, array, 0, array.length);
        }
        return array;
    }
}

