/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.model.util;

import com.kingdee.bos.ctrl.extcommon.util.SortedObjectArray;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;

public class WeakSortedObjectArray
extends SortedObjectArray {
    private static final long serialVersionUID = 2322450696281662067L;
    private final ReferenceQueue queue = new ReferenceQueue();

    @Override
    public int size() {
        this.expungeStaleEntries();
        return super.size();
    }

    @Override
    public Object get(int index) {
        this.expungeStaleEntries();
        WeakReference wr = (WeakReference)this._array[index];
        if (wr == null) {
            return null;
        }
        return ((WeakReference)this._array[index]).get();
    }

    @Override
    public Object insert(Object obj) {
        this.expungeStaleEntries();
        WeakArrayEntry entry = new WeakArrayEntry(obj, this.queue);
        return super.insert(entry);
    }

    public void insert(Object obj, int pos) {
        this.expungeStaleEntries();
        WeakArrayEntry entry = new WeakArrayEntry(obj, this.queue);
        super.insert(pos, entry);
    }

    @Override
    public Object remove(Object obj) {
        this.expungeStaleEntries();
        WeakArrayEntry entry = new WeakArrayEntry(obj, this.queue);
        return super.remove(entry);
    }

    @Override
    public int search(Object obj) {
        if (obj instanceof WeakReference) {
            return super.search(obj);
        }
        this.expungeStaleEntries();
        WeakArrayEntry entry = new WeakArrayEntry(obj, this.queue);
        return super.search(entry);
    }

    public void expungeStaleEntries() {
        Reference r;
        while ((r = this.queue.poll()) != null) {
            WeakReference entry = (WeakReference)r;
            this.removeWeak(entry);
        }
    }

    private void removeWeak(WeakReference entry) {
        if (this._array == null) {
            return;
        }
        for (int i = 0; i < this._array.length; ++i) {
            WeakReference wr = (WeakReference)this._array[i];
            if (wr != entry) continue;
            this.removeByPos(i);
        }
    }

    private static class WeakArrayEntry
    extends WeakReference
    implements Comparable {
        public WeakArrayEntry(Object obj, ReferenceQueue q) {
            super(obj, q);
        }

        public String toString() {
            Object obj = this.get();
            return obj != null ? obj.toString() : "Weak";
        }

        public int compareTo(Object o) {
            Comparable obj = (Comparable)this.get();
            Object b = ((WeakReference)o).get();
            if (obj == null && b == null) {
                return 0;
            }
            if (obj == null || b == null) {
                return -1;
            }
            return obj.compareTo(b);
        }
    }
}

