/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.extendcontrols.plaf;

import com.kingdee.bos.ctrl.extendcontrols.KDWorkCalendar;
import com.kingdee.bos.ctrl.swing.CtrlFocusTraversalPolicy;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDFont;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.ctrl.swing.KDPopupMenu;
import com.kingdee.bos.ctrl.swing.MessageDialog;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.model.DateTimeModel;
import com.kingdee.bos.ctrl.swing.model.IDateTimeModel;
import com.kingdee.bos.ctrl.swing.plaf.KingdeeBorders;
import com.kingdee.bos.ctrl.swing.plaf.PaintUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.accessibility.Accessible;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;

public class KingdeeWorkCalendarUI
extends ComponentUI {
    private LayoutManager layout = null;
    private KDWorkCalendar c = null;
    private KDPopupMenu popupMenu = null;
    private static Dimension zeroDim = new Dimension(0, 0);
    private List yearMonthList = new ArrayList();
    private List dayRectInfoList = new ArrayList();
    private HashMap settedMap = new HashMap();
    private List selectedList = new ArrayList();
    private CustomDate startDate = null;
    private int numberPerRow = 3;
    private int rows = 0;
    private int cols = 0;
    private boolean editable = true;
    private static HashMap dayTypesMap = new HashMap();
    private static HashMap defaultDayTypesMap = new HashMap();
    private static Color WORKDAY_BACKGROUND = UIManager.getColor("WorkCalendar.workdayBackground");
    private static Color HOLIDAY_BACKGROUND = UIManager.getColor("WorkCalendar.holidayBackground");
    private static Color NON_WORKDAY_BACKGROUND = UIManager.getColor("WorkCalendar.nonWorkdayBackground");
    private static Color HALF_WORKDAY_BACKGROUND = UIManager.getColor("WorkCalendar.halfWorkdayBackground");
    private static Color DEFAULT_DAYTYPE_COLOR = WORKDAY_BACKGROUND;
    private static Color DAYBORDERCOLOR = UIManager.getColor("WorkCalendar.dayBorderColor");
    private static Color SELECTED_BACKGROUND = UIManager.getColor("WorkCalendar.selectedBackground");
    private static Color weekAreaForeground = UIManager.getColor("WorkCalendar.weekAreaForeground");
    private static int weekAreaHeight = UIManager.getInt("WorkCalendar.weekAreaHeight");
    private static int monthWidth = UIManager.getInt("WorkCalendar.monthWidth");
    private static int monthHeight = UIManager.getInt("WorkCalendar.monthHeight");
    private static int monthVerticalInterval = UIManager.getInt("WorkCalendar.monthVerticalInterval");
    private static int monthHorizontalInterval = UIManager.getInt("WorkCalendar.monthHorizontalInterval");
    private static int monthInterval = 4;
    private static int monthBorderWidth = UIManager.getInt("WorkCalendar.monthBorderWidth");
    private static Icon yearMonthIcon = UIManager.getIcon("WorkCalendar.yearMonthIcon");
    private static int yearMonthAreaWidth = UIManager.getInt("WorkCalendar.yearMonthAreaWidth");
    private static int yearMonthAreaHeight = UIManager.getInt("WorkCalendar.yearMonthAreaHeight");
    private static int rowInterval = 6;
    private static int columnInterval = 3;
    private static Insets insets = new Insets(10, 10, 10, 10);
    private static Dimension compPreferredSize = new Dimension(340, 200);
    private static String[] weeksZh = new String[]{"\u65e5", "\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d"};
    private static String[] weeksEn = new String[]{"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
    private static String[] weeks = weeksZh;
    private static int dayAreaX = 5;
    private int dayAreaY = 5;
    private int dayAreaInnerY = 7;
    private Calendar calendar = null;
    private Dimension dayAreaDim = null;
    private Dimension dayAreaInnerDim = null;
    private static int dayAreaInsets_top = 5;
    private int selectedIndex = -1;
    private MouseHandler mouseHandler = null;
    private WorkCalendarPropertyChangeListener proListener = null;
    private int selectedYear = 2004;
    private int selectedMonth = 1;
    private int selectedDay = 1;
    private int selectedWeek = 1;
    private DayRectInfo dayRectInfo = null;
    private Color topColorA = null;
    private Color topColorB = null;
    private Color topColorC = null;
    private Color botColorA = null;
    private Color botColorB = null;
    private Color botColorC = null;
    private Color dayAreaBackground = null;
    private Color borderColor = null;
    private Color otherDayTextColor = null;
    private int mouseType = 1;

    public static ComponentUI createUI(JComponent x) {
        return new KingdeeWorkCalendarUI();
    }

    @Override
    public boolean contains(JComponent c, int x, int y) {
        return super.contains(c, x, y);
    }

    @Override
    public Accessible getAccessibleChild(JComponent c, int i) {
        return super.getAccessibleChild(c, i);
    }

    @Override
    public int getAccessibleChildrenCount(JComponent c) {
        return super.getAccessibleChildrenCount(c);
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        Dimension dim = this.getPreferredSize(c);
        dim.width += dim.width + c.getInsets().left + c.getInsets().right + 20;
        dim.height += dim.height + c.getInsets().top + c.getInsets().right + 20;
        return dim;
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        return this.getMaximumSize(c);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        return compPreferredSize;
    }

    private IDateTimeModel getModel() {
        return this.c.getModel();
    }

    public void addYearMonth(Date date) {
        if (date != null) {
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(date);
            calendar.set(5, 1);
            date = calendar.getTime();
            this.yearMonthList.add(new DateTimeModel(date, false));
        }
        this.uninstallUI(this.c);
        this.installUI(this.c);
    }

    public void addYearMonth(Date[] dates) {
        for (int i = 0; i < dates.length; ++i) {
            this.addYearMonth(dates[i]);
        }
    }

    public void addYearMonth(Date startDate, Date endDate) {
        if (startDate != null && endDate != null) {
            GregorianCalendar startCalendar = new GregorianCalendar();
            GregorianCalendar endCalendar = new GregorianCalendar();
            startCalendar.setTime(startDate);
            endCalendar.setTime(endDate);
            startCalendar.set(5, 1);
            endCalendar.set(5, 1);
            if (startCalendar.equals(endCalendar)) {
                this.addYearMonth(startCalendar.getTime());
            } else if (startCalendar.before(endCalendar)) {
                while (!startCalendar.after(endCalendar)) {
                    this.addYearMonth(startCalendar.getTime());
                    startCalendar.add(2, 1);
                }
            }
        }
    }

    public Map getSettedDays() {
        return this.settedMap;
    }

    public int getNumberPerRow() {
        return this.numberPerRow;
    }

    public void setNumberPerRow(int numberPerRow) {
        this.numberPerRow = numberPerRow;
        this.uninstallUI(this.c);
        this.installUI(this.c);
    }

    public void setDayType(Date date, int dayType) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        CustomDate customDate = new CustomDate(cal.get(1), cal.get(2), cal.get(5));
        this.settedMap.put(customDate, this.getDayType(dayType));
        this.c.repaint();
    }

    public void setDayType(Date[] dates, int dayType) {
        for (int i = 0; i < dates.length; ++i) {
            this.setDayType(dates[i], dayType);
        }
    }

    public void setDayType(Date startDate, Date endDate, int dayType) {
        GregorianCalendar startCalendar = new GregorianCalendar();
        startCalendar.setTime(startDate);
        GregorianCalendar endCalendar = new GregorianCalendar();
        endCalendar.setTime(endDate);
        if (startCalendar.equals(endCalendar)) {
            this.setDayType(startCalendar.getTime(), dayType);
        } else {
            while (!startCalendar.after(endCalendar)) {
                this.setDayType(startCalendar.getTime(), dayType);
                startCalendar.add(5, 1);
            }
        }
    }

    public void clearYearMonth() {
        this.yearMonthList.clear();
        this.uninstallUI(this.c);
        this.installUI(this.c);
    }

    public void clearSettedDays() {
        this.settedMap.clear();
        this.c.repaint();
    }

    private DayType getDayType(int type) {
        if (dayTypesMap.get(new Integer(type)) != null) {
            return (DayType)dayTypesMap.get(new Integer(type));
        }
        return null;
    }

    private DayType getDayType(String typeName) {
        DayType dayType = null;
        for (int i = 0; i < dayTypesMap.size(); ++i) {
            dayType = this.getDayType(i + 1);
            if (dayType == null || !dayType.getName().equals(typeName)) continue;
            return dayType;
        }
        return null;
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.c = (KDWorkCalendar)c;
        c.setLayout(this.layout);
        this.installComponents(this.c);
        this.installDefaults(this.c);
        this.installListeners(this.c);
        weeks = Locale.getDefault().getLanguage().equals("en") ? weeksEn : weeksZh;
        this.calculateDayInfo();
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        FontMetrics fms;
        super.paint(g, c);
        c.setOpaque(false);
        Color oldColor = g.getColor();
        Font font = c.getFont();
        int fm = 18;
        if (font != null && (fms = c.getFontMetrics(font)) != null) {
            fm = fms.getHeight();
        }
        int tempX = dayAreaX;
        int tempY = this.dayAreaY;
        int tempInnerY = tempY + (dayAreaInsets_top + fm) * 2;
        Date d = null;
        for (int i = 0; i < this.yearMonthList.size(); ++i) {
            d = ((IDateTimeModel)this.yearMonthList.get(i)).getValue();
            this.calendar.setTime(d);
            this.selectedYear = this.calendar.get(1);
            this.selectedMonth = this.calendar.get(2) + 1;
            this.dayRectInfo = (DayRectInfo)this.dayRectInfoList.get(i);
            if (i > 0) {
                tempX = tempX + monthWidth + monthHorizontalInterval;
                if (i % this.cols == 0) {
                    tempX = dayAreaX;
                    tempY = tempY + monthHeight + monthVerticalInterval;
                    tempInnerY = tempInnerY + monthHeight + monthVerticalInterval;
                }
            }
            g.translate(tempX, tempY);
            g.setColor(UIManager.getColor("WorkCalendar.calendarBackground"));
            g.fillRect(0, 0, monthWidth, monthHeight);
            g.translate(-tempX, -tempY);
            g.translate(tempX, tempY);
            g.setColor(c.getForeground());
            this.paintYearMonth(g, c);
            g.translate(-tempX, -tempY);
            g.translate(tempX, tempY);
            g.setColor(c.getForeground());
            this.paintWeekArea(g, c);
            g.translate(-tempX, -tempY);
            this.paintDayArea(g, c);
            g.translate(tempX, tempY);
            g.setColor(Color.BLUE);
            g.translate(-tempX, -tempY);
            g.setColor(oldColor);
        }
    }

    public void paingSelfBackground(Graphics g, JComponent c) {
        if (!c.isOpaque()) {
            return;
        }
        Color old = g.getColor();
        g.setColor(c.getBackground());
        g.fill3DRect(0, 0, c.getWidth(), c.getHeight(), true);
        PaintUtil.drawRectangle((Graphics)g, (int)c.getWidth(), (int)c.getHeight(), (Color)this.topColorA, (Color)this.topColorB, (Color)this.topColorC, (Color)this.botColorA, (Color)this.botColorB, (Color)this.botColorC);
        g.setColor(old);
    }

    protected void paintYearMonth(Graphics g, JComponent c) {
        KDFont aFont = new KDFont("\u5b8b\u4f53", 0, 11);
        KDFont bFont = new KDFont("Arial", 0, 12);
        Font oldFont = g.getFont();
        Color oldColor = g.getColor();
        g.setColor(UIManager.getColor("WorkCalendar.calendarBorderColor"));
        g.drawRect(0, 0, monthWidth, monthHeight);
        g.setColor(oldColor);
        String yearMonthStr0 = this.selectedYear + "";
        String yearMonthStr1 = " \u5e74 ";
        String yearMonthStr2 = this.selectedMonth + "";
        String yearMonthStr3 = " \u6708";
        g.setFont((Font)aFont);
        FontMetrics fm0 = g.getFontMetrics(g.getFont());
        int fmH0 = fm0.getHeight();
        int fmW1 = fm0.stringWidth(yearMonthStr1);
        int fmW3 = fm0.stringWidth(yearMonthStr3);
        g.setFont((Font)bFont);
        FontMetrics fm1 = g.getFontMetrics(g.getFont());
        int fmH1 = fm1.getHeight();
        int fmW0 = fm1.stringWidth(yearMonthStr0);
        int fmW2 = fm1.stringWidth(yearMonthStr2);
        int fmW = fmW0 + fmW1 + fmW2 + fmW3;
        int fmH = 0;
        if (fmH1 >= fmH0) {
            fmH = fmH1;
        } else if (fmH1 < fmH0) {
            fmH = fmH0;
        }
        g.drawImage(((ImageIcon)yearMonthIcon).getImage(), monthBorderWidth, monthBorderWidth, yearMonthAreaWidth + monthBorderWidth + 1, yearMonthAreaHeight + monthBorderWidth + 1, 0, 0, yearMonthIcon.getIconWidth(), yearMonthIcon.getIconHeight(), c);
        g.setColor(UIManager.getColor("WorkCalendar.yearForeground"));
        g.setFont((Font)bFont);
        g.drawString(yearMonthStr0, (monthWidth - fmW) / 2, fmH);
        g.setFont((Font)aFont);
        g.setColor(UIManager.getColor("WorkCalendar.labelForeground"));
        g.drawString(yearMonthStr1, (monthWidth - fmW) / 2 + fmW0, fmH);
        g.setColor(UIManager.getColor("WorkCalendar.monthForeground"));
        g.setFont((Font)bFont);
        g.drawString(yearMonthStr2, (monthWidth - fmW) / 2 + fmW0 + fmW1, fmH);
        g.setFont((Font)aFont);
        g.setColor(UIManager.getColor("WorkCalendar.labelForeground"));
        g.drawString(yearMonthStr3, (monthWidth - fmW) / 2 + fmW0 + fmW1 + fmW2, fmH);
        g.setFont(oldFont);
        g.setColor(oldColor);
    }

    protected void paintWeekArea(Graphics g, JComponent c) {
        Color oldColor = g.getColor();
        KDFont aFont = new KDFont("\u5b8b\u4f53", 0, 9);
        g.setFont((Font)aFont);
        FontMetrics fm = g.getFontMetrics(g.getFont());
        int fmH = fm.getHeight();
        int fmW = fm.stringWidth(weeks[0]);
        int weekCellWidth = monthWidth / 7;
        int temp0 = weekCellWidth - fmW;
        int temp = temp0 > 2 ? temp0 / 2 : 0;
        g.setColor(weekAreaForeground);
        for (int i = 0; i <= 6; ++i) {
            int x = i * weekCellWidth + temp;
            int y = fmH + yearMonthAreaHeight;
            g.drawString(weeks[i], x, y);
        }
        g.setColor(oldColor);
    }

    protected void paintDayArea(Graphics g, JComponent c) {
        if (this.dayRectInfo == null) {
            return;
        }
        FontMetrics fm = g.getFontMetrics(g.getFont());
        int fmH = fm.getHeight();
        int weekCellWidth = monthWidth / 7;
        int fmW = fm.stringWidth("\u4e00");
        int temp0 = weekCellWidth - fmW;
        int temp = temp0 > 2 ? temp0 / 2 : 0;
        Font oldFont = g.getFont();
        KDFont aFont = new KDFont("\u5b8b\u4f53", 0, 9);
        Color oldColor = g.getColor();
        Color color = null;
        Color dayTypeColor = null;
        CustomDate customDate = null;
        for (int row = 0; row <= 5; ++row) {
            for (int column = 0; column <= 6; ++column) {
                int index = row * 7 + column;
                if (!this.dayRectInfo.isTheMoth(index)) continue;
                Rectangle rec = this.dayRectInfo.getRect(index);
                String text = this.dayRectInfo.getText(index);
                color = this.dayRectInfo.getColor(index);
                customDate = new CustomDate(this.dayRectInfo.getYear(), this.dayRectInfo.getMonth(), new Integer(this.dayRectInfo.getText(index)));
                dayTypeColor = this.settedMap.containsKey(customDate) ? ((DayType)this.settedMap.get(customDate)).getColor() : (column == 0 || column == 6 ? NON_WORKDAY_BACKGROUND : DEFAULT_DAYTYPE_COLOR);
                g.setColor(dayTypeColor);
                g.fillRect(rec.x, rec.y, rec.width, rec.height);
                g.setColor(DAYBORDERCOLOR);
                g.drawRect(rec.x, rec.y, rec.width, rec.height);
                g.setColor(color);
                g.setFont((Font)aFont);
                g.drawString(text, rec.x + temp, rec.y + fmH);
                g.setFont(oldFont);
                if (!this.selectedList.contains(customDate)) continue;
                g.setColor(SELECTED_BACKGROUND);
                g.fillRect(rec.x, rec.y, rec.width, rec.height);
            }
        }
        g.setColor(oldColor);
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        this.unInstallListeners((KDWorkCalendar)c);
        this.unInstallDefaults((KDWorkCalendar)c);
        this.unInstallComponents((KDWorkCalendar)c);
    }

    @Override
    public void update(Graphics g, JComponent c) {
        super.update(g, c);
        this.popupMenu = this.createPopupMenu();
    }

    protected void createLayout() {
        if (this.layout == null) {
            this.layout = new DownLayout();
        }
    }

    protected KDPopupMenu createPopupMenu() {
        DayType dayType = null;
        KDPopupMenu changeTypeMenu = new KDPopupMenu();
        KDPopupMenu clearTypesMenu = new KDPopupMenu();
        KDMenuItem menuItem = null;
        this.reConfigDayTypeMap();
        for (int i = 1; i < dayTypesMap.size() + 1; ++i) {
            dayType = (DayType)dayTypesMap.get(new Integer(i));
            if (dayType == null) continue;
            menuItem = new KDMenuItem("\u8bbe\u7f6e\u4e3a" + dayType.getName());
            menuItem.setActionCommand(dayType.getName());
            menuItem.addActionListener(new ActionListener(){
                private CustomDate customDate = null;

                @Override
                public void actionPerformed(ActionEvent e) {
                    DayType type = KingdeeWorkCalendarUI.this.getDayType(e.getActionCommand());
                    if (type != null) {
                        for (int i = 0; i < KingdeeWorkCalendarUI.this.selectedList.size(); ++i) {
                            this.customDate = (CustomDate)KingdeeWorkCalendarUI.this.selectedList.get(i);
                            KingdeeWorkCalendarUI.this.settedMap.put(this.customDate, type);
                        }
                    }
                    KingdeeWorkCalendarUI.this.c.repaint();
                    KingdeeWorkCalendarUI.this.c.fireDataChanged(new DataChangeEvent((Object)type));
                }
            });
            changeTypeMenu.add((JMenuItem)menuItem);
        }
        if (this.c.isResetToDefaultMenuEnabled()) {
            menuItem = new KDMenuItem("\u6062\u590d\u9884\u8bbe\u72b6\u6001");
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int result = MessageDialog.show((Component)KingdeeWorkCalendarUI.this.c, (Object)"\u786e\u5b9a\u8981\u6062\u590d\u5230\u9884\u8bbe\u72b6\u6001\uff1f", (String)"\u6062\u590d\u5230\u9884\u8bbe\u72b6\u6001", (int)1);
                    if (result == 0) {
                        KingdeeWorkCalendarUI.this.c.clearSettedDays();
                        KingdeeWorkCalendarUI.this.c.fireBackToDefaultEvent();
                    }
                }
            });
            clearTypesMenu.add((JMenuItem)menuItem);
        } else {
            clearTypesMenu = null;
        }
        KDPopupMenu popup = this.selectedList.size() == 0 ? clearTypesMenu : changeTypeMenu;
        return popup;
    }

    protected KDButton createtodayButton() {
        String str = "Today";
        if (Locale.getDefault().getLanguage().equals("zh")) {
            str = "\u5f53\u524d\u65e5\u671f";
        }
        return new KDButton(str);
    }

    protected void installComponents(KDWorkCalendar c) {
        FontMetrics fms;
        int size = this.yearMonthList.size();
        if (size <= this.numberPerRow) {
            this.cols = size;
            this.rows = 1;
        } else if (size > this.numberPerRow) {
            this.cols = this.numberPerRow;
            this.rows = size % this.numberPerRow == 0 ? size / this.numberPerRow : size / this.numberPerRow + 1;
        }
        compPreferredSize = new Dimension(KingdeeWorkCalendarUI.insets.left + monthWidth * this.cols + monthHorizontalInterval * (this.cols - 1) + KingdeeWorkCalendarUI.insets.right, KingdeeWorkCalendarUI.insets.top + monthHeight * this.rows + monthVerticalInterval * (this.rows - 1) + KingdeeWorkCalendarUI.insets.bottom);
        int aw = KingdeeWorkCalendarUI.compPreferredSize.width - KingdeeWorkCalendarUI.insets.left - KingdeeWorkCalendarUI.insets.right;
        int ah = KingdeeWorkCalendarUI.compPreferredSize.height - KingdeeWorkCalendarUI.insets.top - KingdeeWorkCalendarUI.insets.bottom;
        this.dayAreaDim = new Dimension(aw, ah);
        Font font = c.getFont();
        int fm = 18;
        if (font != null && (fms = c.getFontMetrics(font)) != null) {
            fm = fms.getHeight();
        }
        ah = ah - dayAreaInsets_top * 2 - fm * 2;
        this.dayAreaInnerDim = new Dimension(monthWidth - 2 * monthBorderWidth, monthHeight - yearMonthAreaHeight - weekAreaHeight - 2 * monthBorderWidth);
        this.dayAreaInnerY = this.dayAreaY + dayAreaInsets_top * 2 + fm * 2;
        CtrlFocusTraversalPolicy ctrlFocusPolicy = new CtrlFocusTraversalPolicy();
        c.setFocusTraversalPolicy((FocusTraversalPolicy)ctrlFocusPolicy);
        c.setFocusCycleRoot(true);
    }

    protected void installDefaults(KDWorkCalendar c) {
        Color bg = UIManager.getColor("DatePickerDownList.background");
        if (bg == null) {
            bg = Color.decode("#CFCFC0");
        }
        c.setBackground(bg);
        Color fg = UIManager.getColor("DatePickerDownList.foreground");
        if (fg == null) {
            fg = Color.decode("#000000");
        }
        this.borderColor = UIManager.getColor("DatePickerDownList.borderColor");
        if (this.borderColor == null) {
            this.borderColor = Color.decode("#828272");
        }
        this.topColorA = UIManager.getColor("DatePickerDownList.topColorA");
        if (this.topColorA == null) {
            this.topColorA = Color.decode("#DFDED4");
        }
        this.topColorB = UIManager.getColor("DatePickerDownList.topColorB");
        if (this.topColorB == null) {
            this.topColorB = Color.decode("#D9DBCD");
        }
        this.topColorC = UIManager.getColor("DatePickerDownList.topColorC");
        if (this.topColorC == null) {
            this.topColorC = Color.decode("#D3D3C5");
        }
        this.botColorA = UIManager.getColor("DatePickerDownList.botColorA");
        if (this.botColorA == null) {
            this.botColorA = Color.decode("#C9C9B9");
        }
        this.botColorB = UIManager.getColor("DatePickerDownList.botColorB");
        if (this.botColorB == null) {
            this.botColorB = Color.decode("#BFBFAF");
        }
        this.botColorC = UIManager.getColor("DatePickerDownList.botColorC");
        if (this.botColorC == null) {
            this.botColorC = Color.decode("#B5B5A5");
        }
        this.otherDayTextColor = UIManager.getColor("DatePickerDownList.otherDayTextColor");
        if (this.otherDayTextColor == null) {
            this.otherDayTextColor = Color.decode("#7B7B7B");
        }
        this.dayAreaBackground = UIManager.getColor("DatePickerDownList.dayAreaBackground");
        if (this.dayAreaBackground == null) {
            this.dayAreaBackground = Color.decode("#FFFFFF");
        }
        c.setBorder((Border)new KingdeeBorders.CommonEditorBorder(this.borderColor, this.borderColor, this.borderColor));
        c.setPreferredSize(compPreferredSize);
        Object obj = c.getValue();
        this.calendar = Calendar.getInstance();
        if (obj != null && obj instanceof Date) {
            this.calendar.setTime(new Date(((Date)obj).getTime()));
        } else {
            this.calendar.setTime(new Date(System.currentTimeMillis()));
        }
        Calendar tempCa = Calendar.getInstance();
        tempCa.setTime(new Date(System.currentTimeMillis()));
        this.selectedYear = this.calendar.get(1);
        this.selectedMonth = this.calendar.get(2) + 1;
        if (this.dayRectInfo == null) {
            this.dayRectInfo = new DayRectInfo();
        }
        this.calculateDayInfo(new Integer(this.selectedYear), new Integer(this.selectedMonth - 1));
        this.selectedDay = this.calendar.get(5);
        this.selectedWeek = this.calendar.get(4) - 1;
        this.selectedIndex = this.dayRectInfo.getIndexByDay(this.selectedDay);
        tempCa = null;
        dayTypesMap.put(new Integer(1), new DayType(1, "\u5de5\u4f5c\u65e5", WORKDAY_BACKGROUND));
        dayTypesMap.put(new Integer(2), new DayType(2, "\u8282\u5047\u65e5", HOLIDAY_BACKGROUND));
        dayTypesMap.put(new Integer(3), new DayType(3, "\u4f11\u606f\u65e5", NON_WORKDAY_BACKGROUND));
        dayTypesMap.put(new Integer(4), new DayType(4, "\u534a\u4f11\u606f\u65e5", HALF_WORKDAY_BACKGROUND));
        defaultDayTypesMap.put(new Integer(1), new DayType(1, "\u5de5\u4f5c\u65e5", WORKDAY_BACKGROUND));
        defaultDayTypesMap.put(new Integer(2), new DayType(2, "\u8282\u5047\u65e5", HOLIDAY_BACKGROUND));
        defaultDayTypesMap.put(new Integer(3), new DayType(3, "\u4f11\u606f\u65e5", NON_WORKDAY_BACKGROUND));
        defaultDayTypesMap.put(new Integer(4), new DayType(4, "\u534a\u4f11\u606f\u65e5", HALF_WORKDAY_BACKGROUND));
    }

    private void reConfigDayTypeMap() {
        for (int i = 1; i <= 4; ++i) {
            dayTypesMap.put(new Integer(i), null);
        }
        int[] types = this.c.getActiveDataTypes();
        for (int i = 0; i < types.length; ++i) {
            if (types[i] == 0) continue;
            dayTypesMap.put(new Integer(types[i]), defaultDayTypesMap.get(new Integer(types[i])));
        }
    }

    protected void unInstallListeners(KDWorkCalendar c) {
        if (this.proListener != null) {
            c.removePropertyChangeListener(this.proListener);
            this.proListener = null;
        }
        if (this.mouseHandler != null) {
            c.removeMouseListener(this.mouseHandler);
            this.mouseHandler = null;
        }
    }

    protected void unInstallComponents(KDWorkCalendar c) {
        c.setLayout(null);
        c.removeAll();
    }

    protected void unInstallDefaults(KDWorkCalendar c) {
        this.topColorA = null;
        this.topColorB = null;
        this.topColorC = null;
        this.botColorA = null;
        this.botColorB = null;
        this.botColorC = null;
        this.borderColor = null;
        this.dayAreaBackground = null;
        this.otherDayTextColor = null;
    }

    protected void installListeners(KDWorkCalendar c) {
        if (this.mouseHandler == null) {
            this.mouseHandler = new MouseHandler();
        }
        if (this.proListener == null) {
            this.proListener = new WorkCalendarPropertyChangeListener();
        }
        c.addMouseListener(this.mouseHandler);
        c.addPropertyChangeListener(this.proListener);
    }

    protected void calculateDayInfo(Integer year, Integer month) {
        GregorianCalendar calendar = new GregorianCalendar(year, month, 1);
        calendar.setLenient(false);
        int day_of_week = calendar.get(7);
        int days = this.getDaysOfMonth(year, month + 1);
        int preDays = 0;
        preDays = month == 0 ? this.getDaysOfMonth(year - 1, 12) : this.getDaysOfMonth(year, month);
        this.selectedMonth = month + 1;
        this.selectedWeek = day_of_week - 1;
        this.selectedYear = year;
        this.calendar.set(1, this.selectedYear);
        this.calendar.set(2, month);
        if (this.dayRectInfo == null) {
            this.dayRectInfo = new DayRectInfo();
        }
        this.dayRectInfo.calcutateRect(this.dayAreaInnerDim.width, this.dayAreaInnerDim.height);
        this.dayRectInfo.calculateDay(this.selectedWeek, days, preDays);
        if (this.selectedDay > days) {
            this.selectedDay = days;
        }
        this.c.repaint();
    }

    protected void calculateDayInfo() {
        FontMetrics fms;
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setLenient(false);
        int day_of_week = -1;
        int days = -1;
        int preDays = 0;
        int year = -1;
        int month = -1;
        Font font = this.c.getFont();
        if (font == null || (fms = this.c.getFontMetrics(font)) != null) {
            // empty if block
        }
        int tempX = dayAreaX;
        int tempY = this.dayAreaY;
        int tempInnerY = tempY + yearMonthAreaHeight + weekAreaHeight;
        DayRectInfo dayInfo = null;
        this.dayRectInfoList.clear();
        for (int i = 0; i < this.yearMonthList.size(); ++i) {
            if (i > 0) {
                tempX = tempX + monthWidth + monthHorizontalInterval;
                if (i % this.cols == 0) {
                    tempX = dayAreaX;
                    tempY = tempY + monthHeight + monthVerticalInterval;
                    tempInnerY = tempY + yearMonthAreaHeight + weekAreaHeight + monthBorderWidth;
                }
            }
            IDateTimeModel dtModel = (IDateTimeModel)this.yearMonthList.get(i);
            calendar.setTime(dtModel.getValue());
            year = calendar.get(1);
            month = calendar.get(2);
            day_of_week = calendar.get(7);
            days = this.getDaysOfMonth(year, month + 1);
            preDays = month == 0 ? this.getDaysOfMonth(year - 1, 12) : this.getDaysOfMonth(year, month);
            dayInfo = new DayRectInfo();
            dayInfo.setYear(year);
            dayInfo.setMonth(month);
            dayInfo.setX(tempX);
            dayInfo.setY(tempInnerY);
            dayInfo.calcutateRect(tempX + monthBorderWidth, tempInnerY, this.dayAreaInnerDim.width, this.dayAreaInnerDim.height);
            dayInfo.calculateDay(day_of_week - 1, days, preDays);
            this.dayRectInfoList.add(dayInfo);
        }
        this.c.repaint();
    }

    private int getDaysOfMonth(int y, int m) {
        if (m == 4 || m == 6 || m == 9 || m == 11) {
            return 30;
        }
        if (m == 2) {
            GregorianCalendar gc = new GregorianCalendar(y, m, 1);
            if (gc.isLeapYear(y)) {
                return 29;
            }
            return 28;
        }
        return 31;
    }

    protected void setValue(int f, Date value) {
        Calendar tempC = Calendar.getInstance();
        tempC.setTime(value);
        int v = -1;
        int tempV = -1;
        switch (f) {
            case 0: {
                v = tempC.get(1);
                tempV = this.calendar.get(1);
                if (v == tempV) break;
                this.calendar.set(1, v);
                break;
            }
            case 1: {
                v = tempC.get(2);
                tempV = this.calendar.get(2);
                if (v == tempV) break;
                this.calendar.set(2, v);
                break;
            }
            case 2: {
                v = tempC.get(5);
                tempV = this.calendar.get(5);
                if (v != tempV) {
                    this.calendar.set(5, v);
                }
                if (v == this.selectedDay) break;
                this.selectedDay = v;
                break;
            }
            case 8: {
                if (this.calendar == null) {
                    this.calendar = Calendar.getInstance();
                }
                this.setValue(0, value);
                this.setValue(1, value);
                this.setValue(2, value);
                this.setValue(4, value);
                this.calendar.setTime(tempC.getTime());
                break;
            }
            default: {
                if (tempC.equals(this.calendar)) break;
                this.calendar.setTime(tempC.getTime());
            }
        }
    }

    public void commitComfirm() {
        this.calendar.set(5, this.selectedDay);
        this.getModel().setDay(this.selectedDay);
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean mouseSelectedDay(int x, int y) {
        DayRectInfo dayRectInfo;
        block17: {
            int index;
            GregorianCalendar endCalendar;
            GregorianCalendar startCalendar;
            CustomDate customDate;
            block20: {
                int index2;
                block19: {
                    block18: {
                        block16: {
                            dayRectInfo = null;
                            customDate = null;
                            if (this.mouseType != 1) break block16;
                            this.selectedList.clear();
                            this.startDate = null;
                            int index3 = -1;
                            for (int i = 0; i < this.dayRectInfoList.size(); ++i) {
                                dayRectInfo = (DayRectInfo)this.dayRectInfoList.get(i);
                                if (!dayRectInfo.isMouseInTheMonth(x, y) || (index3 = dayRectInfo.contains(x, y)) == -1) continue;
                                customDate = new CustomDate(dayRectInfo.getYear(), dayRectInfo.getMonth(), new Integer(dayRectInfo.getText(index3)));
                                this.selectedList.add(customDate);
                                this.startDate = customDate;
                            }
                            break block17;
                        }
                        if (this.mouseType != 2) break block18;
                        this.startDate = null;
                        index2 = -1;
                        break block19;
                    }
                    if (this.mouseType != 3) break block17;
                    startCalendar = new GregorianCalendar();
                    endCalendar = new GregorianCalendar();
                    index = -1;
                    break block20;
                }
                for (int i = 0; i < this.dayRectInfoList.size(); ++i) {
                    dayRectInfo = (DayRectInfo)this.dayRectInfoList.get(i);
                    if (!dayRectInfo.isMouseInTheMonth(x, y) || (index2 = dayRectInfo.contains(x, y)) == -1) continue;
                    customDate = new CustomDate(dayRectInfo.getYear(), dayRectInfo.getMonth(), new Integer(dayRectInfo.getText(index2)));
                    if (this.selectedList.contains(customDate)) {
                        this.selectedList.remove(customDate);
                        continue;
                    }
                    this.selectedList.add(customDate);
                    this.startDate = customDate;
                }
                break block17;
            }
            for (int i = 0; i < this.dayRectInfoList.size(); ++i) {
                dayRectInfo = (DayRectInfo)this.dayRectInfoList.get(i);
                if (!dayRectInfo.isMouseInTheMonth(x, y) || (index = dayRectInfo.contains(x, y)) == -1) continue;
                startCalendar.set(1, this.startDate.getYear());
                startCalendar.set(2, this.startDate.getMonth());
                startCalendar.set(5, this.startDate.getDate());
                endCalendar.set(1, dayRectInfo.getYear());
                endCalendar.set(2, dayRectInfo.getMonth());
                endCalendar.set(5, new Integer(dayRectInfo.getText(index)));
                if (startCalendar.before(endCalendar)) {
                    this.selectedList.clear();
                    while (!startCalendar.after(endCalendar)) {
                        customDate = new CustomDate(startCalendar.get(1), startCalendar.get(2), startCalendar.get(5));
                        if (!this.selectedList.contains(customDate)) {
                            this.selectedList.add(customDate);
                        }
                        startCalendar.add(5, 1);
                    }
                    continue;
                }
                if (!startCalendar.after(endCalendar)) continue;
                this.selectedList.clear();
                while (!startCalendar.before(endCalendar)) {
                    customDate = new CustomDate(endCalendar.get(1), endCalendar.get(2), endCalendar.get(5));
                    if (!this.selectedList.contains(customDate)) {
                        this.selectedList.add(customDate);
                    }
                    endCalendar.add(5, 1);
                }
            }
        }
        int ix = x - dayAreaX;
        int iy = y - this.dayAreaInnerY;
        boolean b = false;
        if (ix >= 0 && y >= 0 && x <= dayAreaX + this.dayAreaDim.width && y <= this.dayAreaY + this.dayAreaDim.height) {
            if (null != dayRectInfo) {
                this.selectedIndex = dayRectInfo.contains(ix, iy);
            }
            if (this.selectedIndex != -1 && null != dayRectInfo) {
                this.selectedDay = dayRectInfo.getDayByIndex(this.selectedIndex);
                if (this.selectedDay != -1) {
                    boolean flag;
                    if (this.mouseType == 1) {
                        this.calendar.set(5, this.selectedDay);
                        this.getModel().setDay(this.selectedDay);
                        b = true;
                    } else if (this.mouseType == 2 ? (flag = false) : this.mouseType == 3) {
                        // empty if block
                    }
                }
            }
            this.c.repaint(dayAreaX, this.dayAreaY, this.dayAreaDim.width, this.dayAreaDim.height);
        }
        return b;
    }

    static /* synthetic */ Color access$2000() {
        return DEFAULT_DAYTYPE_COLOR;
    }

    protected class WorkCalendarPropertyChangeListener
    implements PropertyChangeListener {
        protected WorkCalendarPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName() == "editable" && evt.getNewValue() != evt.getOldValue()) {
                KingdeeWorkCalendarUI.this.editable = (Boolean)evt.getNewValue();
                Component c = (Component)evt.getSource();
                c.repaint();
            }
        }
    }

    public class CustomDate {
        private int year;
        private int month;
        private int date;

        public CustomDate(int year, int month, int date) {
            this.year = year;
            this.month = month;
            this.date = date;
        }

        public int getYear() {
            return this.year;
        }

        public int getMonth() {
            return this.month;
        }

        public int getDate() {
            return this.date;
        }

        public int hashCode() {
            return this.year * 1000 + this.month * 100 + this.date;
        }

        public boolean equals(Object obj) {
            return obj instanceof CustomDate && this.getYear() == ((CustomDate)obj).getYear() && this.getMonth() == ((CustomDate)obj).getMonth() && this.getDate() == ((CustomDate)obj).getDate();
        }

        public boolean before(CustomDate customDate) {
            return this.getYear() <= customDate.getYear() || this.getMonth() <= customDate.getMonth() || this.getDate() < customDate.getDate();
        }

        public boolean after(CustomDate customDate) {
            return this.getYear() >= customDate.getYear() || this.getMonth() >= customDate.getMonth() || this.getDate() > customDate.getDate();
        }
    }

    public class DayType {
        private int type;
        private String name;
        private Color color = KingdeeWorkCalendarUI.access$2000();

        public DayType(int type, String name) {
            this(type, name, null);
        }

        public DayType(int type, String name, Color color) {
            this.type = type;
            this.name = name;
            if (color != null) {
                this.color = color;
            }
        }

        public int getType() {
            return this.type;
        }

        public void setType(int type) {
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Color getColor() {
            return this.color;
        }

        public void setColor(Color color) {
            this.color = color;
        }
    }

    private class MouseHandler
    extends MouseAdapter {
        private MouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.isControlDown()) {
                if (SwingUtilities.isLeftMouseButton(e)) {
                    KingdeeWorkCalendarUI.this.c.requestFocusInWindow();
                    int x = e.getX();
                    int y = e.getY();
                    KingdeeWorkCalendarUI.this.mouseType = 2;
                    KingdeeWorkCalendarUI.this.mouseSelectedDay(x, y);
                }
            } else if (e.isShiftDown()) {
                if (SwingUtilities.isLeftMouseButton(e) && KingdeeWorkCalendarUI.this.startDate != null) {
                    KingdeeWorkCalendarUI.this.c.requestFocusInWindow();
                    int x = e.getX();
                    int y = e.getY();
                    KingdeeWorkCalendarUI.this.mouseType = 3;
                    KingdeeWorkCalendarUI.this.mouseSelectedDay(x, y);
                }
            } else {
                if (SwingUtilities.isLeftMouseButton(e)) {
                    if (e.getModifiers() != 16) {
                        return;
                    }
                    KingdeeWorkCalendarUI.this.c.requestFocusInWindow();
                    int x = e.getX();
                    int y = e.getY();
                    KingdeeWorkCalendarUI.this.mouseType = 1;
                    KingdeeWorkCalendarUI.this.mouseSelectedDay(x, y);
                }
                if (SwingUtilities.isRightMouseButton(e) && KingdeeWorkCalendarUI.this.editable && KingdeeWorkCalendarUI.this.popupMenu != null) {
                    KingdeeWorkCalendarUI.this.popupMenu.show((Component)KingdeeWorkCalendarUI.this.c, e.getX(), e.getY());
                }
            }
        }
    }

    private class DayRectInfo
    implements Serializable {
        private static final long serialVersionUID = -5816590182329412225L;
        private Rectangle[] rectArray = null;
        private String[] dayArray = null;
        private int w = -1;
        private int h = -1;
        private int week = -1;
        private int days = -1;
        private int preDays = -1;
        private int year = -1;
        private int month = -1;
        private int x;
        private int y;
        private int[] negPlusIndex = new int[42];

        public DayRectInfo() {
            this(-1, -1);
        }

        public DayRectInfo(int w, int h) {
            this.rectArray = new Rectangle[42];
            this.dayArray = new String[42];
            for (int i = 0; i < 42; ++i) {
                this.negPlusIndex[i] = 0;
            }
            if (w > 0 && h > 0) {
                this.calcutateRect(w, h);
            }
        }

        public int getYear() {
            return this.year;
        }

        public void setYear(int year) {
            this.year = year;
        }

        public int getMonth() {
            return this.month;
        }

        public void setMonth(int month) {
            this.month = month;
        }

        public int getX() {
            return this.x;
        }

        public void setX(int x) {
            this.x = x;
        }

        public int getY() {
            return this.y;
        }

        public void setY(int y) {
            this.y = y;
        }

        public Rectangle getRect(int index) {
            if (index < 0 || index > 42) {
                return null;
            }
            return this.rectArray[index];
        }

        public int getIndexByDay(int day) {
            int len = this.dayArray.length;
            if (len < 0 || len > 42) {
                return -1;
            }
            for (int i = 0; i < 42; ++i) {
                String str = this.dayArray[i];
                if (!str.equals(String.valueOf(day)) || this.negPlusIndex[i] < 0) continue;
                return i;
            }
            return -1;
        }

        public int getDayByIndex(int index) {
            if (this.negPlusIndex[index] != -1) {
                String days = this.getText(index);
                try {
                    return Integer.parseInt(days);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return -1;
        }

        public String getText(int index) {
            if (index < 0 || index > 42) {
                return "E";
            }
            return this.dayArray[index];
        }

        public Color getColor(int index) {
            if (index < 0 || index > 42) {
                return Color.red;
            }
            if (this.negPlusIndex[index] == -1) {
                return KingdeeWorkCalendarUI.this.otherDayTextColor;
            }
            return Color.black;
        }

        public boolean isTheMoth(int index) {
            if (index < 0 || index > 42) {
                return false;
            }
            return this.negPlusIndex[index] != -1;
        }

        public boolean isMouseInTheMonth(int x, int y) {
            return x >= this.x && x <= this.x + monthWidth + monthInterval && y >= this.y && y <= this.y + ((KingdeeWorkCalendarUI)KingdeeWorkCalendarUI.this).dayAreaInnerDim.height + monthInterval;
        }

        public boolean isNow(int index) {
            if (index < 0 || index > 42) {
                return false;
            }
            return this.negPlusIndex[index] != -1;
        }

        public int contains(int x, int y) {
            if (this.rectArray.length != 42) {
                return -1;
            }
            int tempIndex = -1;
            for (int i = 0; i < 42; ++i) {
                int tx = this.rectArray[i].x;
                int ty = this.rectArray[i].y;
                int tw = this.rectArray[i].width;
                int th = this.rectArray[i].height;
                if (x < tx || x >= tx + tw || y < ty || y >= ty + th) continue;
                tempIndex = i;
                break;
            }
            if (this.isNow(tempIndex)) {
                return tempIndex;
            }
            return -1;
        }

        public Rectangle getRectangle(int index) {
            int len = this.rectArray.length;
            if (len != 42 || index < 0 || index >= 42 || !this.isNow(index)) {
                return null;
            }
            return this.rectArray[index];
        }

        public Rectangle getRectangle(int x, int y) {
            int index = this.contains(x, y);
            if (index == -1) {
                return null;
            }
            return this.getRectangle(index);
        }

        public void calcutateRect(int w, int h) {
            if (this.w == w && this.h == h) {
                return;
            }
            this.w = w;
            this.h = h;
            int cellWidth = w / 7;
            int cellHeight = h / 6;
            for (int row = 0; row <= 5; ++row) {
                for (int column = 0; column <= 6; ++column) {
                    int x = column * cellWidth;
                    int y = row * cellHeight;
                    this.rectArray[row * 7 + column] = new Rectangle(x, y, cellWidth, cellHeight);
                }
            }
        }

        public void calcutateRect(int x, int y, int w, int h) {
            if (this.w == w && this.h == h) {
                return;
            }
            this.w = w;
            this.h = h;
            int cellWidth = w / 7;
            int cellHeight = h / 6;
            for (int row = 0; row <= 5; ++row) {
                for (int column = 0; column <= 6; ++column) {
                    int x1 = column * cellWidth + x;
                    int y1 = row * cellHeight + y;
                    this.rectArray[row * 7 + column] = new Rectangle(x1, y1, cellWidth, cellHeight);
                }
            }
        }

        public void calculateDay(int week, int days, int preDays) {
            if (week < 0 || days < 28 || days > 31 || preDays < 28 || preDays > 31) {
                StringBuffer sb = new StringBuffer();
                sb.append("argument is illegal:(week=").append(week).append(",days=").append(days).append(",preDays=").append(preDays).append(").");
                throw new IllegalArgumentException(sb.toString());
            }
            if (this.week == week && this.days == days && this.preDays == preDays) {
                return;
            }
            this.week = week;
            this.days = days;
            this.preDays = preDays;
            for (int i = week - 1; i >= 0; --i) {
                this.dayArray[i] = String.valueOf(preDays);
                this.negPlusIndex[i] = -1;
                --preDays;
            }
            int dayIndex = 1;
            boolean endB = false;
            int endRow = 10;
            for (int row = 0; row <= 5; ++row) {
                for (int column = 0; column <= 6; ++column) {
                    if (row == 0) {
                        if (column < week) continue;
                        this.dayArray[column] = String.valueOf(dayIndex);
                        this.negPlusIndex[column] = 1;
                        ++dayIndex;
                        continue;
                    }
                    if (dayIndex > days) {
                        dayIndex = 1;
                        endB = true;
                        endRow = row;
                        if (column == 0) {
                            --endRow;
                        }
                    }
                    this.negPlusIndex[row * 7 + column] = endB ? -1 : 1;
                    this.dayArray[row * 7 + column] = endRow < row ? "" : String.valueOf(dayIndex);
                    ++dayIndex;
                }
            }
        }
    }

    class DownLayout
    implements LayoutManager {
        private Component yearC = null;
        private Component monthC = null;
        private Component timeC = null;
        private Component checkC = null;
        private Component okBu = null;
        private Component cancelBu = null;
        private Component todayBu = null;

        DownLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
            if (name.equals("year")) {
                this.yearC = comp;
                return;
            }
            if (name.equals("month")) {
                this.monthC = comp;
                return;
            }
            if (name.equals("time")) {
                this.timeC = comp;
                return;
            }
            if (name.equals("nullvalue")) {
                this.checkC = comp;
                return;
            }
            if (name.equals("ok")) {
                this.okBu = comp;
                return;
            }
            if (name.equals("cancel")) {
                this.cancelBu = comp;
                return;
            }
            if (name.equals("today")) {
                this.todayBu = comp;
                return;
            }
        }

        private Dimension preferredSize(Component c) {
            return c == null ? zeroDim : c.getPreferredSize();
        }

        @Override
        public void layoutContainer(Container parent) {
            int count = parent.getComponentCount();
            if (count <= 0) {
                return;
            }
            Dimension parentPreDim = compPreferredSize;
            Dimension yearDim = this.preferredSize(this.yearC);
            Dimension monthDim = this.preferredSize(this.monthC);
            Dimension nullDim = this.preferredSize(this.checkC);
            Dimension okDim = this.preferredSize(this.okBu);
            Dimension cancelDim = this.preferredSize(this.cancelBu);
            Dimension todayDim = this.preferredSize(this.todayBu);
            Point yearP = new Point();
            yearP.x = insets.left;
            yearP.y = insets.top;
            Point monthP = new Point();
            monthP.x = yearP.x + yearDim.width + columnInterval;
            monthP.y = insets.top;
            Point timeP = new Point();
            timeP.x = monthP.x + monthDim.width + columnInterval;
            timeP.y = insets.top;
            Point nullP = new Point();
            nullP.x = parentPreDim.width - insets.right - nullDim.width;
            nullP.y = insets.top;
            Point cancelP = new Point();
            cancelP.x = parentPreDim.width - insets.right - cancelDim.width;
            cancelP.y = parentPreDim.height - insets.bottom - cancelDim.height;
            Point okP = new Point();
            okP.x = cancelP.x - columnInterval - okDim.width;
            okP.y = cancelP.y;
            Point todayP = new Point();
            todayP.x = okP.x - columnInterval - todayDim.width;
            todayP.y = cancelP.y;
            dayAreaX = yearP.x;
            KingdeeWorkCalendarUI.this.dayAreaY = yearP.y + yearDim.height + rowInterval;
            Rectangle yearRec = new Rectangle(yearP.x, yearP.y, yearDim.width, yearDim.height);
            Rectangle monthRec = new Rectangle(monthP.x, monthP.y, monthDim.width, monthDim.height);
            Rectangle nullRec = new Rectangle(nullP.x, nullP.y, nullDim.width, nullDim.height);
            this.yearC.setBounds(yearRec.x, yearRec.y, yearRec.width, yearRec.height);
            this.monthC.setBounds(monthRec.x, monthRec.y, monthRec.width, monthRec.height);
            if (this.checkC != null && this.checkC.isVisible()) {
                this.checkC.setBounds(nullRec.x, nullRec.y, nullRec.width, nullRec.height);
            }
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return parent.getMinimumSize();
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return parent.getPreferredSize();
        }

        @Override
        public void removeLayoutComponent(Component comp) {
            if (comp == this.yearC) {
                this.yearC = null;
                return;
            }
            if (comp == this.monthC) {
                this.monthC = null;
                return;
            }
            if (comp == this.timeC) {
                this.timeC = null;
                return;
            }
            if (comp == this.checkC) {
                this.checkC = null;
                return;
            }
            if (comp == this.cancelBu) {
                this.cancelBu = null;
                return;
            }
            if (comp == this.okBu) {
                this.okBu = null;
                return;
            }
            if (comp == this.todayBu) {
                this.todayBu = null;
                return;
            }
        }
    }
}

