/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.fd2.actions;

import com.kingdee.bos.ctrl.common.LanguageManager;
import com.kingdee.bos.ctrl.common.util.CtrlClassUtil;
import com.kingdee.bos.ctrl.kdf.fd2.actions.AbstractDesignerColorAction;
import com.kingdee.bos.ctrl.kdf.fd2.icons.Icons;
import com.kingdee.bos.ctrl.kdf.fd2.reportelement.Page;
import com.kingdee.bos.ctrl.kdf.fd2.reportelement.ReportElement;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.swing.KDComboColor;
import com.kingdee.bos.ctrl.swing.event.ComboColorSelectedEvent;
import com.kingdee.bos.ctrl.swing.event.ComboColorViewPicClickEvent;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;

public class BackColorAction
extends AbstractDesignerColorAction {
    private String getMLS(String key, String defaultValue) {
        String res = CtrlClassUtil.getPackageName(this.getClass()) + ".action";
        return LanguageManager.getLangMessage((String)key, (String)res, (String)defaultValue);
    }

    @Override
    public void setBindCtrl(KDComboColor ctrl) {
        super.setBindCtrl(ctrl);
        ctrl.setPictureForViewPic(Icons.ICN_BACKCOLOR);
        ctrl.setDefaultColor(KDComboColor.TRANSPARENTCOLOR);
        ctrl.setDefaultColorPrompt(this.getMLS("transparent", "\u900f\u660e"));
        ctrl.setColor(Color.WHITE);
    }

    @Override
    protected boolean isEnabled() {
        return this.isSelectedHasBackgroud();
    }

    @Override
    protected void setCtrlEnabled(boolean isEnabled) {
        this.ctrl.setEnabled(isEnabled);
    }

    @Override
    protected void syncCtrl(StyleAttributes sa) {
    }

    @Override
    public void selected(ComboColorSelectedEvent evt) {
        this.doColorSelected(evt.getSelectedColor());
    }

    @Override
    public void clicked(ComboColorViewPicClickEvent evt) {
        this.doColorSelected(evt.getCurrentColor());
    }

    private void doColorSelected(Color newColor) {
        ArrayList eles = this.designer.getKDFFrame().getSelectedElements();
        Iterator it = eles.iterator();
        if (it.hasNext()) {
            while (it.hasNext()) {
                ReportElement ele = (ReportElement)it.next();
                this.setEleColor(ele, newColor);
            }
        } else {
            Page ele = this.designer.getKDFFrame().getCurrentPage();
            this.setEleColor(ele, newColor);
        }
        this.designer.getKDFFrame().repaint();
        if (this.designer.getElementPropertiesDialog().isVisible()) {
            this.designer.getElementPropertiesDialog().updateSelection();
        }
    }

    private void setEleColor(ReportElement ele, Color newColor) {
        StyleAttributes sa = ele.getStyleAttribute();
        if (!newColor.equals(sa.getBackground())) {
            sa.setBackground(newColor);
            this.notFireElePrptChg = true;
            ele.setStyleAttribute(sa);
            this.notFireElePrptChg = false;
        }
    }
}

